/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.serialization;

import io.netty.contrib.handler.codec.serialization.CompactObjectOutputStream;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferOutputStream;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToByteEncoder;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];

    protected Buffer allocateBuffer(ChannelHandlerContext ctx, Serializable msg) {
        return ctx.bufferAllocator().allocate(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, Serializable msg, Buffer out) throws Exception {
        int startIdx = out.writerOffset();
        BufferOutputStream bout = new BufferOutputStream(out);
        ObjectOutputStream oout = null;
        try {
            bout.write(LENGTH_PLACEHOLDER);
            oout = new CompactObjectOutputStream((OutputStream)bout);
            oout.writeObject(msg);
            oout.flush();
        }
        finally {
            if (oout != null) {
                oout.close();
            } else {
                bout.close();
            }
        }
        int endIdx = out.writerOffset();
        out.setInt(startIdx, endIdx - startIdx - 4);
    }

    public boolean isSharable() {
        return true;
    }
}

