/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.xml;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.CorruptedFrameException;
import io.netty5.handler.codec.TooLongFrameException;
import io.netty5.util.internal.ObjectUtil;

public class XmlFrameDecoder
extends ByteToMessageDecoder {
    private final int maxFrameLength;

    public XmlFrameDecoder(int maxFrameLength) {
        this.maxFrameLength = ObjectUtil.checkPositive((int)maxFrameLength, (String)"maxFrameLength");
    }

    private static void fail(ChannelHandlerContext ctx) {
        ctx.fireChannelExceptionCaught((Throwable)new CorruptedFrameException("frame contains content before the xml starts"));
    }

    private static Buffer extractFrame(Buffer buffer, int index, int length) {
        return buffer.copy(index, length);
    }

    private static boolean isValidStartCharForXmlElement(byte b) {
        return b >= 97 && b <= 122 || b >= 65 && b <= 90 || b == 58 || b == 95;
    }

    private static boolean isCommentBlockStart(Buffer in, int i) {
        return i < in.writerOffset() - 3 && in.getByte(i + 2) == 45 && in.getByte(i + 3) == 45;
    }

    private static boolean isCDATABlockStart(Buffer in, int i) {
        return i < in.writerOffset() - 8 && in.getByte(i + 2) == 91 && in.getByte(i + 3) == 67 && in.getByte(i + 4) == 68 && in.getByte(i + 5) == 65 && in.getByte(i + 6) == 84 && in.getByte(i + 7) == 65 && in.getByte(i + 8) == 91;
    }

    protected void decode(ChannelHandlerContext ctx, Buffer in) {
        boolean openingBracketFound = false;
        boolean atLeastOneXmlElementFound = false;
        boolean inCDATASection = false;
        long openBracketsCount = 0L;
        int length = 0;
        int leadingWhiteSpaceCount = 0;
        int bufferLength = in.writerOffset();
        if (bufferLength > this.maxFrameLength) {
            in.skipReadableBytes(in.readableBytes());
            this.fail(bufferLength);
            return;
        }
        block0: for (int i = in.readerOffset(); i < bufferLength; ++i) {
            byte readByte = in.getByte(i);
            if (!openingBracketFound && Character.isWhitespace(readByte)) {
                ++leadingWhiteSpaceCount;
                continue;
            }
            if (!openingBracketFound && readByte != 60) {
                XmlFrameDecoder.fail(ctx);
                in.skipReadableBytes(in.readableBytes());
                return;
            }
            if (!inCDATASection && readByte == 60) {
                openingBracketFound = true;
                if (i >= bufferLength - 1) continue;
                byte peekAheadByte = in.getByte(i + 1);
                if (peekAheadByte == 47) {
                    for (int peekFurtherAheadIndex = i + 2; peekFurtherAheadIndex <= bufferLength - 1; ++peekFurtherAheadIndex) {
                        if (in.getByte(peekFurtherAheadIndex) != 62) continue;
                        --openBracketsCount;
                        continue block0;
                    }
                    continue;
                }
                if (XmlFrameDecoder.isValidStartCharForXmlElement(peekAheadByte)) {
                    atLeastOneXmlElementFound = true;
                    ++openBracketsCount;
                    continue;
                }
                if (peekAheadByte == 33) {
                    if (XmlFrameDecoder.isCommentBlockStart(in, i)) {
                        ++openBracketsCount;
                        continue;
                    }
                    if (!XmlFrameDecoder.isCDATABlockStart(in, i)) continue;
                    ++openBracketsCount;
                    inCDATASection = true;
                    continue;
                }
                if (peekAheadByte != 63) continue;
                ++openBracketsCount;
                continue;
            }
            if (!inCDATASection && readByte == 47) {
                if (i >= bufferLength - 1 || in.getByte(i + 1) != 62) continue;
                --openBracketsCount;
                continue;
            }
            if (readByte != 62) continue;
            length = i + 1;
            if (i - 1 > -1) {
                byte peekBehindByte = in.getByte(i - 1);
                if (!inCDATASection) {
                    if (peekBehindByte == 63) {
                        --openBracketsCount;
                    } else if (peekBehindByte == 45 && i - 2 > -1 && in.getByte(i - 2) == 45) {
                        --openBracketsCount;
                    }
                } else if (peekBehindByte == 93 && i - 2 > -1 && in.getByte(i - 2) == 93) {
                    --openBracketsCount;
                    inCDATASection = false;
                }
            }
            if (atLeastOneXmlElementFound && openBracketsCount == 0L) break;
        }
        int readerIndex = in.readerOffset();
        int xmlElementLength = length - readerIndex;
        if (openBracketsCount == 0L && xmlElementLength > 0) {
            if (readerIndex + xmlElementLength >= bufferLength) {
                xmlElementLength = in.readableBytes();
            }
            Buffer frame = XmlFrameDecoder.extractFrame(in, readerIndex + leadingWhiteSpaceCount, xmlElementLength - leadingWhiteSpaceCount);
            in.skipReadableBytes(xmlElementLength);
            ctx.fireChannelRead((Object)frame);
        }
    }

    private void fail(long frameLength) {
        if (frameLength > 0L) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + frameLength + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }
}

