/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderDateFormat;
import java.text.ParseException;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpHeaderDateFormatTest {
    private static final Date DATE = new Date(784111777000L);

    @Test
    public void testParse() throws ParseException {
        HttpHeaderDateFormat format = HttpHeaderDateFormat.get();
        Date parsedDateWithSingleDigitDay = format.parse("Sun, 6 Nov 1994 08:49:37 GMT");
        Assertions.assertNotNull((Object)parsedDateWithSingleDigitDay);
        Assertions.assertEquals((Object)DATE, (Object)parsedDateWithSingleDigitDay);
        Date parsedDateWithDoubleDigitDay = format.parse("Sun, 06 Nov 1994 08:49:37 GMT");
        Assertions.assertNotNull((Object)parsedDateWithDoubleDigitDay);
        Assertions.assertEquals((Object)DATE, (Object)parsedDateWithDoubleDigitDay);
        Date parsedDateWithDashSeparatorSingleDigitDay = format.parse("Sunday, 06-Nov-94 08:49:37 GMT");
        Assertions.assertNotNull((Object)parsedDateWithDashSeparatorSingleDigitDay);
        Assertions.assertEquals((Object)DATE, (Object)parsedDateWithDashSeparatorSingleDigitDay);
        Date parsedDateWithSingleDoubleDigitDay = format.parse("Sunday, 6-Nov-94 08:49:37 GMT");
        Assertions.assertNotNull((Object)parsedDateWithSingleDoubleDigitDay);
        Assertions.assertEquals((Object)DATE, (Object)parsedDateWithSingleDoubleDigitDay);
        Date parsedDateWithoutGMT = format.parse("Sun Nov 6 08:49:37 1994");
        Assertions.assertNotNull((Object)parsedDateWithoutGMT);
        Assertions.assertEquals((Object)DATE, (Object)parsedDateWithoutGMT);
    }

    @Test
    public void testFormat() {
        HttpHeaderDateFormat format = HttpHeaderDateFormat.get();
        String formatted = format.format(DATE);
        Assertions.assertNotNull((Object)formatted);
        Assertions.assertEquals((Object)"Sun, 06 Nov 1994 08:49:37 GMT", (Object)formatted);
    }
}

