/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.AsciiString;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledForJreRange;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
public class HttpHeaderValidationUtilTest {
    private static final IllegalArgumentException VALIDATION_EXCEPTION = new IllegalArgumentException(){
        private static final long serialVersionUID = -8857428534361331089L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };

    public static List<Arguments> connectionRelatedHeaders() {
        ArrayList<Arguments> list = new ArrayList<Arguments>();
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCEPT));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCEPT_CHARSET));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCEPT_ENCODING));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCEPT_LANGUAGE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCEPT_RANGES));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCEPT_PATCH));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCESS_CONTROL_MAX_AGE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.AGE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ALLOW));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.AUTHORIZATION));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CACHE_CONTROL));
        list.add(HttpHeaderValidationUtilTest.header(true, HttpHeaderNames.CONNECTION));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_BASE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_ENCODING));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_LANGUAGE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_LENGTH));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_LOCATION));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_TRANSFER_ENCODING));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_DISPOSITION));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_MD5));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_RANGE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_SECURITY_POLICY));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.CONTENT_TYPE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.COOKIE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.DATE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.DNT));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ETAG));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.EXPECT));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.EXPIRES));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.FROM));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.HOST));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.IF_MATCH));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.IF_MODIFIED_SINCE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.IF_NONE_MATCH));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.IF_RANGE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.IF_UNMODIFIED_SINCE));
        list.add(HttpHeaderValidationUtilTest.header(true, HttpHeaderNames.KEEP_ALIVE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.LAST_MODIFIED));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.LOCATION));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.MAX_FORWARDS));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.ORIGIN));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.PRAGMA));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.PROXY_AUTHENTICATE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.PROXY_AUTHORIZATION));
        list.add(HttpHeaderValidationUtilTest.header(true, HttpHeaderNames.PROXY_CONNECTION));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.RANGE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.REFERER));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.RETRY_AFTER));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SEC_WEBSOCKET_KEY1));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SEC_WEBSOCKET_KEY2));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SEC_WEBSOCKET_LOCATION));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SEC_WEBSOCKET_ORIGIN));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SEC_WEBSOCKET_VERSION));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SEC_WEBSOCKET_KEY));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SEC_WEBSOCKET_ACCEPT));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SERVER));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SET_COOKIE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.SET_COOKIE2));
        list.add(HttpHeaderValidationUtilTest.header(true, HttpHeaderNames.TE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.TRAILER));
        list.add(HttpHeaderValidationUtilTest.header(true, HttpHeaderNames.TRANSFER_ENCODING));
        list.add(HttpHeaderValidationUtilTest.header(true, HttpHeaderNames.UPGRADE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.UPGRADE_INSECURE_REQUESTS));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.USER_AGENT));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.VARY));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.VIA));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.WARNING));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.WEBSOCKET_LOCATION));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.WEBSOCKET_ORIGIN));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.WEBSOCKET_PROTOCOL));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.WWW_AUTHENTICATE));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.X_FRAME_OPTIONS));
        list.add(HttpHeaderValidationUtilTest.header(false, HttpHeaderNames.X_REQUESTED_WITH));
        return list;
    }

    private static Arguments header(final boolean isConnectionRelated, final AsciiString headerName) {
        return new Arguments(){

            public Object[] get() {
                return new Object[]{headerName, isConnectionRelated};
            }
        };
    }

    @ParameterizedTest
    @MethodSource(value={"connectionRelatedHeaders"})
    void mustIdentifyConnectionRelatedHeadersAsciiString(AsciiString headerName, boolean isConnectionRelated) {
        Assertions.assertEquals((Object)isConnectionRelated, (Object)HttpHeaderValidationUtil.isConnectionHeader((CharSequence)headerName, (boolean)false));
    }

    @ParameterizedTest
    @MethodSource(value={"connectionRelatedHeaders"})
    void mustIdentifyConnectionRelatedHeadersString(AsciiString headerName, boolean isConnectionRelated) {
        Assertions.assertEquals((Object)isConnectionRelated, (Object)HttpHeaderValidationUtil.isConnectionHeader((CharSequence)headerName.toString(), (boolean)false));
    }

    @Test
    void teHeaderIsNotConnectionRelatedWhenIgnoredAsciiString() {
        Assertions.assertFalse((boolean)HttpHeaderValidationUtil.isConnectionHeader((CharSequence)HttpHeaderNames.TE, (boolean)true));
    }

    @Test
    void teHeaderIsNotConnectionRelatedWhenIgnoredString() {
        Assertions.assertFalse((boolean)HttpHeaderValidationUtil.isConnectionHeader((CharSequence)HttpHeaderNames.TE.toString(), (boolean)true));
    }

    public static List<Arguments> teIsTrailersTruthTable() {
        ArrayList<Arguments> list = new ArrayList<Arguments>();
        list.add(HttpHeaderValidationUtilTest.teIsTrailter(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS, false));
        list.add(HttpHeaderValidationUtilTest.teIsTrailter(HttpHeaderNames.TE, HttpHeaderValues.CHUNKED, true));
        list.add(HttpHeaderValidationUtilTest.teIsTrailter(HttpHeaderNames.COOKIE, HttpHeaderValues.CHUNKED, false));
        list.add(HttpHeaderValidationUtilTest.teIsTrailter(HttpHeaderNames.COOKIE, HttpHeaderValues.TRAILERS, false));
        list.add(HttpHeaderValidationUtilTest.teIsTrailter(HttpHeaderNames.TRAILER, HttpHeaderValues.TRAILERS, false));
        list.add(HttpHeaderValidationUtilTest.teIsTrailter(HttpHeaderNames.TRAILER, HttpHeaderValues.CHUNKED, false));
        return list;
    }

    private static Arguments teIsTrailter(final AsciiString headerName, final AsciiString headerValue, final boolean result) {
        return new Arguments(){

            public Object[] get() {
                return new Object[]{headerName, headerValue, result};
            }
        };
    }

    @ParameterizedTest
    @MethodSource(value={"teIsTrailersTruthTable"})
    void whenTeIsNotTrailerOrNotWithNameAndValueAsciiString(AsciiString headerName, AsciiString headerValue, boolean result) {
        Assertions.assertEquals((Object)result, (Object)HttpHeaderValidationUtil.isTeNotTrailers((CharSequence)headerName, (CharSequence)headerValue));
    }

    @ParameterizedTest
    @MethodSource(value={"teIsTrailersTruthTable"})
    void whenTeIsNotTrailerOrNotSWithNameAndValueString(AsciiString headerName, AsciiString headerValue, boolean result) {
        Assertions.assertEquals((Object)result, (Object)HttpHeaderValidationUtil.isTeNotTrailers((CharSequence)headerName.toString(), (CharSequence)headerValue.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"teIsTrailersTruthTable"})
    void whenTeIsNotTrailerOrNotSWithNameAsciiStringAndValueString(AsciiString headerName, AsciiString headerValue, boolean result) {
        Assertions.assertEquals((Object)result, (Object)HttpHeaderValidationUtil.isTeNotTrailers((CharSequence)headerName, (CharSequence)headerValue.toString()));
    }

    @ParameterizedTest
    @MethodSource(value={"teIsTrailersTruthTable"})
    void whenTeIsNotTrailerOrNotSWithNametringAndValueAsciiString(AsciiString headerName, AsciiString headerValue, boolean result) {
        Assertions.assertEquals((Object)result, (Object)HttpHeaderValidationUtil.isTeNotTrailers((CharSequence)headerName.toString(), (CharSequence)headerValue));
    }

    public static List<AsciiString> illegalFirstChar() {
        ArrayList<AsciiString> list = new ArrayList<AsciiString>();
        for (byte i = 0; i < 33; i = (byte)((byte)(i + 1))) {
            list.add(new AsciiString(new byte[]{i, 97}));
        }
        list.add(new AsciiString(new byte[]{127, 97}));
        return list;
    }

    @ParameterizedTest
    @MethodSource(value={"illegalFirstChar"})
    void decodingInvalidHeaderValuesMustFailIfFirstCharIsIllegalAsciiString(AsciiString value) {
        Assertions.assertEquals((int)0, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)value));
    }

    @ParameterizedTest
    @MethodSource(value={"illegalFirstChar"})
    void decodingInvalidHeaderValuesMustFailIfFirstCharIsIllegalCharSequence(AsciiString value) {
        Assertions.assertEquals((int)0, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)HttpHeaderValidationUtilTest.asCharSequence(value)));
    }

    public static List<AsciiString> legalFirstChar() {
        ArrayList<AsciiString> list = new ArrayList<AsciiString>();
        for (int i = 33; i <= 255; ++i) {
            if (i == 127) continue;
            list.add(new AsciiString(new byte[]{(byte)i, 97}));
        }
        return list;
    }

    @ParameterizedTest
    @MethodSource(value={"legalFirstChar"})
    void allOtherCharsAreLegalFirstCharsAsciiString(AsciiString value) {
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)value));
    }

    @ParameterizedTest
    @MethodSource(value={"legalFirstChar"})
    void allOtherCharsAreLegalFirstCharsCharSequence(AsciiString value) {
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)value));
    }

    public static List<AsciiString> illegalNotFirstChar() {
        ArrayList<AsciiString> list = new ArrayList<AsciiString>();
        for (byte i = 0; i < 33; i = (byte)((byte)(i + 1))) {
            if (i == 32 || i == 9) continue;
            list.add(new AsciiString(new byte[]{97, i}));
        }
        list.add(new AsciiString(new byte[]{97, 127}));
        return list;
    }

    @ParameterizedTest
    @MethodSource(value={"illegalNotFirstChar"})
    void decodingInvalidHeaderValuesMustFailIfNotFirstCharIsIllegalAsciiString(AsciiString value) {
        Assertions.assertEquals((int)1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)value));
    }

    @ParameterizedTest
    @MethodSource(value={"illegalNotFirstChar"})
    void decodingInvalidHeaderValuesMustFailIfNotFirstCharIsIllegalCharSequence(AsciiString value) {
        Assertions.assertEquals((int)1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)HttpHeaderValidationUtilTest.asCharSequence(value)));
    }

    public static List<AsciiString> legalNotFirstChar() {
        ArrayList<AsciiString> list = new ArrayList<AsciiString>();
        for (int i = 0; i < 255; ++i) {
            if (i == 127 || i < 33 && (i != 32 || i != 9)) continue;
            list.add(new AsciiString(new byte[]{97, (byte)i}));
        }
        return list;
    }

    @ParameterizedTest
    @MethodSource(value={"legalNotFirstChar"})
    void allOtherCharsArgLegalNotFirstCharsAsciiString(AsciiString value) {
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)value));
    }

    @ParameterizedTest
    @MethodSource(value={"legalNotFirstChar"})
    void allOtherCharsArgLegalNotFirstCharsCharSequence(AsciiString value) {
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)HttpHeaderValidationUtilTest.asCharSequence(value)));
    }

    @Test
    void emptyValuesHaveNoIllegalCharsAsciiString() {
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)AsciiString.EMPTY_STRING));
    }

    @Test
    void emptyValuesHaveNoIllegalCharsCharSequence() {
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)HttpHeaderValidationUtilTest.asCharSequence(AsciiString.EMPTY_STRING)));
    }

    @Test
    void headerValuesCannotEndWithNewlinesAsciiString() {
        Assertions.assertEquals((int)1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)AsciiString.of((CharSequence)"a\n")));
        Assertions.assertEquals((int)1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)AsciiString.of((CharSequence)"a\r")));
    }

    @Test
    void headerValuesCannotEndWithNewlinesCharSequence() {
        Assertions.assertEquals((int)1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)"a\n"));
        Assertions.assertEquals((int)1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)"a\r"));
    }

    private static CharSequence asCharSequence(final AsciiString value) {
        return new CharSequence(){

            @Override
            public int length() {
                return value.length();
            }

            @Override
            public char charAt(int index) {
                return value.charAt(index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return HttpHeaderValidationUtilTest.asCharSequence(value.subSequence(start, end));
            }
        };
    }

    @DisabledForJreRange(max=JRE.JAVA_17)
    @Test
    void headerValueValidationMustRejectAllValuesRejectedByOldAlgorithm() {
        byte[] array = new byte[4];
        final ByteBuffer buffer = ByteBuffer.wrap(array);
        final AsciiString asciiString = new AsciiString(buffer, false);
        CharSequence charSequence = HttpHeaderValidationUtilTest.asCharSequence(asciiString);
        int i = Integer.MIN_VALUE;
        Supplier<String> failureMessageSupplier = new Supplier<String>(){

            @Override
            public String get() {
                return "validation mismatch on string '" + asciiString + "', iteration " + buffer.getInt(0);
            }
        };
        do {
            buffer.putInt(0, i);
            try {
                HttpHeaderValidationUtilTest.oldHeaderValueValidationAlgorithm((CharSequence)asciiString);
            }
            catch (IllegalArgumentException ignore) {
                Assertions.assertNotEquals((int)-1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)asciiString), (Supplier)failureMessageSupplier);
                Assertions.assertNotEquals((int)-1, (int)HttpHeaderValidationUtil.validateValidHeaderValue((CharSequence)charSequence), (Supplier)failureMessageSupplier);
            }
        } while (++i != Integer.MIN_VALUE);
    }

    private static void oldHeaderValueValidationAlgorithm(CharSequence seq) {
        int state = 0;
        for (int index = 0; index < seq.length(); ++index) {
            state = HttpHeaderValidationUtilTest.oldValidationAlgorithmValidateValueChar(state, seq.charAt(index));
        }
        if (state != 0) {
            throw VALIDATION_EXCEPTION;
        }
    }

    private static int oldValidationAlgorithmValidateValueChar(int state, char character) {
        if ((character & 0xFFFFFFF0) == 0) {
            switch (character) {
                case '\u0000': {
                    throw VALIDATION_EXCEPTION;
                }
                case '\u000b': {
                    throw VALIDATION_EXCEPTION;
                }
                case '\f': {
                    throw VALIDATION_EXCEPTION;
                }
            }
        }
        switch (state) {
            case 0: {
                switch (character) {
                    case '\r': {
                        return 1;
                    }
                    case '\n': {
                        return 2;
                    }
                }
                break;
            }
            case 1: {
                if (character == '\n') {
                    return 2;
                }
                throw VALIDATION_EXCEPTION;
            }
            case 2: {
                switch (character) {
                    case '\t': 
                    case ' ': {
                        return 0;
                    }
                }
                throw VALIDATION_EXCEPTION;
            }
        }
        return state;
    }

    @DisabledForJreRange(max=JRE.JAVA_17)
    @Test
    void headerNameValidationMustRejectAllNamesRejectedByOldAlgorithm() throws Exception {
        byte[] array = new byte[4];
        final ByteBuffer buffer = ByteBuffer.wrap(array);
        final AsciiString asciiString = new AsciiString(buffer, false);
        CharSequence charSequence = HttpHeaderValidationUtilTest.asCharSequence(asciiString);
        int i = Integer.MIN_VALUE;
        Supplier<String> failureMessageSupplier = new Supplier<String>(){

            @Override
            public String get() {
                return "validation mismatch on string '" + asciiString + "', iteration " + buffer.getInt(0);
            }
        };
        do {
            buffer.putInt(0, i);
            try {
                HttpHeaderValidationUtilTest.oldHeaderNameValidationAlgorithmAsciiString(asciiString);
            }
            catch (IllegalArgumentException ignore) {
                Assertions.assertNotEquals((int)-1, (int)HttpHeaderValidationUtil.validateToken((CharSequence)asciiString), (Supplier)failureMessageSupplier);
                Assertions.assertNotEquals((int)-1, (int)HttpHeaderValidationUtil.validateToken((CharSequence)charSequence), (Supplier)failureMessageSupplier);
            }
        } while (++i != Integer.MIN_VALUE);
    }

    private static void oldHeaderNameValidationAlgorithmAsciiString(AsciiString name) throws Exception {
        byte[] array = name.array();
        int len = name.arrayOffset() + name.length();
        for (int i = name.arrayOffset(); i < len; ++i) {
            HttpHeaderValidationUtilTest.validateHeaderNameElement(array[i]);
        }
    }

    private static void validateHeaderNameElement(byte value) {
        switch (value) {
            case 0: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 44: 
            case 58: 
            case 59: 
            case 61: {
                throw VALIDATION_EXCEPTION;
            }
        }
        if (value < 0) {
            throw VALIDATION_EXCEPTION;
        }
    }

    public static List<Character> validTokenChars() {
        char c;
        ArrayList<Character> list = new ArrayList<Character>();
        for (c = '0'; c <= '9'; c = (char)(c + 1)) {
            list.add(Character.valueOf(c));
        }
        for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            list.add(Character.valueOf(c));
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            list.add(Character.valueOf(c));
        }
        list.add(Character.valueOf('-'));
        list.add(Character.valueOf('.'));
        list.add(Character.valueOf('_'));
        list.add(Character.valueOf('~'));
        list.add(Character.valueOf('!'));
        list.add(Character.valueOf('#'));
        list.add(Character.valueOf('$'));
        list.add(Character.valueOf('%'));
        list.add(Character.valueOf('&'));
        list.add(Character.valueOf('\''));
        list.add(Character.valueOf('*'));
        list.add(Character.valueOf('+'));
        list.add(Character.valueOf('^'));
        list.add(Character.valueOf('`'));
        list.add(Character.valueOf('|'));
        return list;
    }

    @ParameterizedTest
    @MethodSource(value={"validTokenChars"})
    void allTokenCharsAreValidFirstCharHeaderName(char tokenChar) {
        AsciiString asciiString = new AsciiString(new byte[]{(byte)tokenChar, 97});
        CharSequence charSequence = HttpHeaderValidationUtilTest.asCharSequence(asciiString);
        String string = tokenChar + "a";
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateToken((CharSequence)asciiString));
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateToken((CharSequence)charSequence));
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateToken((CharSequence)string));
    }

    @ParameterizedTest
    @MethodSource(value={"validTokenChars"})
    void allTokenCharsAreValidSecondCharHeaderName(char tokenChar) {
        AsciiString asciiString = new AsciiString(new byte[]{97, (byte)tokenChar});
        CharSequence charSequence = HttpHeaderValidationUtilTest.asCharSequence(asciiString);
        String string = "a" + tokenChar;
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateToken((CharSequence)asciiString));
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateToken((CharSequence)charSequence));
        Assertions.assertEquals((int)-1, (int)HttpHeaderValidationUtil.validateToken((CharSequence)string));
    }
}

