/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.ReadOnlyHttpHeaders;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ReadOnlyHttpHeadersTest {
    @Test
    public void getValue() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON});
        Assertions.assertFalse((boolean)headers.isEmpty());
        Assertions.assertEquals((int)1, (int)headers.size());
        Assertions.assertTrue((boolean)HttpHeaderValues.APPLICATION_JSON.contentEquals((CharSequence)headers.get((CharSequence)HttpHeaderNames.ACCEPT)));
        Assertions.assertTrue((boolean)headers.contains((CharSequence)HttpHeaderNames.ACCEPT));
        Assertions.assertNull((Object)headers.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertFalse((boolean)headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
    }

    @Test
    public void charSequenceIterator() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO, HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE});
        Assertions.assertFalse((boolean)headers.isEmpty());
        Assertions.assertEquals((int)3, (int)headers.size());
        Iterator itr = headers.iteratorCharSequence();
        Assertions.assertTrue((boolean)itr.hasNext());
        Map.Entry next = (Map.Entry)itr.next();
        Assertions.assertTrue((boolean)HttpHeaderNames.ACCEPT.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assertions.assertTrue((boolean)HttpHeaderValues.APPLICATION_JSON.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assertions.assertTrue((boolean)itr.hasNext());
        next = (Map.Entry)itr.next();
        Assertions.assertTrue((boolean)HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assertions.assertTrue((boolean)HttpHeaderValues.ZERO.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assertions.assertTrue((boolean)itr.hasNext());
        next = (Map.Entry)itr.next();
        Assertions.assertTrue((boolean)HttpHeaderNames.CONNECTION.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assertions.assertTrue((boolean)HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assertions.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void stringIterator() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO, HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE});
        Assertions.assertFalse((boolean)headers.isEmpty());
        Assertions.assertEquals((int)3, (int)headers.size());
        ReadOnlyHttpHeadersTest.assert3ParisEquals(headers.iterator());
    }

    @Test
    public void entries() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO, HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE});
        Assertions.assertFalse((boolean)headers.isEmpty());
        Assertions.assertEquals((int)3, (int)headers.size());
        ReadOnlyHttpHeadersTest.assert3ParisEquals(headers.entries().iterator());
    }

    @Test
    public void names() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO, HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE});
        Assertions.assertFalse((boolean)headers.isEmpty());
        Assertions.assertEquals((int)3, (int)headers.size());
        Set names = headers.names();
        Assertions.assertEquals((int)3, (int)names.size());
        Assertions.assertTrue((boolean)names.contains(HttpHeaderNames.ACCEPT.toString()));
        Assertions.assertTrue((boolean)names.contains(HttpHeaderNames.CONTENT_LENGTH.toString()));
        Assertions.assertTrue((boolean)names.contains(HttpHeaderNames.CONNECTION.toString()));
    }

    @Test
    public void getAll() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(false, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO, HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_OCTET_STREAM});
        Assertions.assertFalse((boolean)headers.isEmpty());
        Assertions.assertEquals((int)3, (int)headers.size());
        List names = headers.getAll((CharSequence)HttpHeaderNames.ACCEPT);
        Assertions.assertEquals((int)2, (int)names.size());
        Assertions.assertTrue((boolean)HttpHeaderValues.APPLICATION_JSON.contentEqualsIgnoreCase((CharSequence)names.get(0)));
        Assertions.assertTrue((boolean)HttpHeaderValues.APPLICATION_OCTET_STREAM.contentEqualsIgnoreCase((CharSequence)names.get(1)));
    }

    @Test
    public void validateNamesFail() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, AsciiString.cached((String)" ")});
            }
        });
    }

    @Test
    public void emptyHeaderName() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, AsciiString.cached((String)" "), HttpHeaderValues.ZERO});
            }
        });
    }

    @Test
    public void headerWithoutValue() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new ReadOnlyHttpHeaders(false, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH});
            }
        });
    }

    private static void assert3ParisEquals(Iterator<Map.Entry<String, String>> itr) {
        Assertions.assertTrue((boolean)itr.hasNext());
        Map.Entry<String, String> next = itr.next();
        Assertions.assertTrue((boolean)HttpHeaderNames.ACCEPT.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assertions.assertTrue((boolean)HttpHeaderValues.APPLICATION_JSON.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assertions.assertTrue((boolean)itr.hasNext());
        next = itr.next();
        Assertions.assertTrue((boolean)HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assertions.assertTrue((boolean)HttpHeaderValues.ZERO.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assertions.assertTrue((boolean)itr.hasNext());
        next = itr.next();
        Assertions.assertTrue((boolean)HttpHeaderNames.CONNECTION.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assertions.assertTrue((boolean)HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assertions.assertFalse((boolean)itr.hasNext());
    }
}

