/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DeleteFileOnExitHook;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="The DeleteFileOnExitHook has static shared mutable, and can interferre with other tests that use DiskAttribute")
public class DeleteFileOnExitHookTest {
    private static final HttpRequest REQUEST = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/form");
    private static final String HOOK_TEST_TMP = "target/DeleteFileOnExitHookTest-" + UUID.randomUUID() + "/tmp";
    private FileUpload fu;

    @BeforeEach
    public void setUp() throws IOException {
        DefaultHttpDataFactory defaultHttpDataFactory = new DefaultHttpDataFactory(true);
        defaultHttpDataFactory.setBaseDir(HOOK_TEST_TMP);
        defaultHttpDataFactory.setDeleteOnExit(true);
        File baseDir = new File(HOOK_TEST_TMP);
        baseDir.mkdirs();
        this.fu = defaultHttpDataFactory.createFileUpload(REQUEST, "attribute1", "tmp_f.txt", "text/plain", null, null, 0L);
        this.fu.setContent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
        Assertions.assertTrue((boolean)this.fu.getFile().exists());
    }

    @Test
    public void testSimulateTriggerDeleteFileOnExitHook() {
        DeleteFileOnExitHook.runHook();
        File[] files = new File(HOOK_TEST_TMP).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("FUp_");
            }
        });
        Assertions.assertEquals((int)0, (int)files.length);
    }

    @Test
    public void testAfterHttpDataReleaseCheckFileExist() throws IOException {
        String filePath = this.fu.getFile().getPath();
        Assertions.assertTrue((boolean)DeleteFileOnExitHook.checkFileExist((String)filePath));
        this.fu.release();
        Assertions.assertFalse((boolean)DeleteFileOnExitHook.checkFileExist((String)filePath));
    }
}

