/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.netty.handler.codec.http.multipart.MixedAttribute;
import io.netty.handler.codec.http.multipart.MixedFileUpload;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class HttpDataTest {
    private static final byte[] BYTES = new byte[64];

    HttpDataTest() {
    }

    static HttpData[] data() {
        return new HttpData[]{new MemoryAttribute("test", 10L), new MemoryFileUpload("test", "", "text/plain", null, CharsetUtil.UTF_8, 10L), new MixedAttribute("test", 10L, -1L), new MixedFileUpload("test", "", "text/plain", null, CharsetUtil.UTF_8, 10L, -1L), new DiskAttribute("test", 10L), new DiskFileUpload("test", "", "text/plain", null, CharsetUtil.UTF_8, 10L)};
    }

    @BeforeAll
    static void setUp() {
        Random rndm = new Random();
        rndm.nextBytes(BYTES);
    }

    @ParameterizedHttpDataTest
    void testAddContentEmptyBuffer(HttpData httpData) throws IOException {
        ByteBuf content = PooledByteBufAllocator.DEFAULT.buffer();
        httpData.addContent(content, false);
        Assertions.assertThat((int)content.refCnt()).isEqualTo(0);
    }

    @ParameterizedHttpDataTest
    void testCompletedFlagPreservedAfterRetainDuplicate(HttpData httpData) throws IOException {
        httpData.addContent(Unpooled.wrappedBuffer((byte[])"foo".getBytes(CharsetUtil.UTF_8)), false);
        Assertions.assertThat((boolean)httpData.isCompleted()).isFalse();
        HttpData duplicate = httpData.retainedDuplicate();
        Assertions.assertThat((boolean)duplicate.isCompleted()).isFalse();
        Assertions.assertThat((boolean)duplicate.release()).isTrue();
        httpData.addContent(Unpooled.wrappedBuffer((byte[])"bar".getBytes(CharsetUtil.UTF_8)), true);
        Assertions.assertThat((boolean)httpData.isCompleted()).isTrue();
        duplicate = httpData.retainedDuplicate();
        Assertions.assertThat((boolean)duplicate.isCompleted()).isTrue();
        Assertions.assertThat((boolean)duplicate.release()).isTrue();
    }

    @Test
    void testAddContentExceedsDefinedSizeDiskFileUpload() {
        HttpDataTest.doTestAddContentExceedsSize((HttpData)new DiskFileUpload("test", "", "application/json", null, CharsetUtil.UTF_8, 10L), "Out of size: 64 > 10");
    }

    @Test
    void testAddContentExceedsDefinedSizeMemoryFileUpload() {
        HttpDataTest.doTestAddContentExceedsSize((HttpData)new MemoryFileUpload("test", "", "application/json", null, CharsetUtil.UTF_8, 10L), "Out of size: 64 > 10");
    }

    @ParameterizedHttpDataTest
    void testAddContentExceedsMaxSize(HttpData httpData) {
        httpData.setMaxSize(10L);
        HttpDataTest.doTestAddContentExceedsSize(httpData, "Size exceed allowed maximum capacity");
    }

    @ParameterizedHttpDataTest
    void testSetContentExceedsDefinedSize(HttpData httpData) {
        HttpDataTest.doTestSetContentExceedsSize(httpData, "Out of size: 64 > 10");
    }

    @ParameterizedHttpDataTest
    void testSetContentExceedsMaxSize(HttpData httpData) {
        httpData.setMaxSize(10L);
        HttpDataTest.doTestSetContentExceedsSize(httpData, "Size exceed allowed maximum capacity");
    }

    private static void doTestAddContentExceedsSize(final HttpData httpData, String expectedMessage) {
        final ByteBuf content = PooledByteBufAllocator.DEFAULT.buffer();
        content.writeBytes(BYTES);
        Assertions.assertThatExceptionOfType(IOException.class).isThrownBy(new ThrowableAssert.ThrowingCallable(){

            public void call() throws Throwable {
                httpData.addContent(content, false);
            }
        }).withMessage(expectedMessage);
        Assertions.assertThat((int)content.refCnt()).isEqualTo(0);
    }

    private static void doTestSetContentExceedsSize(final HttpData httpData, String expectedMessage) {
        final ByteBuf content = PooledByteBufAllocator.DEFAULT.buffer();
        content.writeBytes(BYTES);
        Assertions.assertThatExceptionOfType(IOException.class).isThrownBy(new ThrowableAssert.ThrowingCallable(){

            public void call() throws Throwable {
                httpData.setContent(content);
            }
        }).withMessage(expectedMessage);
        Assertions.assertThat((int)content.refCnt()).isEqualTo(0);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @ParameterizedTest(name="{displayName}({0})")
    @MethodSource(value={"data"})
    static @interface ParameterizedHttpDataTest {
    }
}

