/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WebSocket00FrameEncoderTest {
    @Test
    public void testMultipleWebSocketCloseFrames() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket00FrameEncoder()});
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new CloseWebSocketFrame()}));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new CloseWebSocketFrame()}));
        Assertions.assertTrue((boolean)channel.finish());
        WebSocket00FrameEncoderTest.assertCloseWebSocketFrame(channel);
        WebSocket00FrameEncoderTest.assertCloseWebSocketFrame(channel);
        Assertions.assertNull((Object)channel.readOutbound());
    }

    private static void assertCloseWebSocketFrame(EmbeddedChannel channel) {
        ByteBuf buf = (ByteBuf)channel.readOutbound();
        Assertions.assertEquals((int)2, (int)buf.readableBytes());
        Assertions.assertEquals((byte)-1, (byte)buf.readByte());
        Assertions.assertEquals((byte)0, (byte)buf.readByte());
        buf.release();
    }
}

