/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;

public class WebSocketHandshakeHandOverTest {
    private boolean serverReceivedHandshake;
    private WebSocketServerProtocolHandler.HandshakeComplete serverHandshakeComplete;
    private boolean clientReceivedHandshake;
    private boolean clientReceivedMessage;
    private boolean serverReceivedCloseHandshake;
    private boolean clientForceClosed;
    private boolean clientHandshakeTimeout;

    @BeforeEach
    public void setUp() {
        this.serverReceivedHandshake = false;
        this.serverHandshakeComplete = null;
        this.clientReceivedHandshake = false;
        this.clientReceivedMessage = false;
        this.serverReceivedCloseHandshake = false;
        this.clientForceClosed = false;
        this.clientHandshakeTimeout = false;
    }

    @Test
    public void testHandover() throws Exception {
        EmbeddedChannel serverChannel = WebSocketHandshakeHandOverTest.createServerChannel((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt == WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE) {
                    WebSocketHandshakeHandOverTest.this.serverReceivedHandshake = true;
                    ctx.writeAndFlush((Object)new TextWebSocketFrame("abc"));
                } else if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
                    WebSocketHandshakeHandOverTest.this.serverHandshakeComplete = (WebSocketServerProtocolHandler.HandshakeComplete)evt;
                }
            }

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            }
        });
        EmbeddedChannel clientChannel = WebSocketHandshakeHandOverTest.createClientChannel((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
                    WebSocketHandshakeHandOverTest.this.clientReceivedHandshake = true;
                }
            }

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof TextWebSocketFrame) {
                    WebSocketHandshakeHandOverTest.this.clientReceivedMessage = true;
                }
            }
        });
        WebSocketHandshakeHandOverTest.transferAllDataWithMerge(clientChannel, serverChannel);
        Assertions.assertTrue((boolean)this.serverReceivedHandshake);
        Assertions.assertNotNull((Object)this.serverHandshakeComplete);
        Assertions.assertEquals((Object)"/test", (Object)this.serverHandshakeComplete.requestUri());
        Assertions.assertEquals((int)8, (int)this.serverHandshakeComplete.requestHeaders().size());
        Assertions.assertEquals((Object)"test-proto-2", (Object)this.serverHandshakeComplete.selectedSubprotocol());
        WebSocketHandshakeHandOverTest.transferAllDataWithMerge(serverChannel, clientChannel);
        Assertions.assertTrue((boolean)this.clientReceivedHandshake);
        Assertions.assertTrue((boolean)this.clientReceivedMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientHandshakeTimeout() throws Throwable {
        EmbeddedChannel serverChannel = WebSocketHandshakeHandOverTest.createServerChannel((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt == WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE) {
                    WebSocketHandshakeHandOverTest.this.serverReceivedHandshake = true;
                    ctx.writeAndFlush((Object)new TextWebSocketFrame("abc"));
                } else if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
                    WebSocketHandshakeHandOverTest.this.serverHandshakeComplete = (WebSocketServerProtocolHandler.HandshakeComplete)evt;
                }
            }

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            }
        });
        EmbeddedChannel clientChannel = WebSocketHandshakeHandOverTest.createClientChannel((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
                    WebSocketHandshakeHandOverTest.this.clientReceivedHandshake = true;
                } else if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT) {
                    WebSocketHandshakeHandOverTest.this.clientHandshakeTimeout = true;
                }
            }

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof TextWebSocketFrame) {
                    WebSocketHandshakeHandOverTest.this.clientReceivedMessage = true;
                }
            }
        }, 100L);
        WebSocketHandshakeHandOverTest.transferAllDataWithMerge(clientChannel, serverChannel);
        final WebSocketClientProtocolHandshakeHandler handshakeHandler = (WebSocketClientProtocolHandshakeHandler)clientChannel.pipeline().get(WebSocketClientProtocolHandshakeHandler.class.getName());
        while (!handshakeHandler.getHandshakeFuture().isDone()) {
            Thread.sleep(10L);
            clientChannel.runScheduledPendingTasks();
        }
        Assertions.assertTrue((boolean)this.clientHandshakeTimeout);
        Assertions.assertFalse((boolean)this.clientReceivedHandshake);
        Assertions.assertFalse((boolean)this.clientReceivedMessage);
        try {
            Assertions.assertThrows(WebSocketHandshakeException.class, (Executable)new Executable(){

                public void execute() {
                    handshakeHandler.getHandshakeFuture().syncUninterruptibly();
                }
            });
        }
        finally {
            serverChannel.finishAndReleaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandshakeFutureIsNotifiedOnChannelClose() throws Exception {
        EmbeddedChannel clientChannel = WebSocketHandshakeHandOverTest.createClientChannel(null);
        EmbeddedChannel serverChannel = WebSocketHandshakeHandOverTest.createServerChannel(null);
        try {
            WebSocketHandshakeHandOverTest.transferAllDataWithMerge(clientChannel, serverChannel);
            WebSocketClientProtocolHandler clientWsHandler = (WebSocketClientProtocolHandler)clientChannel.pipeline().get(WebSocketClientProtocolHandler.class);
            WebSocketClientProtocolHandshakeHandler clientWsHandshakeHandler = (WebSocketClientProtocolHandshakeHandler)clientChannel.pipeline().get(WebSocketClientProtocolHandshakeHandler.class);
            ChannelHandlerContext ctx = clientChannel.pipeline().context(WebSocketClientProtocolHandler.class);
            clientWsHandler.close(ctx, ctx.newPromise());
            Assertions.assertTrue((boolean)clientWsHandshakeHandler.getHandshakeFuture().isDone());
        }
        finally {
            serverChannel.finishAndReleaseAll();
            clientChannel.finishAndReleaseAll();
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testClientHandshakerForceClose() throws Exception {
        final WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)new URI("ws://localhost:1234/test"), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)EmptyHttpHeaders.INSTANCE, (int)Integer.MAX_VALUE, (boolean)true, (boolean)false, (long)20L);
        EmbeddedChannel serverChannel = WebSocketHandshakeHandOverTest.createServerChannel(new CloseNoOpServerProtocolHandler("/test"), (ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            }
        });
        EmbeddedChannel clientChannel = WebSocketHandshakeHandOverTest.createClientChannel(handshaker, (ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
                    ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            WebSocketHandshakeHandOverTest.this.clientForceClosed = true;
                        }
                    });
                    handshaker.close(ctx.channel(), new CloseWebSocketFrame());
                }
            }

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            }
        });
        WebSocketHandshakeHandOverTest.transferAllDataWithMerge(clientChannel, serverChannel);
        WebSocketHandshakeHandOverTest.transferAllDataWithMerge(serverChannel, clientChannel);
        WebSocketHandshakeHandOverTest.transferAllDataWithMerge(clientChannel, serverChannel);
        Assertions.assertTrue((boolean)this.serverReceivedCloseHandshake);
        Assertions.assertFalse((boolean)this.clientForceClosed);
        while (!this.clientForceClosed) {
            Thread.sleep(10L);
            clientChannel.runPendingTasks();
        }
        Assertions.assertTrue((boolean)handshaker.isForceCloseComplete());
        Assertions.assertFalse((boolean)serverChannel.finishAndReleaseAll());
        Assertions.assertFalse((boolean)clientChannel.finishAndReleaseAll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferAllDataWithMerge(EmbeddedChannel srcChannel, EmbeddedChannel dstChannel) {
        Object srcData;
        ByteBuf mergedBuffer = null;
        while ((srcData = srcChannel.readOutbound()) != null) {
            Assertions.assertTrue((boolean)(srcData instanceof ByteBuf));
            ByteBuf srcBuf = (ByteBuf)srcData;
            try {
                if (mergedBuffer == null) {
                    mergedBuffer = Unpooled.buffer();
                }
                mergedBuffer.writeBytes(srcBuf);
            }
            finally {
                srcBuf.release();
            }
        }
        if (mergedBuffer != null) {
            dstChannel.writeInbound(new Object[]{mergedBuffer});
        }
    }

    private static EmbeddedChannel createClientChannel(ChannelHandler handler) throws Exception {
        return WebSocketHandshakeHandOverTest.createClientChannel(handler, WebSocketClientProtocolConfig.newBuilder().webSocketUri("ws://localhost:1234/test").subprotocol("test-proto-2").build());
    }

    private static EmbeddedChannel createClientChannel(ChannelHandler handler, long timeoutMillis) throws Exception {
        return WebSocketHandshakeHandOverTest.createClientChannel(handler, WebSocketClientProtocolConfig.newBuilder().webSocketUri("ws://localhost:1234/test").subprotocol("test-proto-2").handshakeTimeoutMillis(timeoutMillis).build());
    }

    private static EmbeddedChannel createClientChannel(ChannelHandler handler, WebSocketClientProtocolConfig config) {
        return new EmbeddedChannel(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), new WebSocketClientProtocolHandler(config), handler});
    }

    private static EmbeddedChannel createClientChannel(WebSocketClientHandshaker handshaker, ChannelHandler handler) throws Exception {
        return new EmbeddedChannel(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), new WebSocketClientProtocolHandler(handshaker, false, false), handler});
    }

    private static EmbeddedChannel createServerChannel(ChannelHandler handler) {
        return WebSocketHandshakeHandOverTest.createServerChannel(new WebSocketServerProtocolHandler("/test", "test-proto-1, test-proto-2", false), handler);
    }

    private static EmbeddedChannel createServerChannel(WebSocketServerProtocolHandler webSocketHandler, ChannelHandler handler) {
        return new EmbeddedChannel(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(8192), webSocketHandler, handler});
    }

    private final class CloseNoOpServerProtocolHandler
    extends WebSocketServerProtocolHandler {
        CloseNoOpServerProtocolHandler(String websocketPath) {
            super(WebSocketServerProtocolConfig.newBuilder().websocketPath(websocketPath).allowExtensions(false).sendCloseFrame(null).build());
        }

        protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
            if (frame instanceof CloseWebSocketFrame) {
                WebSocketHandshakeHandOverTest.this.serverReceivedCloseHandshake = true;
                return;
            }
            super.decode(ctx, frame, out);
        }
    }
}

