/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class WebSocketServerHandshakerTest {
    protected abstract WebSocketServerHandshaker newHandshaker(String var1, String var2, WebSocketDecoderConfig var3);

    protected abstract WebSocketVersion webSocketVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateHandshakeResponseHeaders() {
        WebSocketServerHandshaker serverHandshaker = this.newHandshaker("ws://example.com/chat", "chat", WebSocketDecoderConfig.DEFAULT);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/chat");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"example.com").set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"example.com").set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)"dGhlIHNhbXBsZSBub25jZQ==").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)"http://example.com").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"chat, superchat").set((CharSequence)HttpHeaderNames.WEBSOCKET_PROTOCOL, (Object)"chat, superchat").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)this.webSocketVersion().toAsciiString());
        DefaultHttpHeaders customResponseHeaders = new DefaultHttpHeaders();
        customResponseHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"superchat").set((CharSequence)HttpHeaderNames.WEBSOCKET_PROTOCOL, (Object)"superchat").set("custom", (Object)"header");
        if (this.webSocketVersion() != WebSocketVersion.V00) {
            customResponseHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, (Object)"12345");
        }
        FullHttpResponse response = null;
        try {
            response = serverHandshaker.newHandshakeResponse((FullHttpRequest)request, (HttpHeaders)customResponseHeaders);
            HttpHeaders responseHeaders = response.headers();
            Assertions.assertEquals((int)1, (int)responseHeaders.getAll((CharSequence)HttpHeaderNames.CONNECTION).size());
            Assertions.assertEquals((int)1, (int)responseHeaders.getAll((CharSequence)HttpHeaderNames.UPGRADE).size());
            Assertions.assertTrue((boolean)responseHeaders.containsValue((CharSequence)"custom", (CharSequence)"header", true));
            if (this.webSocketVersion() != WebSocketVersion.V00) {
                Assertions.assertFalse((boolean)responseHeaders.containsValue((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, (CharSequence)"12345", false));
                Assertions.assertEquals((int)1, (int)responseHeaders.getAll((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL).size());
                Assertions.assertEquals((Object)"chat", (Object)responseHeaders.get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL));
            } else {
                Assertions.assertEquals((int)1, (int)responseHeaders.getAll((CharSequence)HttpHeaderNames.WEBSOCKET_PROTOCOL).size());
                Assertions.assertEquals((Object)"chat", (Object)responseHeaders.get((CharSequence)HttpHeaderNames.WEBSOCKET_PROTOCOL));
            }
        }
        finally {
            request.release();
            if (response != null) {
                response.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebSocketServerHandshakeException() {
        WebSocketServerHandshaker serverHandshaker = this.newHandshaker("ws://example.com/chat", "chat", WebSocketDecoderConfig.DEFAULT);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "ws://example.com/chat");
        request.headers().set("x-client-header", (Object)"value");
        try {
            serverHandshaker.handshake(null, (FullHttpRequest)request, null, null);
        }
        catch (WebSocketServerHandshakeException exception) {
            Assertions.assertNotNull((Object)exception.getMessage());
            Assertions.assertEquals((Object)request.headers(), (Object)exception.request().headers());
            Assertions.assertEquals((Object)HttpMethod.GET, (Object)exception.request().method());
        }
        finally {
            request.release();
        }
    }

    @Test
    public void testHandshakeForHttpRequestWithoutAggregator() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpResponseEncoder()});
        WebSocketServerHandshaker serverHandshaker = this.newHandshaker("ws://example.com/chat", "chat", WebSocketDecoderConfig.DEFAULT);
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/chat");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"example.com").set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"example.com").set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)"dGhlIHNhbXBsZSBub25jZQ==").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)"http://example.com").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"chat, superchat").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY1, (Object)"4 @1  46546xW%0l 1 5").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY2, (Object)"12998 5 Y3 1  .P00").set((CharSequence)HttpHeaderNames.WEBSOCKET_PROTOCOL, (Object)"chat, superchat").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)this.webSocketVersion().toAsciiString());
        ChannelFuture future = serverHandshaker.handshake((Channel)channel, (HttpRequest)request);
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertNotNull((Object)channel.pipeline().get("handshaker"));
        if (this.webSocketVersion() != WebSocketVersion.V00) {
            Assertions.assertNull((Object)channel.pipeline().get("httpAggregator"));
            channel.writeInbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        } else {
            Assertions.assertNotNull((Object)channel.pipeline().get("httpAggregator"));
            channel.writeInbound(new Object[]{new DefaultLastHttpContent(Unpooled.copiedBuffer((CharSequence)"^n:ds[4U", (Charset)CharsetUtil.US_ASCII))});
        }
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertNull((Object)channel.pipeline().get("handshaker"));
        ByteBuf byteBuf = (ByteBuf)channel.readOutbound();
        Assertions.assertFalse((boolean)channel.finish());
        channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{byteBuf}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        Assertions.assertEquals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS, (Object)response.status());
        Assertions.assertTrue((boolean)response.headers().containsValue((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true));
        LastHttpContent lastHttpContent = (LastHttpContent)channel.readInbound();
        if (this.webSocketVersion() != WebSocketVersion.V00) {
            Assertions.assertEquals((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)lastHttpContent);
        } else {
            Assertions.assertEquals((Object)"8jKS'y:G*Co,Wxa-", (Object)lastHttpContent.content().toString(CharsetUtil.US_ASCII));
            Assertions.assertTrue((boolean)lastHttpContent.release());
        }
        Assertions.assertFalse((boolean)channel.finish());
    }
}

