/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WebSocketExtensionFilterTest {
    @Test
    public void testNeverSkip() {
        WebSocketExtensionFilter neverSkip = WebSocketExtensionFilter.NEVER_SKIP;
        BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame();
        Assertions.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)binaryFrame));
        Assertions.assertTrue((boolean)binaryFrame.release());
        TextWebSocketFrame textFrame = new TextWebSocketFrame();
        Assertions.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)textFrame));
        Assertions.assertTrue((boolean)textFrame.release());
        PingWebSocketFrame pingFrame = new PingWebSocketFrame();
        Assertions.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)pingFrame));
        Assertions.assertTrue((boolean)pingFrame.release());
        PongWebSocketFrame pongFrame = new PongWebSocketFrame();
        Assertions.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)pongFrame));
        Assertions.assertTrue((boolean)pongFrame.release());
        CloseWebSocketFrame closeFrame = new CloseWebSocketFrame();
        Assertions.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)closeFrame));
        Assertions.assertTrue((boolean)closeFrame.release());
        ContinuationWebSocketFrame continuationFrame = new ContinuationWebSocketFrame();
        Assertions.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)continuationFrame));
        Assertions.assertTrue((boolean)continuationFrame.release());
    }

    @Test
    public void testAlwaysSkip() {
        WebSocketExtensionFilter neverSkip = WebSocketExtensionFilter.ALWAYS_SKIP;
        BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame();
        Assertions.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)binaryFrame));
        Assertions.assertTrue((boolean)binaryFrame.release());
        TextWebSocketFrame textFrame = new TextWebSocketFrame();
        Assertions.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)textFrame));
        Assertions.assertTrue((boolean)textFrame.release());
        PingWebSocketFrame pingFrame = new PingWebSocketFrame();
        Assertions.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)pingFrame));
        Assertions.assertTrue((boolean)pingFrame.release());
        PongWebSocketFrame pongFrame = new PongWebSocketFrame();
        Assertions.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)pongFrame));
        Assertions.assertTrue((boolean)pongFrame.release());
        CloseWebSocketFrame closeFrame = new CloseWebSocketFrame();
        Assertions.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)closeFrame));
        Assertions.assertTrue((boolean)closeFrame.release());
        ContinuationWebSocketFrame continuationFrame = new ContinuationWebSocketFrame();
        Assertions.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)continuationFrame));
        Assertions.assertTrue((boolean)continuationFrame.release());
    }
}

