/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyHeaderBlockRawDecoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SpdyHeaderBlockRawDecoderTest {
    private static final int maxHeaderSize = 16;
    private static final String name = "name";
    private static final String value = "value";
    private static final byte[] nameBytes = "name".getBytes();
    private static final byte[] valueBytes = "value".getBytes();
    private SpdyHeaderBlockRawDecoder decoder;
    private SpdyHeadersFrame frame;

    @BeforeEach
    public void setUp() {
        this.decoder = new SpdyHeaderBlockRawDecoder(SpdyVersion.SPDY_3_1, 16);
        this.frame = new DefaultSpdyHeadersFrame(1);
    }

    @AfterEach
    public void tearDown() {
        this.decoder.end();
    }

    @Test
    public void testEmptyHeaderBlock() throws Exception {
        ByteBuf headerBlock = Unpooled.EMPTY_BUFFER;
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testZeroNameValuePairs() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)4);
        headerBlock.writeInt(0);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertFalse((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testNegativeNameValuePairs() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)4);
        headerBlock.writeInt(-1);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testOneNameValuePair() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)21);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertFalse((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)1, (int)this.frame.headers().names().size());
        Assertions.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assertions.assertEquals((int)1, (int)this.frame.headers().getAll((Object)name).size());
        Assertions.assertEquals((Object)value, (Object)this.frame.headers().get((Object)name));
        headerBlock.release();
    }

    @Test
    public void testMissingNameLength() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)4);
        headerBlock.writeInt(1);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testZeroNameLength() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)8);
        headerBlock.writeInt(1);
        headerBlock.writeInt(0);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testNegativeNameLength() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)8);
        headerBlock.writeInt(1);
        headerBlock.writeInt(-1);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testMissingName() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)8);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testIllegalNameOnlyNull() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)18);
        headerBlock.writeInt(1);
        headerBlock.writeInt(1);
        headerBlock.writeByte(0);
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testMissingValueLength() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)12);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testZeroValueLength() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)16);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(0);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertFalse((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)1, (int)this.frame.headers().names().size());
        Assertions.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assertions.assertEquals((int)1, (int)this.frame.headers().getAll((Object)name).size());
        Assertions.assertEquals((Object)"", (Object)this.frame.headers().get((Object)name));
        headerBlock.release();
    }

    @Test
    public void testNegativeValueLength() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)16);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(-1);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testMissingValue() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)16);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(5);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testIllegalValueOnlyNull() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)17);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(1);
        headerBlock.writeByte(0);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testIllegalValueStartsWithNull() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)22);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(6);
        headerBlock.writeByte(0);
        headerBlock.writeBytes(valueBytes);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testIllegalValueEndsWithNull() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)22);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(6);
        headerBlock.writeBytes(valueBytes);
        headerBlock.writeByte(0);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testMultipleValues() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)27);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(11);
        headerBlock.writeBytes(valueBytes);
        headerBlock.writeByte(0);
        headerBlock.writeBytes(valueBytes);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertFalse((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)1, (int)this.frame.headers().names().size());
        Assertions.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assertions.assertEquals((int)2, (int)this.frame.headers().getAll((Object)name).size());
        Assertions.assertEquals((Object)value, this.frame.headers().getAll((Object)name).get(0));
        Assertions.assertEquals((Object)value, this.frame.headers().getAll((Object)name).get(1));
        headerBlock.release();
    }

    @Test
    public void testMultipleValuesEndsWithNull() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)28);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(12);
        headerBlock.writeBytes(valueBytes);
        headerBlock.writeByte(0);
        headerBlock.writeBytes(valueBytes);
        headerBlock.writeByte(0);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)1, (int)this.frame.headers().names().size());
        Assertions.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assertions.assertEquals((int)1, (int)this.frame.headers().getAll((Object)name).size());
        Assertions.assertEquals((Object)value, (Object)this.frame.headers().get((Object)name));
        headerBlock.release();
    }

    @Test
    public void testIllegalValueMultipleNulls() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)28);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(12);
        headerBlock.writeBytes(valueBytes);
        headerBlock.writeByte(0);
        headerBlock.writeByte(0);
        headerBlock.writeBytes(valueBytes);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testMissingNextNameValuePair() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)21);
        headerBlock.writeInt(2);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)1, (int)this.frame.headers().names().size());
        Assertions.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assertions.assertEquals((int)1, (int)this.frame.headers().getAll((Object)name).size());
        Assertions.assertEquals((Object)value, (Object)this.frame.headers().get((Object)name));
        headerBlock.release();
    }

    @Test
    public void testMultipleNames() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)38);
        headerBlock.writeInt(2);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)1, (int)this.frame.headers().names().size());
        Assertions.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assertions.assertEquals((int)1, (int)this.frame.headers().getAll((Object)name).size());
        Assertions.assertEquals((Object)value, (Object)this.frame.headers().get((Object)name));
        headerBlock.release();
    }

    @Test
    public void testExtraData() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)22);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        headerBlock.writeByte(0);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)1, (int)this.frame.headers().names().size());
        Assertions.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assertions.assertEquals((int)1, (int)this.frame.headers().getAll((Object)name).size());
        Assertions.assertEquals((Object)value, (Object)this.frame.headers().get((Object)name));
        headerBlock.release();
    }

    @Test
    public void testMultipleDecodes() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)21);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        int readableBytes = headerBlock.readableBytes();
        for (int i = 0; i < readableBytes; ++i) {
            ByteBuf headerBlockSegment = headerBlock.slice(i, 1);
            this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlockSegment, this.frame);
            Assertions.assertFalse((boolean)headerBlockSegment.isReadable());
        }
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)1, (int)this.frame.headers().names().size());
        Assertions.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assertions.assertEquals((int)1, (int)this.frame.headers().getAll((Object)name).size());
        Assertions.assertEquals((Object)value, (Object)this.frame.headers().get((Object)name));
        headerBlock.release();
    }

    @Test
    public void testContinueAfterInvalidHeaders() throws Exception {
        ByteBuf numHeaders = Unpooled.buffer((int)4);
        numHeaders.writeInt(1);
        ByteBuf nameBlock = Unpooled.buffer((int)8);
        nameBlock.writeInt(4);
        nameBlock.writeBytes(nameBytes);
        ByteBuf valueBlock = Unpooled.buffer((int)9);
        valueBlock.writeInt(5);
        valueBlock.writeBytes(valueBytes);
        this.decoder.decode(ByteBufAllocator.DEFAULT, numHeaders, this.frame);
        this.decoder.decode(ByteBufAllocator.DEFAULT, nameBlock, this.frame);
        this.frame.setInvalid();
        this.decoder.decode(ByteBufAllocator.DEFAULT, valueBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)numHeaders.isReadable());
        Assertions.assertFalse((boolean)nameBlock.isReadable());
        Assertions.assertFalse((boolean)valueBlock.isReadable());
        Assertions.assertEquals((int)1, (int)this.frame.headers().names().size());
        Assertions.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assertions.assertEquals((int)1, (int)this.frame.headers().getAll((Object)name).size());
        Assertions.assertEquals((Object)value, (Object)this.frame.headers().get((Object)name));
        numHeaders.release();
        nameBlock.release();
        valueBlock.release();
    }

    @Test
    public void testTruncatedHeaderName() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)34);
        headerBlock.writeInt(1);
        headerBlock.writeInt(17);
        for (int i = 0; i < 17; ++i) {
            headerBlock.writeByte(97);
        }
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isTruncated());
        Assertions.assertFalse((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testTruncatedHeaderValue() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)29);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(13);
        for (int i = 0; i < 13; ++i) {
            headerBlock.writeByte(97);
        }
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assertions.assertFalse((boolean)headerBlock.isReadable());
        Assertions.assertTrue((boolean)this.frame.isTruncated());
        Assertions.assertFalse((boolean)this.frame.isInvalid());
        Assertions.assertEquals((int)0, (int)this.frame.headers().names().size());
        headerBlock.release();
    }
}

