/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecoder;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HttpContentDecoderTest {
    private static final String HELLO_WORLD = "hello, world";
    private static final byte[] GZ_HELLO_WORLD = new byte[]{31, -117, 8, 8, 12, 3, -74, 84, 0, 3, 50, 0, -53, 72, -51, -55, -55, -41, 81, 40, -49, 47, -54, 73, 1, 0, 58, 114, -85, -1, 12, 0, 0, 0};

    @Test
    public void testBinaryDecompression() throws Exception {
        byte[] helloWorld = HttpContentDecoderTest.gzDecompress(GZ_HELLO_WORLD);
        Assert.assertEquals((long)HELLO_WORLD.length(), (long)helloWorld.length);
        Assert.assertEquals((Object)HELLO_WORLD, (Object)new String(helloWorld, CharsetUtil.US_ASCII));
        String fullCycleTest = "full cycle test";
        byte[] compressed = HttpContentDecoderTest.gzCompress(fullCycleTest.getBytes(CharsetUtil.US_ASCII));
        byte[] decompressed = HttpContentDecoderTest.gzDecompress(compressed);
        Assert.assertEquals((long)decompressed.length, (long)fullCycleTest.length());
        Assert.assertEquals((Object)fullCycleTest, (Object)new String(decompressed, CharsetUtil.US_ASCII));
    }

    @Test
    public void testRequestDecompression() {
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        HttpObjectAggregator aggregator = new HttpObjectAggregator(1024);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, decompressor, aggregator});
        String headers = "POST / HTTP/1.1\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nContent-Encoding: gzip\r\n\r\n";
        ByteBuf buf = Unpooled.copiedBuffer((byte[][])new byte[][]{headers.getBytes(CharsetUtil.US_ASCII), GZ_HELLO_WORLD});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{buf}));
        Object o = channel.readInbound();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpRequest.class)));
        FullHttpRequest req = (FullHttpRequest)o;
        Assert.assertEquals((long)HELLO_WORLD.length(), (long)req.headers().getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertEquals((Object)HELLO_WORLD, (Object)req.content().toString(CharsetUtil.US_ASCII));
        req.release();
        HttpContentDecoderTest.assertHasInboundMessages(channel, false);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testChunkedRequestDecompression() {
        HttpResponseDecoder decoder = new HttpResponseDecoder();
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, decompressor, null});
        String headers = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\nTrailer: My-Trailer\r\nContent-Encoding: gzip\r\n\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])headers.getBytes(CharsetUtil.US_ASCII))});
        String chunkLength = Integer.toHexString(GZ_HELLO_WORLD.length);
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(chunkLength + "\r\n"), (Charset)CharsetUtil.US_ASCII)}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])GZ_HELLO_WORLD)}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])"\r\n".getBytes(CharsetUtil.US_ASCII))}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"My-Trailer: 42\r\n\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Object ob1 = channel.readInbound();
        Assert.assertThat((Object)ob1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(DefaultHttpResponse.class)));
        Object ob2 = channel.readInbound();
        Assert.assertThat((Object)ob1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(DefaultHttpResponse.class)));
        HttpContent content = (HttpContent)ob2;
        Assert.assertEquals((Object)HELLO_WORLD, (Object)content.content().toString(CharsetUtil.US_ASCII));
        content.release();
        Object ob3 = channel.readInbound();
        Assert.assertThat((Object)ob1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(DefaultHttpResponse.class)));
        LastHttpContent lastContent = (LastHttpContent)ob3;
        Assert.assertNotNull((Object)lastContent.decoderResult());
        Assert.assertTrue((boolean)lastContent.decoderResult().isSuccess());
        Assert.assertFalse((boolean)lastContent.trailingHeaders().isEmpty());
        Assert.assertEquals((Object)"42", (Object)lastContent.trailingHeaders().get("My-Trailer"));
        HttpContentDecoderTest.assertHasInboundMessages(channel, false);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testResponseDecompression() {
        HttpResponseDecoder decoder = new HttpResponseDecoder();
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        HttpObjectAggregator aggregator = new HttpObjectAggregator(1024);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, decompressor, aggregator});
        String headers = "HTTP/1.1 200 OK\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nContent-Encoding: gzip\r\n\r\n";
        ByteBuf buf = Unpooled.copiedBuffer((byte[][])new byte[][]{headers.getBytes(CharsetUtil.US_ASCII), GZ_HELLO_WORLD});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{buf}));
        Object o = channel.readInbound();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        FullHttpResponse resp = (FullHttpResponse)o;
        Assert.assertEquals((long)HELLO_WORLD.length(), (long)resp.headers().getInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH).intValue());
        Assert.assertEquals((Object)HELLO_WORLD, (Object)resp.content().toString(CharsetUtil.US_ASCII));
        resp.release();
        HttpContentDecoderTest.assertHasInboundMessages(channel, false);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testExpectContinueResponse1() {
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        HttpObjectAggregator aggregator = new HttpObjectAggregator(1024);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, aggregator});
        String req = "POST / HTTP/1.1\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nExpect: 100-continue\r\n\r\n";
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])req.getBytes())}));
        Object o = channel.readOutbound();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        FullHttpResponse r = (FullHttpResponse)o;
        Assert.assertEquals((long)100L, (long)r.status().code());
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])GZ_HELLO_WORLD)}));
        r.release();
        HttpContentDecoderTest.assertHasInboundMessages(channel, true);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testExpectContinueResponse2() {
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        HttpObjectAggregator aggregator = new HttpObjectAggregator(1024);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, decompressor, aggregator});
        String req = "POST / HTTP/1.1\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nExpect: 100-continue\r\n\r\n";
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])req.getBytes())}));
        Object o = channel.readOutbound();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        FullHttpResponse r = (FullHttpResponse)o;
        Assert.assertEquals((long)100L, (long)r.status().code());
        r.release();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])GZ_HELLO_WORLD)}));
        HttpContentDecoderTest.assertHasInboundMessages(channel, true);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testExpectContinueResponse3() {
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        HttpObjectAggregator aggregator = new HttpObjectAggregator(1024);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, decompressor, aggregator});
        String req = "POST / HTTP/1.1\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nExpect: 100-continue\r\nContent-Encoding: gzip\r\n\r\n";
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])req.getBytes())}));
        Object o = channel.readOutbound();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        FullHttpResponse r = (FullHttpResponse)o;
        Assert.assertEquals((long)100L, (long)r.status().code());
        r.release();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])GZ_HELLO_WORLD)}));
        HttpContentDecoderTest.assertHasInboundMessages(channel, true);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testExpectContinueResponse4() {
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        HttpObjectAggregator aggregator = new HttpObjectAggregator(1024);
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, aggregator, decompressor});
        String req = "POST / HTTP/1.1\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nExpect: 100-continue\r\nContent-Encoding: gzip\r\n\r\n";
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])req.getBytes())}));
        Object o = channel.readOutbound();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        FullHttpResponse r = (FullHttpResponse)o;
        Assert.assertEquals((long)100L, (long)r.status().code());
        r.release();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])GZ_HELLO_WORLD)}));
        HttpContentDecoderTest.assertHasInboundMessages(channel, true);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testExpectContinueResetHttpObjectDecoder() {
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        int maxBytes = 10;
        HttpObjectAggregator aggregator = new HttpObjectAggregator(10);
        final AtomicReference secondRequestRef = new AtomicReference();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, aggregator, new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof FullHttpRequest) {
                    if (!secondRequestRef.compareAndSet(null, (FullHttpRequest)msg)) {
                        ((FullHttpRequest)msg).release();
                    }
                } else {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        }});
        String req1 = "POST /1 HTTP/1.1\r\nContent-Length: 11\r\nExpect: 100-continue\r\n\r\n";
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])req1.getBytes(CharsetUtil.US_ASCII))}));
        FullHttpResponse resp = (FullHttpResponse)channel.readOutbound();
        Assert.assertEquals((Object)HttpStatusClass.CLIENT_ERROR, (Object)resp.status().codeClass());
        resp.release();
        String req2 = "POST /2 HTTP/1.1\r\nContent-Length: 10\r\nExpect: 100-continue\r\n\r\n";
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])req2.getBytes(CharsetUtil.US_ASCII))}));
        resp = (FullHttpResponse)channel.readOutbound();
        Assert.assertEquals((long)100L, (long)resp.status().code());
        resp.release();
        byte[] content = new byte[10];
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])content)}));
        FullHttpRequest req = (FullHttpRequest)secondRequestRef.get();
        Assert.assertNotNull((Object)req);
        Assert.assertEquals((Object)"/2", (Object)req.uri());
        Assert.assertEquals((long)10L, (long)req.content().readableBytes());
        req.release();
        HttpContentDecoderTest.assertHasInboundMessages(channel, false);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testRequestContentLength1() {
        HttpRequestDecoder decoder = new HttpRequestDecoder(4096, 4096, 5);
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, decompressor});
        String headers = "POST / HTTP/1.1\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nContent-Encoding: gzip\r\n\r\n";
        ByteBuf buf = Unpooled.copiedBuffer((byte[][])new byte[][]{headers.getBytes(CharsetUtil.US_ASCII), GZ_HELLO_WORLD});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{buf}));
        Queue req = channel.inboundMessages();
        Assert.assertTrue((req.size() >= 1 ? 1 : 0) != 0);
        Object o = req.peek();
        Assert.assertThat(o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpRequest.class)));
        HttpRequest r = (HttpRequest)o;
        String v = r.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        Long value = v == null ? null : Long.valueOf(Long.parseLong(v));
        Assert.assertTrue((value == null || value == (long)HELLO_WORLD.length() ? 1 : 0) != 0);
        HttpContentDecoderTest.assertHasInboundMessages(channel, true);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testRequestContentLength2() {
        HttpRequestDecoder decoder = new HttpRequestDecoder(4096, 4096, 5);
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        HttpObjectAggregator aggregator = new HttpObjectAggregator(1024);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, decompressor, aggregator});
        String headers = "POST / HTTP/1.1\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nContent-Encoding: gzip\r\n\r\n";
        ByteBuf buf = Unpooled.copiedBuffer((byte[][])new byte[][]{headers.getBytes(CharsetUtil.US_ASCII), GZ_HELLO_WORLD});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{buf}));
        Object o = channel.readInbound();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpRequest.class)));
        FullHttpRequest r = (FullHttpRequest)o;
        String v = r.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        Long value = v == null ? null : Long.valueOf(Long.parseLong(v));
        r.release();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)HELLO_WORLD.length(), (long)value);
        HttpContentDecoderTest.assertHasInboundMessages(channel, false);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testResponseContentLength1() {
        HttpResponseDecoder decoder = new HttpResponseDecoder(4096, 4096, 5);
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, decompressor});
        String headers = "HTTP/1.1 200 OK\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nContent-Encoding: gzip\r\n\r\n";
        ByteBuf buf = Unpooled.copiedBuffer((byte[][])new byte[][]{headers.getBytes(CharsetUtil.US_ASCII), GZ_HELLO_WORLD});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{buf}));
        Queue resp = channel.inboundMessages();
        Assert.assertTrue((resp.size() >= 1 ? 1 : 0) != 0);
        Object o = resp.peek();
        Assert.assertThat(o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpResponse.class)));
        HttpResponse r = (HttpResponse)o;
        Assert.assertFalse((String)"Content-Length header not removed.", (boolean)r.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        String transferEncoding = r.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        Assert.assertNotNull((String)"Content-length as well as transfer-encoding not set.", (Object)transferEncoding);
        Assert.assertEquals((String)"Unexpected transfer-encoding value.", (Object)HttpHeaderValues.CHUNKED.toString(), (Object)transferEncoding);
        HttpContentDecoderTest.assertHasInboundMessages(channel, true);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testResponseContentLength2() {
        HttpResponseDecoder decoder = new HttpResponseDecoder(4096, 4096, 5);
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        HttpObjectAggregator aggregator = new HttpObjectAggregator(1024);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, decompressor, aggregator});
        String headers = "HTTP/1.1 200 OK\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nContent-Encoding: gzip\r\n\r\n";
        ByteBuf buf = Unpooled.copiedBuffer((byte[][])new byte[][]{headers.getBytes(CharsetUtil.US_ASCII), GZ_HELLO_WORLD});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{buf}));
        Object o = channel.readInbound();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        FullHttpResponse r = (FullHttpResponse)o;
        String v = r.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        Long value = v == null ? null : Long.valueOf(Long.parseLong(v));
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)HELLO_WORLD.length(), (long)value);
        r.release();
        HttpContentDecoderTest.assertHasInboundMessages(channel, false);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFullHttpRequest() {
        HttpRequestDecoder decoder = new HttpRequestDecoder(4096, 4096, 5);
        HttpObjectAggregator aggregator = new HttpObjectAggregator(1024);
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, aggregator, decompressor});
        String headers = "POST / HTTP/1.1\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nContent-Encoding: gzip\r\n\r\n";
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[][])new byte[][]{headers.getBytes(), GZ_HELLO_WORLD})}));
        Queue req = channel.inboundMessages();
        Assert.assertTrue((req.size() > 1 ? 1 : 0) != 0);
        int contentLength = 0;
        contentLength = HttpContentDecoderTest.calculateContentLength(req, contentLength);
        byte[] receivedContent = HttpContentDecoderTest.readContent(req, contentLength, true);
        Assert.assertEquals((Object)HELLO_WORLD, (Object)new String(receivedContent, CharsetUtil.US_ASCII));
        HttpContentDecoderTest.assertHasInboundMessages(channel, true);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFullHttpResponse() {
        HttpResponseDecoder decoder = new HttpResponseDecoder(4096, 4096, 5);
        HttpObjectAggregator aggregator = new HttpObjectAggregator(1024);
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, aggregator, decompressor});
        String headers = "HTTP/1.1 200 OK\r\nContent-Length: " + GZ_HELLO_WORLD.length + "\r\nContent-Encoding: gzip\r\n\r\n";
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[][])new byte[][]{headers.getBytes(), GZ_HELLO_WORLD})}));
        Queue resp = channel.inboundMessages();
        Assert.assertTrue((resp.size() > 1 ? 1 : 0) != 0);
        int contentLength = 0;
        contentLength = HttpContentDecoderTest.calculateContentLength(resp, contentLength);
        byte[] receivedContent = HttpContentDecoderTest.readContent(resp, contentLength, true);
        Assert.assertEquals((Object)HELLO_WORLD, (Object)new String(receivedContent, CharsetUtil.US_ASCII));
        HttpContentDecoderTest.assertHasInboundMessages(channel, true);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFullHttpResponseEOF() {
        HttpResponseDecoder decoder = new HttpResponseDecoder(4096, 4096, 5);
        HttpContentDecompressor decompressor = new HttpContentDecompressor();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, decompressor});
        String headers = "HTTP/1.1 200 OK\r\nContent-Encoding: gzip\r\n\r\n";
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[][])new byte[][]{headers.getBytes(), GZ_HELLO_WORLD})}));
        Assert.assertTrue((boolean)channel.finish());
        Queue resp = channel.inboundMessages();
        Assert.assertTrue((resp.size() > 1 ? 1 : 0) != 0);
        int contentLength = 0;
        contentLength = HttpContentDecoderTest.calculateContentLength(resp, contentLength);
        byte[] receivedContent = HttpContentDecoderTest.readContent(resp, contentLength, false);
        Assert.assertEquals((Object)HELLO_WORLD, (Object)new String(receivedContent, CharsetUtil.US_ASCII));
        HttpContentDecoderTest.assertHasInboundMessages(channel, true);
        HttpContentDecoderTest.assertHasOutboundMessages(channel, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testCleanupThrows() {
        HttpContentDecoder decoder = new HttpContentDecoder(){

            protected EmbeddedChannel newContentDecoder(String contentEncoding) throws Exception {
                return new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        ctx.fireExceptionCaught((Throwable)new DecoderException());
                        ctx.fireChannelInactive();
                    }
                }});
            }
        };
        final AtomicBoolean channelInactiveCalled = new AtomicBoolean();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder, new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                Assert.assertTrue((boolean)channelInactiveCalled.compareAndSet(false, true));
                super.channelInactive(ctx);
            }
        }});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")}));
        DefaultHttpContent content = new DefaultHttpContent(Unpooled.buffer().writeZero(10));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{content}));
        Assert.assertEquals((long)1L, (long)content.refCnt());
        try {
            channel.finishAndReleaseAll();
            Assert.fail();
        }
        catch (CodecException codecException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)channelInactiveCalled.get());
        Assert.assertEquals((long)0L, (long)content.refCnt());
    }

    private static byte[] gzDecompress(byte[] input) {
        ByteBuf o;
        ZlibDecoder decoder = ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])input)}));
        Assert.assertTrue((boolean)channel.finish());
        int outputSize = 0;
        ArrayList<ByteBuf> inbound = new ArrayList<ByteBuf>();
        while ((o = (ByteBuf)channel.readInbound()) != null) {
            inbound.add(o);
            outputSize += o.readableBytes();
        }
        byte[] output = new byte[outputSize];
        int readCount = 0;
        for (ByteBuf b : inbound) {
            int readableBytes = b.readableBytes();
            b.readBytes(output, readCount, readableBytes);
            b.release();
            readCount += readableBytes;
        }
        Assert.assertTrue((channel.inboundMessages().isEmpty() && channel.outboundMessages().isEmpty() ? 1 : 0) != 0);
        return output;
    }

    private static byte[] readContent(Queue<Object> req, int contentLength, boolean hasTransferEncoding) {
        byte[] receivedContent = new byte[contentLength];
        int readCount = 0;
        for (Object e : req) {
            if (e instanceof HttpContent) {
                ByteBuf b = ((HttpContent)e).content();
                int readableBytes = b.readableBytes();
                b.readBytes(receivedContent, readCount, readableBytes);
                readCount += readableBytes;
            }
            if (!(e instanceof HttpMessage)) continue;
            Assert.assertEquals((Object)hasTransferEncoding, (Object)((HttpMessage)e).headers().contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        }
        return receivedContent;
    }

    private static int calculateContentLength(Queue<Object> req, int contentLength) {
        for (Object e : req) {
            if (!(e instanceof HttpContent)) continue;
            Assert.assertTrue((((HttpContent)e).refCnt() > 0 ? 1 : 0) != 0);
            ByteBuf b = ((HttpContent)e).content();
            contentLength += b.readableBytes();
        }
        return contentLength;
    }

    private static byte[] gzCompress(byte[] input) {
        ByteBuf o;
        ZlibEncoder encoder = ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])input)}));
        Assert.assertTrue((boolean)channel.finish());
        int outputSize = 0;
        ArrayList<ByteBuf> outbound = new ArrayList<ByteBuf>();
        while ((o = (ByteBuf)channel.readOutbound()) != null) {
            outbound.add(o);
            outputSize += o.readableBytes();
        }
        byte[] output = new byte[outputSize];
        int readCount = 0;
        for (ByteBuf b : outbound) {
            int readableBytes = b.readableBytes();
            b.readBytes(output, readCount, readableBytes);
            b.release();
            readCount += readableBytes;
        }
        Assert.assertTrue((channel.inboundMessages().isEmpty() && channel.outboundMessages().isEmpty() ? 1 : 0) != 0);
        return output;
    }

    private static void assertHasInboundMessages(EmbeddedChannel channel, boolean hasMessages) {
        if (hasMessages) {
            Object o;
            do {
                o = channel.readInbound();
                Assert.assertNotNull((Object)o);
                ReferenceCountUtil.release((Object)o);
            } while (!(o instanceof LastHttpContent));
        } else {
            Object o = channel.readInbound();
            Assert.assertNull((Object)o);
        }
    }

    private static void assertHasOutboundMessages(EmbeddedChannel channel, boolean hasMessages) {
        if (hasMessages) {
            Object o;
            do {
                o = channel.readOutbound();
                Assert.assertNotNull((Object)o);
                ReferenceCountUtil.release((Object)o);
            } while (!(o instanceof LastHttpContent));
        } else {
            Object o = channel.readOutbound();
            Assert.assertNull((Object)o);
        }
    }
}

