/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AsciiString;
import org.junit.Assert;
import org.junit.Test;

public class HttpResponseStatusTest {
    @Test
    public void parseLineStringJustCode() {
        Assert.assertSame((Object)HttpResponseStatus.OK, (Object)HttpResponseStatus.parseLine((String)"200"));
    }

    @Test
    public void parseLineStringCodeAndPhrase() {
        Assert.assertSame((Object)HttpResponseStatus.OK, (Object)HttpResponseStatus.parseLine((String)"200 OK"));
    }

    @Test
    public void parseLineStringCustomCode() {
        HttpResponseStatus customStatus = HttpResponseStatus.parseLine((String)"612");
        Assert.assertEquals((long)612L, (long)customStatus.code());
    }

    @Test
    public void parseLineStringCustomCodeAndPhrase() {
        HttpResponseStatus customStatus = HttpResponseStatus.parseLine((String)"612 FOO");
        Assert.assertEquals((long)612L, (long)customStatus.code());
        Assert.assertEquals((Object)"FOO", (Object)customStatus.reasonPhrase());
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseLineStringMalformedCode() {
        HttpResponseStatus.parseLine((String)"200a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseLineStringMalformedCodeWithPhrase() {
        HttpResponseStatus.parseLine((String)"200a foo");
    }

    @Test
    public void parseLineAsciiStringJustCode() {
        Assert.assertSame((Object)HttpResponseStatus.OK, (Object)HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"200")));
    }

    @Test
    public void parseLineAsciiStringCodeAndPhrase() {
        Assert.assertSame((Object)HttpResponseStatus.OK, (Object)HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"200 OK")));
    }

    @Test
    public void parseLineAsciiStringCustomCode() {
        HttpResponseStatus customStatus = HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"612"));
        Assert.assertEquals((long)612L, (long)customStatus.code());
    }

    @Test
    public void parseLineAsciiStringCustomCodeAndPhrase() {
        HttpResponseStatus customStatus = HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"612 FOO"));
        Assert.assertEquals((long)612L, (long)customStatus.code());
        Assert.assertEquals((Object)"FOO", (Object)customStatus.reasonPhrase());
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseLineAsciiStringMalformedCode() {
        HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"200a"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseLineAsciiStringMalformedCodeWithPhrase() {
        HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"200a foo"));
    }
}

