/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.ReadOnlyHttpHeaders;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyHttpHeadersTest {
    @Test
    public void getValue() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON});
        Assert.assertFalse((boolean)headers.isEmpty());
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertTrue((boolean)HttpHeaderValues.APPLICATION_JSON.contentEquals((CharSequence)headers.get((CharSequence)HttpHeaderNames.ACCEPT)));
        Assert.assertTrue((boolean)headers.contains((CharSequence)HttpHeaderNames.ACCEPT));
        Assert.assertNull((Object)headers.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assert.assertFalse((boolean)headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
    }

    @Test
    public void charSequenceIterator() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO, HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE});
        Assert.assertFalse((boolean)headers.isEmpty());
        Assert.assertEquals((long)3L, (long)headers.size());
        Iterator itr = headers.iteratorCharSequence();
        Assert.assertTrue((boolean)itr.hasNext());
        Map.Entry next = (Map.Entry)itr.next();
        Assert.assertTrue((boolean)HttpHeaderNames.ACCEPT.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assert.assertTrue((boolean)HttpHeaderValues.APPLICATION_JSON.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assert.assertTrue((boolean)itr.hasNext());
        next = (Map.Entry)itr.next();
        Assert.assertTrue((boolean)HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assert.assertTrue((boolean)HttpHeaderValues.ZERO.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assert.assertTrue((boolean)itr.hasNext());
        next = (Map.Entry)itr.next();
        Assert.assertTrue((boolean)HttpHeaderNames.CONNECTION.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assert.assertTrue((boolean)HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void stringIterator() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO, HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE});
        Assert.assertFalse((boolean)headers.isEmpty());
        Assert.assertEquals((long)3L, (long)headers.size());
        ReadOnlyHttpHeadersTest.assert3ParisEquals(headers.iterator());
    }

    @Test
    public void entries() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO, HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE});
        Assert.assertFalse((boolean)headers.isEmpty());
        Assert.assertEquals((long)3L, (long)headers.size());
        ReadOnlyHttpHeadersTest.assert3ParisEquals(headers.entries().iterator());
    }

    @Test
    public void names() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO, HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE});
        Assert.assertFalse((boolean)headers.isEmpty());
        Assert.assertEquals((long)3L, (long)headers.size());
        Set names = headers.names();
        Assert.assertEquals((long)3L, (long)names.size());
        Assert.assertTrue((boolean)names.contains(HttpHeaderNames.ACCEPT.toString()));
        Assert.assertTrue((boolean)names.contains(HttpHeaderNames.CONTENT_LENGTH.toString()));
        Assert.assertTrue((boolean)names.contains(HttpHeaderNames.CONNECTION.toString()));
    }

    @Test
    public void getAll() {
        ReadOnlyHttpHeaders headers = new ReadOnlyHttpHeaders(false, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, HttpHeaderNames.CONTENT_LENGTH, HttpHeaderValues.ZERO, HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_OCTET_STREAM});
        Assert.assertFalse((boolean)headers.isEmpty());
        Assert.assertEquals((long)3L, (long)headers.size());
        List names = headers.getAll((CharSequence)HttpHeaderNames.ACCEPT);
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertTrue((boolean)HttpHeaderValues.APPLICATION_JSON.contentEqualsIgnoreCase((CharSequence)names.get(0)));
        Assert.assertTrue((boolean)HttpHeaderValues.APPLICATION_OCTET_STREAM.contentEqualsIgnoreCase((CharSequence)names.get(1)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void validateNamesFail() {
        new ReadOnlyHttpHeaders(true, new CharSequence[]{HttpHeaderNames.ACCEPT, HttpHeaderValues.APPLICATION_JSON, AsciiString.cached((String)" ")});
    }

    private static void assert3ParisEquals(Iterator<Map.Entry<String, String>> itr) {
        Assert.assertTrue((boolean)itr.hasNext());
        Map.Entry<String, String> next = itr.next();
        Assert.assertTrue((boolean)HttpHeaderNames.ACCEPT.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assert.assertTrue((boolean)HttpHeaderValues.APPLICATION_JSON.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assert.assertTrue((boolean)itr.hasNext());
        next = itr.next();
        Assert.assertTrue((boolean)HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assert.assertTrue((boolean)HttpHeaderValues.ZERO.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assert.assertTrue((boolean)itr.hasNext());
        next = itr.next();
        Assert.assertTrue((boolean)HttpHeaderNames.CONNECTION.contentEqualsIgnoreCase((CharSequence)next.getKey()));
        Assert.assertTrue((boolean)HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)next.getValue()));
        Assert.assertFalse((boolean)itr.hasNext());
    }
}

