/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.multipart.AbstractMemoryHttpData;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class AbstractMemoryHttpDataTest {
    @Test
    public void testSetContentFromStream() throws Exception {
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 20; ++i) {
            int size = random.nextInt(Short.MAX_VALUE);
            byte[] bytes = new byte[size];
            ((Random)random).nextBytes(bytes);
            TestHttpData data = new TestHttpData("name", CharsetUtil.UTF_8, 0L);
            data.setContent(new ByteArrayInputStream(bytes));
            ByteBuf buffer = data.getByteBuf();
            Assert.assertEquals((long)0L, (long)buffer.readerIndex());
            Assert.assertEquals((long)bytes.length, (long)buffer.writerIndex());
            Assert.assertArrayEquals((byte[])bytes, (byte[])Arrays.copyOf(buffer.array(), bytes.length));
        }
    }

    private static final class TestHttpData
    extends AbstractMemoryHttpData {
        private TestHttpData(String name, Charset charset, long size) {
            super(name, charset, size);
        }

        public InterfaceHttpData.HttpDataType getHttpDataType() {
            throw TestHttpData.reject();
        }

        public HttpData copy() {
            throw TestHttpData.reject();
        }

        public HttpData duplicate() {
            throw TestHttpData.reject();
        }

        public HttpData retainedDuplicate() {
            throw TestHttpData.reject();
        }

        public HttpData replace(ByteBuf content) {
            return null;
        }

        public int compareTo(InterfaceHttpData o) {
            throw TestHttpData.reject();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        private static UnsupportedOperationException reject() {
            throw new UnsupportedOperationException("Should never be called.");
        }
    }
}

