/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker08;
import io.netty.util.ReferenceCountUtil;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketServerHandshaker08Test {
    @Test
    public void testPerformOpeningHandshake() {
        WebSocketServerHandshaker08Test.testPerformOpeningHandshake0(true);
    }

    @Test
    public void testPerformOpeningHandshakeSubProtocolNotSupported() {
        WebSocketServerHandshaker08Test.testPerformOpeningHandshake0(false);
    }

    private static void testPerformOpeningHandshake0(boolean subProtocol) {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(42), new HttpRequestDecoder(), new HttpResponseEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/chat");
        req.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"server.example.com");
        req.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET);
        req.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Upgrade");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)"dGhlIHNhbXBsZSBub25jZQ==");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)"http://example.com");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"chat, superchat");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"8");
        if (subProtocol) {
            new WebSocketServerHandshaker08("ws://example.com/chat", "chat", false, Integer.MAX_VALUE, false).handshake((Channel)ch, (FullHttpRequest)req);
        } else {
            new WebSocketServerHandshaker08("ws://example.com/chat", null, false, Integer.MAX_VALUE, false).handshake((Channel)ch, (FullHttpRequest)req);
        }
        ByteBuf resBuf = (ByteBuf)ch.readOutbound();
        EmbeddedChannel ch2 = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch2.writeInbound(new Object[]{resBuf});
        HttpResponse res = (HttpResponse)ch2.readInbound();
        Assert.assertEquals((Object)"s3pPLMBiTxaQ9kYGzzhZRbK+xOo=", (Object)res.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT));
        if (subProtocol) {
            Assert.assertEquals((Object)"chat", (Object)res.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL));
        } else {
            Assert.assertNull((Object)res.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL));
        }
        ReferenceCountUtil.release((Object)res);
        req.release();
    }
}

