/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateEncoder;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class DeflateFrameClientExtensionHandshakerTest {
    @Test
    public void testWebkitDeflateFrameData() {
        DeflateFrameClientExtensionHandshaker handshaker = new DeflateFrameClientExtensionHandshaker(true);
        WebSocketExtensionData data = handshaker.newRequestData();
        Assert.assertEquals((Object)"x-webkit-deflate-frame", (Object)data.name());
        Assert.assertTrue((boolean)data.parameters().isEmpty());
    }

    @Test
    public void testDeflateFrameData() {
        DeflateFrameClientExtensionHandshaker handshaker = new DeflateFrameClientExtensionHandshaker(false);
        WebSocketExtensionData data = handshaker.newRequestData();
        Assert.assertEquals((Object)"deflate-frame", (Object)data.name());
        Assert.assertTrue((boolean)data.parameters().isEmpty());
    }

    @Test
    public void testNormalHandshake() {
        DeflateFrameClientExtensionHandshaker handshaker = new DeflateFrameClientExtensionHandshaker(false);
        WebSocketClientExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("deflate-frame", Collections.emptyMap()));
        Assert.assertNotNull((Object)extension);
        Assert.assertEquals((long)4L, (long)extension.rsv());
        Assert.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerFrameDeflateDecoder));
        Assert.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerFrameDeflateEncoder));
    }

    @Test
    public void testFailedHandshake() {
        DeflateFrameClientExtensionHandshaker handshaker = new DeflateFrameClientExtensionHandshaker(false);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("invalid", "12");
        WebSocketClientExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("deflate-frame", parameters));
        Assert.assertNull((Object)extension);
    }
}

