/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateDecoder;
import io.netty.util.CharsetUtil;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class PerMessageDeflateDecoderTest {
    private static final Random random = new Random();

    @Test
    public void testCompressedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedFrame = new BinaryWebSocketFrame(true, 5, compressedPayload.slice(0, compressedPayload.readableBytes() - 4));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame}));
        BinaryWebSocketFrame uncompressedFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assert.assertNotNull((Object)uncompressedFrame);
        Assert.assertNotNull((Object)uncompressedFrame.content());
        Assert.assertEquals((long)1L, (long)uncompressedFrame.rsv());
        Assert.assertEquals((long)300L, (long)uncompressedFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        uncompressedFrame.content().readBytes(finalPayload);
        Assert.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        uncompressedFrame.release();
    }

    @Test
    public void testNormalFrame() {
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])payload));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{frame}));
        BinaryWebSocketFrame newFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assert.assertNotNull((Object)newFrame);
        Assert.assertNotNull((Object)newFrame.content());
        Assert.assertEquals((long)1L, (long)newFrame.rsv());
        Assert.assertEquals((long)300L, (long)newFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        newFrame.content().readBytes(finalPayload);
        Assert.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        newFrame.release();
    }

    @Test
    public void testFragmentedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        compressedPayload = compressedPayload.slice(0, compressedPayload.readableBytes() - 4);
        int oneThird = compressedPayload.readableBytes() / 3;
        BinaryWebSocketFrame compressedFrame1 = new BinaryWebSocketFrame(false, 5, compressedPayload.slice(0, oneThird));
        ContinuationWebSocketFrame compressedFrame2 = new ContinuationWebSocketFrame(false, 1, compressedPayload.slice(oneThird, oneThird));
        ContinuationWebSocketFrame compressedFrame3 = new ContinuationWebSocketFrame(true, 1, compressedPayload.slice(oneThird * 2, compressedPayload.readableBytes() - oneThird * 2));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame1.retain()}));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame2.retain()}));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame3}));
        BinaryWebSocketFrame uncompressedFrame1 = (BinaryWebSocketFrame)decoderChannel.readInbound();
        ContinuationWebSocketFrame uncompressedFrame2 = (ContinuationWebSocketFrame)decoderChannel.readInbound();
        ContinuationWebSocketFrame uncompressedFrame3 = (ContinuationWebSocketFrame)decoderChannel.readInbound();
        Assert.assertNotNull((Object)uncompressedFrame1);
        Assert.assertNotNull((Object)uncompressedFrame2);
        Assert.assertNotNull((Object)uncompressedFrame3);
        Assert.assertEquals((long)1L, (long)uncompressedFrame1.rsv());
        Assert.assertEquals((long)1L, (long)uncompressedFrame2.rsv());
        Assert.assertEquals((long)1L, (long)uncompressedFrame3.rsv());
        ByteBuf finalPayloadWrapped = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{uncompressedFrame1.content(), uncompressedFrame2.content(), uncompressedFrame3.content()});
        Assert.assertEquals((long)300L, (long)finalPayloadWrapped.readableBytes());
        byte[] finalPayload = new byte[300];
        finalPayloadWrapped.readBytes(finalPayload);
        Assert.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        finalPayloadWrapped.release();
    }

    @Test
    public void testMultiCompressedPayloadWithinFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false)});
        byte[] payload1 = new byte[100];
        random.nextBytes(payload1);
        byte[] payload2 = new byte[100];
        random.nextBytes(payload2);
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload1)}));
        ByteBuf compressedPayload1 = (ByteBuf)encoderChannel.readOutbound();
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload2)}));
        ByteBuf compressedPayload2 = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedFrame = new BinaryWebSocketFrame(true, 5, Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{compressedPayload1, compressedPayload2.slice(0, compressedPayload2.readableBytes() - 4)}));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame}));
        BinaryWebSocketFrame uncompressedFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assert.assertNotNull((Object)uncompressedFrame);
        Assert.assertNotNull((Object)uncompressedFrame.content());
        Assert.assertEquals((long)1L, (long)uncompressedFrame.rsv());
        Assert.assertEquals((long)200L, (long)uncompressedFrame.content().readableBytes());
        byte[] finalPayload1 = new byte[100];
        uncompressedFrame.content().readBytes(finalPayload1);
        Assert.assertArrayEquals((byte[])finalPayload1, (byte[])payload1);
        byte[] finalPayload2 = new byte[100];
        uncompressedFrame.content().readBytes(finalPayload2);
        Assert.assertArrayEquals((byte[])finalPayload2, (byte[])payload2);
        uncompressedFrame.release();
    }

    @Test
    public void testDecompressionSkipForBinaryFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, WebSocketExtensionFilter.ALWAYS_SKIP)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedBinaryFrame = new BinaryWebSocketFrame(true, 4, compressedPayload);
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedBinaryFrame}));
        WebSocketFrame inboundFrame = (WebSocketFrame)decoderChannel.readInbound();
        Assert.assertEquals((long)4L, (long)inboundFrame.rsv());
        Assert.assertEquals((Object)compressedPayload, (Object)inboundFrame.content());
        Assert.assertTrue((boolean)inboundFrame.release());
        Assert.assertTrue((boolean)encoderChannel.finishAndReleaseAll());
        Assert.assertFalse((boolean)decoderChannel.finish());
    }

    @Test
    public void testSelectivityDecompressionSkip() {
        WebSocketExtensionFilter selectivityDecompressionFilter = new WebSocketExtensionFilter(){

            public boolean mustSkip(WebSocketFrame frame) {
                return frame instanceof TextWebSocketFrame && frame.content().readableBytes() < 100;
            }
        };
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, selectivityDecompressionFilter)});
        String textPayload = "compressed payload";
        byte[] binaryPayload = new byte[300];
        random.nextBytes(binaryPayload);
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])textPayload.getBytes(CharsetUtil.UTF_8))}));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])binaryPayload)}));
        ByteBuf compressedTextPayload = (ByteBuf)encoderChannel.readOutbound();
        ByteBuf compressedBinaryPayload = (ByteBuf)encoderChannel.readOutbound();
        TextWebSocketFrame compressedTextFrame = new TextWebSocketFrame(true, 4, compressedTextPayload);
        BinaryWebSocketFrame compressedBinaryFrame = new BinaryWebSocketFrame(true, 4, compressedBinaryPayload);
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedTextFrame}));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedBinaryFrame}));
        TextWebSocketFrame inboundTextFrame = (TextWebSocketFrame)decoderChannel.readInbound();
        BinaryWebSocketFrame inboundBinaryFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assert.assertEquals((long)4L, (long)inboundTextFrame.rsv());
        Assert.assertEquals((Object)compressedTextPayload, (Object)inboundTextFrame.content());
        Assert.assertTrue((boolean)inboundTextFrame.release());
        Assert.assertEquals((long)0L, (long)inboundBinaryFrame.rsv());
        Assert.assertArrayEquals((byte[])binaryPayload, (byte[])ByteBufUtil.getBytes((ByteBuf)inboundBinaryFrame.content()));
        Assert.assertTrue((boolean)inboundBinaryFrame.release());
        Assert.assertTrue((boolean)encoderChannel.finishAndReleaseAll());
        Assert.assertFalse((boolean)decoderChannel.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=DecoderException.class)
    public void testIllegalStateWhenDecompressionInProgress() {
        WebSocketExtensionFilter selectivityDecompressionFilter = new WebSocketExtensionFilter(){

            public boolean mustSkip(WebSocketFrame frame) {
                return frame.content().readableBytes() < 100;
            }
        };
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, selectivityDecompressionFilter)});
        byte[] firstPayload = new byte[200];
        random.nextBytes(firstPayload);
        byte[] finalPayload = new byte[50];
        random.nextBytes(finalPayload);
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])firstPayload)}));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])finalPayload)}));
        ByteBuf compressedFirstPayload = (ByteBuf)encoderChannel.readOutbound();
        ByteBuf compressedFinalPayload = (ByteBuf)encoderChannel.readOutbound();
        Assert.assertTrue((boolean)encoderChannel.finishAndReleaseAll());
        BinaryWebSocketFrame firstPart = new BinaryWebSocketFrame(false, 4, compressedFirstPayload);
        ContinuationWebSocketFrame finalPart = new ContinuationWebSocketFrame(true, 4, compressedFinalPayload);
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{firstPart}));
        BinaryWebSocketFrame outboundFirstPart = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assert.assertEquals((long)0L, (long)outboundFirstPart.rsv());
        Assert.assertArrayEquals((byte[])firstPayload, (byte[])ByteBufUtil.getBytes((ByteBuf)outboundFirstPart.content()));
        Assert.assertTrue((boolean)outboundFirstPart.release());
        try {
            decoderChannel.writeInbound(new Object[]{finalPart});
        }
        finally {
            Assert.assertTrue((boolean)finalPart.release());
            Assert.assertFalse((boolean)encoderChannel.finishAndReleaseAll());
        }
    }

    @Test
    public void testEmptyFrameDecompression() {
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false)});
        TextWebSocketFrame emptyDeflateBlockFrame = new TextWebSocketFrame(true, 4, DeflateDecoder.EMPTY_DEFLATE_BLOCK);
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{emptyDeflateBlockFrame}));
        TextWebSocketFrame emptyBufferFrame = (TextWebSocketFrame)decoderChannel.readInbound();
        Assert.assertFalse((boolean)emptyBufferFrame.content().isReadable());
        Assert.assertTrue((boolean)emptyBufferFrame.release());
        Assert.assertFalse((boolean)decoderChannel.finish());
    }

    @Test
    public void testFragmentedFrameWithLeftOverInLastFragment() {
        String hexDump = "677170647a777a737574656b707a787a6f6a7561756578756f6b7868616371716c657a6d64697479766d726f6269746c6376777464776f6f72767a726f64667278676764687775786f6762766d776d706b76697773777a70726a6a737279707a7078697a6c69616d7461656d646278626d786f66666e686e776a7a7461746d7a776668776b6f6f736e73746575637a6d727a7175707a6e74627578687871767771697a71766c64626d78726d6d767575687762667963626b687a726d676e646263776e67797264706d6c6863626577616967706a78636a72697464756e627977616f79736475676f76736f7178746a7a7479626c64636b6b6778637768746c62";
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false)});
        ByteBuf originPayload = Unpooled.wrappedBuffer((byte[])ByteBufUtil.decodeHexDump((CharSequence)hexDump));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{originPayload.duplicate().retain()}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        compressedPayload = compressedPayload.slice(0, compressedPayload.readableBytes() - 4);
        int oneThird = compressedPayload.readableBytes() / 3;
        TextWebSocketFrame compressedFrame1 = new TextWebSocketFrame(false, 4, compressedPayload.slice(0, oneThird));
        ContinuationWebSocketFrame compressedFrame2 = new ContinuationWebSocketFrame(false, 1, compressedPayload.slice(oneThird, oneThird));
        ContinuationWebSocketFrame compressedFrame3 = new ContinuationWebSocketFrame(false, 1, compressedPayload.slice(oneThird * 2, oneThird));
        int offset = oneThird * 3;
        ContinuationWebSocketFrame compressedFrameWithExtraData = new ContinuationWebSocketFrame(true, 1, compressedPayload.slice(offset, compressedPayload.readableBytes() - offset));
        Assert.assertEquals((long)1L, (long)compressedFrameWithExtraData.content().readableBytes());
        Assert.assertEquals((long)1L, (long)compressedFrameWithExtraData.content().getByte(0));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame1.retain()}));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame2.retain()}));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame3.retain()}));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrameWithExtraData}));
        TextWebSocketFrame uncompressedFrame1 = (TextWebSocketFrame)decoderChannel.readInbound();
        ContinuationWebSocketFrame uncompressedFrame2 = (ContinuationWebSocketFrame)decoderChannel.readInbound();
        ContinuationWebSocketFrame uncompressedFrame3 = (ContinuationWebSocketFrame)decoderChannel.readInbound();
        ContinuationWebSocketFrame uncompressedExtraData = (ContinuationWebSocketFrame)decoderChannel.readInbound();
        Assert.assertFalse((boolean)uncompressedExtraData.content().isReadable());
        ByteBuf uncompressedPayload = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{uncompressedFrame1.content(), uncompressedFrame2.content(), uncompressedFrame3.content(), uncompressedExtraData.content()});
        Assert.assertEquals((Object)originPayload, (Object)uncompressedPayload);
        Assert.assertTrue((boolean)originPayload.release());
        Assert.assertTrue((boolean)uncompressedPayload.release());
        Assert.assertTrue((boolean)encoderChannel.finishAndReleaseAll());
        Assert.assertFalse((boolean)decoderChannel.finish());
    }
}

