/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateEncoder;
import io.netty.util.CharsetUtil;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class PerMessageDeflateEncoderTest {
    private static final Random random = new Random();

    @Test
    public void testCompressedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])payload));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame}));
        BinaryWebSocketFrame compressedFrame = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        Assert.assertNotNull((Object)compressedFrame);
        Assert.assertNotNull((Object)compressedFrame.content());
        Assert.assertEquals((long)5L, (long)compressedFrame.rsv());
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame.content()}));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{DeflateDecoder.FRAME_TAIL.duplicate()}));
        ByteBuf uncompressedPayload = (ByteBuf)decoderChannel.readInbound();
        Assert.assertEquals((long)300L, (long)uncompressedPayload.readableBytes());
        byte[] finalPayload = new byte[300];
        uncompressedPayload.readBytes(finalPayload);
        Assert.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        uncompressedPayload.release();
    }

    @Test
    public void testAlreadyCompressedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 5, Unpooled.wrappedBuffer((byte[])payload));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame}));
        BinaryWebSocketFrame newFrame = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        Assert.assertNotNull((Object)newFrame);
        Assert.assertNotNull((Object)newFrame.content());
        Assert.assertEquals((long)5L, (long)newFrame.rsv());
        Assert.assertEquals((long)300L, (long)newFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        newFrame.content().readBytes(finalPayload);
        Assert.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        newFrame.release();
    }

    @Test
    public void testFragmentedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false, WebSocketExtensionFilter.NEVER_SKIP)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE)});
        byte[] payload1 = new byte[100];
        random.nextBytes(payload1);
        byte[] payload2 = new byte[100];
        random.nextBytes(payload2);
        byte[] payload3 = new byte[100];
        random.nextBytes(payload3);
        BinaryWebSocketFrame frame1 = new BinaryWebSocketFrame(false, 1, Unpooled.wrappedBuffer((byte[])payload1));
        ContinuationWebSocketFrame frame2 = new ContinuationWebSocketFrame(false, 1, Unpooled.wrappedBuffer((byte[])payload2));
        ContinuationWebSocketFrame frame3 = new ContinuationWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])payload3));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame1}));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame2}));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame3}));
        BinaryWebSocketFrame compressedFrame1 = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        ContinuationWebSocketFrame compressedFrame2 = (ContinuationWebSocketFrame)encoderChannel.readOutbound();
        ContinuationWebSocketFrame compressedFrame3 = (ContinuationWebSocketFrame)encoderChannel.readOutbound();
        Assert.assertNotNull((Object)compressedFrame1);
        Assert.assertNotNull((Object)compressedFrame2);
        Assert.assertNotNull((Object)compressedFrame3);
        Assert.assertEquals((long)5L, (long)compressedFrame1.rsv());
        Assert.assertEquals((long)1L, (long)compressedFrame2.rsv());
        Assert.assertEquals((long)1L, (long)compressedFrame3.rsv());
        Assert.assertFalse((boolean)compressedFrame1.isFinalFragment());
        Assert.assertFalse((boolean)compressedFrame2.isFinalFragment());
        Assert.assertTrue((boolean)compressedFrame3.isFinalFragment());
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame1.content()}));
        ByteBuf uncompressedPayload1 = (ByteBuf)decoderChannel.readInbound();
        byte[] finalPayload1 = new byte[100];
        uncompressedPayload1.readBytes(finalPayload1);
        Assert.assertArrayEquals((byte[])finalPayload1, (byte[])payload1);
        uncompressedPayload1.release();
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame2.content()}));
        ByteBuf uncompressedPayload2 = (ByteBuf)decoderChannel.readInbound();
        byte[] finalPayload2 = new byte[100];
        uncompressedPayload2.readBytes(finalPayload2);
        Assert.assertArrayEquals((byte[])finalPayload2, (byte[])payload2);
        uncompressedPayload2.release();
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame3.content()}));
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{DeflateDecoder.FRAME_TAIL.duplicate()}));
        ByteBuf uncompressedPayload3 = (ByteBuf)decoderChannel.readInbound();
        byte[] finalPayload3 = new byte[100];
        uncompressedPayload3.readBytes(finalPayload3);
        Assert.assertArrayEquals((byte[])finalPayload3, (byte[])payload3);
        uncompressedPayload3.release();
    }

    @Test
    public void testCompressionSkipForBinaryFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false, WebSocketExtensionFilter.ALWAYS_SKIP)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])payload));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{binaryFrame.copy()}));
        WebSocketFrame outboundFrame = (WebSocketFrame)encoderChannel.readOutbound();
        Assert.assertEquals((long)0L, (long)outboundFrame.rsv());
        Assert.assertArrayEquals((byte[])payload, (byte[])ByteBufUtil.getBytes((ByteBuf)outboundFrame.content()));
        Assert.assertTrue((boolean)outboundFrame.release());
        Assert.assertFalse((boolean)encoderChannel.finish());
    }

    @Test
    public void testSelectivityCompressionSkip() {
        WebSocketExtensionFilter selectivityCompressionFilter = new WebSocketExtensionFilter(){

            public boolean mustSkip(WebSocketFrame frame) {
                return (frame instanceof TextWebSocketFrame || frame instanceof BinaryWebSocketFrame) && frame.content().readableBytes() < 100;
            }
        };
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false, selectivityCompressionFilter)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE)});
        String textPayload = "not compressed payload";
        byte[] binaryPayload = new byte[101];
        random.nextBytes(binaryPayload);
        TextWebSocketFrame textFrame = new TextWebSocketFrame(textPayload);
        BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])binaryPayload));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{textFrame}));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{binaryFrame}));
        WebSocketFrame outboundTextFrame = (WebSocketFrame)encoderChannel.readOutbound();
        Assert.assertEquals((long)0L, (long)outboundTextFrame.rsv());
        Assert.assertEquals((Object)textPayload, (Object)outboundTextFrame.content().toString(CharsetUtil.UTF_8));
        Assert.assertTrue((boolean)outboundTextFrame.release());
        WebSocketFrame outboundBinaryFrame = (WebSocketFrame)encoderChannel.readOutbound();
        Assert.assertEquals((long)4L, (long)outboundBinaryFrame.rsv());
        Assert.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{outboundBinaryFrame.content().retain()}));
        ByteBuf uncompressedBinaryPayload = (ByteBuf)decoderChannel.readInbound();
        Assert.assertArrayEquals((byte[])binaryPayload, (byte[])ByteBufUtil.getBytes((ByteBuf)uncompressedBinaryPayload));
        Assert.assertTrue((boolean)outboundBinaryFrame.release());
        Assert.assertTrue((boolean)uncompressedBinaryPayload.release());
        Assert.assertFalse((boolean)encoderChannel.finish());
        Assert.assertFalse((boolean)decoderChannel.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=EncoderException.class)
    public void testIllegalStateWhenCompressionInProgress() {
        WebSocketExtensionFilter selectivityCompressionFilter = new WebSocketExtensionFilter(){

            public boolean mustSkip(WebSocketFrame frame) {
                return frame.content().readableBytes() < 100;
            }
        };
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false, selectivityCompressionFilter)});
        byte[] firstPayload = new byte[200];
        random.nextBytes(firstPayload);
        byte[] finalPayload = new byte[90];
        random.nextBytes(finalPayload);
        BinaryWebSocketFrame firstPart = new BinaryWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])firstPayload));
        ContinuationWebSocketFrame finalPart = new ContinuationWebSocketFrame(true, 0, Unpooled.wrappedBuffer((byte[])finalPayload));
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{firstPart}));
        BinaryWebSocketFrame outboundFirstPart = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        Assert.assertEquals((long)4L, (long)outboundFirstPart.rsv());
        Assert.assertFalse((boolean)Arrays.equals(firstPayload, ByteBufUtil.getBytes((ByteBuf)outboundFirstPart.content())));
        Assert.assertTrue((boolean)outboundFirstPart.release());
        try {
            encoderChannel.writeOutbound(new Object[]{finalPart});
        }
        finally {
            Assert.assertTrue((boolean)finalPart.release());
            Assert.assertFalse((boolean)encoderChannel.finishAndReleaseAll());
        }
    }

    @Test
    public void testEmptyFrameCompression() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false)});
        TextWebSocketFrame emptyFrame = new TextWebSocketFrame("");
        Assert.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{emptyFrame}));
        TextWebSocketFrame emptyDeflateFrame = (TextWebSocketFrame)encoderChannel.readOutbound();
        Assert.assertEquals((long)4L, (long)emptyDeflateFrame.rsv());
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)DeflateDecoder.EMPTY_DEFLATE_BLOCK, (ByteBuf)emptyDeflateFrame.content()));
        Assert.assertFalse((boolean)emptyDeflateFrame.release());
        Assert.assertFalse((boolean)encoderChannel.finish());
    }

    @Test(expected=EncoderException.class)
    public void testCodecExceptionForNotFinEmptyFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false)});
        TextWebSocketFrame emptyNotFinFrame = new TextWebSocketFrame(false, 0, "");
        try {
            encoderChannel.writeOutbound(new Object[]{emptyNotFinFrame});
        }
        finally {
            Assert.assertFalse((boolean)emptyNotFinFrame.release());
            Assert.assertFalse((boolean)encoderChannel.finish());
        }
    }
}

