/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.rtsp;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.rtsp.RtspDecoder;
import org.junit.Assert;
import org.junit.Test;

public class RtspDecoderTest {
    @Test
    public void testReceiveAnnounce() {
        byte[] data1 = "ANNOUNCE rtsp://172.20.184.218:554/d3abaaa7-65f2-42b4-8d6b-379f492fcf0f RTSP/1.0\r\nCSeq: 2\r\nSession: 2777476816092819869\r\nx-notice: 5402 \"Session Terminated by Server\" event-date=20150514T075303Z\r\nRange: npt=0\r\n\r\n".getBytes();
        byte[] data2 = "RTSP/1.0 200 OK\r\nServer: Orbit2x\r\nCSeq: 172\r\nSession: 2547019973447939919\r\n\r\n".getBytes();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new RtspDecoder(), new HttpObjectAggregator(0x100000)});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])data1), Unpooled.wrappedBuffer((byte[])data2)});
        HttpObject res1 = (HttpObject)ch.readInbound();
        System.out.println(res1);
        Assert.assertNotNull((Object)res1);
        Assert.assertTrue((boolean)(res1 instanceof FullHttpRequest));
        ((FullHttpRequest)res1).release();
        HttpObject res2 = (HttpObject)ch.readInbound();
        Assert.assertNotNull((Object)res2);
        Assert.assertTrue((boolean)(res2 instanceof FullHttpResponse));
        ((FullHttpResponse)res2).release();
    }
}

