/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyHeaderBlockZlibDecoder;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyProtocolException;
import io.netty.handler.codec.spdy.SpdyVersion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpdyHeaderBlockZlibDecoderTest {
    private static final byte[] zlibHeader = new byte[]{120, 63, -29, -58, -89, -62};
    private static final byte[] zlibSyncFlush = new byte[]{0, 0, 0, -1, -1};
    private static final int maxHeaderSize = 8192;
    private static final String name = "name";
    private static final String value = "value";
    private static final byte[] nameBytes = "name".getBytes();
    private static final byte[] valueBytes = "value".getBytes();
    private SpdyHeaderBlockZlibDecoder decoder;
    private SpdyHeadersFrame frame;

    @Before
    public void setUp() {
        this.decoder = new SpdyHeaderBlockZlibDecoder(SpdyVersion.SPDY_3_1, 8192);
        this.frame = new DefaultSpdyHeadersFrame(1);
    }

    @After
    public void tearDown() {
        this.decoder.end();
    }

    @Test
    public void testHeaderBlock() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)37);
        headerBlock.writeBytes(zlibHeader);
        headerBlock.writeByte(0);
        headerBlock.writeByte(21);
        headerBlock.writeByte(0);
        headerBlock.writeByte(234);
        headerBlock.writeByte(255);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        headerBlock.writeBytes(zlibSyncFlush);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assert.assertFalse((boolean)headerBlock.isReadable());
        Assert.assertFalse((boolean)this.frame.isInvalid());
        Assert.assertEquals((long)1L, (long)this.frame.headers().names().size());
        Assert.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assert.assertEquals((long)1L, (long)this.frame.headers().getAll((Object)name).size());
        Assert.assertEquals((Object)value, (Object)this.frame.headers().get((Object)name));
        headerBlock.release();
    }

    @Test
    public void testHeaderBlockMultipleDecodes() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)37);
        headerBlock.writeBytes(zlibHeader);
        headerBlock.writeByte(0);
        headerBlock.writeByte(21);
        headerBlock.writeByte(0);
        headerBlock.writeByte(234);
        headerBlock.writeByte(255);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        headerBlock.writeBytes(zlibSyncFlush);
        int readableBytes = headerBlock.readableBytes();
        for (int i = 0; i < readableBytes; ++i) {
            ByteBuf headerBlockSegment = headerBlock.slice(i, 1);
            this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlockSegment, this.frame);
            Assert.assertFalse((boolean)headerBlockSegment.isReadable());
        }
        this.decoder.endHeaderBlock(this.frame);
        Assert.assertFalse((boolean)this.frame.isInvalid());
        Assert.assertEquals((long)1L, (long)this.frame.headers().names().size());
        Assert.assertTrue((boolean)this.frame.headers().contains((Object)name));
        Assert.assertEquals((long)1L, (long)this.frame.headers().getAll((Object)name).size());
        Assert.assertEquals((Object)value, (Object)this.frame.headers().get((Object)name));
        headerBlock.release();
    }

    @Test
    public void testLargeHeaderName() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)8220);
        headerBlock.writeBytes(zlibHeader);
        headerBlock.writeByte(0);
        headerBlock.writeByte(12);
        headerBlock.writeByte(32);
        headerBlock.writeByte(243);
        headerBlock.writeByte(223);
        headerBlock.writeInt(1);
        headerBlock.writeInt(8192);
        for (int i = 0; i < 8192; ++i) {
            headerBlock.writeByte(110);
        }
        headerBlock.writeInt(0);
        headerBlock.writeBytes(zlibSyncFlush);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assert.assertFalse((boolean)headerBlock.isReadable());
        Assert.assertFalse((boolean)this.frame.isInvalid());
        Assert.assertFalse((boolean)this.frame.isTruncated());
        Assert.assertEquals((long)1L, (long)this.frame.headers().names().size());
        headerBlock.release();
    }

    @Test
    public void testLargeHeaderValue() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)8220);
        headerBlock.writeBytes(zlibHeader);
        headerBlock.writeByte(0);
        headerBlock.writeByte(12);
        headerBlock.writeByte(32);
        headerBlock.writeByte(243);
        headerBlock.writeByte(223);
        headerBlock.writeInt(1);
        headerBlock.writeInt(1);
        headerBlock.writeByte(110);
        headerBlock.writeInt(8191);
        for (int i = 0; i < 8191; ++i) {
            headerBlock.writeByte(118);
        }
        headerBlock.writeBytes(zlibSyncFlush);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        this.decoder.endHeaderBlock(this.frame);
        Assert.assertFalse((boolean)headerBlock.isReadable());
        Assert.assertFalse((boolean)this.frame.isInvalid());
        Assert.assertFalse((boolean)this.frame.isTruncated());
        Assert.assertEquals((long)1L, (long)this.frame.headers().names().size());
        Assert.assertEquals((long)8191L, (long)((CharSequence)this.frame.headers().get((Object)"n")).length());
        headerBlock.release();
    }

    @Test(expected=SpdyProtocolException.class)
    public void testHeaderBlockExtraData() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)37);
        headerBlock.writeBytes(zlibHeader);
        headerBlock.writeByte(0);
        headerBlock.writeByte(21);
        headerBlock.writeByte(0);
        headerBlock.writeByte(234);
        headerBlock.writeByte(255);
        headerBlock.writeInt(1);
        headerBlock.writeInt(4);
        headerBlock.writeBytes(nameBytes);
        headerBlock.writeInt(5);
        headerBlock.writeBytes(valueBytes);
        headerBlock.writeByte(25);
        headerBlock.writeByte(165);
        headerBlock.writeByte(3);
        headerBlock.writeByte(201);
        headerBlock.writeByte(0);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        headerBlock.release();
    }

    @Test(expected=SpdyProtocolException.class)
    public void testHeaderBlockInvalidDictionary() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)7);
        headerBlock.writeByte(120);
        headerBlock.writeByte(63);
        headerBlock.writeByte(1);
        headerBlock.writeByte(2);
        headerBlock.writeByte(3);
        headerBlock.writeByte(4);
        headerBlock.writeByte(0);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        headerBlock.release();
    }

    @Test(expected=SpdyProtocolException.class)
    public void testHeaderBlockInvalidDeflateBlock() throws Exception {
        ByteBuf headerBlock = Unpooled.buffer((int)11);
        headerBlock.writeBytes(zlibHeader);
        headerBlock.writeByte(0);
        headerBlock.writeByte(0);
        headerBlock.writeByte(0);
        headerBlock.writeByte(0);
        headerBlock.writeByte(0);
        this.decoder.decode(ByteBufAllocator.DEFAULT, headerBlock, this.frame);
        headerBlock.release();
    }
}

