/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cookie;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServerCookieEncoderTest {
    @Test
    public void testEncodingSingleCookieV0() throws ParseException {
        int maxAge = 50;
        String result = "myCookie=myValue; Max-Age=50; Expires=(.+?); Path=/apathsomewhere; Domain=.adomainsomewhere; Secure; SameSite=Lax";
        DefaultCookie cookie = new DefaultCookie("myCookie", "myValue");
        cookie.setDomain(".adomainsomewhere");
        cookie.setMaxAge((long)maxAge);
        cookie.setPath("/apathsomewhere");
        cookie.setSecure(true);
        cookie.setSameSite(CookieHeaderNames.SameSite.Lax);
        String encodedCookie = ServerCookieEncoder.STRICT.encode((Cookie)cookie);
        java.util.regex.Matcher matcher = Pattern.compile(result).matcher(encodedCookie);
        Assertions.assertTrue((boolean)matcher.find());
        Date expiresDate = DateFormatter.parseHttpDate((CharSequence)matcher.group(1));
        long diff = (expiresDate.getTime() - System.currentTimeMillis()) / 1000L;
        Assertions.assertTrue((Math.abs(diff - (long)maxAge) <= 2L ? 1 : 0) != 0);
    }

    @Test
    public void testEncodingWithNoCookies() {
        String encodedCookie1 = ClientCookieEncoder.STRICT.encode(new Cookie[0]);
        List encodedCookie2 = ServerCookieEncoder.STRICT.encode(new Cookie[0]);
        Assertions.assertNull((Object)encodedCookie1);
        Assertions.assertNotNull((Object)encodedCookie2);
        Assertions.assertTrue((boolean)encodedCookie2.isEmpty());
    }

    @Test
    public void testEncodingMultipleCookiesStrict() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("cookie2=value2");
        result.add("cookie1=value3");
        DefaultCookie cookie1 = new DefaultCookie("cookie1", "value1");
        DefaultCookie cookie2 = new DefaultCookie("cookie2", "value2");
        DefaultCookie cookie3 = new DefaultCookie("cookie1", "value3");
        List encodedCookies = ServerCookieEncoder.STRICT.encode(new Cookie[]{cookie1, cookie2, cookie3});
        Assertions.assertEquals(result, (Object)encodedCookies);
    }

    @Test
    public void illegalCharInCookieNameMakesStrictEncoderThrowsException() {
        HashSet<Character> illegalChars = new HashSet<Character>();
        for (int i = 0; i <= 31; ++i) {
            illegalChars.add(Character.valueOf((char)i));
        }
        illegalChars.add(Character.valueOf('\u007f'));
        for (char c : new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'}) {
            illegalChars.add(Character.valueOf(c));
        }
        int exceptions = 0;
        Iterator iterator = illegalChars.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            try {
                ServerCookieEncoder.STRICT.encode((Cookie)new DefaultCookie("foo" + c + "bar", "value"));
            }
            catch (IllegalArgumentException e) {
                ++exceptions;
            }
        }
        Assertions.assertEquals((int)illegalChars.size(), (int)exceptions);
    }

    @Test
    public void illegalCharInCookieValueMakesStrictEncoderThrowsException() {
        HashSet<Character> illegalChars = new HashSet<Character>();
        for (int i = 0; i <= 31; ++i) {
            illegalChars.add(Character.valueOf((char)i));
        }
        illegalChars.add(Character.valueOf('\u007f'));
        for (char c : new char[]{' ', '\"', ',', ';', '\\'}) {
            illegalChars.add(Character.valueOf(c));
        }
        int exceptions = 0;
        Iterator iterator = illegalChars.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            try {
                ServerCookieEncoder.STRICT.encode((Cookie)new DefaultCookie("name", "value" + c));
            }
            catch (IllegalArgumentException e) {
                ++exceptions;
            }
        }
        Assertions.assertEquals((int)illegalChars.size(), (int)exceptions);
    }

    @Test
    public void illegalCharInWrappedValueAppearsInException() {
        try {
            ServerCookieEncoder.STRICT.encode((Cookie)new DefaultCookie("name", "\"value,\""));
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage().toLowerCase(), (Matcher)CoreMatchers.containsString((String)"cookie value contains an invalid char: ,"));
        }
    }

    @Test
    public void testEncodingMultipleCookiesLax() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("cookie1=value1");
        result.add("cookie2=value2");
        result.add("cookie1=value3");
        DefaultCookie cookie1 = new DefaultCookie("cookie1", "value1");
        DefaultCookie cookie2 = new DefaultCookie("cookie2", "value2");
        DefaultCookie cookie3 = new DefaultCookie("cookie1", "value3");
        List encodedCookies = ServerCookieEncoder.LAX.encode(new Cookie[]{cookie1, cookie2, cookie3});
        Assertions.assertEquals(result, (Object)encodedCookies);
    }
}

