/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateEncoder;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeflateFrameClientExtensionHandshakerTest {
    @Test
    public void testWebkitDeflateFrameData() {
        DeflateFrameClientExtensionHandshaker handshaker = new DeflateFrameClientExtensionHandshaker(true);
        WebSocketExtensionData data = handshaker.newRequestData();
        Assertions.assertEquals((Object)"x-webkit-deflate-frame", (Object)data.name());
        Assertions.assertTrue((boolean)data.parameters().isEmpty());
    }

    @Test
    public void testDeflateFrameData() {
        DeflateFrameClientExtensionHandshaker handshaker = new DeflateFrameClientExtensionHandshaker(false);
        WebSocketExtensionData data = handshaker.newRequestData();
        Assertions.assertEquals((Object)"deflate-frame", (Object)data.name());
        Assertions.assertTrue((boolean)data.parameters().isEmpty());
    }

    @Test
    public void testNormalHandshake() {
        DeflateFrameClientExtensionHandshaker handshaker = new DeflateFrameClientExtensionHandshaker(false);
        WebSocketClientExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("deflate-frame", Collections.emptyMap()));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerFrameDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerFrameDeflateEncoder));
    }

    @Test
    public void testFailedHandshake() {
        DeflateFrameClientExtensionHandshaker handshaker = new DeflateFrameClientExtensionHandshaker(false);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("invalid", "12");
        WebSocketClientExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("deflate-frame", parameters));
        Assertions.assertNull((Object)extension);
    }
}

