/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateEncoder;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeflateFrameServerExtensionHandshakerTest {
    @Test
    public void testNormalHandshake() {
        DeflateFrameServerExtensionHandshaker handshaker = new DeflateFrameServerExtensionHandshaker();
        WebSocketServerExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("deflate-frame", Collections.emptyMap()));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerFrameDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerFrameDeflateEncoder));
    }

    @Test
    public void testWebkitHandshake() {
        DeflateFrameServerExtensionHandshaker handshaker = new DeflateFrameServerExtensionHandshaker();
        WebSocketServerExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("x-webkit-deflate-frame", Collections.emptyMap()));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerFrameDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerFrameDeflateEncoder));
    }

    @Test
    public void testFailedHandshake() {
        DeflateFrameServerExtensionHandshaker handshaker = new DeflateFrameServerExtensionHandshaker();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("unknown", "11");
        WebSocketServerExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("deflate-frame", parameters));
        Assertions.assertNull((Object)extension);
    }
}

