/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.util.AsciiString;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultHttp2HeadersEncoderTest {
    private DefaultHttp2HeadersEncoder encoder;

    @Before
    public void setup() {
        this.encoder = new DefaultHttp2HeadersEncoder(Http2HeadersEncoder.NEVER_SENSITIVE, Http2TestUtil.newTestEncoder());
    }

    @Test
    public void encodeShouldSucceed() throws Http2Exception {
        Http2Headers headers = DefaultHttp2HeadersEncoderTest.headers();
        ByteBuf buf = Unpooled.buffer();
        try {
            this.encoder.encodeHeaders(3, headers, buf);
            Assert.assertTrue((buf.writerIndex() > 0 ? 1 : 0) != 0);
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=Http2Exception.StreamException.class)
    public void headersExceedMaxSetSizeShouldFail() throws Http2Exception {
        Http2Headers headers = DefaultHttp2HeadersEncoderTest.headers();
        this.encoder.maxHeaderListSize(2L);
        this.encoder.encodeHeaders(3, headers, Unpooled.buffer());
    }

    private static Http2Headers headers() {
        return (Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).add((Object)new AsciiString((CharSequence)"a"), (Object)new AsciiString((CharSequence)"1"))).add((Object)new AsciiString((CharSequence)"a"), (Object)new AsciiString((CharSequence)"2"));
    }
}

