/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.EventExecutor;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class DefaultHttp2LocalFlowControllerTest {
    private static final int STREAM_ID = 1;
    private DefaultHttp2LocalFlowController controller;
    @Mock
    private Http2FrameWriter frameWriter;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private EventExecutor executor;
    @Mock
    private ChannelPromise promise;
    private DefaultHttp2Connection connection;

    @Before
    public void setup() throws Http2Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.setupChannelHandlerContext(false);
        Mockito.when((Object)this.executor.inEventLoop()).thenReturn((Object)true);
        this.initController(false);
    }

    private void setupChannelHandlerContext(boolean allowFlush) {
        Mockito.reset((Object[])new ChannelHandlerContext[]{this.ctx});
        Mockito.when((Object)this.ctx.newPromise()).thenReturn((Object)this.promise);
        if (allowFlush) {
            Mockito.when((Object)this.ctx.flush()).then((Answer)new Answer<ChannelHandlerContext>(){

                public ChannelHandlerContext answer(InvocationOnMock invocationOnMock) {
                    return DefaultHttp2LocalFlowControllerTest.this.ctx;
                }
            });
        } else {
            Mockito.when((Object)this.ctx.flush()).thenThrow(new Throwable[]{new AssertionFailedError("forbidden")});
        }
        Mockito.when((Object)this.ctx.executor()).thenReturn((Object)this.executor);
    }

    @Test
    public void dataFrameShouldBeAccepted() throws Http2Exception {
        this.receiveFlowControlledFrame(1, 10, 0, false);
        this.verifyWindowUpdateNotSent();
    }

    @Test
    public void windowUpdateShouldSendOnceBytesReturned() throws Http2Exception {
        int dataSize = 32768;
        this.receiveFlowControlledFrame(1, dataSize, 0, false);
        Assert.assertFalse((boolean)this.consumeBytes(1, 10));
        this.verifyWindowUpdateNotSent(1);
        this.verifyWindowUpdateNotSent(0);
        Assert.assertTrue((boolean)this.consumeBytes(1, dataSize - 10));
        this.verifyWindowUpdateSent(1, dataSize);
        this.verifyWindowUpdateSent(0, dataSize);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.frameWriter});
    }

    @Test
    public void connectionWindowShouldAutoRefillWhenDataReceived() throws Http2Exception {
        this.initController(true);
        int dataSize = 32768;
        this.receiveFlowControlledFrame(1, dataSize, 0, false);
        this.verifyWindowUpdateSent(0, dataSize);
        Assert.assertFalse((boolean)this.consumeBytes(1, 10));
        this.verifyWindowUpdateNotSent(1);
        Assert.assertTrue((boolean)this.consumeBytes(1, dataSize - 10));
        this.verifyWindowUpdateSent(1, dataSize);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.frameWriter});
    }

    @Test(expected=Http2Exception.class)
    public void connectionFlowControlExceededShouldThrow() throws Http2Exception {
        this.receiveFlowControlledFrame(1, 65535, 1, true);
    }

    @Test
    public void windowUpdateShouldNotBeSentAfterEndOfStream() throws Http2Exception {
        int dataSize = 32768;
        this.receiveFlowControlledFrame(1, dataSize, 0, true);
        this.verifyWindowUpdateNotSent(0);
        this.verifyWindowUpdateNotSent(1);
        Assert.assertTrue((boolean)this.consumeBytes(1, dataSize));
        this.verifyWindowUpdateSent(0, dataSize);
        this.verifyWindowUpdateNotSent(1);
    }

    @Test
    public void windowUpdateShouldNotBeSentAfterStreamIsClosedForUnconsumedBytes() throws Http2Exception {
        int dataSize = 32768;
        this.receiveFlowControlledFrame(1, dataSize, 0, false);
        this.verifyWindowUpdateNotSent(0);
        this.verifyWindowUpdateNotSent(1);
        Http2Stream stream = this.connection.stream(1);
        stream.close();
        Assert.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream.state());
        Assert.assertNull((Object)this.connection.stream(1));
        this.verifyWindowUpdateSent(0, dataSize);
        this.verifyWindowUpdateNotSent(1);
    }

    @Test
    public void windowUpdateShouldBeWrittenWhenStreamIsClosedAndFlushed() throws Http2Exception {
        int dataSize = 32768;
        this.setupChannelHandlerContext(true);
        this.receiveFlowControlledFrame(1, dataSize, 0, false);
        this.verifyWindowUpdateNotSent(0);
        this.verifyWindowUpdateNotSent(1);
        this.connection.stream(1).close();
        this.verifyWindowUpdateSent(0, dataSize);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).flush();
    }

    @Test
    public void halfWindowRemainingShouldUpdateAllWindows() throws Http2Exception {
        int dataSize = 32768;
        int initialWindowSize = 65535;
        int windowDelta = DefaultHttp2LocalFlowControllerTest.getWindowDelta(initialWindowSize, initialWindowSize, dataSize);
        this.receiveFlowControlledFrame(1, dataSize, 0, false);
        Assert.assertTrue((boolean)this.consumeBytes(1, dataSize));
        this.verifyWindowUpdateSent(0, windowDelta);
        this.verifyWindowUpdateSent(1, windowDelta);
    }

    @Test
    public void initialWindowUpdateShouldAllowMoreFrames() throws Http2Exception {
        int initialWindowSize = 65535;
        this.receiveFlowControlledFrame(1, initialWindowSize, 0, false);
        Assert.assertEquals((long)0L, (long)this.window(1));
        Assert.assertEquals((long)0L, (long)this.window(0));
        this.consumeBytes(1, initialWindowSize);
        Assert.assertEquals((long)initialWindowSize, (long)this.window(1));
        Assert.assertEquals((long)65535L, (long)this.window(0));
        int newInitialWindowSize = 2 * initialWindowSize;
        this.controller.initialWindowSize(newInitialWindowSize);
        Assert.assertEquals((long)newInitialWindowSize, (long)this.window(1));
        Assert.assertEquals((long)65535L, (long)this.window(0));
        Mockito.reset((Object[])new Http2FrameWriter[]{this.frameWriter});
        this.receiveFlowControlledFrame(1, initialWindowSize, 0, false);
        Assert.assertTrue((boolean)this.consumeBytes(1, initialWindowSize));
        int delta = newInitialWindowSize - initialWindowSize;
        this.verifyWindowUpdateSent(1, delta);
        this.verifyWindowUpdateSent(0, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectionWindowShouldAdjustWithMultipleStreams() throws Http2Exception {
        int newStreamId = 3;
        this.connection.local().createStream(newStreamId, false);
        try {
            Assert.assertEquals((long)65535L, (long)this.window(1));
            Assert.assertEquals((long)65535L, (long)this.window(0));
            int data1 = 32768;
            this.receiveFlowControlledFrame(1, data1, 0, false);
            this.verifyWindowUpdateNotSent(1);
            this.verifyWindowUpdateNotSent(0);
            Assert.assertEquals((long)(65535 - data1), (long)this.window(1));
            Assert.assertEquals((long)(65535 - data1), (long)this.window(0));
            Assert.assertTrue((boolean)this.consumeBytes(1, data1));
            this.verifyWindowUpdateSent(1, data1);
            this.verifyWindowUpdateSent(0, data1);
            Mockito.reset((Object[])new Http2FrameWriter[]{this.frameWriter});
            int data2 = --data1 >> 1;
            this.receiveFlowControlledFrame(1, data1, 0, false);
            this.receiveFlowControlledFrame(newStreamId, data1, 0, false);
            this.verifyWindowUpdateNotSent(1);
            this.verifyWindowUpdateNotSent(newStreamId);
            this.verifyWindowUpdateNotSent(0);
            Assert.assertEquals((long)(65535 - data1), (long)this.window(1));
            Assert.assertEquals((long)(65535 - data1), (long)this.window(newStreamId));
            Assert.assertEquals((long)(65535 - (data1 << 1)), (long)this.window(0));
            Assert.assertFalse((boolean)this.consumeBytes(1, data1));
            Assert.assertTrue((boolean)this.consumeBytes(newStreamId, data2));
            this.verifyWindowUpdateNotSent(1);
            this.verifyWindowUpdateNotSent(newStreamId);
            this.verifyWindowUpdateSent(0, data1 + data2);
            Assert.assertEquals((long)(65535 - data1), (long)this.window(1));
            Assert.assertEquals((long)(65535 - data1), (long)this.window(newStreamId));
            Assert.assertEquals((long)(65535 - (data1 - data2)), (long)this.window(0));
        }
        finally {
            this.connection.stream(newStreamId).close();
        }
    }

    @Test
    public void closeShouldConsumeBytes() throws Http2Exception {
        this.receiveFlowControlledFrame(1, 10, 0, false);
        Assert.assertEquals((long)10L, (long)this.controller.unconsumedBytes(this.connection.connectionStream()));
        this.stream(1).close();
        Assert.assertEquals((long)0L, (long)this.controller.unconsumedBytes(this.connection.connectionStream()));
    }

    @Test
    public void closeShouldNotConsumeConnectionWindowWhenAutoRefilled() throws Http2Exception {
        this.initController(true);
        this.receiveFlowControlledFrame(1, 10, 0, false);
        Assert.assertEquals((long)0L, (long)this.controller.unconsumedBytes(this.connection.connectionStream()));
        this.stream(1).close();
        Assert.assertEquals((long)0L, (long)this.controller.unconsumedBytes(this.connection.connectionStream()));
    }

    @Test
    public void dataReceivedForClosedStreamShouldImmediatelyConsumeBytes() throws Http2Exception {
        Http2Stream stream = this.stream(1);
        stream.close();
        this.receiveFlowControlledFrame(stream, 10, 0, false);
        Assert.assertEquals((long)0L, (long)this.controller.unconsumedBytes(this.connection.connectionStream()));
    }

    @Test
    public void dataReceivedForNullStreamShouldImmediatelyConsumeBytes() throws Http2Exception {
        this.receiveFlowControlledFrame(null, 10, 0, false);
        Assert.assertEquals((long)0L, (long)this.controller.unconsumedBytes(this.connection.connectionStream()));
    }

    @Test
    public void consumeBytesForNullStreamShouldIgnore() throws Http2Exception {
        this.controller.consumeBytes(null, 10);
        Assert.assertEquals((long)0L, (long)this.controller.unconsumedBytes(this.connection.connectionStream()));
    }

    @Test
    public void globalRatioShouldImpactStreams() throws Http2Exception {
        float ratio = 0.6f;
        this.controller.windowUpdateRatio(ratio);
        this.testRatio(ratio, 131070, 3, false);
    }

    @Test
    public void streamlRatioShouldImpactStreams() throws Http2Exception {
        float ratio = 0.6f;
        this.testRatio(ratio, 131070, 3, true);
    }

    @Test
    public void consumeBytesForZeroNumBytesShouldIgnore() throws Http2Exception {
        Assert.assertFalse((boolean)this.controller.consumeBytes(this.connection.stream(1), 0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void consumeBytesForNegativeNumBytesShouldFail() throws Http2Exception {
        Assert.assertFalse((boolean)this.controller.consumeBytes(this.connection.stream(1), -1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRatio(float ratio, int newDefaultWindowSize, int newStreamId, boolean setStreamRatio) throws Http2Exception {
        int delta = newDefaultWindowSize - 65535;
        this.controller.incrementWindowSize(this.stream(0), delta);
        Http2Stream stream = this.connection.local().createStream(newStreamId, false);
        if (setStreamRatio) {
            this.controller.windowUpdateRatio(stream, ratio);
        }
        this.controller.incrementWindowSize(stream, delta);
        Mockito.reset((Object[])new Http2FrameWriter[]{this.frameWriter});
        try {
            int data1 = (int)((float)newDefaultWindowSize * ratio) + 1;
            int data2 = 16383;
            this.receiveFlowControlledFrame(1, data2, 0, false);
            this.receiveFlowControlledFrame(newStreamId, data1, 0, false);
            this.verifyWindowUpdateNotSent(1);
            this.verifyWindowUpdateNotSent(newStreamId);
            this.verifyWindowUpdateNotSent(0);
            Assert.assertEquals((long)(65535 - data2), (long)this.window(1));
            Assert.assertEquals((long)(newDefaultWindowSize - data1), (long)this.window(newStreamId));
            Assert.assertEquals((long)(newDefaultWindowSize - data2 - data1), (long)this.window(0));
            Assert.assertFalse((boolean)this.consumeBytes(1, data2));
            Assert.assertTrue((boolean)this.consumeBytes(newStreamId, data1));
            this.verifyWindowUpdateNotSent(1);
            this.verifyWindowUpdateSent(newStreamId, data1);
            this.verifyWindowUpdateSent(0, data1 + data2);
            Assert.assertEquals((long)(65535 - data2), (long)this.window(1));
            Assert.assertEquals((long)newDefaultWindowSize, (long)this.window(newStreamId));
            Assert.assertEquals((long)newDefaultWindowSize, (long)this.window(0));
        }
        finally {
            this.connection.stream(newStreamId).close();
        }
    }

    private static int getWindowDelta(int initialSize, int windowSize, int dataSize) {
        int newWindowSize = windowSize - dataSize;
        return initialSize - newWindowSize;
    }

    private void receiveFlowControlledFrame(int streamId, int dataSize, int padding, boolean endOfStream) throws Http2Exception {
        this.receiveFlowControlledFrame(this.stream(streamId), dataSize, padding, endOfStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveFlowControlledFrame(Http2Stream stream, int dataSize, int padding, boolean endOfStream) throws Http2Exception {
        ByteBuf buf = DefaultHttp2LocalFlowControllerTest.dummyData(dataSize);
        try {
            this.controller.receiveFlowControlledFrame(stream, buf, padding, endOfStream);
        }
        finally {
            buf.release();
        }
    }

    private static ByteBuf dummyData(int size) {
        ByteBuf buffer = Unpooled.buffer((int)size);
        buffer.writerIndex(size);
        return buffer;
    }

    private boolean consumeBytes(int streamId, int numBytes) throws Http2Exception {
        return this.controller.consumeBytes(this.stream(streamId), numBytes);
    }

    private void verifyWindowUpdateSent(int streamId, int windowSizeIncrement) {
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeWindowUpdate((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)streamId), Mockito.eq((int)windowSizeIncrement), (ChannelPromise)Mockito.eq((Object)this.promise));
    }

    private void verifyWindowUpdateNotSent(int streamId) {
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeWindowUpdate((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)streamId), Mockito.anyInt(), (ChannelPromise)Mockito.eq((Object)this.promise));
    }

    private void verifyWindowUpdateNotSent() {
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeWindowUpdate((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyInt(), (ChannelPromise)Mockito.any(ChannelPromise.class));
    }

    private int window(int streamId) {
        return this.controller.windowSize(this.stream(streamId));
    }

    private Http2Stream stream(int streamId) {
        return this.connection.stream(streamId);
    }

    private void initController(boolean autoRefillConnectionWindow) throws Http2Exception {
        this.connection = new DefaultHttp2Connection(false);
        this.controller = new DefaultHttp2LocalFlowController((Http2Connection)this.connection, 0.5f, autoRefillConnectionWindow).frameWriter(this.frameWriter);
        this.connection.local().flowController((Http2FlowController)this.controller);
        this.connection.local().createStream(1, false);
        this.controller.channelHandlerContext(this.ctx);
    }
}

