/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.DefaultHttp2SettingsFrame;
import io.netty.handler.codec.http2.DefaultHttp2UnknownFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameInboundWriter;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamEvent;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.LastInboundHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class Http2FrameCodecTest {
    private Http2FrameWriter frameWriter;
    private Http2FrameCodec frameCodec;
    private EmbeddedChannel channel;
    private Http2FrameInboundWriter frameInboundWriter;
    private LastInboundHandler inboundHandler;
    private final Http2Headers request = new DefaultHttp2Headers().method((CharSequence)HttpMethod.GET.asciiName()).scheme((CharSequence)HttpScheme.HTTPS.name()).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/foo"));
    private final Http2Headers response = new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText());

    @Before
    public void setUp() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer(), new Http2Settings());
    }

    @After
    public void tearDown() throws Exception {
        if (this.inboundHandler != null) {
            this.inboundHandler.finishAndReleaseAll();
            this.inboundHandler = null;
        }
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
            this.channel.close();
            this.channel = null;
        }
    }

    private void setUp(Http2FrameCodecBuilder frameCodecBuilder, Http2Settings initialRemoteSettings) throws Exception {
        this.tearDown();
        this.frameWriter = Http2TestUtil.mockedFrameWriter();
        this.frameCodec = frameCodecBuilder.frameWriter(this.frameWriter).frameLogger(new Http2FrameLogger(LogLevel.TRACE)).initialSettings(initialRemoteSettings).build();
        this.inboundHandler = new LastInboundHandler();
        this.channel = new EmbeddedChannel();
        this.frameInboundWriter = new Http2FrameInboundWriter(this.channel);
        this.channel.connect((SocketAddress)new InetSocketAddress(0));
        this.channel.pipeline().addLast(new ChannelHandler[]{this.frameCodec});
        this.channel.pipeline().addLast(new ChannelHandler[]{this.inboundHandler});
        this.channel.pipeline().fireChannelActive();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettings(this.eqFrameCodecCtx(), Http2TestUtil.anyHttp2Settings(), Http2TestUtil.anyChannelPromise());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.frameWriter});
        this.channel.writeInbound(new Object[]{Http2CodecUtil.connectionPrefaceBuf()});
        this.frameInboundWriter.writeInboundSettings(initialRemoteSettings);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettingsAck(this.eqFrameCodecCtx(), Http2TestUtil.anyChannelPromise());
        this.frameInboundWriter.writeInboundSettingsAck();
        Http2SettingsFrame settingsFrame = (Http2SettingsFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)settingsFrame);
        Http2SettingsAckFrame settingsAckFrame = (Http2SettingsAckFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)settingsAckFrame);
    }

    @Test
    public void stateChanges() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(1, this.request, 31, true);
        Http2Stream stream = this.frameCodec.connection().stream(1);
        Assert.assertNotNull((Object)stream);
        Assert.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Http2FrameStreamEvent event = (Http2FrameStreamEvent)this.inboundHandler.readInboundMessageOrUserEvent();
        Assert.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)event.stream().state());
        Http2StreamFrame inboundFrame = (Http2StreamFrame)this.inboundHandler.readInbound();
        Http2FrameStream stream2 = inboundFrame.stream();
        Assert.assertNotNull((Object)stream2);
        Assert.assertEquals((long)1L, (long)stream2.id());
        Assert.assertEquals((Object)inboundFrame, (Object)new DefaultHttp2HeadersFrame(this.request, true, 31).stream(stream2));
        Assert.assertNull(this.inboundHandler.readInbound());
        this.channel.writeOutbound(new Object[]{new DefaultHttp2HeadersFrame(this.response, true, 27).stream(stream2)});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeHeaders(this.eqFrameCodecCtx(), Mockito.eq((int)1), (Http2Headers)Mockito.eq((Object)this.response), Mockito.eq((int)27), Mockito.eq((boolean)true), Http2TestUtil.anyChannelPromise());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqFrameCodecCtx(), Mockito.anyInt(), Mockito.anyLong(), Http2TestUtil.anyChannelPromise());
        Assert.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream.state());
        event = (Http2FrameStreamEvent)this.inboundHandler.readInboundMessageOrUserEvent();
        Assert.assertEquals((Object)Http2Stream.State.CLOSED, (Object)event.stream().state());
        Assert.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void headerRequestHeaderResponse() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(1, this.request, 31, true);
        Http2Stream stream = this.frameCodec.connection().stream(1);
        Assert.assertNotNull((Object)stream);
        Assert.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Http2StreamFrame inboundFrame = (Http2StreamFrame)this.inboundHandler.readInbound();
        Http2FrameStream stream2 = inboundFrame.stream();
        Assert.assertNotNull((Object)stream2);
        Assert.assertEquals((long)1L, (long)stream2.id());
        Assert.assertEquals((Object)inboundFrame, (Object)new DefaultHttp2HeadersFrame(this.request, true, 31).stream(stream2));
        Assert.assertNull(this.inboundHandler.readInbound());
        this.channel.writeOutbound(new Object[]{new DefaultHttp2HeadersFrame(this.response, true, 27).stream(stream2)});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeHeaders(this.eqFrameCodecCtx(), Mockito.eq((int)1), (Http2Headers)Mockito.eq((Object)this.response), Mockito.eq((int)27), Mockito.eq((boolean)true), Http2TestUtil.anyChannelPromise());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqFrameCodecCtx(), Mockito.anyInt(), Mockito.anyLong(), Http2TestUtil.anyChannelPromise());
        Assert.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream.state());
        Assert.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void flowControlShouldBeResilientToMissingStreams() throws Http2Exception {
        DefaultHttp2Connection conn = new DefaultHttp2Connection(true);
        DefaultHttp2ConnectionEncoder enc = new DefaultHttp2ConnectionEncoder((Http2Connection)conn, (Http2FrameWriter)new DefaultHttp2FrameWriter());
        DefaultHttp2ConnectionDecoder dec = new DefaultHttp2ConnectionDecoder((Http2Connection)conn, (Http2ConnectionEncoder)enc, (Http2FrameReader)new DefaultHttp2FrameReader());
        Http2FrameCodec codec = new Http2FrameCodec((Http2ConnectionEncoder)enc, (Http2ConnectionDecoder)dec, new Http2Settings(), false);
        EmbeddedChannel em = new EmbeddedChannel(new ChannelHandler[]{codec});
        Assert.assertFalse((boolean)codec.consumeBytes(1, 1));
        Assert.assertTrue((boolean)em.finishAndReleaseAll());
    }

    @Test
    public void entityRequestEntityResponse() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(1, this.request, 0, false);
        Http2Stream stream = this.frameCodec.connection().stream(1);
        Assert.assertNotNull((Object)stream);
        Assert.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        Http2HeadersFrame inboundHeaders = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Http2FrameStream stream2 = inboundHeaders.stream();
        Assert.assertNotNull((Object)stream2);
        Assert.assertEquals((long)1L, (long)stream2.id());
        Assert.assertEquals((Object)new DefaultHttp2HeadersFrame(this.request, false).stream(stream2), (Object)inboundHeaders);
        Assert.assertNull(this.inboundHandler.readInbound());
        ByteBuf hello = Http2TestUtil.bb("hello");
        this.frameInboundWriter.writeInboundData(1, hello, 31, true);
        Http2DataFrame inboundData = (Http2DataFrame)this.inboundHandler.readInbound();
        DefaultHttp2DataFrame expected = new DefaultHttp2DataFrame(Http2TestUtil.bb("hello"), true, 31).stream(stream2);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)expected, (Http2Frame)inboundData);
        Assert.assertNull(this.inboundHandler.readInbound());
        this.channel.writeOutbound(new Object[]{new DefaultHttp2HeadersFrame(this.response, false).stream(stream2)});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeHeaders(this.eqFrameCodecCtx(), Mockito.eq((int)1), (Http2Headers)Mockito.eq((Object)this.response), Mockito.eq((int)0), Mockito.eq((boolean)false), Http2TestUtil.anyChannelPromise());
        this.channel.writeOutbound(new Object[]{new DefaultHttp2DataFrame(Http2TestUtil.bb("world"), true, 27).stream(stream2)});
        ArgumentCaptor outboundData = ArgumentCaptor.forClass(ByteBuf.class);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeData(this.eqFrameCodecCtx(), Mockito.eq((int)1), (ByteBuf)outboundData.capture(), Mockito.eq((int)27), Mockito.eq((boolean)true), Http2TestUtil.anyChannelPromise());
        ByteBuf bb = Http2TestUtil.bb("world");
        Assert.assertEquals((Object)bb, (Object)outboundData.getValue());
        Assert.assertEquals((long)1L, (long)((ByteBuf)outboundData.getValue()).refCnt());
        bb.release();
        ((ByteBuf)outboundData.getValue()).release();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqFrameCodecCtx(), Mockito.anyInt(), Mockito.anyLong(), Http2TestUtil.anyChannelPromise());
        Assert.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void sendRstStream() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, true);
        Http2Stream stream = this.frameCodec.connection().stream(3);
        Assert.assertNotNull((Object)stream);
        Assert.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Http2HeadersFrame inboundHeaders = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)inboundHeaders);
        Assert.assertTrue((boolean)inboundHeaders.isEndStream());
        Http2FrameStream stream2 = inboundHeaders.stream();
        Assert.assertNotNull((Object)stream2);
        Assert.assertEquals((long)3L, (long)stream2.id());
        this.channel.writeOutbound(new Object[]{new DefaultHttp2ResetFrame(314L).stream(stream2)});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.eqFrameCodecCtx(), Mockito.eq((int)3), Mockito.eq((long)314L), Http2TestUtil.anyChannelPromise());
        Assert.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream.state());
        Assert.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void receiveRstStream() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(3);
        Assert.assertNotNull((Object)stream);
        Assert.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        DefaultHttp2HeadersFrame expectedHeaders = new DefaultHttp2HeadersFrame(this.request, false, 31);
        Http2HeadersFrame actualHeaders = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assert.assertEquals((Object)expectedHeaders.stream(actualHeaders.stream()), (Object)actualHeaders);
        this.frameInboundWriter.writeInboundRstStream(3, Http2Error.NO_ERROR.code());
        DefaultHttp2ResetFrame expectedRst = new DefaultHttp2ResetFrame(Http2Error.NO_ERROR).stream(actualHeaders.stream());
        Http2ResetFrame actualRst = (Http2ResetFrame)this.inboundHandler.readInbound();
        Assert.assertEquals((Object)expectedRst, (Object)actualRst);
        Assert.assertNull(this.inboundHandler.readInbound());
    }

    @Test
    public void sendGoAway() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(3);
        Assert.assertNotNull((Object)stream);
        Assert.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        ByteBuf debugData = Http2TestUtil.bb("debug");
        ByteBuf expected = debugData.copy();
        DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR.code(), debugData.retainedDuplicate());
        goAwayFrame.setExtraStreamIds(2);
        this.channel.writeOutbound(new Object[]{goAwayFrame});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway(this.eqFrameCodecCtx(), Mockito.eq((int)7), Mockito.eq((long)Http2Error.NO_ERROR.code()), (ByteBuf)Mockito.eq((Object)expected), Http2TestUtil.anyChannelPromise());
        Assert.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        Assert.assertTrue((boolean)this.channel.isActive());
        expected.release();
        debugData.release();
    }

    @Test
    public void receiveGoaway() throws Exception {
        ByteBuf debugData = Http2TestUtil.bb("foo");
        this.frameInboundWriter.writeInboundGoAway(2, Http2Error.NO_ERROR.code(), debugData);
        DefaultHttp2GoAwayFrame expectedFrame = new DefaultHttp2GoAwayFrame(2, Http2Error.NO_ERROR.code(), Http2TestUtil.bb("foo"));
        Http2GoAwayFrame actualFrame = (Http2GoAwayFrame)this.inboundHandler.readInbound();
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)expectedFrame, (Http2Frame)actualFrame);
        Assert.assertNull(this.inboundHandler.readInbound());
    }

    @Test
    public void unknownFrameTypeShouldThrowAndBeReleased() throws Exception {
        class UnknownHttp2Frame
        extends AbstractReferenceCounted
        implements Http2Frame {
            UnknownHttp2Frame() {
            }

            public String name() {
                return "UNKNOWN";
            }

            protected void deallocate() {
            }

            public ReferenceCounted touch(Object hint) {
                return this;
            }
        }
        UnknownHttp2Frame frame = new UnknownHttp2Frame();
        Assert.assertEquals((long)1L, (long)frame.refCnt());
        ChannelFuture f = this.channel.write((Object)frame);
        f.await();
        Assert.assertTrue((boolean)f.isDone());
        Assert.assertFalse((boolean)f.isSuccess());
        Assert.assertThat((Object)f.cause(), (Matcher)Matchers.instanceOf(UnsupportedMessageTypeException.class));
        Assert.assertEquals((long)0L, (long)frame.refCnt());
    }

    @Test
    public void goAwayLastStreamIdOverflowed() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(5, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(5);
        Assert.assertNotNull((Object)stream);
        Assert.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        ByteBuf debugData = Http2TestUtil.bb("debug");
        DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR.code(), debugData.retainedDuplicate());
        goAwayFrame.setExtraStreamIds(Integer.MAX_VALUE);
        this.channel.writeOutbound(new Object[]{goAwayFrame});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway(this.eqFrameCodecCtx(), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((long)Http2Error.NO_ERROR.code()), (ByteBuf)Mockito.eq((Object)debugData), Http2TestUtil.anyChannelPromise());
        debugData.release();
        Assert.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        Assert.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void streamErrorShouldFireExceptionForInbound() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(3);
        Assert.assertNotNull((Object)stream);
        Http2Exception.StreamException streamEx = new Http2Exception.StreamException(3, Http2Error.INTERNAL_ERROR, "foo");
        this.channel.pipeline().fireExceptionCaught((Throwable)streamEx);
        Http2FrameStreamEvent event = (Http2FrameStreamEvent)this.inboundHandler.readInboundMessageOrUserEvent();
        Assert.assertEquals((Object)Http2FrameStreamEvent.Type.State, (Object)event.type());
        Assert.assertEquals((Object)Http2Stream.State.OPEN, (Object)event.stream().state());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)this.inboundHandler.readInboundMessageOrUserEvent();
        Assert.assertNotNull((Object)headersFrame);
        try {
            this.inboundHandler.checkException();
            Assert.fail((String)"stream exception expected");
        }
        catch (Http2FrameStreamException e) {
            Assert.assertEquals((Object)((Object)streamEx), (Object)e.getCause());
        }
        Assert.assertNull(this.inboundHandler.readInboundMessageOrUserEvent());
    }

    @Test
    public void streamErrorShouldNotFireExceptionForOutbound() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(3);
        Assert.assertNotNull((Object)stream);
        Http2Exception.StreamException streamEx = new Http2Exception.StreamException(3, Http2Error.INTERNAL_ERROR, "foo");
        this.frameCodec.onError(this.frameCodec.ctx, true, (Throwable)streamEx);
        Http2FrameStreamEvent event = (Http2FrameStreamEvent)this.inboundHandler.readInboundMessageOrUserEvent();
        Assert.assertEquals((Object)Http2FrameStreamEvent.Type.State, (Object)event.type());
        Assert.assertEquals((Object)Http2Stream.State.OPEN, (Object)event.stream().state());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)this.inboundHandler.readInboundMessageOrUserEvent();
        Assert.assertNotNull((Object)headersFrame);
        this.inboundHandler.checkException();
        Assert.assertNull(this.inboundHandler.readInboundMessageOrUserEvent());
    }

    @Test
    public void windowUpdateFrameDecrementsConsumedBytes() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Connection connection = this.frameCodec.connection();
        Http2Stream stream = connection.stream(3);
        Assert.assertNotNull((Object)stream);
        ByteBuf data = Unpooled.buffer((int)100).writeZero(100);
        this.frameInboundWriter.writeInboundData(3, data, 0, false);
        Http2HeadersFrame inboundHeaders = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)inboundHeaders);
        Assert.assertNotNull((Object)inboundHeaders.stream());
        Http2FrameStream stream2 = inboundHeaders.stream();
        int before = ((Http2LocalFlowController)connection.local().flowController()).unconsumedBytes(stream);
        ChannelFuture f = this.channel.write((Object)new DefaultHttp2WindowUpdateFrame(100).stream(stream2));
        int after = ((Http2LocalFlowController)connection.local().flowController()).unconsumedBytes(stream);
        Assert.assertEquals((long)100L, (long)(before - after));
        Assert.assertTrue((boolean)f.isSuccess());
    }

    @Test
    public void windowUpdateMayFail() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Connection connection = this.frameCodec.connection();
        Http2Stream stream = connection.stream(3);
        Assert.assertNotNull((Object)stream);
        Http2HeadersFrame inboundHeaders = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)inboundHeaders);
        Http2FrameStream stream2 = inboundHeaders.stream();
        ChannelFuture f = this.channel.write((Object)new DefaultHttp2WindowUpdateFrame(100).stream(stream2));
        Assert.assertTrue((boolean)f.isDone());
        Assert.assertFalse((boolean)f.isSuccess());
        Assert.assertThat((Object)f.cause(), (Matcher)Matchers.instanceOf(Http2Exception.class));
    }

    @Test
    public void inboundWindowUpdateShouldBeForwarded() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        this.frameInboundWriter.writeInboundWindowUpdate(3, 100);
        this.frameInboundWriter.writeInboundWindowUpdate(0, 100);
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)headersFrame);
        Http2WindowUpdateFrame windowUpdateFrame = (Http2WindowUpdateFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)windowUpdateFrame);
        Assert.assertEquals((long)3L, (long)windowUpdateFrame.stream().id());
        Assert.assertEquals((long)100L, (long)windowUpdateFrame.windowSizeIncrement());
        Assert.assertNull(this.inboundHandler.readInbound());
    }

    @Test
    public void streamZeroWindowUpdateIncrementsConnectionWindow() throws Http2Exception {
        Http2Connection connection = this.frameCodec.connection();
        Http2LocalFlowController localFlow = (Http2LocalFlowController)connection.local().flowController();
        int initialWindowSizeBefore = localFlow.initialWindowSize();
        Http2Stream connectionStream = connection.connectionStream();
        int connectionWindowSizeBefore = localFlow.windowSize(connectionStream);
        ((DefaultHttp2LocalFlowController)localFlow).windowUpdateRatio(connectionStream, 0.999f);
        int windowUpdate = 1024;
        this.channel.write((Object)new DefaultHttp2WindowUpdateFrame(windowUpdate));
        Assert.assertEquals((long)initialWindowSizeBefore, (long)localFlow.initialWindowSize());
        Assert.assertEquals((long)(connectionWindowSizeBefore + windowUpdate), (long)localFlow.windowSize(connectionStream));
    }

    @Test
    public void windowUpdateDoesNotOverflowConnectionWindow() {
        Http2Connection connection = this.frameCodec.connection();
        Http2LocalFlowController localFlow = (Http2LocalFlowController)connection.local().flowController();
        int initialWindowSizeBefore = localFlow.initialWindowSize();
        this.channel.write((Object)new DefaultHttp2WindowUpdateFrame(Integer.MAX_VALUE));
        Assert.assertEquals((long)initialWindowSizeBefore, (long)localFlow.initialWindowSize());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)localFlow.windowSize(connection.connectionStream()));
    }

    @Test
    public void writeUnknownFrame() {
        Http2FrameCodec.DefaultHttp2FrameStream stream = this.frameCodec.newStream();
        ByteBuf buffer = Unpooled.buffer().writeByte(1);
        DefaultHttp2UnknownFrame unknownFrame = new DefaultHttp2UnknownFrame(20, new Http2Flags().ack(true), buffer);
        unknownFrame.stream((Http2FrameStream)stream);
        this.channel.write((Object)unknownFrame);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeFrame(this.eqFrameCodecCtx(), Mockito.eq((byte)unknownFrame.frameType()), Mockito.eq((int)unknownFrame.stream().id()), (Http2Flags)Mockito.eq((Object)unknownFrame.flags()), (ByteBuf)Mockito.eq((Object)buffer), (ChannelPromise)Mockito.any(ChannelPromise.class));
    }

    @Test
    public void sendSettingsFrame() {
        Http2Settings settings = new Http2Settings();
        this.channel.write((Object)new DefaultHttp2SettingsFrame(settings));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettings(this.eqFrameCodecCtx(), (Http2Settings)Mockito.same((Object)settings), (ChannelPromise)Mockito.any(ChannelPromise.class));
    }

    @Test(timeout=5000L)
    public void newOutboundStream() {
        Http2FrameCodec.DefaultHttp2FrameStream stream = this.frameCodec.newStream();
        Assert.assertNotNull((Object)stream);
        Assert.assertFalse((boolean)Http2CodecUtil.isStreamIdValid((int)stream.id()));
        DefaultPromise listenerExecuted = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), false).stream((Http2FrameStream)stream)).addListener((GenericFutureListener)new ChannelFutureListener((Http2FrameStream)stream, (Promise)listenerExecuted){
            final /* synthetic */ Http2FrameStream val$stream;
            final /* synthetic */ Promise val$listenerExecuted;
            {
                this.val$stream = http2FrameStream;
                this.val$listenerExecuted = promise;
            }

            public void operationComplete(ChannelFuture future) throws Exception {
                Assert.assertTrue((boolean)future.isSuccess());
                Assert.assertTrue((boolean)Http2CodecUtil.isStreamIdValid((int)this.val$stream.id()));
                this.val$listenerExecuted.setSuccess(null);
            }
        });
        ByteBuf data = Unpooled.buffer().writeZero(100);
        ChannelFuture f = this.channel.writeAndFlush((Object)new DefaultHttp2DataFrame(data).stream((Http2FrameStream)stream));
        Assert.assertTrue((boolean)f.isSuccess());
        listenerExecuted.syncUninterruptibly();
        Assert.assertTrue((boolean)listenerExecuted.isSuccess());
    }

    @Test
    public void newOutboundStreamsShouldBeBuffered() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer().encoderEnforceMaxConcurrentStreams(true), new Http2Settings().maxConcurrentStreams(1L));
        Http2FrameCodec.DefaultHttp2FrameStream stream1 = this.frameCodec.newStream();
        Http2FrameCodec.DefaultHttp2FrameStream stream2 = this.frameCodec.newStream();
        ChannelPromise promise1 = this.channel.newPromise();
        ChannelPromise promise2 = this.channel.newPromise();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream1), promise1);
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream2), promise2);
        Assert.assertTrue((boolean)Http2CodecUtil.isStreamIdValid((int)stream1.id()));
        this.channel.runPendingTasks();
        Assert.assertTrue((boolean)Http2CodecUtil.isStreamIdValid((int)stream2.id()));
        Assert.assertTrue((boolean)promise1.syncUninterruptibly().isSuccess());
        Assert.assertFalse((boolean)promise2.isDone());
        this.frameInboundWriter.writeInboundSettings(new Http2Settings().maxConcurrentStreams(2L));
        this.channel.flush();
        Assert.assertTrue((boolean)promise2.syncUninterruptibly().isSuccess());
    }

    @Test
    public void multipleNewOutboundStreamsShouldBeBuffered() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer().encoderEnforceMaxConcurrentStreams(true), new Http2Settings().maxConcurrentStreams(1L));
        Http2FrameCodec.DefaultHttp2FrameStream stream1 = this.frameCodec.newStream();
        Http2FrameCodec.DefaultHttp2FrameStream stream2 = this.frameCodec.newStream();
        Http2FrameCodec.DefaultHttp2FrameStream stream3 = this.frameCodec.newStream();
        ChannelPromise promise1 = this.channel.newPromise();
        ChannelPromise promise2 = this.channel.newPromise();
        ChannelPromise promise3 = this.channel.newPromise();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream1), promise1);
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream2), promise2);
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream3), promise3);
        Assert.assertTrue((boolean)Http2CodecUtil.isStreamIdValid((int)stream1.id()));
        this.channel.runPendingTasks();
        Assert.assertTrue((boolean)Http2CodecUtil.isStreamIdValid((int)stream2.id()));
        Assert.assertTrue((boolean)promise1.syncUninterruptibly().isSuccess());
        Assert.assertFalse((boolean)promise2.isDone());
        Assert.assertFalse((boolean)promise3.isDone());
        this.frameInboundWriter.writeInboundSettings(new Http2Settings().maxConcurrentStreams(2L));
        this.channel.flush();
        Assert.assertTrue((boolean)promise2.syncUninterruptibly().isSuccess());
        Assert.assertFalse((boolean)promise3.isDone());
        this.frameInboundWriter.writeInboundSettings(new Http2Settings().maxConcurrentStreams(3L));
        this.channel.flush();
        Assert.assertTrue((boolean)promise3.syncUninterruptibly().isSuccess());
        Assert.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @Test
    public void doNotLeakOnFailedInitializationForChannels() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer(), new Http2Settings().maxConcurrentStreams(2L));
        Http2FrameCodec.DefaultHttp2FrameStream stream1 = this.frameCodec.newStream();
        Http2FrameCodec.DefaultHttp2FrameStream stream2 = this.frameCodec.newStream();
        ChannelPromise stream1HeaderPromise = this.channel.newPromise();
        ChannelPromise stream2HeaderPromise = this.channel.newPromise();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream1), stream1HeaderPromise);
        this.channel.runPendingTasks();
        this.frameInboundWriter.writeInboundGoAway(stream1.id(), 0L, Unpooled.EMPTY_BUFFER);
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream2), stream2HeaderPromise);
        this.channel.runPendingTasks();
        Assert.assertTrue((boolean)stream1HeaderPromise.syncUninterruptibly().isSuccess());
        Assert.assertTrue((boolean)stream2HeaderPromise.isDone());
        Assert.assertEquals((long)0L, (long)this.frameCodec.numInitializingStreams());
        Assert.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @Test
    public void streamIdentifiersExhausted() throws Http2Exception {
        int maxServerStreamId = 0x7FFFFFFE;
        Assert.assertNotNull((Object)this.frameCodec.connection().local().createStream(maxServerStreamId, false));
        Http2FrameCodec.DefaultHttp2FrameStream stream = this.frameCodec.newStream();
        Assert.assertNotNull((Object)stream);
        ChannelPromise writePromise = this.channel.newPromise();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream), writePromise);
        Http2GoAwayFrame goAwayFrame = (Http2GoAwayFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)goAwayFrame);
        Assert.assertEquals((long)Http2Error.NO_ERROR.code(), (long)goAwayFrame.errorCode());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)goAwayFrame.lastStreamId());
        goAwayFrame.release();
        Assert.assertThat((Object)writePromise.cause(), (Matcher)Matchers.instanceOf(Http2NoMoreStreamIdsException.class));
    }

    @Test
    public void receivePing() throws Http2Exception {
        this.frameInboundWriter.writeInboundPing(false, 12345L);
        Http2PingFrame pingFrame = (Http2PingFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)pingFrame);
        Assert.assertEquals((long)12345L, (long)pingFrame.content());
        Assert.assertFalse((boolean)pingFrame.ack());
    }

    @Test
    public void sendPing() {
        this.channel.writeAndFlush((Object)new DefaultHttp2PingFrame(12345L));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writePing(this.eqFrameCodecCtx(), Mockito.eq((boolean)false), Mockito.eq((long)12345L), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void receiveSettings() throws Http2Exception {
        Http2Settings settings = new Http2Settings().maxConcurrentStreams(1L);
        this.frameInboundWriter.writeInboundSettings(settings);
        Http2SettingsFrame settingsFrame = (Http2SettingsFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)settingsFrame);
        Assert.assertEquals((Object)settings, (Object)settingsFrame.settings());
    }

    @Test
    public void sendSettings() {
        Http2Settings settings = new Http2Settings().maxConcurrentStreams(1L);
        this.channel.writeAndFlush((Object)new DefaultHttp2SettingsFrame(settings));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettings(this.eqFrameCodecCtx(), (Http2Settings)Mockito.eq((Object)settings), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void iterateActiveStreams() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer().encoderEnforceMaxConcurrentStreams(true), new Http2Settings().maxConcurrentStreams(1L));
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 0, false);
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assert.assertNotNull((Object)headersFrame);
        Http2FrameStream activeInbond = headersFrame.stream();
        Http2FrameCodec.DefaultHttp2FrameStream activeOutbound = this.frameCodec.newStream();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)activeOutbound));
        Http2FrameCodec.DefaultHttp2FrameStream bufferedOutbound = this.frameCodec.newStream();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)bufferedOutbound));
        Http2FrameCodec.DefaultHttp2FrameStream idleStream = this.frameCodec.newStream();
        final HashSet activeStreams = new HashSet();
        this.frameCodec.forEachActiveStream(new Http2FrameStreamVisitor(){

            public boolean visit(Http2FrameStream stream) {
                activeStreams.add(stream);
                return true;
            }
        });
        Assert.assertEquals((long)2L, (long)activeStreams.size());
        HashSet<Object> expectedStreams = new HashSet<Object>();
        expectedStreams.add(activeInbond);
        expectedStreams.add(activeOutbound);
        Assert.assertEquals(expectedStreams, activeStreams);
    }

    @Test
    public void autoAckPingTrue() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer().autoAckPingFrame(true), new Http2Settings());
        this.frameInboundWriter.writeInboundPing(false, 8L);
        Http2PingFrame frame = (Http2PingFrame)this.inboundHandler.readInbound();
        Assert.assertFalse((boolean)frame.ack());
        Assert.assertEquals((long)8L, (long)frame.content());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writePing(this.eqFrameCodecCtx(), Mockito.eq((boolean)true), Mockito.eq((long)8L), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void autoAckPingFalse() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer().autoAckPingFrame(false), new Http2Settings());
        this.frameInboundWriter.writeInboundPing(false, 8L);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writePing(this.eqFrameCodecCtx(), Mockito.eq((boolean)true), Mockito.eq((long)8L), Http2TestUtil.anyChannelPromise());
        Http2PingFrame frame = (Http2PingFrame)this.inboundHandler.readInbound();
        Assert.assertFalse((boolean)frame.ack());
        Assert.assertEquals((long)8L, (long)frame.content());
        this.channel.writeAndFlush((Object)new DefaultHttp2PingFrame(8L, true));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writePing(this.eqFrameCodecCtx(), Mockito.eq((boolean)true), Mockito.eq((long)8L), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void streamShouldBeOpenInListener() {
        Http2FrameCodec.DefaultHttp2FrameStream stream2 = this.frameCodec.newStream();
        Assert.assertEquals((Object)Http2Stream.State.IDLE, (Object)stream2.state());
        AtomicBoolean listenerExecuted = new AtomicBoolean();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream2)).addListener((GenericFutureListener)new ChannelFutureListener((Http2FrameStream)stream2, listenerExecuted){
            final /* synthetic */ Http2FrameStream val$stream2;
            final /* synthetic */ AtomicBoolean val$listenerExecuted;
            {
                this.val$stream2 = http2FrameStream;
                this.val$listenerExecuted = atomicBoolean;
            }

            public void operationComplete(ChannelFuture future) throws Exception {
                Assert.assertTrue((boolean)future.isSuccess());
                Assert.assertEquals((Object)Http2Stream.State.OPEN, (Object)this.val$stream2.state());
                this.val$listenerExecuted.set(true);
            }
        });
        Assert.assertTrue((boolean)listenerExecuted.get());
    }

    @Test
    public void upgradeEventNoRefCntError() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(1, this.request, 31, false);
        Constructor constructor = HttpServerUpgradeHandler.UpgradeEvent.class.getDeclaredConstructor(CharSequence.class, FullHttpRequest.class);
        Assume.assumeTrue((ReflectionUtil.trySetAccessible(constructor, (boolean)true) == null ? 1 : 0) != 0);
        HttpServerUpgradeHandler.UpgradeEvent upgradeEvent = (HttpServerUpgradeHandler.UpgradeEvent)constructor.newInstance("HTTP/2", new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/"));
        this.channel.pipeline().fireUserEventTriggered((Object)upgradeEvent);
        Assert.assertEquals((long)1L, (long)upgradeEvent.refCnt());
    }

    @Test
    public void upgradeWithoutFlowControlling() throws Exception {
        this.channel.pipeline().addAfter(this.frameCodec.ctx.name(), null, (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof Http2DataFrame) {
                    Http2DataFrame data = (Http2DataFrame)msg;
                    ctx.writeAndFlush((Object)new DefaultHttp2WindowUpdateFrame(data.initialFlowControlledBytes()).stream(data.stream())).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            Throwable cause = future.cause();
                            if (cause != null) {
                                ctx.fireExceptionCaught(cause);
                            }
                        }
                    });
                }
                ReferenceCountUtil.release((Object)msg);
            }
        });
        this.frameInboundWriter.writeInboundHeaders(1, this.request, 31, false);
        Constructor constructor = HttpServerUpgradeHandler.UpgradeEvent.class.getDeclaredConstructor(CharSequence.class, FullHttpRequest.class);
        Assume.assumeTrue((ReflectionUtil.trySetAccessible(constructor, (boolean)true) == null ? 1 : 0) != 0);
        String longString = new String(new char[70000]).replace("\u0000", "*");
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/", Http2TestUtil.bb(longString));
        HttpServerUpgradeHandler.UpgradeEvent upgradeEvent = (HttpServerUpgradeHandler.UpgradeEvent)constructor.newInstance("HTTP/2", request);
        this.channel.pipeline().fireUserEventTriggered((Object)upgradeEvent);
    }

    private ChannelHandlerContext eqFrameCodecCtx() {
        return (ChannelHandlerContext)Mockito.eq((Object)this.frameCodec.ctx);
    }
}

