/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.DefaultChannelId;
import io.netty.channel.ServerChannel;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameInboundWriter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class Http2ServerUpgradeCodecTest {
    @Test
    public void testUpgradeToHttp2ConnectionHandler() {
        Http2ServerUpgradeCodecTest.testUpgrade(new Http2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new Http2FrameAdapter()).build(), null);
    }

    @Test
    public void testUpgradeToHttp2FrameCodec() {
        Http2ServerUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)new Http2FrameCodecBuilder(true).build(), null);
    }

    @Test
    public void testUpgradeToHttp2MultiplexCodec() {
        Http2ServerUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)new Http2MultiplexCodecBuilder(true, (ChannelHandler)new HttpInboundHandler()).build(), null);
    }

    @Test
    public void testUpgradeToHttp2FrameCodecWithMultiplexer() {
        Http2ServerUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)new Http2FrameCodecBuilder(true).build(), (ChannelHandler)new Http2MultiplexHandler((ChannelHandler)new HttpInboundHandler()));
    }

    private static void testUpgrade(Http2ConnectionHandler handler, ChannelHandler multiplexer) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.OPTIONS, "*");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"netty.io");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Upgrade, HTTP2-Settings");
        request.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)"h2c");
        request.headers().set("HTTP2-Settings", (Object)"AAMAAABkAAQAAP__");
        ServerChannel parent = (ServerChannel)Mockito.mock(ServerChannel.class);
        EmbeddedChannel channel = new EmbeddedChannel((Channel)parent, (ChannelId)DefaultChannelId.newInstance(), true, false, new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
        ChannelHandlerContext ctx = channel.pipeline().firstContext();
        Http2ServerUpgradeCodec codec = multiplexer == null ? new Http2ServerUpgradeCodec(handler) : new Http2ServerUpgradeCodec((Http2FrameCodec)handler, new ChannelHandler[]{multiplexer});
        Assert.assertTrue((boolean)codec.prepareUpgradeResponse(ctx, (FullHttpRequest)request, (HttpHeaders)new DefaultHttpHeaders()));
        codec.upgradeTo(ctx, (FullHttpRequest)request);
        channel.flush();
        channel.writeInbound(new Object[]{Http2CodecUtil.connectionPrefaceBuf()});
        Http2FrameInboundWriter writer = new Http2FrameInboundWriter(channel);
        writer.writeInboundSettings(new Http2Settings());
        writer.writeInboundRstStream(1, Http2Error.CANCEL.code());
        Assert.assertSame((Object)handler, (Object)channel.pipeline().remove(handler.getClass()));
        Assert.assertNull((Object)channel.pipeline().get(handler.getClass()));
        Assert.assertTrue((boolean)channel.finish());
        ByteBuf settingsBuffer = (ByteBuf)channel.readOutbound();
        Assert.assertNotNull((Object)settingsBuffer);
        settingsBuffer.release();
        ByteBuf buf = (ByteBuf)channel.readOutbound();
        Assert.assertNotNull((Object)buf);
        buf.release();
        Assert.assertNull((Object)channel.readOutbound());
    }

    @ChannelHandler.Sharable
    private static final class HttpInboundHandler
    extends ChannelInboundHandlerAdapter {
        private HttpInboundHandler() {
        }
    }
}

