/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.util.CharsetUtil;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class DefaultHttp2ConnectionDecoderTest {
    private static final int STREAM_ID = 3;
    private static final int PUSH_STREAM_ID = 2;
    private static final int STREAM_DEPENDENCY_ID = 5;
    private static final int STATE_RECV_HEADERS = 1;
    private static final int STATE_RECV_TRAILERS = 2;
    private Http2ConnectionDecoder decoder;
    private ChannelPromise promise;
    @Mock
    private Http2Connection connection;
    @Mock
    private Http2Connection.Endpoint<Http2RemoteFlowController> remote;
    @Mock
    private Http2Connection.Endpoint<Http2LocalFlowController> local;
    @Mock
    private Http2LocalFlowController localFlow;
    @Mock
    private Http2RemoteFlowController remoteFlow;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private Channel channel;
    @Mock
    private ChannelFuture future;
    @Mock
    private Http2Stream stream;
    @Mock
    private Http2Stream pushStream;
    @Mock
    private Http2FrameListener listener;
    @Mock
    private Http2FrameReader reader;
    @Mock
    private Http2FrameWriter writer;
    @Mock
    private Http2ConnectionEncoder encoder;
    @Mock
    private Http2LifecycleManager lifecycleManager;

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.promise = new DefaultChannelPromise(this.channel);
        final AtomicInteger headersReceivedState = new AtomicInteger();
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.stream.id()).thenReturn((Object)3);
        Mockito.when((Object)this.stream.state()).thenReturn((Object)Http2Stream.State.OPEN);
        Mockito.when((Object)this.stream.open(Mockito.anyBoolean())).thenReturn((Object)this.stream);
        final IdentityHashMap properties = new IdentityHashMap();
        Mockito.when((Object)this.stream.getProperty((Http2Connection.PropertyKey)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) {
                return properties.get(invocationOnMock.getArgument(0));
            }
        });
        Mockito.when((Object)this.stream.setProperty((Http2Connection.PropertyKey)ArgumentMatchers.any(), Mockito.any())).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) {
                return properties.put(invocationOnMock.getArgument(0), invocationOnMock.getArgument(1));
            }
        });
        Mockito.when((Object)this.pushStream.id()).thenReturn((Object)2);
        ((Http2Stream)Mockito.doAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock in) throws Throwable {
                return (headersReceivedState.get() & 1) != 0;
            }
        }).when((Object)this.stream)).isHeadersReceived();
        ((Http2Stream)Mockito.doAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock in) throws Throwable {
                return (headersReceivedState.get() & 2) != 0;
            }
        }).when((Object)this.stream)).isTrailersReceived();
        ((Http2Stream)Mockito.doAnswer((Answer)new Answer<Http2Stream>(){

            public Http2Stream answer(InvocationOnMock in) throws Throwable {
                int next;
                int current;
                boolean isInformational = (Boolean)in.getArgument(0);
                if (isInformational) {
                    return DefaultHttp2ConnectionDecoderTest.this.stream;
                }
                do {
                    next = current = headersReceivedState.get();
                    if ((current & 1) != 0) {
                        if ((current & 2) != 0) {
                            throw new IllegalStateException("already sent headers!");
                        }
                        next |= 2;
                        continue;
                    }
                    next |= 1;
                } while (!headersReceivedState.compareAndSet(current, next));
                return DefaultHttp2ConnectionDecoderTest.this.stream;
            }
        }).when((Object)this.stream)).headersReceived(Mockito.anyBoolean());
        ((Http2Connection)Mockito.doAnswer((Answer)new Answer<Http2Stream>(){

            public Http2Stream answer(InvocationOnMock in) throws Throwable {
                Http2StreamVisitor visitor = (Http2StreamVisitor)in.getArgument(0);
                if (!visitor.visit(DefaultHttp2ConnectionDecoderTest.this.stream)) {
                    return DefaultHttp2ConnectionDecoderTest.this.stream;
                }
                return null;
            }
        }).when((Object)this.connection)).forEachActiveStream((Http2StreamVisitor)Mockito.any(Http2StreamVisitor.class));
        Mockito.when((Object)this.connection.stream(3)).thenReturn((Object)this.stream);
        Mockito.when((Object)this.connection.streamMayHaveExisted(3)).thenReturn((Object)true);
        Mockito.when((Object)this.connection.local()).thenReturn(this.local);
        Mockito.when((Object)this.local.flowController()).thenReturn((Object)this.localFlow);
        Mockito.when((Object)this.encoder.flowController()).thenReturn((Object)this.remoteFlow);
        Mockito.when((Object)this.encoder.frameWriter()).thenReturn((Object)this.writer);
        Mockito.when((Object)this.connection.remote()).thenReturn(this.remote);
        Mockito.when((Object)this.local.reservePushStream(Mockito.eq((int)2), (Http2Stream)Mockito.eq((Object)this.stream))).thenReturn((Object)this.pushStream);
        Mockito.when((Object)this.remote.reservePushStream(Mockito.eq((int)2), (Http2Stream)Mockito.eq((Object)this.stream))).thenReturn((Object)this.pushStream);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.ctx.newSucceededFuture()).thenReturn((Object)this.future);
        Mockito.when((Object)this.ctx.newPromise()).thenReturn((Object)this.promise);
        Mockito.when((Object)this.ctx.write(Mockito.any())).thenReturn((Object)this.future);
        this.decoder = new DefaultHttp2ConnectionDecoder(this.connection, this.encoder, this.reader);
        this.decoder.lifecycleManager(this.lifecycleManager);
        this.decoder.frameListener(this.listener);
        this.decode().onSettingsRead(this.ctx, new Http2Settings());
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onSettingsRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (Http2Settings)Mockito.eq((Object)new Http2Settings()));
        Assertions.assertTrue((boolean)this.decoder.prefaceReceived());
        ((Http2ConnectionEncoder)Mockito.verify((Object)this.encoder)).writeSettingsAck((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (ChannelPromise)Mockito.eq((Object)this.promise));
        this.decode().onSettingsAckRead(this.ctx);
        Mockito.when((Object)this.ctx.flush()).then((Answer)new Answer<ChannelHandlerContext>(){

            public ChannelHandlerContext answer(InvocationOnMock invocationOnMock) {
                Assertions.fail();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataReadAfterGoAwaySentShouldApplyFlowControl() throws Exception {
        this.mockGoAwaySent();
        ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        int padding = 10;
        int processedBytes = data.readableBytes() + padding;
        this.mockFlowControl(processedBytes);
        try {
            this.decode().onDataRead(this.ctx, 3, data, padding, true);
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)this.stream), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)padding), Mockito.eq((boolean)true));
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).consumeBytes((Http2Stream)Mockito.eq((Object)this.stream), Mockito.eq((int)processedBytes));
            ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataReadAfterGoAwaySentShouldAllowFramesForStreamCreatedByLocalEndpoint() throws Exception {
        this.mockGoAwaySentShouldAllowFramesForStreamCreatedByLocalEndpoint();
        ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        int padding = 10;
        int processedBytes = data.readableBytes() + padding;
        this.mockFlowControl(processedBytes);
        try {
            this.decode().onDataRead(this.ctx, 3, data, padding, true);
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)this.stream), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)padding), Mockito.eq((boolean)true));
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).consumeBytes((Http2Stream)Mockito.eq((Object)this.stream), Mockito.eq((int)processedBytes));
            ((Http2FrameListener)Mockito.verify((Object)this.listener)).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataReadForUnknownStreamShouldApplyFlowControlAndFail() throws Exception {
        Mockito.when((Object)this.connection.streamMayHaveExisted(3)).thenReturn((Object)true);
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        final ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        int padding = 10;
        int processedBytes = data.readableBytes() + 10;
        Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onDataRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, data, 10, true);
            }
        });
        try {
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)null), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).consumeBytes((Http2Stream)Mockito.eq((Object)null), Mockito.eq((int)processedBytes));
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).frameWriter((Http2FrameWriter)Mockito.any(Http2FrameWriter.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.localFlow});
            ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataReadForUnknownStreamThatCouldntExistFail() throws Exception {
        Mockito.when((Object)this.connection.streamMayHaveExisted(3)).thenReturn((Object)false);
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        final ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        int padding = 10;
        int processedBytes = data.readableBytes() + 10;
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                try {
                    DefaultHttp2ConnectionDecoderTest.this.decode().onDataRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, data, 10, true);
                }
                catch (Http2Exception ex) {
                    MatcherAssert.assertThat((Object)((Object)ex), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(Http2Exception.StreamException.class)));
                    throw ex;
                }
            }
        });
        try {
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)null), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).consumeBytes((Http2Stream)Mockito.eq((Object)null), Mockito.eq((int)processedBytes));
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).frameWriter((Http2FrameWriter)Mockito.any(Http2FrameWriter.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.localFlow});
            ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dataReadForUnknownStreamShouldApplyFlowControl() throws Exception {
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        final ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        int padding = 10;
        int processedBytes = data.readableBytes() + 10;
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2ConnectionDecoderTest.this.decode().onDataRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, data, 10, true);
                }
            });
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)null), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).consumeBytes((Http2Stream)Mockito.eq((Object)null), Mockito.eq((int)processedBytes));
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).frameWriter((Http2FrameWriter)Mockito.any(Http2FrameWriter.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.localFlow});
            ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        }
        finally {
            data.release();
        }
    }

    @Test
    public void emptyDataFrameShouldApplyFlowControl() throws Exception {
        ByteBuf data = Unpooled.EMPTY_BUFFER;
        int padding = 0;
        this.mockFlowControl(0);
        try {
            this.decode().onDataRead(this.ctx, 3, data, padding, true);
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)this.stream), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)padding), Mockito.eq((boolean)true));
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).consumeBytes((Http2Stream)Mockito.eq((Object)this.stream), Mockito.eq((int)0));
            ((Http2FrameListener)Mockito.verify((Object)this.listener)).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)padding), Mockito.eq((boolean)true));
        }
        finally {
            data.release();
        }
    }

    @Test
    public void dataReadForStreamInInvalidStateShouldThrow() throws Exception {
        Mockito.when((Object)this.stream.state()).thenReturn((Object)Http2Stream.State.CLOSED);
        final ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onDataRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, data, 10, true);
            }
        });
        data.release();
    }

    @Test
    public void dataReadAfterGoAwaySentForStreamInInvalidStateShouldIgnore() throws Exception {
        Mockito.when((Object)this.stream.state()).thenReturn((Object)Http2Stream.State.CLOSED);
        this.mockGoAwaySent();
        ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        try {
            this.decode().onDataRead(this.ctx, 3, data, 10, true);
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)this.stream), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
            ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        }
        finally {
            data.release();
        }
    }

    @Test
    public void dataReadAfterGoAwaySentOnUnknownStreamShouldIgnore() throws Exception {
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        this.mockGoAwaySent();
        ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        try {
            this.decode().onDataRead(this.ctx, 3, data, 10, true);
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.isNull(), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
            ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        }
        finally {
            data.release();
        }
    }

    @Test
    public void dataReadAfterRstStreamForStreamInInvalidStateShouldIgnore() throws Exception {
        Mockito.when((Object)this.stream.state()).thenReturn((Object)Http2Stream.State.CLOSED);
        Mockito.when((Object)this.stream.isResetSent()).thenReturn((Object)true);
        ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        try {
            this.decode().onDataRead(this.ctx, 3, data, 10, true);
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)this.stream), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
            ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        }
        finally {
            data.release();
        }
    }

    @Test
    public void dataReadWithEndOfStreamShouldcloseStreamRemote() throws Exception {
        ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        try {
            this.decode().onDataRead(this.ctx, 3, data, 10, true);
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)this.stream), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
            ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager)).closeStreamRemote((Http2Stream)Mockito.eq((Object)this.stream), (ChannelFuture)Mockito.eq((Object)this.future));
            ((Http2FrameListener)Mockito.verify((Object)this.listener)).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
        }
        finally {
            data.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void errorDuringDeliveryShouldReturnCorrectNumberOfBytes() throws Exception {
        final ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        int padding = 10;
        final AtomicInteger unprocessed = new AtomicInteger(data.readableBytes() + 10);
        ((Http2LocalFlowController)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock in) throws Throwable {
                return unprocessed.get();
            }
        }).when((Object)this.localFlow)).unconsumedBytes((Http2Stream)Mockito.eq((Object)this.stream));
        ((Http2LocalFlowController)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock in) throws Throwable {
                int delta = (Integer)in.getArguments()[1];
                int newValue = unprocessed.addAndGet(-delta);
                if (newValue < 0) {
                    throw new RuntimeException("Returned too many bytes");
                }
                return null;
            }
        }).when((Object)this.localFlow)).consumeBytes((Http2Stream)Mockito.eq((Object)this.stream), Mockito.anyInt());
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock in) throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.localFlow.consumeBytes(DefaultHttp2ConnectionDecoderTest.this.stream, 4);
                throw new RuntimeException("Fake Exception");
            }
        }).when((Object)this.listener)).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)10), Mockito.eq((boolean)true));
        try {
            Assertions.assertThrows(RuntimeException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2ConnectionDecoderTest.this.decode().onDataRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, data, 10, true);
                }
            });
            ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)this.stream), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
            ((Http2FrameListener)Mockito.verify((Object)this.listener)).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
            Assertions.assertEquals((int)0, (int)this.localFlow.unconsumedBytes(this.stream));
        }
        finally {
            data.release();
        }
    }

    @Test
    public void headersReadForUnknownStreamShouldThrow() throws Exception {
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onHeadersRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false);
            }
        });
    }

    @Test
    public void headersReadForStreamThatAlreadySentResetShouldBeIgnored() throws Exception {
        Mockito.when((Object)this.stream.isResetSent()).thenReturn((Object)true);
        this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false);
        ((Http2Connection.Endpoint)Mockito.verify(this.remote, (VerificationMode)Mockito.never())).createStream(Mockito.anyInt(), Mockito.anyBoolean());
        ((Http2Stream)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.never())).open(Mockito.anyBoolean());
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyBoolean());
        ((Http2Connection.Endpoint)Mockito.verify(this.remote, (VerificationMode)Mockito.never())).createStream(Mockito.anyInt(), Mockito.anyBoolean());
        ((Http2Stream)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.never())).open(Mockito.anyBoolean());
    }

    @Test
    public void headersReadForUnknownStreamAfterGoAwayShouldBeIgnored() throws Exception {
        this.mockGoAwaySent();
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false);
        ((Http2Connection.Endpoint)Mockito.verify(this.remote, (VerificationMode)Mockito.never())).createStream(Mockito.anyInt(), Mockito.anyBoolean());
        ((Http2Stream)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.never())).open(Mockito.anyBoolean());
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyBoolean());
        ((Http2Connection.Endpoint)Mockito.verify(this.remote, (VerificationMode)Mockito.never())).createStream(Mockito.anyInt(), Mockito.anyBoolean());
        ((Http2Stream)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.never())).open(Mockito.anyBoolean());
    }

    @Test
    public void headersReadForUnknownStreamShouldCreateStream() throws Exception {
        int streamId = 5;
        Mockito.when((Object)this.remote.createStream(Mockito.eq((int)5), Mockito.anyBoolean())).thenReturn((Object)this.stream);
        this.decode().onHeadersRead(this.ctx, 5, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false);
        ((Http2Connection.Endpoint)Mockito.verify(this.remote)).createStream(Mockito.eq((int)5), Mockito.eq((boolean)false));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)5), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)false));
    }

    @Test
    public void headersReadForUnknownStreamShouldCreateHalfClosedStream() throws Exception {
        int streamId = 5;
        Mockito.when((Object)this.remote.createStream(Mockito.eq((int)5), Mockito.anyBoolean())).thenReturn((Object)this.stream);
        this.decode().onHeadersRead(this.ctx, 5, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true);
        ((Http2Connection.Endpoint)Mockito.verify(this.remote)).createStream(Mockito.eq((int)5), Mockito.eq((boolean)true));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)5), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void headersReadForPromisedStreamShouldHalfOpenStream() throws Exception {
        Mockito.when((Object)this.stream.state()).thenReturn((Object)Http2Stream.State.RESERVED_REMOTE);
        this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false);
        ((Http2Stream)Mockito.verify((Object)this.stream)).open(false);
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)false));
    }

    @Test
    public void trailersDoNotEndStreamThrows() throws Exception {
        this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onHeadersRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false);
            }
        });
    }

    @Test
    public void tooManyHeadersEOSThrows() throws Exception {
        this.tooManyHeaderThrows(true);
    }

    @Test
    public void tooManyHeadersNoEOSThrows() throws Exception {
        this.tooManyHeaderThrows(false);
    }

    private void tooManyHeaderThrows(final boolean eos) throws Exception {
        this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false);
        this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onHeadersRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, eos);
            }
        });
    }

    private static Http2Headers informationalHeaders() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.status((CharSequence)HttpResponseStatus.CONTINUE.codeAsText());
        return headers;
    }

    @Test
    public void infoHeadersAndTrailersAllowed() throws Exception {
        this.infoHeadersAndTrailersAllowed(true, 1);
    }

    @Test
    public void multipleInfoHeadersAndTrailersAllowed() throws Exception {
        this.infoHeadersAndTrailersAllowed(true, 10);
    }

    @Test
    public void infoHeadersAndTrailersNoEOSThrows() throws Exception {
        this.infoHeadersAndTrailersAllowed(false, 1);
    }

    @Test
    public void multipleInfoHeadersAndTrailersNoEOSThrows() throws Exception {
        this.infoHeadersAndTrailersAllowed(false, 10);
    }

    private void infoHeadersAndTrailersAllowed(final boolean eos, int infoHeaderCount) throws Exception {
        for (int i = 0; i < infoHeaderCount; ++i) {
            this.decode().onHeadersRead(this.ctx, 3, DefaultHttp2ConnectionDecoderTest.informationalHeaders(), 0, false);
        }
        this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false);
        if (eos) {
            this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, eos);
        } else {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2ConnectionDecoderTest.this.decode().onHeadersRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, eos);
                }
            });
        }
    }

    @Test
    public void headersReadForPromisedStreamShouldCloseStream() throws Exception {
        Mockito.when((Object)this.stream.state()).thenReturn((Object)Http2Stream.State.RESERVED_REMOTE);
        this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, true);
        ((Http2Stream)Mockito.verify((Object)this.stream)).open(true);
        ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager)).closeStreamRemote((Http2Stream)Mockito.eq((Object)this.stream), (ChannelFuture)Mockito.eq((Object)this.future));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void headersDependencyNotCreatedShouldCreateAndSucceed() throws Exception {
        boolean weight = true;
        this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)EmptyHttp2Headers.INSTANCE, 5, (short)1, true, 0, true);
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)5), Mockito.eq((short)1), Mockito.eq((boolean)true), Mockito.eq((int)0), Mockito.eq((boolean)true));
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow)).updateDependencyTree(Mockito.eq((int)3), Mockito.eq((int)5), Mockito.eq((short)1), Mockito.eq((boolean)true));
        ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager)).closeStreamRemote((Http2Stream)Mockito.eq((Object)this.stream), (ChannelFuture)Mockito.any(ChannelFuture.class));
    }

    @Test
    public void pushPromiseReadAfterGoAwaySentShouldBeIgnored() throws Exception {
        this.mockGoAwaySent();
        this.decode().onPushPromiseRead(this.ctx, 3, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0);
        ((Http2Connection.Endpoint)Mockito.verify(this.remote, (VerificationMode)Mockito.never())).reservePushStream(Mockito.anyInt(), (Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onPushPromiseRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt());
    }

    @Test
    public void pushPromiseReadAfterGoAwayShouldAllowFramesForStreamCreatedByLocalEndpoint() throws Exception {
        this.mockGoAwaySentShouldAllowFramesForStreamCreatedByLocalEndpoint();
        this.decode().onPushPromiseRead(this.ctx, 3, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0);
        ((Http2Connection.Endpoint)Mockito.verify(this.remote)).reservePushStream(Mockito.anyInt(), (Http2Stream)Mockito.any(Http2Stream.class));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPushPromiseRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt());
    }

    @Test
    public void pushPromiseReadForUnknownStreamShouldThrow() throws Exception {
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onPushPromiseRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0);
            }
        });
    }

    @Test
    public void pushPromiseReadShouldSucceed() throws Exception {
        this.decode().onPushPromiseRead(this.ctx, 3, 2, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0);
        ((Http2Connection.Endpoint)Mockito.verify(this.remote)).reservePushStream(Mockito.eq((int)2), (Http2Stream)Mockito.eq((Object)this.stream));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPushPromiseRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), Mockito.eq((int)2), (Http2Headers)Mockito.eq((Object)EmptyHttp2Headers.INSTANCE), Mockito.eq((int)0));
    }

    @Test
    public void priorityReadAfterGoAwaySentShouldAllowFramesForStreamCreatedByLocalEndpoint() throws Exception {
        this.mockGoAwaySentShouldAllowFramesForStreamCreatedByLocalEndpoint();
        this.decode().onPriorityRead(this.ctx, 3, 0, (short)255, true);
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow)).updateDependencyTree(Mockito.eq((int)3), Mockito.eq((int)0), Mockito.eq((short)255), Mockito.eq((boolean)true));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPriorityRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean());
    }

    @Test
    public void priorityReadForUnknownStreamShouldNotBeIgnored() throws Exception {
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        this.decode().onPriorityRead(this.ctx, 3, 0, (short)255, true);
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow)).updateDependencyTree(Mockito.eq((int)3), Mockito.eq((int)0), Mockito.eq((short)255), Mockito.eq((boolean)true));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPriorityRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), Mockito.eq((int)0), Mockito.eq((short)255), Mockito.eq((boolean)true));
    }

    @Test
    public void priorityReadShouldNotCreateNewStream() throws Exception {
        Mockito.when((Object)this.connection.streamMayHaveExisted(3)).thenReturn((Object)false);
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        this.decode().onPriorityRead(this.ctx, 3, 5, (short)255, true);
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow)).updateDependencyTree(Mockito.eq((int)3), Mockito.eq((int)5), Mockito.eq((short)255), Mockito.eq((boolean)true));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPriorityRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), Mockito.eq((int)5), Mockito.eq((short)255), Mockito.eq((boolean)true));
        ((Http2Connection.Endpoint)Mockito.verify(this.remote, (VerificationMode)Mockito.never())).createStream(Mockito.eq((int)3), Mockito.anyBoolean());
        ((Http2Stream)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.never())).open(Mockito.anyBoolean());
    }

    @Test
    public void windowUpdateReadAfterGoAwaySentShouldBeIgnored() throws Exception {
        this.mockGoAwaySent();
        this.decode().onWindowUpdateRead(this.ctx, 3, 10);
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow, (VerificationMode)Mockito.never())).incrementWindowSize((Http2Stream)Mockito.any(Http2Stream.class), Mockito.anyInt());
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onWindowUpdateRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void windowUpdateReadAfterGoAwaySentShouldAllowFramesForStreamCreatedByLocalEndpoint() throws Exception {
        this.mockGoAwaySentShouldAllowFramesForStreamCreatedByLocalEndpoint();
        this.decode().onWindowUpdateRead(this.ctx, 3, 10);
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow)).incrementWindowSize((Http2Stream)Mockito.any(Http2Stream.class), Mockito.anyInt());
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onWindowUpdateRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void windowUpdateReadForUnknownStreamShouldThrow() throws Exception {
        Mockito.when((Object)this.connection.streamMayHaveExisted(3)).thenReturn((Object)false);
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onWindowUpdateRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, 10);
            }
        });
    }

    @Test
    public void windowUpdateReadForUnknownStreamShouldBeIgnored() throws Exception {
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        this.decode().onWindowUpdateRead(this.ctx, 3, 10);
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow, (VerificationMode)Mockito.never())).incrementWindowSize((Http2Stream)Mockito.any(Http2Stream.class), Mockito.anyInt());
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onWindowUpdateRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void windowUpdateReadShouldSucceed() throws Exception {
        this.decode().onWindowUpdateRead(this.ctx, 3, 10);
        ((Http2RemoteFlowController)Mockito.verify((Object)this.remoteFlow)).incrementWindowSize((Http2Stream)Mockito.eq((Object)this.stream), Mockito.eq((int)10));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onWindowUpdateRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), Mockito.eq((int)10));
    }

    @Test
    public void rstStreamReadAfterGoAwayShouldSucceed() throws Exception {
        Mockito.when((Object)this.connection.goAwaySent()).thenReturn((Object)true);
        this.decode().onRstStreamRead(this.ctx, 3, Http2Error.PROTOCOL_ERROR.code());
        ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager)).closeStream((Http2Stream)Mockito.eq((Object)this.stream), (ChannelFuture)Mockito.eq((Object)this.future));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onRstStreamRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyLong());
    }

    @Test
    public void rstStreamReadForUnknownStreamShouldThrow() throws Exception {
        Mockito.when((Object)this.connection.streamMayHaveExisted(3)).thenReturn((Object)false);
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onRstStreamRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, Http2Error.PROTOCOL_ERROR.code());
            }
        });
    }

    @Test
    public void rstStreamReadForUnknownStreamShouldBeIgnored() throws Exception {
        Mockito.when((Object)this.connection.stream(3)).thenReturn(null);
        this.decode().onRstStreamRead(this.ctx, 3, Http2Error.PROTOCOL_ERROR.code());
        ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager, (VerificationMode)Mockito.never())).closeStream((Http2Stream)Mockito.eq((Object)this.stream), (ChannelFuture)Mockito.eq((Object)this.future));
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyLong());
    }

    @Test
    public void rstStreamReadShouldCloseStream() throws Exception {
        this.decode().onRstStreamRead(this.ctx, 3, Http2Error.PROTOCOL_ERROR.code());
        ((Http2LifecycleManager)Mockito.verify((Object)this.lifecycleManager)).closeStream((Http2Stream)Mockito.eq((Object)this.stream), (ChannelFuture)Mockito.eq((Object)this.future));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onRstStreamRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()));
    }

    @Test
    public void rstStreamOnIdleStreamShouldThrow() throws Exception {
        Mockito.when((Object)this.stream.state()).thenReturn((Object)Http2Stream.State.IDLE);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onRstStreamRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, Http2Error.PROTOCOL_ERROR.code());
            }
        });
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onRstStreamRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong());
    }

    @Test
    public void pingReadWithAckShouldNotifyListener() throws Exception {
        this.decode().onPingAckRead(this.ctx, 0L);
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPingAckRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((long)0L));
    }

    @Test
    public void pingReadShouldReplyWithAck() throws Exception {
        this.decode().onPingRead(this.ctx, 0L);
        ((Http2ConnectionEncoder)Mockito.verify((Object)this.encoder)).writePing((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((boolean)true), Mockito.eq((long)0L), (ChannelPromise)Mockito.eq((Object)this.promise));
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onPingAckRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), ((Long)Mockito.any(Long.TYPE)).longValue());
    }

    @Test
    public void settingsReadWithAckShouldNotifyListener() throws Exception {
        this.decode().onSettingsAckRead(this.ctx);
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)2))).onSettingsAckRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx));
    }

    @Test
    public void settingsReadShouldSetValues() throws Exception {
        Http2Settings settings = new Http2Settings();
        settings.pushEnabled(true);
        settings.initialWindowSize(123);
        settings.maxConcurrentStreams(456L);
        settings.headerTableSize(789L);
        this.decode().onSettingsRead(this.ctx, settings);
        ((Http2ConnectionEncoder)Mockito.verify((Object)this.encoder)).remoteSettings(settings);
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onSettingsRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (Http2Settings)Mockito.eq((Object)settings));
    }

    @Test
    public void goAwayShouldReadShouldUpdateConnectionState() throws Exception {
        this.decode().onGoAwayRead(this.ctx, 1, 2L, Unpooled.EMPTY_BUFFER);
        ((Http2Connection)Mockito.verify((Object)this.connection)).goAwayReceived(Mockito.eq((int)1), Mockito.eq((long)2L), (ByteBuf)Mockito.eq((Object)Unpooled.EMPTY_BUFFER));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onGoAwayRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.eq((long)2L), (ByteBuf)Mockito.eq((Object)Unpooled.EMPTY_BUFFER));
    }

    @Test
    public void dataContentLengthMissmatch() throws Exception {
        this.dataContentLengthInvalid(false);
    }

    @Test
    public void dataContentLengthInvalid() throws Exception {
        this.dataContentLengthInvalid(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataContentLengthInvalid(boolean negative) throws Exception {
        final ByteBuf data = DefaultHttp2ConnectionDecoderTest.dummyData();
        int padding = 10;
        int processedBytes = data.readableBytes() + 10;
        this.mockFlowControl(processedBytes);
        try {
            if (negative) {
                Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable(){

                    public void execute() throws Throwable {
                        DefaultHttp2ConnectionDecoderTest.this.decode().onHeadersRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, (Http2Headers)new DefaultHttp2Headers().setLong((Object)HttpHeaderNames.CONTENT_LENGTH, -1L), 10, false);
                    }
                });
            } else {
                this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)new DefaultHttp2Headers().setLong((Object)HttpHeaderNames.CONTENT_LENGTH, 1L), 10, false);
                Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable(){

                    public void execute() throws Throwable {
                        DefaultHttp2ConnectionDecoderTest.this.decode().onDataRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, data, 10, true);
                    }
                });
                ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).receiveFlowControlledFrame((Http2Stream)Mockito.eq((Object)this.stream), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)10), Mockito.eq((boolean)true));
                ((Http2LocalFlowController)Mockito.verify((Object)this.localFlow)).consumeBytes((Http2Stream)Mockito.eq((Object)this.stream), Mockito.eq((int)processedBytes));
                ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)10), Mockito.eq((boolean)false));
            }
            ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
        }
        finally {
            data.release();
        }
    }

    @Test
    public void headersContentLengthPositiveSign() throws Exception {
        this.headersContentLengthSign("+1");
    }

    @Test
    public void headersContentLengthNegativeSign() throws Exception {
        this.headersContentLengthSign("-1");
    }

    private void headersContentLengthSign(final String length) throws Exception {
        int padding = 10;
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onHeadersRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, (Http2Headers)new DefaultHttp2Headers().set((Object)HttpHeaderNames.CONTENT_LENGTH, (Object)length), 10, false);
            }
        });
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean());
    }

    @Test
    public void headersContentLengthMissmatch() throws Exception {
        this.headersContentLength(false);
    }

    @Test
    public void headersContentLengthInvalid() throws Exception {
        this.headersContentLength(true);
    }

    private void headersContentLength(final boolean negative) throws Exception {
        int padding = 10;
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2ConnectionDecoderTest.this.decode().onHeadersRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, (Http2Headers)new DefaultHttp2Headers().setLong((Object)HttpHeaderNames.CONTENT_LENGTH, negative ? -1L : 1L), 10, true);
            }
        });
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean());
    }

    @Test
    public void multipleHeadersContentLengthSame() throws Exception {
        this.multipleHeadersContentLength(true);
    }

    @Test
    public void multipleHeadersContentLengthDifferent() throws Exception {
        this.multipleHeadersContentLength(false);
    }

    private void multipleHeadersContentLength(boolean same) throws Exception {
        int padding = 10;
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        if (same) {
            headers.addLong((Object)HttpHeaderNames.CONTENT_LENGTH, 0L);
            headers.addLong((Object)HttpHeaderNames.CONTENT_LENGTH, 0L);
        } else {
            headers.addLong((Object)HttpHeaderNames.CONTENT_LENGTH, 0L);
            headers.addLong((Object)HttpHeaderNames.CONTENT_LENGTH, 1L);
        }
        if (same) {
            this.decode().onHeadersRead(this.ctx, 3, (Http2Headers)headers, 10, true);
            ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)1))).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean());
            Assertions.assertEquals((int)1, (int)headers.getAll((Object)HttpHeaderNames.CONTENT_LENGTH).size());
        } else {
            Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable((Http2Headers)headers){
                final /* synthetic */ Http2Headers val$headers;
                {
                    this.val$headers = http2Headers;
                }

                public void execute() throws Throwable {
                    DefaultHttp2ConnectionDecoderTest.this.decode().onHeadersRead(DefaultHttp2ConnectionDecoderTest.this.ctx, 3, this.val$headers, 10, true);
                }
            });
            ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean());
        }
    }

    private static ByteBuf dummyData() {
        return Unpooled.wrappedBuffer((byte[])"abcdefgh".getBytes(CharsetUtil.UTF_8));
    }

    private Http2FrameListener decode() throws Exception {
        ArgumentCaptor internalListener = ArgumentCaptor.forClass(Http2FrameListener.class);
        ((Http2FrameReader)Mockito.doNothing().when((Object)this.reader)).readFrame((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (ByteBuf)Mockito.any(ByteBuf.class), (Http2FrameListener)internalListener.capture());
        this.decoder.decodeFrame(this.ctx, Unpooled.EMPTY_BUFFER, Collections.emptyList());
        return (Http2FrameListener)internalListener.getValue();
    }

    private void mockFlowControl(final int processedBytes) throws Http2Exception {
        ((Http2FrameListener)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                return processedBytes;
            }
        }).when((Object)this.listener)).onDataRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean());
    }

    private void mockGoAwaySent() {
        Mockito.when((Object)this.connection.goAwaySent()).thenReturn((Object)true);
        Mockito.when((Object)this.remote.isValidStreamId(3)).thenReturn((Object)true);
        Mockito.when((Object)this.remote.lastStreamKnownByPeer()).thenReturn((Object)0);
    }

    private void mockGoAwaySentShouldAllowFramesForStreamCreatedByLocalEndpoint() {
        Mockito.when((Object)this.connection.goAwaySent()).thenReturn((Object)true);
        Mockito.when((Object)this.remote.isValidStreamId(3)).thenReturn((Object)false);
        Mockito.when((Object)this.remote.lastStreamKnownByPeer()).thenReturn((Object)0);
    }
}

