/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.HpackDynamicTable;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.util.AsciiString;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HpackDynamicTableTest {
    private static final AsciiString FOO = AsciiString.cached((String)"foo");
    private static final AsciiString BAR = AsciiString.cached((String)"bar");
    private static final AsciiString HELLO = AsciiString.cached((String)"hello");
    private static final AsciiString WORLD = AsciiString.cached((String)"world");

    @Test
    public void testLength() {
        HpackDynamicTable table = new HpackDynamicTable(100L);
        Assertions.assertEquals((int)0, (int)table.length());
        HpackHeaderField entry = new HpackHeaderField((CharSequence)FOO, (CharSequence)BAR);
        table.add(entry);
        Assertions.assertEquals((int)1, (int)table.length());
        table.clear();
        Assertions.assertEquals((int)0, (int)table.length());
    }

    @Test
    public void testSize() {
        HpackDynamicTable table = new HpackDynamicTable(100L);
        Assertions.assertEquals((long)0L, (long)table.size());
        HpackHeaderField entry = new HpackHeaderField((CharSequence)FOO, (CharSequence)BAR);
        table.add(entry);
        Assertions.assertEquals((long)entry.size(), (long)table.size());
        table.clear();
        Assertions.assertEquals((long)0L, (long)table.size());
    }

    @Test
    public void testGetEntry() {
        final HpackDynamicTable table = new HpackDynamicTable(100L);
        HpackHeaderField entry = new HpackHeaderField((CharSequence)FOO, (CharSequence)BAR);
        table.add(entry);
        Assertions.assertEquals((Object)entry, (Object)table.getEntry(1));
        table.clear();
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                table.getEntry(1);
            }
        });
    }

    @Test
    public void testGetEntryExceptionally() {
        final HpackDynamicTable table = new HpackDynamicTable(1L);
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                table.getEntry(1);
            }
        });
    }

    @Test
    public void testRemove() {
        HpackDynamicTable table = new HpackDynamicTable(100L);
        Assertions.assertNull((Object)table.remove());
        HpackHeaderField entry1 = new HpackHeaderField((CharSequence)FOO, (CharSequence)BAR);
        HpackHeaderField entry2 = new HpackHeaderField((CharSequence)HELLO, (CharSequence)WORLD);
        table.add(entry1);
        table.add(entry2);
        Assertions.assertEquals((Object)entry1, (Object)table.remove());
        Assertions.assertEquals((Object)entry2, (Object)table.getEntry(1));
        Assertions.assertEquals((int)1, (int)table.length());
        Assertions.assertEquals((long)entry2.size(), (long)table.size());
    }

    @Test
    public void testSetCapacity() {
        HpackHeaderField entry1 = new HpackHeaderField((CharSequence)FOO, (CharSequence)BAR);
        HpackHeaderField entry2 = new HpackHeaderField((CharSequence)HELLO, (CharSequence)WORLD);
        int size1 = entry1.size();
        int size2 = entry2.size();
        HpackDynamicTable table = new HpackDynamicTable((long)(size1 + size2));
        table.add(entry1);
        table.add(entry2);
        Assertions.assertEquals((int)2, (int)table.length());
        Assertions.assertEquals((long)(size1 + size2), (long)table.size());
        table.setCapacity(((long)size1 + (long)size2) * 2L);
        Assertions.assertEquals((int)2, (int)table.length());
        Assertions.assertEquals((long)(size1 + size2), (long)table.size());
        table.setCapacity((long)size2);
        Assertions.assertEquals((int)1, (int)table.length());
        Assertions.assertEquals((long)size2, (long)table.size());
        Assertions.assertEquals((Object)entry2, (Object)table.getEntry(1));
        table.setCapacity(0L);
        Assertions.assertEquals((int)0, (int)table.length());
        Assertions.assertEquals((long)0L, (long)table.size());
    }

    @Test
    public void testAdd() {
        HpackDynamicTable table = new HpackDynamicTable(100L);
        Assertions.assertEquals((long)0L, (long)table.size());
        HpackHeaderField entry1 = new HpackHeaderField((CharSequence)FOO, (CharSequence)BAR);
        HpackHeaderField entry2 = new HpackHeaderField((CharSequence)HELLO, (CharSequence)WORLD);
        table.add(entry1);
        Assertions.assertEquals((long)entry1.size(), (long)table.size());
        table.setCapacity(32L);
        Assertions.assertEquals((long)0L, (long)table.size());
        Assertions.assertEquals((int)0, (int)table.length());
        table.add(entry1);
        Assertions.assertEquals((long)0L, (long)table.size());
        Assertions.assertEquals((int)0, (int)table.length());
        table.setCapacity(64L);
        table.add(entry1);
        Assertions.assertEquals((long)entry1.size(), (long)table.size());
        Assertions.assertEquals((int)1, (int)table.length());
        table.add(entry2);
        Assertions.assertEquals((long)entry2.size(), (long)table.size());
        Assertions.assertEquals((int)1, (int)table.length());
        Assertions.assertEquals((Object)entry2, (Object)table.getEntry(1));
    }
}

