/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.DefaultHttp2HeadersEncoder;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class Http2FrameRoundtripTest {
    private static final byte[] MESSAGE = "hello world".getBytes(CharsetUtil.UTF_8);
    private static final int STREAM_ID = Integer.MAX_VALUE;
    private static final int WINDOW_UPDATE = Integer.MAX_VALUE;
    private static final long ERROR_CODE = 0xFFFFFFFFL;
    @Mock
    private Http2FrameListener listener;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private EventExecutor executor;
    @Mock
    private Channel channel;
    @Mock
    private ByteBufAllocator alloc;
    private Http2FrameWriter writer;
    private Http2FrameReader reader;
    private final List<ByteBuf> needReleasing = new LinkedList<ByteBuf>();

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)this.alloc);
        Mockito.when((Object)this.ctx.executor()).thenReturn((Object)this.executor);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        ((ByteBufAllocator)Mockito.doAnswer((Answer)new Answer<ByteBuf>(){

            public ByteBuf answer(InvocationOnMock in) throws Throwable {
                return Unpooled.buffer();
            }
        }).when((Object)this.alloc)).buffer();
        ((ByteBufAllocator)Mockito.doAnswer((Answer)new Answer<ByteBuf>(){

            public ByteBuf answer(InvocationOnMock in) throws Throwable {
                return Unpooled.buffer((int)((Integer)in.getArguments()[0]));
            }
        }).when((Object)this.alloc)).buffer(Mockito.anyInt());
        ((ChannelHandlerContext)Mockito.doAnswer((Answer)new Answer<ChannelPromise>(){

            public ChannelPromise answer(InvocationOnMock invocation) throws Throwable {
                return new DefaultChannelPromise(Http2FrameRoundtripTest.this.channel, (EventExecutor)GlobalEventExecutor.INSTANCE);
            }
        }).when((Object)this.ctx)).newPromise();
        this.writer = new DefaultHttp2FrameWriter((Http2HeadersEncoder)new DefaultHttp2HeadersEncoder(Http2HeadersEncoder.NEVER_SENSITIVE, Http2TestUtil.newTestEncoder()));
        this.reader = new DefaultHttp2FrameReader((Http2HeadersDecoder)new DefaultHttp2HeadersDecoder(false, false, Http2TestUtil.newTestDecoder()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterEach
    public void teardown() {
        try {
            for (ByteBuf buf : this.needReleasing) {
                buf.release();
            }
            for (ByteBuf buf : this.needReleasing) {
                int expectedFinalRefCount = 0;
                if (buf.isReadOnly() || buf instanceof EmptyByteBuf) {
                    expectedFinalRefCount = 1;
                }
                Assertions.assertEquals((int)expectedFinalRefCount, (int)buf.refCnt());
            }
        }
        finally {
            this.needReleasing.clear();
        }
    }

    @Test
    public void emptyDataShouldMatch() throws Exception {
        ByteBuf data = Unpooled.EMPTY_BUFFER;
        this.writer.writeData(this.ctx, Integer.MAX_VALUE, data.slice(), 0, false, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)0), Mockito.eq((boolean)false));
    }

    @Test
    public void dataShouldMatch() throws Exception {
        ByteBuf data = Http2FrameRoundtripTest.data(10);
        this.writer.writeData(this.ctx, Integer.MAX_VALUE, data.slice(), 1, false, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)1), Mockito.eq((boolean)false));
    }

    @Test
    public void dataWithPaddingShouldMatch() throws Exception {
        ByteBuf data = Http2FrameRoundtripTest.data(10);
        this.writer.writeData(this.ctx, Integer.MAX_VALUE, data.slice(), 256, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (ByteBuf)Mockito.eq((Object)data), Mockito.eq((int)256), Mockito.eq((boolean)true));
    }

    @Test
    public void largeDataFrameShouldMatch() throws Exception {
        ByteBuf originalData = Http2FrameRoundtripTest.data(0x100000);
        int originalPadding = 100;
        boolean endOfStream = true;
        this.writer.writeData(this.ctx, Integer.MAX_VALUE, originalData.slice(), 100, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.atLeastOnce())).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.eq((boolean)false));
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.eq((boolean)true));
        ArgumentCaptor dataCaptor = ArgumentCaptor.forClass(ByteBuf.class);
        ArgumentCaptor paddingCaptor = ArgumentCaptor.forClass(Integer.class);
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.atLeastOnce())).onDataRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (ByteBuf)dataCaptor.capture(), ((Integer)paddingCaptor.capture()).intValue(), Mockito.anyBoolean());
        for (ByteBuf chunk : dataCaptor.getAllValues()) {
            ByteBuf originalChunk = originalData.readSlice(chunk.readableBytes());
            Assertions.assertEquals((Object)originalChunk, (Object)chunk);
        }
        Assertions.assertFalse((boolean)originalData.isReadable());
        int totalReadPadding = 0;
        Iterator iterator = paddingCaptor.getAllValues().iterator();
        while (iterator.hasNext()) {
            int framePadding = (Integer)iterator.next();
            totalReadPadding += framePadding;
        }
        Assertions.assertEquals((int)100, (int)totalReadPadding);
    }

    @Test
    public void emptyHeadersShouldMatch() throws Exception {
        EmptyHttp2Headers headers = EmptyHttp2Headers.INSTANCE;
        this.writer.writeHeaders(this.ctx, Integer.MAX_VALUE, (Http2Headers)headers, 0, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void emptyHeadersWithPaddingShouldMatch() throws Exception {
        EmptyHttp2Headers headers = EmptyHttp2Headers.INSTANCE;
        this.writer.writeHeaders(this.ctx, Integer.MAX_VALUE, (Http2Headers)headers, 256, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)256), Mockito.eq((boolean)true));
    }

    @Test
    public void binaryHeadersWithoutPriorityShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.binaryHeaders();
        this.writer.writeHeaders(this.ctx, Integer.MAX_VALUE, headers, 0, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void headersFrameWithoutPriorityShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.headers();
        this.writer.writeHeaders(this.ctx, Integer.MAX_VALUE, headers, 0, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void headersFrameWithPriorityShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.headers();
        this.writer.writeHeaders(this.ctx, Integer.MAX_VALUE, headers, 4, (short)255, true, 0, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)4), Mockito.eq((short)255), Mockito.eq((boolean)true), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void headersWithPaddingWithoutPriorityShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.headers();
        this.writer.writeHeaders(this.ctx, Integer.MAX_VALUE, headers, 256, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)256), Mockito.eq((boolean)true));
    }

    @Test
    public void headersWithPaddingWithPriorityShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.headers();
        this.writer.writeHeaders(this.ctx, Integer.MAX_VALUE, headers, 2, (short)3, true, 1, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)2), Mockito.eq((short)3), Mockito.eq((boolean)true), Mockito.eq((int)1), Mockito.eq((boolean)true));
    }

    @Test
    public void continuedHeadersShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.largeHeaders();
        this.writer.writeHeaders(this.ctx, Integer.MAX_VALUE, headers, 2, (short)3, true, 0, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)2), Mockito.eq((short)3), Mockito.eq((boolean)true), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void continuedHeadersWithPaddingShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.largeHeaders();
        this.writer.writeHeaders(this.ctx, Integer.MAX_VALUE, headers, 2, (short)3, true, 256, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onHeadersRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)2), Mockito.eq((short)3), Mockito.eq((boolean)true), Mockito.eq((int)256), Mockito.eq((boolean)true));
    }

    @Test
    public void headersThatAreTooBigShouldFail() throws Exception {
        this.reader = new DefaultHttp2FrameReader(false);
        int maxListSize = 100;
        this.reader.configuration().headersConfiguration().maxHeaderListSize(100L, 100L);
        Http2Headers headers = Http2FrameRoundtripTest.headersOfSize(101);
        this.writer.writeHeaders(this.ctx, Integer.MAX_VALUE, headers, 2, (short)3, true, 256, true, this.ctx.newPromise());
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                Http2FrameRoundtripTest.this.readFrames();
            }
        });
        ((Http2FrameListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onHeadersRead((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean());
    }

    @Test
    public void emptyPushPromiseShouldMatch() throws Exception {
        EmptyHttp2Headers headers = EmptyHttp2Headers.INSTANCE;
        this.writer.writePushPromise(this.ctx, Integer.MAX_VALUE, 2, (Http2Headers)headers, 0, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPushPromiseRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((int)2), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0));
    }

    @Test
    public void pushPromiseFrameShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.headers();
        this.writer.writePushPromise(this.ctx, Integer.MAX_VALUE, 1, headers, 5, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPushPromiseRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((int)1), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)5));
    }

    @Test
    public void pushPromiseWithPaddingShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.headers();
        this.writer.writePushPromise(this.ctx, Integer.MAX_VALUE, 2, headers, 256, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPushPromiseRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((int)2), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)256));
    }

    @Test
    public void continuedPushPromiseShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.largeHeaders();
        this.writer.writePushPromise(this.ctx, Integer.MAX_VALUE, 2, headers, 0, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPushPromiseRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((int)2), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)0));
    }

    @Test
    public void continuedPushPromiseWithPaddingShouldMatch() throws Exception {
        Http2Headers headers = Http2FrameRoundtripTest.largeHeaders();
        this.writer.writePushPromise(this.ctx, Integer.MAX_VALUE, 2, headers, 255, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPushPromiseRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((int)2), (Http2Headers)Mockito.eq((Object)headers), Mockito.eq((int)255));
    }

    @Test
    public void goAwayFrameShouldMatch() throws Exception {
        String text = "test";
        ByteBuf data = Http2FrameRoundtripTest.buf("test".getBytes());
        this.writer.writeGoAway(this.ctx, Integer.MAX_VALUE, 0xFFFFFFFFL, data.slice(), this.ctx.newPromise());
        this.readFrames();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ByteBuf.class);
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onGoAwayRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((long)0xFFFFFFFFL), (ByteBuf)captor.capture());
        Assertions.assertEquals((Object)data, (Object)captor.getValue());
    }

    @Test
    public void pingFrameShouldMatch() throws Exception {
        this.writer.writePing(this.ctx, false, 1234567L, this.ctx.newPromise());
        this.readFrames();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.TYPE);
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPingRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), ((Long)captor.capture()).longValue());
        Assertions.assertEquals((long)1234567L, (long)((Long)captor.getValue()));
    }

    @Test
    public void pingAckFrameShouldMatch() throws Exception {
        this.writer.writePing(this.ctx, true, 1234567L, this.ctx.newPromise());
        this.readFrames();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.TYPE);
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPingAckRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), ((Long)captor.capture()).longValue());
        Assertions.assertEquals((long)1234567L, (long)((Long)captor.getValue()));
    }

    @Test
    public void priorityFrameShouldMatch() throws Exception {
        this.writer.writePriority(this.ctx, Integer.MAX_VALUE, 1, (short)1, true, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onPriorityRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((int)1), Mockito.eq((short)1), Mockito.eq((boolean)true));
    }

    @Test
    public void rstStreamFrameShouldMatch() throws Exception {
        this.writer.writeRstStream(this.ctx, Integer.MAX_VALUE, 0xFFFFFFFFL, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onRstStreamRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((long)0xFFFFFFFFL));
    }

    @Test
    public void emptySettingsFrameShouldMatch() throws Exception {
        Http2Settings settings = new Http2Settings();
        this.writer.writeSettings(this.ctx, settings, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onSettingsRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (Http2Settings)Mockito.eq((Object)settings));
    }

    @Test
    public void settingsShouldStripShouldMatch() throws Exception {
        Http2Settings settings = new Http2Settings();
        settings.pushEnabled(true);
        settings.headerTableSize(4096L);
        settings.initialWindowSize(123);
        settings.maxConcurrentStreams(456L);
        this.writer.writeSettings(this.ctx, settings, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onSettingsRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (Http2Settings)Mockito.eq((Object)settings));
    }

    @Test
    public void settingsAckShouldMatch() throws Exception {
        this.writer.writeSettingsAck(this.ctx, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onSettingsAckRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx));
    }

    @Test
    public void windowUpdateFrameShouldMatch() throws Exception {
        this.writer.writeWindowUpdate(this.ctx, Integer.MAX_VALUE, Integer.MAX_VALUE, this.ctx.newPromise());
        this.readFrames();
        ((Http2FrameListener)Mockito.verify((Object)this.listener)).onWindowUpdateRead((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((int)Integer.MAX_VALUE));
    }

    private void readFrames() throws Http2Exception {
        ByteBuf write = this.captureWrites();
        this.reader.readFrame(this.ctx, write, this.listener);
    }

    private static ByteBuf data(int size) {
        int length;
        byte[] data = new byte[size];
        for (int ix = 0; ix < data.length; ix += length) {
            length = Math.min(MESSAGE.length, data.length - ix);
            System.arraycopy(MESSAGE, 0, data, ix, length);
        }
        return Http2FrameRoundtripTest.buf(data);
    }

    private static ByteBuf buf(byte[] bytes) {
        return Unpooled.wrappedBuffer((byte[])bytes);
    }

    private <T extends ByteBuf> T releaseLater(T buf) {
        this.needReleasing.add(buf);
        return buf;
    }

    private ByteBuf captureWrites() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(ByteBuf.class);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.atLeastOnce())).write(captor.capture(), (ChannelPromise)Mockito.isA(ChannelPromise.class));
        CompositeByteBuf composite = this.releaseLater(Unpooled.compositeBuffer());
        for (ByteBuf buf : captor.getAllValues()) {
            buf = this.releaseLater(buf.retain());
            composite.addComponent(true, buf);
        }
        return composite;
    }

    private static Http2Headers headers() {
        return (Http2Headers)new DefaultHttp2Headers(false).method((CharSequence)AsciiString.of((CharSequence)"GET")).scheme((CharSequence)AsciiString.of((CharSequence)"https")).authority((CharSequence)AsciiString.of((CharSequence)"example.org")).path((CharSequence)AsciiString.of((CharSequence)"/some/path/resource2")).add((Object)Http2TestUtil.randomString(), (Object)Http2TestUtil.randomString());
    }

    private static Http2Headers largeHeaders() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (int i = 0; i < 100; ++i) {
            String key = "this-is-a-test-header-key-" + i;
            String value = "this-is-a-test-header-value-" + i;
            headers.add((Object)AsciiString.of((CharSequence)key), (Object)AsciiString.of((CharSequence)value));
        }
        return headers;
    }

    private static Http2Headers headersOfSize(int minSize) {
        AsciiString singleByte = new AsciiString(new byte[]{0}, false);
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (int size = 0; size < minSize; size += 2) {
            headers.add((Object)singleByte, (Object)singleByte);
        }
        return headers;
    }

    private static Http2Headers binaryHeaders() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (int ix = 0; ix < 10; ++ix) {
            headers.add((Object)Http2TestUtil.randomString(), (Object)Http2TestUtil.randomString());
        }
        return headers;
    }
}

