/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTestUtils;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubAckPayload;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MqttMessageFactoryTest {
    private static final String SAMPLE_TOPIC = "a/b/c";
    private static final int SAMPLE_MESSAGE_ID = 123;

    @Test
    public void createUnsubAckV3() {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)123);
        MqttMessage unsuback = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        Assertions.assertEquals((Object)MqttMessageType.UNSUBACK, (Object)unsuback.fixedHeader().messageType());
        MqttMessageIdAndPropertiesVariableHeader actualVariableHeader = (MqttMessageIdAndPropertiesVariableHeader)unsuback.variableHeader();
        Assertions.assertEquals((int)123, (int)actualVariableHeader.messageId());
        MqttTestUtils.validateProperties(MqttProperties.NO_PROPERTIES, actualVariableHeader.properties());
        MqttUnsubAckPayload actualPayload = (MqttUnsubAckPayload)unsuback.payload();
        Assertions.assertNotNull((Object)actualPayload);
        Assertions.assertEquals((int)0, (int)actualPayload.unsubscribeReasonCodes().size());
    }

    @Test
    public void createUnsubAckV5() {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttProperties properties = new MqttProperties();
        String reasonString = "All right";
        properties.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.REASON_STRING.value(), reasonString));
        MqttMessageIdAndPropertiesVariableHeader variableHeader = new MqttMessageIdAndPropertiesVariableHeader(123, properties);
        MqttUnsubAckPayload payload = new MqttUnsubAckPayload(new short[]{128});
        MqttMessage unsuback = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        Assertions.assertEquals((Object)MqttMessageType.UNSUBACK, (Object)unsuback.fixedHeader().messageType());
        MqttMessageIdAndPropertiesVariableHeader actualVariableHeader = (MqttMessageIdAndPropertiesVariableHeader)unsuback.variableHeader();
        Assertions.assertEquals((int)123, (int)actualVariableHeader.messageId());
        MqttTestUtils.validateProperties(properties, actualVariableHeader.properties());
        MqttUnsubAckPayload actualPayload = (MqttUnsubAckPayload)unsuback.payload();
        Assertions.assertEquals((Object)payload.unsubscribeReasonCodes(), (Object)actualPayload.unsubscribeReasonCodes());
    }

    @Test
    public void createSubscribeV3() {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)123);
        ArrayList<MqttTopicSubscription> subscriptions = new ArrayList<MqttTopicSubscription>();
        subscriptions.add(new MqttTopicSubscription(SAMPLE_TOPIC, MqttQoS.AT_MOST_ONCE));
        MqttSubscribePayload payload = new MqttSubscribePayload(subscriptions);
        MqttMessage subscribe = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        Assertions.assertEquals((Object)MqttMessageType.SUBSCRIBE, (Object)subscribe.fixedHeader().messageType());
        MqttMessageIdAndPropertiesVariableHeader actualVariableHeader = (MqttMessageIdAndPropertiesVariableHeader)subscribe.variableHeader();
        Assertions.assertEquals((int)123, (int)actualVariableHeader.messageId());
        MqttTestUtils.validateProperties(MqttProperties.NO_PROPERTIES, actualVariableHeader.properties());
        MqttSubscribePayload actualPayload = (MqttSubscribePayload)subscribe.payload();
        MqttTestUtils.validateSubscribePayload(payload, actualPayload);
    }

    @Test
    public void createSubscribeV5() {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttProperties properties = new MqttProperties();
        properties.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("correlationId", "111222"));
        MqttMessageIdAndPropertiesVariableHeader variableHeader = new MqttMessageIdAndPropertiesVariableHeader(123, properties);
        ArrayList<MqttTopicSubscription> subscriptions = new ArrayList<MqttTopicSubscription>();
        subscriptions.add(new MqttTopicSubscription(SAMPLE_TOPIC, MqttQoS.AT_MOST_ONCE));
        MqttSubscribePayload payload = new MqttSubscribePayload(subscriptions);
        MqttMessage subscribe = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        Assertions.assertEquals((Object)MqttMessageType.SUBSCRIBE, (Object)subscribe.fixedHeader().messageType());
        MqttMessageIdAndPropertiesVariableHeader actualVariableHeader = (MqttMessageIdAndPropertiesVariableHeader)subscribe.variableHeader();
        Assertions.assertEquals((int)123, (int)actualVariableHeader.messageId());
        MqttTestUtils.validateProperties(properties, actualVariableHeader.properties());
        MqttSubscribePayload actualPayload = (MqttSubscribePayload)subscribe.payload();
        MqttTestUtils.validateSubscribePayload(payload, actualPayload);
    }

    @Test
    public void createUnsubscribeV3() {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)123);
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(SAMPLE_TOPIC);
        MqttUnsubscribePayload payload = new MqttUnsubscribePayload(topics);
        MqttMessage unsubscribe = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        Assertions.assertEquals((Object)MqttMessageType.UNSUBSCRIBE, (Object)unsubscribe.fixedHeader().messageType());
        MqttMessageIdAndPropertiesVariableHeader actualVariableHeader = (MqttMessageIdAndPropertiesVariableHeader)unsubscribe.variableHeader();
        Assertions.assertEquals((int)123, (int)actualVariableHeader.messageId());
        MqttTestUtils.validateProperties(MqttProperties.NO_PROPERTIES, actualVariableHeader.properties());
        MqttUnsubscribePayload actualPayload = (MqttUnsubscribePayload)unsubscribe.payload();
        MqttTestUtils.validateUnsubscribePayload(payload, actualPayload);
    }

    @Test
    public void createUnsubscribeV5() {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttProperties properties = new MqttProperties();
        properties.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("correlationId", "111222"));
        MqttMessageIdAndPropertiesVariableHeader variableHeader = new MqttMessageIdAndPropertiesVariableHeader(123, properties);
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(SAMPLE_TOPIC);
        MqttUnsubscribePayload payload = new MqttUnsubscribePayload(topics);
        MqttMessage unsubscribe = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        Assertions.assertEquals((Object)MqttMessageType.UNSUBSCRIBE, (Object)unsubscribe.fixedHeader().messageType());
        MqttMessageIdAndPropertiesVariableHeader actualVariableHeader = (MqttMessageIdAndPropertiesVariableHeader)unsubscribe.variableHeader();
        Assertions.assertEquals((int)123, (int)actualVariableHeader.messageId());
        MqttTestUtils.validateProperties(properties, actualVariableHeader.properties());
        MqttUnsubscribePayload actualPayload = (MqttUnsubscribePayload)unsubscribe.payload();
        MqttTestUtils.validateUnsubscribePayload(payload, actualPayload);
    }
}

