/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.util.CharsetUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class MqttCodecTest {
    private static final String CLIENT_ID = "RANDOM_TEST_CLIENT";
    private static final String WILL_TOPIC = "/my_will";
    private static final String WILL_MESSAGE = "gone";
    private static final String USER_NAME = "happy_user";
    private static final String PASSWORD = "123_or_no_pwd";
    private static final int KEEP_ALIVE_SECONDS = 600;
    private static final ByteBufAllocator ALLOCATOR = new UnpooledByteBufAllocator(false);
    @Mock
    private final ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
    @Mock
    private final Channel channel = (Channel)Mockito.mock(Channel.class);
    private final MqttDecoder mqttDecoder = new MqttDecoder();
    private final MqttDecoder mqttDecoderLimitedMessageSize = new MqttDecoder(1);

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
    }

    @Test
    public void testConnectMessageForMqtt31() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttConnectMessage decodedMessage = (MqttConnectMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateConnectPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testConnectMessageForMqtt311() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttConnectMessage decodedMessage = (MqttConnectMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateConnectPayload(message.payload(), decodedMessage.payload());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectMessageWithNonZeroReservedFlagForMqtt311() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        try {
            byteBuf.setByte(9, byteBuf.getByte(9) | 1);
            LinkedList out = new LinkedList();
            this.mqttDecoder.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            Assert.assertTrue((boolean)decodedMessage.decoderResult().isFailure());
            Throwable cause = decodedMessage.decoderResult().cause();
            Assert.assertTrue((boolean)(cause instanceof DecoderException));
            Assert.assertEquals((Object)"non-zero reserved flag", (Object)cause.getMessage());
        }
        finally {
            byteBuf.release();
        }
    }

    @Test
    public void testConnectMessageNoPassword() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1, null, PASSWORD);
        try {
            ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        }
        catch (Exception cause) {
            Assert.assertTrue((boolean)(cause instanceof DecoderException));
        }
    }

    @Test
    public void testConnAckMessage() throws Exception {
        MqttConnAckMessage message = MqttCodecTest.createConnAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttConnAckMessage decodedMessage = (MqttConnAckMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnAckVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
    }

    @Test
    public void testPublishMessage() throws Exception {
        MqttPublishMessage message = MqttCodecTest.createPublishMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttPublishMessage decodedMessage = (MqttPublishMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validatePublishVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validatePublishPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testPubAckMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBACK);
    }

    @Test
    public void testPubRecMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBREC);
    }

    @Test
    public void testPubRelMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBREL);
    }

    @Test
    public void testPubCompMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBCOMP);
    }

    @Test
    public void testSubscribeMessage() throws Exception {
        MqttSubscribeMessage message = MqttCodecTest.createSubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttSubscribeMessage decodedMessage = (MqttSubscribeMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateSubscribePayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testSubAckMessage() throws Exception {
        MqttSubAckMessage message = MqttCodecTest.createSubAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttSubAckMessage decodedMessage = (MqttSubAckMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateSubAckPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testSubAckMessageWithFailureInPayload() throws Exception {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        MqttSubAckPayload mqttSubAckPayload = new MqttSubAckPayload(new int[]{MqttQoS.FAILURE.value()});
        MqttSubAckMessage message = new MqttSubAckMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttSubAckPayload);
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttSubAckMessage decodedMessage = (MqttSubAckMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateSubAckPayload(message.payload(), decodedMessage.payload());
        Assert.assertEquals((long)1L, (long)decodedMessage.payload().grantedQoSLevels().size());
        Assert.assertEquals((Object)MqttQoS.FAILURE, (Object)MqttQoS.valueOf((int)((Integer)decodedMessage.payload().grantedQoSLevels().get(0))));
    }

    @Test
    public void testUnSubscribeMessage() throws Exception {
        MqttUnsubscribeMessage message = MqttCodecTest.createUnsubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttUnsubscribeMessage decodedMessage = (MqttUnsubscribeMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateUnsubscribePayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testUnsubAckMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.UNSUBACK);
    }

    @Test
    public void testPingReqMessage() throws Exception {
        this.testMessageWithOnlyFixedHeader(MqttMessage.PINGREQ);
    }

    @Test
    public void testPingRespMessage() throws Exception {
        this.testMessageWithOnlyFixedHeader(MqttMessage.PINGRESP);
    }

    @Test
    public void testDisconnectMessage() throws Exception {
        this.testMessageWithOnlyFixedHeader(MqttMessage.DISCONNECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnknownMessageType() throws Exception {
        MqttMessage message = MqttCodecTest.createMessageWithFixedHeader(MqttMessageType.PINGREQ);
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        try {
            byteBuf.setByte(0, 240);
            LinkedList out = new LinkedList();
            this.mqttDecoder.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            Assert.assertTrue((boolean)decodedMessage.decoderResult().isFailure());
            Throwable cause = decodedMessage.decoderResult().cause();
            Assert.assertTrue((boolean)(cause instanceof IllegalArgumentException));
            Assert.assertEquals((Object)"unknown message type: 15", (Object)cause.getMessage());
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectMessageForMqtt31TooLarge() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), (MqttConnectVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectMessageForMqtt311TooLarge() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), (MqttConnectVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnAckMessageTooLarge() throws Exception {
        MqttConnAckMessage message = MqttCodecTest.createConnAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishMessageTooLarge() throws Exception {
        MqttPublishMessage message = MqttCodecTest.createPublishMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validatePublishVariableHeader(message.variableHeader(), (MqttPublishVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubscribeMessageTooLarge() throws Exception {
        MqttSubscribeMessage message = MqttCodecTest.createSubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubAckMessageTooLarge() throws Exception {
        MqttSubAckMessage message = MqttCodecTest.createSubAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnSubscribeMessageTooLarge() throws Exception {
        MqttUnsubscribeMessage message = MqttCodecTest.createUnsubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    private void testMessageWithOnlyFixedHeader(MqttMessage message) throws Exception {
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttMessage decodedMessage = (MqttMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
    }

    private void testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType messageType) throws Exception {
        MqttMessage message = MqttCodecTest.createMessageWithFixedHeaderAndMessageIdVariableHeader(messageType);
        ByteBuf byteBuf = MqttEncoder.doEncode((ByteBufAllocator)ALLOCATOR, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttMessage decodedMessage = (MqttMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader((MqttMessageIdVariableHeader)message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
    }

    private static MqttMessage createMessageWithFixedHeader(MqttMessageType messageType) {
        return new MqttMessage(new MqttFixedHeader(messageType, false, MqttQoS.AT_MOST_ONCE, false, 0));
    }

    private static MqttMessage createMessageWithFixedHeaderAndMessageIdVariableHeader(MqttMessageType messageType) {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(messageType, false, messageType == MqttMessageType.PUBREL ? MqttQoS.AT_LEAST_ONCE : MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        return new MqttMessage(mqttFixedHeader, (Object)mqttMessageIdVariableHeader);
    }

    private static MqttConnectMessage createConnectMessage(MqttVersion mqttVersion) {
        return MqttCodecTest.createConnectMessage(mqttVersion, USER_NAME, PASSWORD);
    }

    private static MqttConnectMessage createConnectMessage(MqttVersion mqttVersion, String username, String password) {
        return MqttMessageBuilders.connect().clientId(CLIENT_ID).protocolVersion(mqttVersion).username(username).password(password).willRetain(true).willQoS(MqttQoS.AT_LEAST_ONCE).willFlag(true).willTopic(WILL_TOPIC).willMessage(WILL_MESSAGE).cleanSession(true).keepAlive(600).build();
    }

    private static MqttConnAckMessage createConnAckMessage() {
        return MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_ACCEPTED).sessionPresent(true).build();
    }

    private static MqttPublishMessage createPublishMessage() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_LEAST_ONCE, true, 0);
        MqttPublishVariableHeader mqttPublishVariableHeader = new MqttPublishVariableHeader("/abc", 1234);
        ByteBuf payload = ALLOCATOR.buffer();
        payload.writeBytes("whatever".getBytes(CharsetUtil.UTF_8));
        return new MqttPublishMessage(mqttFixedHeader, mqttPublishVariableHeader, payload);
    }

    private static MqttSubscribeMessage createSubscribeMessage() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, true, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        LinkedList<MqttTopicSubscription> topicSubscriptions = new LinkedList<MqttTopicSubscription>();
        topicSubscriptions.add(new MqttTopicSubscription("/abc", MqttQoS.AT_LEAST_ONCE));
        topicSubscriptions.add(new MqttTopicSubscription("/def", MqttQoS.AT_LEAST_ONCE));
        topicSubscriptions.add(new MqttTopicSubscription("/xyz", MqttQoS.EXACTLY_ONCE));
        MqttSubscribePayload mqttSubscribePayload = new MqttSubscribePayload(topicSubscriptions);
        return new MqttSubscribeMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttSubscribePayload);
    }

    private static MqttSubAckMessage createSubAckMessage() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        MqttSubAckPayload mqttSubAckPayload = new MqttSubAckPayload(new int[]{1, 2, 0});
        return new MqttSubAckMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttSubAckPayload);
    }

    private static MqttUnsubscribeMessage createUnsubscribeMessage() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, true, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        LinkedList<String> topics = new LinkedList<String>();
        topics.add("/abc");
        topics.add("/def");
        topics.add("/xyz");
        MqttUnsubscribePayload mqttUnsubscribePayload = new MqttUnsubscribePayload(topics);
        return new MqttUnsubscribeMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttUnsubscribePayload);
    }

    private static void validateFixedHeaders(MqttFixedHeader expected, MqttFixedHeader actual) {
        Assert.assertEquals((String)"MqttFixedHeader MqttMessageType mismatch ", (Object)expected.messageType(), (Object)actual.messageType());
        Assert.assertEquals((String)"MqttFixedHeader Qos mismatch ", (Object)expected.qosLevel(), (Object)actual.qosLevel());
    }

    private static void validateConnectVariableHeader(MqttConnectVariableHeader expected, MqttConnectVariableHeader actual) {
        Assert.assertEquals((String)"MqttConnectVariableHeader Name mismatch ", (Object)expected.name(), (Object)actual.name());
        Assert.assertEquals((String)"MqttConnectVariableHeader KeepAliveTimeSeconds mismatch ", (long)expected.keepAliveTimeSeconds(), (long)actual.keepAliveTimeSeconds());
        Assert.assertEquals((String)"MqttConnectVariableHeader Version mismatch ", (long)expected.version(), (long)actual.version());
        Assert.assertEquals((String)"MqttConnectVariableHeader WillQos mismatch ", (long)expected.willQos(), (long)actual.willQos());
        Assert.assertEquals((String)"MqttConnectVariableHeader HasUserName mismatch ", (Object)expected.hasUserName(), (Object)actual.hasUserName());
        Assert.assertEquals((String)"MqttConnectVariableHeader HasPassword mismatch ", (Object)expected.hasPassword(), (Object)actual.hasPassword());
        Assert.assertEquals((String)"MqttConnectVariableHeader IsCleanSession mismatch ", (Object)expected.isCleanSession(), (Object)actual.isCleanSession());
        Assert.assertEquals((String)"MqttConnectVariableHeader IsWillFlag mismatch ", (Object)expected.isWillFlag(), (Object)actual.isWillFlag());
        Assert.assertEquals((String)"MqttConnectVariableHeader IsWillRetain mismatch ", (Object)expected.isWillRetain(), (Object)actual.isWillRetain());
    }

    private static void validateConnectPayload(MqttConnectPayload expected, MqttConnectPayload actual) {
        Assert.assertEquals((String)"MqttConnectPayload ClientIdentifier mismatch ", (Object)expected.clientIdentifier(), (Object)actual.clientIdentifier());
        Assert.assertEquals((String)"MqttConnectPayload UserName mismatch ", (Object)expected.userName(), (Object)actual.userName());
        Assert.assertEquals((String)"MqttConnectPayload Password mismatch ", (Object)expected.password(), (Object)actual.password());
        Assert.assertTrue((String)"MqttConnectPayload Password bytes mismatch ", (boolean)Arrays.equals(expected.passwordInBytes(), actual.passwordInBytes()));
        Assert.assertEquals((String)"MqttConnectPayload WillMessage mismatch ", (Object)expected.willMessage(), (Object)actual.willMessage());
        Assert.assertTrue((String)"MqttConnectPayload WillMessage bytes mismatch ", (boolean)Arrays.equals(expected.willMessageInBytes(), actual.willMessageInBytes()));
        Assert.assertEquals((String)"MqttConnectPayload WillTopic mismatch ", (Object)expected.willTopic(), (Object)actual.willTopic());
    }

    private static void validateConnAckVariableHeader(MqttConnAckVariableHeader expected, MqttConnAckVariableHeader actual) {
        Assert.assertEquals((String)"MqttConnAckVariableHeader MqttConnectReturnCode mismatch", (Object)expected.connectReturnCode(), (Object)actual.connectReturnCode());
    }

    private static void validatePublishVariableHeader(MqttPublishVariableHeader expected, MqttPublishVariableHeader actual) {
        Assert.assertEquals((String)"MqttPublishVariableHeader TopicName mismatch ", (Object)expected.topicName(), (Object)actual.topicName());
        Assert.assertEquals((String)"MqttPublishVariableHeader MessageId mismatch ", (long)expected.messageId(), (long)actual.messageId());
    }

    private static void validatePublishPayload(ByteBuf expected, ByteBuf actual) {
        Assert.assertEquals((String)"PublishPayload mismatch ", (long)0L, (long)expected.compareTo(actual));
    }

    private static void validateMessageIdVariableHeader(MqttMessageIdVariableHeader expected, MqttMessageIdVariableHeader actual) {
        Assert.assertEquals((String)"MqttMessageIdVariableHeader MessageId mismatch ", (long)expected.messageId(), (long)actual.messageId());
    }

    private static void validateSubscribePayload(MqttSubscribePayload expected, MqttSubscribePayload actual) {
        List expectedTopicSubscriptions = expected.topicSubscriptions();
        List actualTopicSubscriptions = actual.topicSubscriptions();
        Assert.assertEquals((String)"MqttSubscribePayload TopicSubscriptionList size mismatch ", (long)expectedTopicSubscriptions.size(), (long)actualTopicSubscriptions.size());
        for (int i = 0; i < expectedTopicSubscriptions.size(); ++i) {
            MqttCodecTest.validateTopicSubscription((MqttTopicSubscription)expectedTopicSubscriptions.get(i), (MqttTopicSubscription)actualTopicSubscriptions.get(i));
        }
    }

    private static void validateTopicSubscription(MqttTopicSubscription expected, MqttTopicSubscription actual) {
        Assert.assertEquals((String)"MqttTopicSubscription TopicName mismatch ", (Object)expected.topicName(), (Object)actual.topicName());
        Assert.assertEquals((String)"MqttTopicSubscription Qos mismatch ", (Object)expected.qualityOfService(), (Object)actual.qualityOfService());
    }

    private static void validateSubAckPayload(MqttSubAckPayload expected, MqttSubAckPayload actual) {
        Assert.assertArrayEquals((String)"MqttSubAckPayload GrantedQosLevels mismatch ", (Object[])expected.grantedQoSLevels().toArray(), (Object[])actual.grantedQoSLevels().toArray());
    }

    private static void validateUnsubscribePayload(MqttUnsubscribePayload expected, MqttUnsubscribePayload actual) {
        Assert.assertArrayEquals((String)"MqttUnsubscribePayload TopicList mismatch ", (Object[])expected.topics().toArray(), (Object[])actual.topics().toArray());
    }

    private static void validateDecoderExceptionTooLargeMessage(MqttMessage message) {
        Assert.assertNull((String)"MqttMessage payload expected null ", (Object)message.payload());
        Assert.assertTrue((boolean)message.decoderResult().isFailure());
        Throwable cause = message.decoderResult().cause();
        Assert.assertTrue((String)"MqttMessage DecoderResult cause expected instance of DecoderException ", (boolean)(cause instanceof DecoderException));
        Assert.assertTrue((String)"MqttMessage DecoderResult cause reason expect to contain 'too large message' ", (boolean)cause.getMessage().contains("too large message:"));
    }
}

