/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import io.netty.util.CharsetUtil;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class MqttConnectPayloadTest {
    @Test
    public void testNullWillMessage() throws Exception {
        String clientIdentifier = "clientIdentifier";
        String willTopic = "willTopic";
        byte[] willMessage = null;
        String userName = "userName";
        byte[] password = "password".getBytes(CharsetUtil.UTF_8);
        MqttConnectPayload mqttConnectPayload = new MqttConnectPayload(clientIdentifier, willTopic, willMessage, userName, password);
        Assert.assertNull((Object)mqttConnectPayload.willMessageInBytes());
        Assert.assertNull((Object)mqttConnectPayload.willMessage());
    }

    @Test
    public void testNullPassword() throws Exception {
        String clientIdentifier = "clientIdentifier";
        String willTopic = "willTopic";
        byte[] willMessage = "willMessage".getBytes(CharsetUtil.UTF_8);
        String userName = "userName";
        byte[] password = null;
        MqttConnectPayload mqttConnectPayload = new MqttConnectPayload(clientIdentifier, willTopic, willMessage, userName, password);
        Assert.assertNull((Object)mqttConnectPayload.passwordInBytes());
        Assert.assertNull((Object)mqttConnectPayload.password());
    }

    @Test
    public void testBuilderNullPassword() throws Exception {
        MqttMessageBuilders.ConnectBuilder builder = new MqttMessageBuilders.ConnectBuilder();
        builder.password((String)null);
        MqttConnectPayload mqttConnectPayload = builder.build().payload();
        Assert.assertNull((Object)mqttConnectPayload.passwordInBytes());
        Assert.assertNull((Object)mqttConnectPayload.password());
        builder = new MqttMessageBuilders.ConnectBuilder();
        builder.password((byte[])null);
        mqttConnectPayload = builder.build().payload();
        Assert.assertNull((Object)mqttConnectPayload.passwordInBytes());
        Assert.assertNull((Object)mqttConnectPayload.password());
    }

    @Test
    public void testBuilderNullWillMessage() throws Exception {
        MqttMessageBuilders.ConnectBuilder builder = new MqttMessageBuilders.ConnectBuilder();
        builder.willMessage((String)null);
        MqttConnectPayload mqttConnectPayload = builder.build().payload();
        Assert.assertNull((Object)mqttConnectPayload.willMessageInBytes());
        Assert.assertNull((Object)mqttConnectPayload.willMessage());
        builder = new MqttMessageBuilders.ConnectBuilder();
        builder.willMessage((byte[])null);
        mqttConnectPayload = builder.build().payload();
        Assert.assertNull((Object)mqttConnectPayload.willMessageInBytes());
        Assert.assertNull((Object)mqttConnectPayload.willMessage());
    }

    @Test
    public void testEmptyTopicsToString() {
        new MqttSubscribePayload(Collections.emptyList()).toString();
        new MqttUnsubscribePayload(Collections.emptyList()).toString();
    }
}

