/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.mqtt.MqttCodecUtil;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttMessageIdAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import io.netty.handler.codec.mqtt.MqttTestUtils;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.util.Attribute;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class MqttCodecTest {
    private static final String CLIENT_ID = "RANDOM_TEST_CLIENT";
    private static final String WILL_TOPIC = "/my_will";
    private static final String WILL_MESSAGE = "gone";
    private static final String USER_NAME = "happy_user";
    private static final String PASSWORD = "123_or_no_pwd";
    private static final int KEEP_ALIVE_SECONDS = 600;
    private static final ByteBufAllocator ALLOCATOR = new UnpooledByteBufAllocator(false);
    private static final int DEFAULT_MAX_BYTES_IN_MESSAGE = 8092;
    @Mock
    private final ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
    @Mock
    private final Channel channel = (Channel)Mockito.mock(Channel.class);
    @Mock
    private final Attribute<MqttVersion> versionAttrMock = (Attribute)Mockito.mock(Attribute.class);
    private final List<Object> out = new ArrayList<Object>();
    private final MqttDecoder mqttDecoder = new MqttDecoder();
    private final MqttDecoder mqttDecoderLimitedMessageSize = new MqttDecoder(1);

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)ALLOCATOR);
        Mockito.when((Object)this.ctx.fireChannelRead(ArgumentMatchers.any())).then((Answer)new Answer<ChannelHandlerContext>(){

            public ChannelHandlerContext answer(InvocationOnMock invocation) {
                MqttCodecTest.this.out.add(invocation.getArguments()[0]);
                return MqttCodecTest.this.ctx;
            }
        });
        Mockito.when((Object)this.channel.attr(MqttCodecUtil.MQTT_VERSION_KEY)).thenReturn(this.versionAttrMock);
    }

    @AfterEach
    public void after() {
        for (Object o : this.out) {
            ReferenceCountUtil.release((Object)o);
        }
        this.out.clear();
    }

    @Test
    public void testConnectMessageForMqtt31() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttConnectMessage decodedMessage = (MqttConnectMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateConnectPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testConnectMessageForMqtt311() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttConnectMessage decodedMessage = (MqttConnectMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateConnectPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testConnectMessageWithNonZeroReservedFlagForMqtt311() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        byteBuf.setByte(9, byteBuf.getByte(9) | 1);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        Assertions.assertTrue((boolean)decodedMessage.decoderResult().isFailure());
        Throwable cause = decodedMessage.decoderResult().cause();
        MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(DecoderException.class));
        Assertions.assertEquals((Object)"non-zero reserved flag", (Object)cause.getMessage());
    }

    @Test
    public void testConnectMessageNonZeroReservedBit0Mqtt311() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        byte firstByte = byteBuf.getByte(0);
        byteBuf.setByte(0, (int)((byte)(firstByte | 1)));
        LinkedList<Object> out = new LinkedList<Object>();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        this.checkForSingleDecoderException(out);
    }

    @Test
    public void testConnectMessageNonZeroReservedBit1Mqtt311() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        byte firstByte = byteBuf.getByte(0);
        byteBuf.setByte(0, (int)((byte)(firstByte | 2)));
        LinkedList<Object> out = new LinkedList<Object>();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        this.checkForSingleDecoderException(out);
    }

    @Test
    public void testConnectMessageNonZeroReservedBit2Mqtt311() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        byte firstByte = byteBuf.getByte(0);
        byteBuf.setByte(0, (int)((byte)(firstByte | 4)));
        LinkedList<Object> out = new LinkedList<Object>();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        this.checkForSingleDecoderException(out);
    }

    @Test
    public void testConnectMessageNonZeroReservedBit3Mqtt311() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        byte firstByte = byteBuf.getByte(0);
        byteBuf.setByte(0, (int)((byte)(firstByte | 8)));
        LinkedList<Object> out = new LinkedList<Object>();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        this.checkForSingleDecoderException(out);
    }

    @Test
    public void testSubscribeMessageNonZeroReservedBit0Mqtt311() throws Exception {
        MqttSubscribeMessage message = MqttCodecTest.createSubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        byte firstByte = byteBuf.getByte(0);
        byteBuf.setByte(0, (int)((byte)(firstByte | 1)));
        LinkedList<Object> out = new LinkedList<Object>();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        this.checkForSingleDecoderException(out);
    }

    @Test
    public void testSubscribeMessageZeroReservedBit1Mqtt311() throws Exception {
        MqttSubscribeMessage message = MqttCodecTest.createSubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        byte firstByte = byteBuf.getByte(0);
        byteBuf.setByte(0, (int)((byte)(firstByte & 0xFFFFFFFD)));
        LinkedList<Object> out = new LinkedList<Object>();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        this.checkForSingleDecoderException(out);
    }

    private void checkForSingleDecoderException(List<Object> out) {
        Assertions.assertEquals((int)1, (int)out.size());
        MatcherAssert.assertThat((Object)out.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(MqttConnectMessage.class)));
        MqttMessage result = (MqttMessage)out.get(0);
        MatcherAssert.assertThat((Object)result.decoderResult().cause(), (Matcher)CoreMatchers.instanceOf(DecoderException.class));
    }

    @Test
    public void testConnectMessageNoPassword() throws Exception {
        final MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1, null, PASSWORD, MqttProperties.NO_PROPERTIES, MqttProperties.NO_PROPERTIES);
        Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

            public void execute() {
                MqttEncoder.doEncode((ChannelHandlerContext)MqttCodecTest.this.ctx, (MqttMessage)message);
            }
        });
    }

    @Test
    public void testConnAckMessage() throws Exception {
        MqttConnAckMessage message = MqttCodecTest.createConnAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttConnAckMessage decodedMessage = (MqttConnAckMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnAckVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
    }

    @Test
    public void testPublishMessage() throws Exception {
        MqttPublishMessage message = MqttCodecTest.createPublishMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttPublishMessage decodedMessage = (MqttPublishMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validatePublishVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validatePublishPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testPubAckMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBACK);
    }

    @Test
    public void testPubRecMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBREC);
    }

    @Test
    public void testPubRelMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBREL);
    }

    @Test
    public void testPubCompMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBCOMP);
    }

    @Test
    public void testSubscribeMessage() throws Exception {
        MqttSubscribeMessage message = MqttCodecTest.createSubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttSubscribeMessage decodedMessage = (MqttSubscribeMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttTestUtils.validateSubscribePayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testSubAckMessage() throws Exception {
        MqttSubAckMessage message = MqttCodecTest.createSubAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttSubAckMessage decodedMessage = (MqttSubAckMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateSubAckPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testSubAckMessageWithFailureInPayload() throws Exception {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        MqttSubAckPayload mqttSubAckPayload = new MqttSubAckPayload(new int[]{MqttQoS.FAILURE.value()});
        MqttSubAckMessage message = new MqttSubAckMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttSubAckPayload);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttSubAckMessage decodedMessage = (MqttSubAckMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateSubAckPayload(message.payload(), decodedMessage.payload());
        Assertions.assertEquals((int)1, (int)decodedMessage.payload().grantedQoSLevels().size());
        Assertions.assertEquals((Object)MqttQoS.FAILURE, (Object)MqttQoS.valueOf((int)((Integer)decodedMessage.payload().grantedQoSLevels().get(0))));
    }

    @Test
    public void testUnSubscribeMessage() throws Exception {
        MqttUnsubscribeMessage message = MqttCodecTest.createUnsubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttUnsubscribeMessage decodedMessage = (MqttUnsubscribeMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttTestUtils.validateUnsubscribePayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testUnsubAckMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.UNSUBACK);
    }

    @Test
    public void testPingReqMessage() throws Exception {
        this.testMessageWithOnlyFixedHeader(MqttMessage.PINGREQ);
    }

    @Test
    public void testPingRespMessage() throws Exception {
        this.testMessageWithOnlyFixedHeader(MqttMessage.PINGRESP);
    }

    @Test
    public void testDisconnectMessage() throws Exception {
        this.testMessageWithOnlyFixedHeader(MqttMessage.DISCONNECT);
    }

    @Test
    public void testUnknownMessageType() throws Exception {
        MqttMessage message = MqttCodecTest.createMessageWithFixedHeader(MqttMessageType.PINGREQ);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        byteBuf.setByte(0, 240);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        Assertions.assertTrue((boolean)decodedMessage.decoderResult().isFailure());
        Throwable cause = decodedMessage.decoderResult().cause();
        MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(DecoderException.class));
        Assertions.assertEquals((Object)"AUTH message requires at least MQTT 5", (Object)cause.getMessage());
    }

    @Test
    public void testConnectMessageForMqtt31TooLarge() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoderLimitedMessageSize.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        Assertions.assertEquals((int)0, (int)byteBuf.readableBytes());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), (MqttConnectVariableHeader)decodedMessage.variableHeader());
        MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
    }

    @Test
    public void testConnectMessageForMqtt311TooLarge() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoderLimitedMessageSize.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        Assertions.assertEquals((int)0, (int)byteBuf.readableBytes());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), (MqttConnectVariableHeader)decodedMessage.variableHeader());
        MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
    }

    @Test
    public void testConnAckMessageTooLarge() throws Exception {
        MqttConnAckMessage message = MqttCodecTest.createConnAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoderLimitedMessageSize.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        Assertions.assertEquals((int)0, (int)byteBuf.readableBytes());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
    }

    @Test
    public void testPublishMessageTooLarge() throws Exception {
        MqttPublishMessage message = MqttCodecTest.createPublishMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoderLimitedMessageSize.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        Assertions.assertEquals((int)0, (int)byteBuf.readableBytes());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validatePublishVariableHeader(message.variableHeader(), (MqttPublishVariableHeader)decodedMessage.variableHeader());
        MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
    }

    @Test
    public void testSubscribeMessageTooLarge() throws Exception {
        MqttSubscribeMessage message = MqttCodecTest.createSubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoderLimitedMessageSize.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        Assertions.assertEquals((int)0, (int)byteBuf.readableBytes());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
        MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
    }

    @Test
    public void testSubAckMessageTooLarge() throws Exception {
        MqttSubAckMessage message = MqttCodecTest.createSubAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoderLimitedMessageSize.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        Assertions.assertEquals((int)0, (int)byteBuf.readableBytes());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
        MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
    }

    @Test
    public void testUnSubscribeMessageTooLarge() throws Exception {
        MqttUnsubscribeMessage message = MqttCodecTest.createUnsubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoderLimitedMessageSize.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        Assertions.assertEquals((int)0, (int)byteBuf.readableBytes());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
        MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
    }

    @Test
    public void testConnectMessageForMqtt5() throws Exception {
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value(), Integer.valueOf(10)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.AUTHENTICATION_METHOD.value(), "Plain"));
        MqttProperties willProps = new MqttProperties();
        willProps.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.WILL_DELAY_INTERVAL.value(), Integer.valueOf(100)));
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_5, USER_NAME, PASSWORD, props, willProps);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttConnectMessage decodedMessage = (MqttConnectMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateConnectPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testConnAckMessageForMqtt5() throws Exception {
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value(), Integer.valueOf(10)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.MAXIMUM_QOS.value(), Integer.valueOf(1)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.MAXIMUM_PACKET_SIZE.value(), Integer.valueOf(1000)));
        MqttConnAckMessage message = MqttCodecTest.createConnAckMessage(props);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttConnAckMessage decodedMessage = (MqttConnAckMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnAckVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
    }

    @Test
    public void testPublishMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(10)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(20)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("isSecret", "true"));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("tag", "firstTag"));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("tag", "secondTag"));
        Assertions.assertEquals((int)2, (int)props.getProperties(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value()).size());
        Assertions.assertEquals((int)3, (int)props.getProperties(MqttProperties.MqttPropertyType.USER_PROPERTY.value()).size());
        Assertions.assertEquals((int)3, (int)((List)((MqttProperties.UserProperties)props.getProperty((int)MqttProperties.MqttPropertyType.USER_PROPERTY.value())).value).size());
        MqttPublishMessage message = MqttCodecTest.createPublishMessage(props);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttPublishMessage decodedMessage = (MqttPublishMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validatePublishVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validatePublishPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testPubAckMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        MqttMessage message = this.createPubAckMessage((byte)-121, props);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validatePubReplyVariableHeader((MqttPubReplyMessageVariableHeader)message.variableHeader(), (MqttPubReplyMessageVariableHeader)decodedMessage.variableHeader());
    }

    @Test
    public void testPubAckMessageSkipCodeForMqtt5() throws Exception {
        MqttMessage message = this.createPubAckMessage((byte)0, MqttProperties.NO_PROPERTIES);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validatePubReplyVariableHeader((MqttPubReplyMessageVariableHeader)message.variableHeader(), (MqttPubReplyMessageVariableHeader)decodedMessage.variableHeader());
    }

    @Test
    public void testSubAckMessageForMqtt5() throws Exception {
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        MqttSubAckMessage message = MqttCodecTest.createSubAckMessage(props, new int[]{1, 2, 0, 135});
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttSubAckMessage decodedMessage = (MqttSubAckMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        this.validatePacketIdAndPropertiesVariableHeader((MqttMessageIdAndPropertiesVariableHeader)message.variableHeader(), (MqttMessageIdAndPropertiesVariableHeader)decodedMessage.variableHeader());
        MqttCodecTest.validateSubAckPayload(message.payload(), decodedMessage.payload());
        Assertions.assertArrayEquals((Object[])new Integer[]{1, 2, 0, 128}, (Object[])decodedMessage.payload().grantedQoSLevels().toArray());
    }

    @Test
    public void testSubscribeMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        MqttSubscribeMessage message = MqttMessageBuilders.subscribe().messageId(1).properties(props).addSubscription("/topic", new MqttSubscriptionOption(MqttQoS.AT_LEAST_ONCE, true, true, MqttSubscriptionOption.RetainedHandlingPolicy.SEND_AT_SUBSCRIBE_IF_NOT_YET_EXISTS)).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttSubscribeMessage decodedMessage = (MqttSubscribeMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttMessageIdAndPropertiesVariableHeader expectedHeader = (MqttMessageIdAndPropertiesVariableHeader)message.variableHeader();
        MqttMessageIdAndPropertiesVariableHeader actualHeader = (MqttMessageIdAndPropertiesVariableHeader)decodedMessage.variableHeader();
        this.validatePacketIdAndPropertiesVariableHeader(expectedHeader, actualHeader);
        MqttTestUtils.validateSubscribePayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testSubscribeMessageMqtt5EncodeAsMqtt3() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_3_1_1);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        MqttSubscribeMessage message = MqttMessageBuilders.subscribe().messageId(1).properties(props).addSubscription("/topic", new MqttSubscriptionOption(MqttQoS.AT_LEAST_ONCE, true, true, MqttSubscriptionOption.RetainedHandlingPolicy.SEND_AT_SUBSCRIBE_IF_NOT_YET_EXISTS)).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttSubscribeMessage decodedMessage = (MqttSubscribeMessage)this.out.get(0);
        MqttSubscribeMessage expectedMessage = MqttMessageBuilders.subscribe().messageId(1).addSubscription("/topic", MqttSubscriptionOption.onlyFromQos((MqttQoS)MqttQoS.AT_LEAST_ONCE)).build();
        MqttCodecTest.validateFixedHeaders(expectedMessage.fixedHeader(), decodedMessage.fixedHeader());
        MqttMessageIdAndPropertiesVariableHeader expectedHeader = (MqttMessageIdAndPropertiesVariableHeader)expectedMessage.variableHeader();
        MqttMessageIdAndPropertiesVariableHeader actualHeader = (MqttMessageIdAndPropertiesVariableHeader)decodedMessage.variableHeader();
        this.validatePacketIdAndPropertiesVariableHeader(expectedHeader, actualHeader);
        MqttTestUtils.validateSubscribePayload(expectedMessage.payload(), decodedMessage.payload());
    }

    @Test
    public void testUnsubAckMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        MqttUnsubAckMessage message = MqttMessageBuilders.unsubAck().packetId((short)1).properties(props).addReasonCode((short)131).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttUnsubAckMessage decodedMessage = (MqttUnsubAckMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        this.validatePacketIdAndPropertiesVariableHeader((MqttMessageIdAndPropertiesVariableHeader)message.variableHeader(), (MqttMessageIdAndPropertiesVariableHeader)decodedMessage.variableHeader());
        Assertions.assertEquals((Object)message.payload().unsubscribeReasonCodes(), (Object)decodedMessage.payload().unsubscribeReasonCodes());
    }

    @Test
    public void testDisconnectMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value(), Integer.valueOf(6)));
        MqttMessage message = MqttMessageBuilders.disconnect().reasonCode((byte)-106).properties(props).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        this.validateReasonCodeAndPropertiesVariableHeader((MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader(), (MqttReasonCodeAndPropertiesVariableHeader)decodedMessage.variableHeader());
    }

    @Test
    public void testDisconnectMessageSkipCodeForMqtt5() throws Exception {
        MqttMessage message = MqttMessageBuilders.disconnect().reasonCode((byte)0).properties(MqttProperties.NO_PROPERTIES).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        this.validateReasonCodeAndPropertiesVariableHeader((MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader(), (MqttReasonCodeAndPropertiesVariableHeader)decodedMessage.variableHeader());
    }

    @Test
    public void testAuthMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.BinaryProperty(MqttProperties.MqttPropertyType.AUTHENTICATION_DATA.value(), "secret".getBytes(CharsetUtil.UTF_8)));
        MqttMessage message = MqttMessageBuilders.auth().reasonCode((byte)24).properties(props).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        this.validateReasonCodeAndPropertiesVariableHeader((MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader(), (MqttReasonCodeAndPropertiesVariableHeader)decodedMessage.variableHeader());
    }

    @Test
    public void testMqttVersionDetection() throws Exception {
        Mockito.clearInvocations((Object[])new Attribute[]{this.versionAttrMock});
        MqttConnectMessage connectMessage = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_5);
        ByteBuf connectByteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)connectMessage);
        ((Attribute)Mockito.verify(this.versionAttrMock, (VerificationMode)Mockito.times((int)1))).set((Object)MqttVersion.MQTT_5);
        Mockito.clearInvocations((Object[])new Attribute[]{this.versionAttrMock});
        this.mqttDecoder.channelRead(this.ctx, (Object)connectByteBuf);
        ((Attribute)Mockito.verify(this.versionAttrMock, (VerificationMode)Mockito.times((int)1))).set((Object)MqttVersion.MQTT_5);
        Assertions.assertEquals((float)this.out.size(), (float)1.0f, (float)this.out.size());
        MqttConnectMessage decodedConnectMessage = (MqttConnectMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(connectMessage.fixedHeader(), decodedConnectMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(connectMessage.variableHeader(), decodedConnectMessage.variableHeader());
        MqttCodecTest.validateConnectPayload(connectMessage.payload(), decodedConnectMessage.payload());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.versionAttrMock});
    }

    private void testMessageWithOnlyFixedHeader(MqttMessage message) throws Exception {
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((int)1, (int)this.out.size());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
    }

    private void testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType messageType) throws Exception {
        MqttMessage message = MqttCodecTest.createMessageWithFixedHeaderAndMessageIdVariableHeader(messageType);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        this.mqttDecoder.channelRead(this.ctx, (Object)byteBuf);
        Assertions.assertEquals((float)this.out.size(), (float)1.0f, (float)this.out.size());
        MqttMessage decodedMessage = (MqttMessage)this.out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader((MqttMessageIdVariableHeader)message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
    }

    private static MqttMessage createMessageWithFixedHeader(MqttMessageType messageType) {
        return new MqttMessage(new MqttFixedHeader(messageType, false, MqttQoS.AT_MOST_ONCE, false, 0));
    }

    private static MqttMessage createMessageWithFixedHeaderAndMessageIdVariableHeader(MqttMessageType messageType) {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(messageType, false, messageType == MqttMessageType.PUBREL ? MqttQoS.AT_LEAST_ONCE : MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        return new MqttMessage(mqttFixedHeader, (Object)mqttMessageIdVariableHeader);
    }

    private static MqttConnectMessage createConnectMessage(MqttVersion mqttVersion) {
        return MqttCodecTest.createConnectMessage(mqttVersion, USER_NAME, PASSWORD, MqttProperties.NO_PROPERTIES, MqttProperties.NO_PROPERTIES);
    }

    private static MqttConnectMessage createConnectMessage(MqttVersion mqttVersion, String username, String password, MqttProperties properties, MqttProperties willProperties) {
        return MqttMessageBuilders.connect().clientId(CLIENT_ID).protocolVersion(mqttVersion).username(username).password(password.getBytes(CharsetUtil.UTF_8)).properties(properties).willRetain(true).willQoS(MqttQoS.AT_LEAST_ONCE).willFlag(true).willTopic(WILL_TOPIC).willMessage(WILL_MESSAGE.getBytes(CharsetUtil.UTF_8)).willProperties(willProperties).cleanSession(true).keepAlive(600).build();
    }

    private static MqttConnAckMessage createConnAckMessage() {
        return MqttCodecTest.createConnAckMessage(MqttProperties.NO_PROPERTIES);
    }

    private static MqttConnAckMessage createConnAckMessage(MqttProperties properties) {
        return MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_ACCEPTED).properties(properties).sessionPresent(true).build();
    }

    private static MqttPublishMessage createPublishMessage() {
        return MqttCodecTest.createPublishMessage(MqttProperties.NO_PROPERTIES);
    }

    private static MqttPublishMessage createPublishMessage(MqttProperties properties) {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_LEAST_ONCE, true, 0);
        MqttPublishVariableHeader mqttPublishVariableHeader = new MqttPublishVariableHeader("/abc", 1234, properties);
        ByteBuf payload = ALLOCATOR.buffer();
        payload.writeBytes("whatever".getBytes(CharsetUtil.UTF_8));
        return new MqttPublishMessage(mqttFixedHeader, mqttPublishVariableHeader, payload);
    }

    private static MqttSubscribeMessage createSubscribeMessage() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        LinkedList<MqttTopicSubscription> topicSubscriptions = new LinkedList<MqttTopicSubscription>();
        topicSubscriptions.add(new MqttTopicSubscription("/abc", MqttQoS.AT_LEAST_ONCE));
        topicSubscriptions.add(new MqttTopicSubscription("/def", MqttQoS.AT_LEAST_ONCE));
        topicSubscriptions.add(new MqttTopicSubscription("/xyz", MqttQoS.EXACTLY_ONCE));
        MqttSubscribePayload mqttSubscribePayload = new MqttSubscribePayload(topicSubscriptions);
        return new MqttSubscribeMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttSubscribePayload);
    }

    private static MqttSubAckMessage createSubAckMessage() {
        return MqttCodecTest.createSubAckMessage(MqttProperties.NO_PROPERTIES, new int[]{1, 2, 0});
    }

    private static MqttSubAckMessage createSubAckMessage(MqttProperties properties, int[] reasonCodes) {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        MqttSubAckPayload mqttSubAckPayload = new MqttSubAckPayload(reasonCodes);
        return new MqttSubAckMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttSubAckPayload);
    }

    private static MqttUnsubscribeMessage createUnsubscribeMessage() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        LinkedList<String> topics = new LinkedList<String>();
        topics.add("/abc");
        topics.add("/def");
        topics.add("/xyz");
        MqttUnsubscribePayload mqttUnsubscribePayload = new MqttUnsubscribePayload(topics);
        return new MqttUnsubscribeMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttUnsubscribePayload);
    }

    private MqttMessage createPubAckMessage(byte reasonCode, MqttProperties properties) {
        return MqttMessageBuilders.pubAck().packetId((short)1).reasonCode(reasonCode).properties(properties).build();
    }

    private static void validateFixedHeaders(MqttFixedHeader expected, MqttFixedHeader actual) {
        Assertions.assertEquals((Object)expected.messageType(), (Object)actual.messageType());
        Assertions.assertEquals((Object)expected.qosLevel(), (Object)actual.qosLevel());
    }

    private static void validateConnectVariableHeader(MqttConnectVariableHeader expected, MqttConnectVariableHeader actual) {
        Assertions.assertEquals((Object)expected.name(), (Object)actual.name());
        Assertions.assertEquals((int)expected.keepAliveTimeSeconds(), (int)actual.keepAliveTimeSeconds());
        Assertions.assertEquals((int)expected.version(), (int)actual.version());
        Assertions.assertEquals((int)expected.version(), (int)actual.version());
        MqttTestUtils.validateProperties(expected.properties(), actual.properties());
        Assertions.assertEquals((int)expected.willQos(), (int)actual.willQos());
        Assertions.assertEquals((Object)expected.hasUserName(), (Object)actual.hasUserName());
        Assertions.assertEquals((Object)expected.hasPassword(), (Object)actual.hasPassword());
        Assertions.assertEquals((Object)expected.isCleanSession(), (Object)actual.isCleanSession());
        Assertions.assertEquals((Object)expected.isWillFlag(), (Object)actual.isWillFlag());
        Assertions.assertEquals((Object)expected.isWillRetain(), (Object)actual.isWillRetain());
    }

    private static void validateConnectPayload(MqttConnectPayload expected, MqttConnectPayload actual) {
        Assertions.assertEquals((Object)expected.clientIdentifier(), (Object)actual.clientIdentifier());
        Assertions.assertEquals((Object)expected.userName(), (Object)actual.userName());
        Assertions.assertEquals((Object)expected.password(), (Object)actual.password());
        Assertions.assertArrayEquals((byte[])expected.passwordInBytes(), (byte[])actual.passwordInBytes());
        Assertions.assertEquals((Object)expected.willMessage(), (Object)actual.willMessage());
        Assertions.assertArrayEquals((byte[])expected.willMessageInBytes(), (byte[])actual.willMessageInBytes());
        Assertions.assertEquals((Object)expected.willTopic(), (Object)actual.willTopic());
        MqttTestUtils.validateProperties(expected.willProperties(), actual.willProperties());
    }

    private static void validateConnAckVariableHeader(MqttConnAckVariableHeader expected, MqttConnAckVariableHeader actual) {
        Assertions.assertEquals((Object)expected.connectReturnCode(), (Object)actual.connectReturnCode());
    }

    private static void validatePublishVariableHeader(MqttPublishVariableHeader expected, MqttPublishVariableHeader actual) {
        Assertions.assertEquals((Object)expected.topicName(), (Object)actual.topicName());
        Assertions.assertEquals((int)expected.packetId(), (int)actual.packetId());
        MqttTestUtils.validateProperties(expected.properties(), actual.properties());
    }

    private static void validatePublishPayload(ByteBuf expected, ByteBuf actual) {
        Assertions.assertEquals((int)0, (int)expected.compareTo(actual));
    }

    private static void validateMessageIdVariableHeader(MqttMessageIdVariableHeader expected, MqttMessageIdVariableHeader actual) {
        Assertions.assertEquals((int)expected.messageId(), (int)actual.messageId());
    }

    private static void validateSubAckPayload(MqttSubAckPayload expected, MqttSubAckPayload actual) {
        Assertions.assertArrayEquals((Object[])expected.reasonCodes().toArray(), (Object[])actual.reasonCodes().toArray());
        Assertions.assertArrayEquals((Object[])expected.grantedQoSLevels().toArray(), (Object[])actual.grantedQoSLevels().toArray());
    }

    private static void validateDecoderExceptionTooLargeMessage(MqttMessage message) {
        Assertions.assertNull((Object)message.payload());
        Assertions.assertTrue((boolean)message.decoderResult().isFailure());
        Throwable cause = message.decoderResult().cause();
        MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(DecoderException.class));
        Assertions.assertTrue((boolean)cause.getMessage().contains("too large message:"));
    }

    private static void validatePubReplyVariableHeader(MqttPubReplyMessageVariableHeader expected, MqttPubReplyMessageVariableHeader actual) {
        Assertions.assertEquals((int)expected.messageId(), (int)actual.messageId());
        Assertions.assertEquals((byte)expected.reasonCode(), (byte)actual.reasonCode());
        MqttProperties expectedProps = expected.properties();
        MqttProperties actualProps = actual.properties();
        MqttTestUtils.validateProperties(expectedProps, actualProps);
    }

    private void validatePacketIdAndPropertiesVariableHeader(MqttMessageIdAndPropertiesVariableHeader expected, MqttMessageIdAndPropertiesVariableHeader actual) {
        Assertions.assertEquals((int)expected.messageId(), (int)actual.messageId());
        MqttProperties expectedProps = expected.properties();
        MqttProperties actualProps = actual.properties();
        MqttTestUtils.validateProperties(expectedProps, actualProps);
    }

    private void validateReasonCodeAndPropertiesVariableHeader(MqttReasonCodeAndPropertiesVariableHeader expected, MqttReasonCodeAndPropertiesVariableHeader actual) {
        Assertions.assertEquals((byte)expected.reasonCode(), (byte)actual.reasonCode());
        MqttProperties expectedProps = expected.properties();
        MqttProperties actualProps = actual.properties();
        MqttTestUtils.validateProperties(expectedProps, actualProps);
    }
}

