/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import java.util.List;
import org.junit.jupiter.api.Assertions;

public final class MqttTestUtils {
    private MqttTestUtils() {
    }

    public static void validateProperties(MqttProperties expected, MqttProperties actual) {
        block9: for (MqttProperties.MqttProperty expectedProperty : expected.listAll()) {
            MqttProperties.MqttProperty actualProperty = actual.getProperty(expectedProperty.propertyId);
            List actualProperties = actual.getProperties(expectedProperty.propertyId);
            switch (MqttProperties.MqttPropertyType.valueOf((int)expectedProperty.propertyId)) {
                case PAYLOAD_FORMAT_INDICATOR: 
                case REQUEST_PROBLEM_INFORMATION: 
                case REQUEST_RESPONSE_INFORMATION: 
                case MAXIMUM_QOS: 
                case RETAIN_AVAILABLE: 
                case WILDCARD_SUBSCRIPTION_AVAILABLE: 
                case SUBSCRIPTION_IDENTIFIER_AVAILABLE: 
                case SHARED_SUBSCRIPTION_AVAILABLE: {
                    Object expectedValue = (Integer)((MqttProperties.IntegerProperty)expectedProperty).value;
                    Object actualValue = (Integer)((MqttProperties.IntegerProperty)actualProperty).value;
                    Assertions.assertEquals((Integer)expectedValue, (Integer)actualValue, (String)"one byte property doesn't match");
                    break;
                }
                case SERVER_KEEP_ALIVE: 
                case RECEIVE_MAXIMUM: 
                case TOPIC_ALIAS_MAXIMUM: 
                case TOPIC_ALIAS: {
                    Object expectedValue = (Integer)((MqttProperties.IntegerProperty)expectedProperty).value;
                    Object actualValue = (Integer)((MqttProperties.IntegerProperty)actualProperty).value;
                    Assertions.assertEquals((Integer)expectedValue, (Integer)actualValue, (String)"two byte property doesn't match");
                    break;
                }
                case PUBLICATION_EXPIRY_INTERVAL: 
                case SESSION_EXPIRY_INTERVAL: 
                case WILL_DELAY_INTERVAL: 
                case MAXIMUM_PACKET_SIZE: {
                    Object expectedValue = (Integer)((MqttProperties.IntegerProperty)expectedProperty).value;
                    Object actualValue = (Integer)((MqttProperties.IntegerProperty)actualProperty).value;
                    Assertions.assertEquals((Integer)expectedValue, (Integer)actualValue, (String)"four byte property doesn't match");
                    break;
                }
                case SUBSCRIPTION_IDENTIFIER: {
                    Object expectedValue = (Integer)((MqttProperties.IntegerProperty)expectedProperty).value;
                    MqttTestUtils.assertContainsValue("Subscription ID doesn't match", (Integer)expectedValue, actualProperties);
                    break;
                }
                case CONTENT_TYPE: 
                case RESPONSE_TOPIC: 
                case ASSIGNED_CLIENT_IDENTIFIER: 
                case AUTHENTICATION_METHOD: 
                case RESPONSE_INFORMATION: 
                case SERVER_REFERENCE: 
                case REASON_STRING: {
                    Object expectedValue = (String)((MqttProperties.StringProperty)expectedProperty).value;
                    Object actualValue = (String)((MqttProperties.StringProperty)actualProperty).value;
                    Assertions.assertEquals((Object)expectedValue, (Object)actualValue, (String)"String property doesn't match");
                    break;
                }
                case USER_PROPERTY: {
                    List expectedPairs = (List)((MqttProperties.UserProperties)expectedProperty).value;
                    List actualPairs = (List)((MqttProperties.UserProperties)actualProperty).value;
                    Assertions.assertEquals((Object)expectedPairs, (Object)actualPairs, (String)"User properties count doesn't match");
                    for (int i = 0; i < expectedPairs.size(); ++i) {
                        Assertions.assertEquals(expectedPairs.get(i), actualPairs.get(i), (String)"User property mismatch");
                    }
                    continue block9;
                }
                case CORRELATION_DATA: 
                case AUTHENTICATION_DATA: {
                    Object expectedValue = (byte[])((MqttProperties.BinaryProperty)expectedProperty).value;
                    Object actualValue = (byte[])((MqttProperties.BinaryProperty)actualProperty).value;
                    String expectedHexDump = ByteBufUtil.hexDump((byte[])expectedValue);
                    String actualHexDump = ByteBufUtil.hexDump((byte[])actualValue);
                    Assertions.assertEquals((Object)expectedHexDump, (Object)actualHexDump, (String)"byte[] property doesn't match");
                    break;
                }
                default: {
                    Assertions.fail((String)("Property Id not recognized " + Integer.toHexString(expectedProperty.propertyId)));
                }
            }
        }
        for (MqttProperties.MqttProperty actualProperty : actual.listAll()) {
            MqttProperties.MqttProperty expectedProperty = expected.getProperty(actualProperty.propertyId);
            Assertions.assertNotNull((Object)expectedProperty, (String)("Property " + actualProperty.propertyId + " not expected"));
        }
    }

    private static void assertContainsValue(String message, Integer expectedValue, List<? extends MqttProperties.MqttProperty> properties) {
        for (MqttProperties.MqttProperty mqttProperty : properties) {
            if (!(mqttProperty instanceof MqttProperties.IntegerProperty) || ((MqttProperties.IntegerProperty)mqttProperty).value != expectedValue) continue;
            return;
        }
        Assertions.fail((String)(message + " - properties didn't contain expected integer value " + expectedValue + ": " + properties));
    }

    public static void validateSubscribePayload(MqttSubscribePayload expected, MqttSubscribePayload actual) {
        List expectedTopicSubscriptions = expected.topicSubscriptions();
        List actualTopicSubscriptions = actual.topicSubscriptions();
        Assertions.assertEquals((int)expectedTopicSubscriptions.size(), (int)actualTopicSubscriptions.size(), (String)"MqttSubscribePayload TopicSubscriptionList size mismatch");
        for (int i = 0; i < expectedTopicSubscriptions.size(); ++i) {
            MqttTestUtils.validateTopicSubscription((MqttTopicSubscription)expectedTopicSubscriptions.get(i), (MqttTopicSubscription)actualTopicSubscriptions.get(i));
        }
    }

    public static void validateTopicSubscription(MqttTopicSubscription expected, MqttTopicSubscription actual) {
        Assertions.assertEquals((Object)expected.topicName(), (Object)actual.topicName(), (String)"MqttTopicSubscription TopicName mismatch");
        Assertions.assertEquals((Object)expected.qualityOfService(), (Object)actual.qualityOfService(), (String)"MqttTopicSubscription Qos mismatch");
        Assertions.assertEquals((Object)expected.option(), (Object)actual.option(), (String)"MqttTopicSubscription options mismatch");
    }

    public static void validateUnsubscribePayload(MqttUnsubscribePayload expected, MqttUnsubscribePayload actual) {
        Assertions.assertArrayEquals((Object[])expected.topics().toArray(), (Object[])actual.topics().toArray(), (String)"MqttUnsubscribePayload TopicList mismatch");
    }
}

