/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class DefaultHeadersTest {
    private static TestDefaultHeaders newInstance() {
        return new TestDefaultHeaders();
    }

    @Test
    public void addShouldIncreaseAndRemoveShouldDecreaseTheSize() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        Assertions.assertEquals((int)0, (int)headers.size());
        headers.add(AsciiString.of((CharSequence)"name1"), new CharSequence[]{AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2")});
        Assertions.assertEquals((int)2, (int)headers.size());
        headers.add(AsciiString.of((CharSequence)"name2"), new CharSequence[]{AsciiString.of((CharSequence)"value3"), AsciiString.of((CharSequence)"value4")});
        Assertions.assertEquals((int)4, (int)headers.size());
        headers.add(AsciiString.of((CharSequence)"name3"), AsciiString.of((CharSequence)"value5"));
        Assertions.assertEquals((int)5, (int)headers.size());
        headers.remove(AsciiString.of((CharSequence)"name3"));
        Assertions.assertEquals((int)4, (int)headers.size());
        headers.remove(AsciiString.of((CharSequence)"name1"));
        Assertions.assertEquals((int)2, (int)headers.size());
        headers.remove(AsciiString.of((CharSequence)"name2"));
        Assertions.assertEquals((int)0, (int)headers.size());
        Assertions.assertTrue((boolean)headers.isEmpty());
    }

    @Test
    public void afterClearHeadersShouldBeEmpty() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        Assertions.assertEquals((int)2, (int)headers.size());
        headers.clear();
        Assertions.assertEquals((int)0, (int)headers.size());
        Assertions.assertTrue((boolean)headers.isEmpty());
        Assertions.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name1")));
        Assertions.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name2")));
    }

    @Test
    public void removingANameForASecondTimeShouldReturnFalse() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        Assertions.assertTrue((boolean)headers.remove(AsciiString.of((CharSequence)"name2")));
        Assertions.assertFalse((boolean)headers.remove(AsciiString.of((CharSequence)"name2")));
    }

    @Test
    public void multipleValuesPerNameShouldBeAllowed() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value2"));
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value3"));
        Assertions.assertEquals((int)3, (int)headers.size());
        List values = headers.getAll(AsciiString.of((CharSequence)"name"));
        Assertions.assertEquals((int)3, (int)values.size());
        Assertions.assertTrue((boolean)values.containsAll(Arrays.asList(AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2"), AsciiString.of((CharSequence)"value3"))));
    }

    @Test
    public void multipleValuesPerNameIteratorWithOtherNames() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value2"));
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value4"));
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value3"));
        Assertions.assertEquals((int)4, (int)headers.size());
        ArrayList values = new ArrayList();
        Iterator itr = headers.valueIterator(AsciiString.of((CharSequence)"name1"));
        while (itr.hasNext()) {
            values.add(itr.next());
            itr.remove();
        }
        Assertions.assertEquals((int)3, (int)values.size());
        Assertions.assertEquals((int)1, (int)headers.size());
        Assertions.assertFalse((boolean)headers.isEmpty());
        Assertions.assertTrue((boolean)values.containsAll(Arrays.asList(AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2"), AsciiString.of((CharSequence)"value3"))));
        itr = headers.valueIterator(AsciiString.of((CharSequence)"name1"));
        Assertions.assertFalse((boolean)itr.hasNext());
        itr = headers.valueIterator(AsciiString.of((CharSequence)"name2"));
        Assertions.assertTrue((boolean)itr.hasNext());
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"value4"), itr.next());
        Assertions.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void multipleValuesPerNameIterator() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value2"));
        Assertions.assertEquals((int)2, (int)headers.size());
        ArrayList values = new ArrayList();
        Iterator itr = headers.valueIterator(AsciiString.of((CharSequence)"name1"));
        while (itr.hasNext()) {
            values.add(itr.next());
            itr.remove();
        }
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((int)0, (int)headers.size());
        Assertions.assertTrue((boolean)headers.isEmpty());
        Assertions.assertTrue((boolean)values.containsAll(Arrays.asList(AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2"))));
        itr = headers.valueIterator(AsciiString.of((CharSequence)"name1"));
        Assertions.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void valuesItrRemoveThrowsWhenEmpty() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        Assertions.assertEquals((int)0, (int)headers.size());
        Assertions.assertTrue((boolean)headers.isEmpty());
        final Iterator itr = headers.valueIterator(AsciiString.of((CharSequence)"name"));
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                itr.remove();
            }
        });
    }

    @Test
    public void valuesItrRemoveThrowsAfterLastElement() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value1"));
        Assertions.assertEquals((int)1, (int)headers.size());
        ArrayList values = new ArrayList();
        Iterator itr = headers.valueIterator(AsciiString.of((CharSequence)"name"));
        while (itr.hasNext()) {
            values.add(itr.next());
            itr.remove();
        }
        Assertions.assertEquals((int)1, (int)values.size());
        Assertions.assertEquals((int)0, (int)headers.size());
        Assertions.assertTrue((boolean)headers.isEmpty());
        Assertions.assertTrue((boolean)values.contains(AsciiString.of((CharSequence)"value1")));
        try {
            itr.remove();
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void multipleValuesPerNameIteratorEmpty() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        ArrayList values = new ArrayList();
        Iterator itr = headers.valueIterator(AsciiString.of((CharSequence)"name"));
        while (itr.hasNext()) {
            values.add(itr.next());
        }
        Assertions.assertEquals((int)0, (int)values.size());
        try {
            itr.next();
            Assertions.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testContains() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.addBoolean(AsciiString.of((CharSequence)"boolean"), true);
        Assertions.assertTrue((boolean)headers.containsBoolean(AsciiString.of((CharSequence)"boolean"), true));
        Assertions.assertFalse((boolean)headers.containsBoolean(AsciiString.of((CharSequence)"boolean"), false));
        headers.addLong(AsciiString.of((CharSequence)"long"), Long.MAX_VALUE);
        Assertions.assertTrue((boolean)headers.containsLong(AsciiString.of((CharSequence)"long"), Long.MAX_VALUE));
        Assertions.assertFalse((boolean)headers.containsLong(AsciiString.of((CharSequence)"long"), Long.MIN_VALUE));
        headers.addInt(AsciiString.of((CharSequence)"int"), Integer.MIN_VALUE);
        Assertions.assertTrue((boolean)headers.containsInt(AsciiString.of((CharSequence)"int"), Integer.MIN_VALUE));
        Assertions.assertFalse((boolean)headers.containsInt(AsciiString.of((CharSequence)"int"), Integer.MAX_VALUE));
        headers.addShort(AsciiString.of((CharSequence)"short"), (short)Short.MAX_VALUE);
        Assertions.assertTrue((boolean)headers.containsShort(AsciiString.of((CharSequence)"short"), (short)Short.MAX_VALUE));
        Assertions.assertFalse((boolean)headers.containsShort(AsciiString.of((CharSequence)"short"), (short)Short.MIN_VALUE));
        headers.addChar(AsciiString.of((CharSequence)"char"), '\uffff');
        Assertions.assertTrue((boolean)headers.containsChar(AsciiString.of((CharSequence)"char"), '\uffff'));
        Assertions.assertFalse((boolean)headers.containsChar(AsciiString.of((CharSequence)"char"), '\u0000'));
        headers.addByte(AsciiString.of((CharSequence)"byte"), (byte)127);
        Assertions.assertTrue((boolean)headers.containsByte(AsciiString.of((CharSequence)"byte"), (byte)127));
        Assertions.assertFalse((boolean)headers.containsLong(AsciiString.of((CharSequence)"byte"), -128L));
        headers.addDouble(AsciiString.of((CharSequence)"double"), Double.MAX_VALUE);
        Assertions.assertTrue((boolean)headers.containsDouble(AsciiString.of((CharSequence)"double"), Double.MAX_VALUE));
        Assertions.assertFalse((boolean)headers.containsDouble(AsciiString.of((CharSequence)"double"), Double.MIN_VALUE));
        headers.addFloat(AsciiString.of((CharSequence)"float"), Float.MAX_VALUE);
        Assertions.assertTrue((boolean)headers.containsFloat(AsciiString.of((CharSequence)"float"), Float.MAX_VALUE));
        Assertions.assertFalse((boolean)headers.containsFloat(AsciiString.of((CharSequence)"float"), Float.MIN_VALUE));
        long millis = System.currentTimeMillis();
        headers.addTimeMillis(AsciiString.of((CharSequence)"millis"), millis);
        Assertions.assertTrue((boolean)headers.containsTimeMillis(AsciiString.of((CharSequence)"millis"), millis));
        Assertions.assertFalse((boolean)headers.containsTimeMillis(AsciiString.of((CharSequence)"millis"), 0L));
        headers.addObject(AsciiString.of((CharSequence)"object"), "Hello World");
        Assertions.assertTrue((boolean)headers.containsObject(AsciiString.of((CharSequence)"object"), "Hello World"));
        Assertions.assertFalse((boolean)headers.containsObject(AsciiString.of((CharSequence)"object"), ""));
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value"));
        Assertions.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value")));
        Assertions.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value1")));
    }

    @Test
    public void testCopy() throws Exception {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.addBoolean(AsciiString.of((CharSequence)"boolean"), true);
        headers.addLong(AsciiString.of((CharSequence)"long"), Long.MAX_VALUE);
        headers.addInt(AsciiString.of((CharSequence)"int"), Integer.MIN_VALUE);
        headers.addShort(AsciiString.of((CharSequence)"short"), (short)Short.MAX_VALUE);
        headers.addChar(AsciiString.of((CharSequence)"char"), '\uffff');
        headers.addByte(AsciiString.of((CharSequence)"byte"), (byte)127);
        headers.addDouble(AsciiString.of((CharSequence)"double"), Double.MAX_VALUE);
        headers.addFloat(AsciiString.of((CharSequence)"float"), Float.MAX_VALUE);
        long millis = System.currentTimeMillis();
        headers.addTimeMillis(AsciiString.of((CharSequence)"millis"), millis);
        headers.addObject(AsciiString.of((CharSequence)"object"), "Hello World");
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value"));
        headers = (TestDefaultHeaders)DefaultHeadersTest.newInstance().add((Headers)headers);
        Assertions.assertTrue((boolean)headers.containsBoolean(AsciiString.of((CharSequence)"boolean"), true));
        Assertions.assertFalse((boolean)headers.containsBoolean(AsciiString.of((CharSequence)"boolean"), false));
        Assertions.assertTrue((boolean)headers.containsLong(AsciiString.of((CharSequence)"long"), Long.MAX_VALUE));
        Assertions.assertFalse((boolean)headers.containsLong(AsciiString.of((CharSequence)"long"), Long.MIN_VALUE));
        Assertions.assertTrue((boolean)headers.containsInt(AsciiString.of((CharSequence)"int"), Integer.MIN_VALUE));
        Assertions.assertFalse((boolean)headers.containsInt(AsciiString.of((CharSequence)"int"), Integer.MAX_VALUE));
        Assertions.assertTrue((boolean)headers.containsShort(AsciiString.of((CharSequence)"short"), (short)Short.MAX_VALUE));
        Assertions.assertFalse((boolean)headers.containsShort(AsciiString.of((CharSequence)"short"), (short)Short.MIN_VALUE));
        Assertions.assertTrue((boolean)headers.containsChar(AsciiString.of((CharSequence)"char"), '\uffff'));
        Assertions.assertFalse((boolean)headers.containsChar(AsciiString.of((CharSequence)"char"), '\u0000'));
        Assertions.assertTrue((boolean)headers.containsByte(AsciiString.of((CharSequence)"byte"), (byte)127));
        Assertions.assertFalse((boolean)headers.containsLong(AsciiString.of((CharSequence)"byte"), -128L));
        Assertions.assertTrue((boolean)headers.containsDouble(AsciiString.of((CharSequence)"double"), Double.MAX_VALUE));
        Assertions.assertFalse((boolean)headers.containsDouble(AsciiString.of((CharSequence)"double"), Double.MIN_VALUE));
        Assertions.assertTrue((boolean)headers.containsFloat(AsciiString.of((CharSequence)"float"), Float.MAX_VALUE));
        Assertions.assertFalse((boolean)headers.containsFloat(AsciiString.of((CharSequence)"float"), Float.MIN_VALUE));
        Assertions.assertTrue((boolean)headers.containsTimeMillis(AsciiString.of((CharSequence)"millis"), millis));
        Assertions.assertFalse((boolean)headers.containsTimeMillis(AsciiString.of((CharSequence)"millis"), 0L));
        Assertions.assertTrue((boolean)headers.containsObject(AsciiString.of((CharSequence)"object"), "Hello World"));
        Assertions.assertFalse((boolean)headers.containsObject(AsciiString.of((CharSequence)"object"), ""));
        Assertions.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value")));
        Assertions.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value1")));
    }

    @Test
    public void canMixConvertedAndNormalValues() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value"));
        headers.addInt(AsciiString.of((CharSequence)"name"), 100);
        headers.addBoolean(AsciiString.of((CharSequence)"name"), false);
        Assertions.assertEquals((int)3, (int)headers.size());
        Assertions.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name")));
        Assertions.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value")));
        Assertions.assertTrue((boolean)headers.containsInt(AsciiString.of((CharSequence)"name"), 100));
        Assertions.assertTrue((boolean)headers.containsBoolean(AsciiString.of((CharSequence)"name"), false));
    }

    @Test
    public void testGetAndRemove() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name2"), new CharSequence[]{AsciiString.of((CharSequence)"value2"), AsciiString.of((CharSequence)"value3")});
        headers.add(AsciiString.of((CharSequence)"name3"), new CharSequence[]{AsciiString.of((CharSequence)"value4"), AsciiString.of((CharSequence)"value5"), AsciiString.of((CharSequence)"value6")});
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"value1"), (Object)headers.getAndRemove(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"defaultvalue")));
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"value2"), (Object)headers.getAndRemove(AsciiString.of((CharSequence)"name2")));
        Assertions.assertNull((Object)headers.getAndRemove(AsciiString.of((CharSequence)"name2")));
        Assertions.assertEquals(Arrays.asList(AsciiString.of((CharSequence)"value4"), AsciiString.of((CharSequence)"value5"), AsciiString.of((CharSequence)"value6")), (Object)headers.getAllAndRemove(AsciiString.of((CharSequence)"name3")));
        Assertions.assertEquals((int)0, (int)headers.size());
        Assertions.assertNull((Object)headers.getAndRemove(AsciiString.of((CharSequence)"noname")));
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"defaultvalue"), (Object)headers.getAndRemove(AsciiString.of((CharSequence)"noname"), AsciiString.of((CharSequence)"defaultvalue")));
    }

    @Test
    public void whenNameContainsMultipleValuesGetShouldReturnTheFirst() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), new CharSequence[]{AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2")});
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"value1"), (Object)headers.get(AsciiString.of((CharSequence)"name1")));
    }

    @Test
    public void getWithDefaultValueWorks() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"value1"), (Object)headers.get(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"defaultvalue")));
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"defaultvalue"), (Object)headers.get(AsciiString.of((CharSequence)"noname"), AsciiString.of((CharSequence)"defaultvalue")));
    }

    @Test
    public void setShouldOverWritePreviousValue() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.set(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value1"));
        headers.set(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value2"));
        Assertions.assertEquals((int)1, (int)headers.size());
        Assertions.assertEquals((int)1, (int)headers.getAll(AsciiString.of((CharSequence)"name")).size());
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"value2"), headers.getAll(AsciiString.of((CharSequence)"name")).get(0));
        Assertions.assertEquals((Object)AsciiString.of((CharSequence)"value2"), (Object)headers.get(AsciiString.of((CharSequence)"name")));
    }

    @Test
    public void setAllShouldOverwriteSomeAndLeaveOthersUntouched() {
        TestDefaultHeaders h1 = DefaultHeadersTest.newInstance();
        h1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        h1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        h1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value3"));
        h1.add(AsciiString.of((CharSequence)"name3"), AsciiString.of((CharSequence)"value4"));
        TestDefaultHeaders h2 = DefaultHeadersTest.newInstance();
        h2.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value5"));
        h2.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value6"));
        h2.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value7"));
        TestDefaultHeaders expected = DefaultHeadersTest.newInstance();
        expected.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value5"));
        expected.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value6"));
        expected.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value7"));
        expected.add(AsciiString.of((CharSequence)"name3"), AsciiString.of((CharSequence)"value4"));
        h1.setAll((Headers)h2);
        Assertions.assertEquals((Object)((Object)expected), (Object)((Object)h1));
    }

    @Test
    public void headersWithSameNamesAndValuesShouldBeEquivalent() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        headers1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value3"));
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        headers2.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers2.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        headers2.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value3"));
        Assertions.assertEquals((Object)((Object)headers1), (Object)((Object)headers2));
        Assertions.assertEquals((Object)((Object)headers2), (Object)((Object)headers1));
        Assertions.assertEquals((Object)((Object)headers1), (Object)((Object)headers1));
        Assertions.assertEquals((Object)((Object)headers2), (Object)((Object)headers2));
        Assertions.assertEquals((int)headers1.hashCode(), (int)headers2.hashCode());
        Assertions.assertEquals((int)headers1.hashCode(), (int)headers1.hashCode());
        Assertions.assertEquals((int)headers2.hashCode(), (int)headers2.hashCode());
    }

    @Test
    public void emptyHeadersShouldBeEqual() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        Assertions.assertNotSame((Object)((Object)headers1), (Object)((Object)headers2));
        Assertions.assertEquals((Object)((Object)headers1), (Object)((Object)headers2));
        Assertions.assertEquals((int)headers1.hashCode(), (int)headers2.hashCode());
    }

    @Test
    public void headersWithSameNamesButDifferentValuesShouldNotBeEquivalent() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value2"));
        Assertions.assertNotEquals((Object)((Object)headers1), (Object)((Object)headers2));
    }

    @Test
    public void subsetOfHeadersShouldNotBeEquivalent() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        Assertions.assertNotEquals((Object)((Object)headers1), (Object)((Object)headers2));
    }

    @Test
    public void headersWithDifferentNamesAndValuesShouldNotBeEquivalent() {
        TestDefaultHeaders h1 = DefaultHeadersTest.newInstance();
        h1.set(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        TestDefaultHeaders h2 = DefaultHeadersTest.newInstance();
        h2.set(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        Assertions.assertNotEquals((Object)((Object)h1), (Object)((Object)h2));
        Assertions.assertNotEquals((Object)((Object)h2), (Object)((Object)h1));
        Assertions.assertEquals((Object)((Object)h1), (Object)((Object)h1));
        Assertions.assertEquals((Object)((Object)h2), (Object)((Object)h2));
    }

    @Test
    public void iterateEmptyHeadersShouldThrow() {
        final Iterator iterator = DefaultHeadersTest.newInstance().iterator();
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(){

            public void execute() {
                iterator.next();
            }
        });
    }

    @Test
    public void iteratorShouldReturnAllNameValuePairs() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name1"), new CharSequence[]{AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2")});
        headers1.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value3"));
        headers1.add(AsciiString.of((CharSequence)"name3"), new CharSequence[]{AsciiString.of((CharSequence)"value4"), AsciiString.of((CharSequence)"value5"), AsciiString.of((CharSequence)"value6")});
        headers1.add(AsciiString.of((CharSequence)"name1"), new CharSequence[]{AsciiString.of((CharSequence)"value7"), AsciiString.of((CharSequence)"value8")});
        Assertions.assertEquals((int)8, (int)headers1.size());
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        Iterator iterator = headers1.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            headers2.add(entry.getKey(), entry.getValue());
        }
        Assertions.assertEquals((Object)((Object)headers1), (Object)((Object)headers2));
    }

    @Test
    public void iteratorSetValueShouldChangeHeaderValue() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), new CharSequence[]{AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2"), AsciiString.of((CharSequence)"value3")});
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value4"));
        Assertions.assertEquals((int)4, (int)headers.size());
        Iterator iter = headers.iterator();
        while (iter.hasNext()) {
            Map.Entry header = (Map.Entry)iter.next();
            if (AsciiString.of((CharSequence)"name1").equals(header.getKey()) && AsciiString.of((CharSequence)"value2").equals(header.getValue())) {
                header.setValue(AsciiString.of((CharSequence)"updatedvalue2"));
                Assertions.assertEquals((Object)AsciiString.of((CharSequence)"updatedvalue2"), header.getValue());
            }
            if (!AsciiString.of((CharSequence)"name1").equals(header.getKey()) || !AsciiString.of((CharSequence)"value3").equals(header.getValue())) continue;
            header.setValue(AsciiString.of((CharSequence)"updatedvalue3"));
            Assertions.assertEquals((Object)AsciiString.of((CharSequence)"updatedvalue3"), header.getValue());
        }
        Assertions.assertEquals((int)4, (int)headers.size());
        Assertions.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"updatedvalue2")));
        Assertions.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value2")));
        Assertions.assertTrue((boolean)headers.contains(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"updatedvalue3")));
        Assertions.assertFalse((boolean)headers.contains(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value3")));
    }

    @Test
    public void testEntryEquals() {
        Map.Entry same1 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name", "value")).iterator().next();
        Map.Entry same2 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name", "value")).iterator().next();
        Assertions.assertEquals((Object)same1, (Object)same2);
        Assertions.assertEquals((int)same1.hashCode(), (int)same2.hashCode());
        Map.Entry nameDifferent1 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name1", "value")).iterator().next();
        Map.Entry nameDifferent2 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name2", "value")).iterator().next();
        Assertions.assertNotEquals((Object)nameDifferent1, (Object)nameDifferent2);
        Assertions.assertNotEquals((int)nameDifferent1.hashCode(), (int)nameDifferent2.hashCode());
        Map.Entry valueDifferent1 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name", "value1")).iterator().next();
        Map.Entry valueDifferent2 = (Map.Entry)((TestDefaultHeaders)DefaultHeadersTest.newInstance().add("name", "value2")).iterator().next();
        Assertions.assertNotEquals((Object)valueDifferent1, (Object)valueDifferent2);
        Assertions.assertNotEquals((int)valueDifferent1.hashCode(), (int)valueDifferent2.hashCode());
    }

    @Test
    public void getAllReturnsEmptyListForUnknownName() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        Assertions.assertEquals((int)0, (int)headers.getAll(AsciiString.of((CharSequence)"noname")).size());
    }

    @Test
    public void setHeadersShouldClearAndOverwrite() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value"));
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        headers2.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"newvalue"));
        headers2.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers1.set((Headers)headers2);
        Assertions.assertEquals((Object)((Object)headers1), (Object)((Object)headers2));
    }

    @Test
    public void setAllHeadersShouldOnlyOverwriteHeaders() {
        TestDefaultHeaders headers1 = DefaultHeadersTest.newInstance();
        headers1.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"value"));
        headers1.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        TestDefaultHeaders headers2 = DefaultHeadersTest.newInstance();
        headers2.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"newvalue"));
        headers2.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        TestDefaultHeaders expected = DefaultHeadersTest.newInstance();
        expected.add(AsciiString.of((CharSequence)"name"), AsciiString.of((CharSequence)"newvalue"));
        expected.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        expected.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        headers1.setAll((Headers)headers2);
        Assertions.assertEquals((Object)((Object)headers1), (Object)((Object)expected));
    }

    @Test
    public void testAddSelf() {
        final TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                headers.add((Headers)headers);
            }
        });
    }

    @Test
    public void testSetSelfIsNoOp() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add("name", "value");
        headers.set((Headers)headers);
        Assertions.assertEquals((int)1, (int)headers.size());
    }

    @Test
    public void testToString() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value2"));
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value3"));
        Assertions.assertEquals((Object)"TestDefaultHeaders[name1: value1, name1: value2, name2: value3]", (Object)headers.toString());
        headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        headers.add(AsciiString.of((CharSequence)"name2"), AsciiString.of((CharSequence)"value2"));
        headers.add(AsciiString.of((CharSequence)"name3"), AsciiString.of((CharSequence)"value3"));
        Assertions.assertEquals((Object)"TestDefaultHeaders[name1: value1, name2: value2, name3: value3]", (Object)headers.toString());
        headers = DefaultHeadersTest.newInstance();
        headers.add(AsciiString.of((CharSequence)"name1"), AsciiString.of((CharSequence)"value1"));
        Assertions.assertEquals((Object)"TestDefaultHeaders[name1: value1]", (Object)headers.toString());
        headers = DefaultHeadersTest.newInstance();
        Assertions.assertEquals((Object)"TestDefaultHeaders[]", (Object)headers.toString());
    }

    @Test
    public void testNotThrowWhenConvertFails() {
        TestDefaultHeaders headers = new TestDefaultHeaders(new ValueConverter<CharSequence>(){

            public CharSequence convertObject(Object value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertBoolean(boolean value) {
                throw new IllegalArgumentException();
            }

            public boolean convertToBoolean(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertByte(byte value) {
                throw new IllegalArgumentException();
            }

            public byte convertToByte(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertChar(char value) {
                throw new IllegalArgumentException();
            }

            public char convertToChar(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertShort(short value) {
                throw new IllegalArgumentException();
            }

            public short convertToShort(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertInt(int value) {
                throw new IllegalArgumentException();
            }

            public int convertToInt(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertLong(long value) {
                throw new IllegalArgumentException();
            }

            public long convertToLong(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertTimeMillis(long value) {
                throw new IllegalArgumentException();
            }

            public long convertToTimeMillis(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertFloat(float value) {
                throw new IllegalArgumentException();
            }

            public float convertToFloat(CharSequence value) {
                throw new IllegalArgumentException();
            }

            public CharSequence convertDouble(double value) {
                throw new IllegalArgumentException();
            }

            public double convertToDouble(CharSequence value) {
                throw new IllegalArgumentException();
            }
        });
        headers.set("name1", "");
        Assertions.assertNull((Object)headers.getInt("name1"));
        Assertions.assertEquals((int)1, (int)headers.getInt("name1", 1));
        Assertions.assertNull((Object)headers.getBoolean(""));
        Assertions.assertFalse((boolean)headers.getBoolean("name1", false));
        Assertions.assertNull((Object)headers.getByte("name1"));
        Assertions.assertEquals((int)1, (int)headers.getByte("name1", (byte)1));
        Assertions.assertNull((Object)headers.getChar("name"));
        Assertions.assertEquals((char)'n', (char)headers.getChar("name1", 'n'));
        Assertions.assertNull((Object)headers.getDouble("name"));
        Assertions.assertEquals((double)1.0, (double)headers.getDouble("name1", 1.0), (double)0.0);
        Assertions.assertNull((Object)headers.getFloat("name"));
        Assertions.assertEquals((float)Float.MAX_VALUE, (float)headers.getFloat("name1", Float.MAX_VALUE), (float)0.0f);
        Assertions.assertNull((Object)headers.getLong("name"));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)headers.getLong("name1", Long.MAX_VALUE));
        Assertions.assertNull((Object)headers.getShort("name"));
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)headers.getShort("name1", (short)Short.MAX_VALUE));
        Assertions.assertNull((Object)headers.getTimeMillis("name"));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)headers.getTimeMillis("name1", Long.MAX_VALUE));
    }

    @Test
    public void testGetBooleanInvalidValue() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.set("name1", "invalid");
        headers.set("name2", new AsciiString((CharSequence)"invalid"));
        headers.set("name3", new StringBuilder("invalid"));
        Assertions.assertFalse((boolean)headers.getBoolean("name1", false));
        Assertions.assertFalse((boolean)headers.getBoolean("name2", false));
        Assertions.assertFalse((boolean)headers.getBoolean("name3", false));
    }

    @Test
    public void testGetBooleanFalseValue() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.set("name1", "false");
        headers.set("name2", new AsciiString((CharSequence)"false"));
        headers.set("name3", new StringBuilder("false"));
        Assertions.assertFalse((boolean)headers.getBoolean("name1", true));
        Assertions.assertFalse((boolean)headers.getBoolean("name2", true));
        Assertions.assertFalse((boolean)headers.getBoolean("name3", true));
    }

    @Test
    public void testGetBooleanTrueValue() {
        TestDefaultHeaders headers = DefaultHeadersTest.newInstance();
        headers.set("name1", "true");
        headers.set("name2", new AsciiString((CharSequence)"true"));
        headers.set("name3", new StringBuilder("true"));
        Assertions.assertTrue((boolean)headers.getBoolean("name1", false));
        Assertions.assertTrue((boolean)headers.getBoolean("name2", false));
        Assertions.assertTrue((boolean)headers.getBoolean("name3", false));
    }

    @Test
    public void handlingOfHeaderNameHashCollisions() {
        TestDefaultHeaders headers = new TestDefaultHeaders(new HashingStrategy<CharSequence>(){

            public int hashCode(CharSequence obj) {
                return 0;
            }

            public boolean equals(CharSequence a, CharSequence b) {
                return a.equals(b);
            }
        });
        headers.add("Cookie", "a=b; c=d; e=f");
        headers.add("other", "text/plain");
        DefaultHeadersTest.simulateCookieSplitting(headers);
        List cookies = headers.getAll("Cookie");
        MatcherAssert.assertThat((Object)cookies, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)cookies, (Matcher)Matchers.containsInAnyOrder((Object[])new CharSequence[]{"a=b", "c=d", "e=f"}));
    }

    static void simulateCookieSplitting(TestDefaultHeaders headers) {
        Iterator cookieItr = headers.valueIterator("Cookie");
        if (!cookieItr.hasNext()) {
            return;
        }
        ArrayList<String> cookiesToAdd = new ArrayList<String>();
        while (cookieItr.hasNext()) {
            String[] cookies = ((CharSequence)cookieItr.next()).toString().split("; ");
            cookiesToAdd.addAll(Arrays.asList(cookies));
            cookieItr.remove();
        }
        for (CharSequence charSequence : cookiesToAdd) {
            headers.add("Cookie", charSequence);
        }
    }

    private static final class TestDefaultHeaders
    extends DefaultHeaders<CharSequence, CharSequence, TestDefaultHeaders> {
        TestDefaultHeaders() {
            this((ValueConverter<CharSequence>)CharSequenceValueConverter.INSTANCE);
        }

        TestDefaultHeaders(ValueConverter<CharSequence> converter) {
            super(converter);
        }

        TestDefaultHeaders(HashingStrategy<CharSequence> nameHashingStrategy) {
            super(nameHashingStrategy, (ValueConverter)CharSequenceValueConverter.INSTANCE);
        }
    }
}

