/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DelimiterBasedFrameDecoderTest {
    @Test
    public void testMultipleLinesStrippedDelimiters() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, true, Delimiters.lineDelimiter())});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"TestLine\r\ng\r\n", (Charset)Charset.defaultCharset())});
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"TestLine", (Object)buf.toString(Charset.defaultCharset()));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"g", (Object)buf2.toString(Charset.defaultCharset()));
        Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        buf.release();
        buf2.release();
    }

    @Test
    public void testIncompleteLinesStrippedDelimiters() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, true, Delimiters.lineDelimiter())});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"Test", (Charset)Charset.defaultCharset())});
        Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"Line\r\ng\r\n", (Charset)Charset.defaultCharset())});
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"TestLine", (Object)buf.toString(Charset.defaultCharset()));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"g", (Object)buf2.toString(Charset.defaultCharset()));
        Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        buf.release();
        buf2.release();
    }

    @Test
    public void testMultipleLines() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, false, Delimiters.lineDelimiter())});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"TestLine\r\ng\r\n", (Charset)Charset.defaultCharset())});
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"TestLine\r\n", (Object)buf.toString(Charset.defaultCharset()));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"g\r\n", (Object)buf2.toString(Charset.defaultCharset()));
        Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        buf.release();
        buf2.release();
    }

    @Test
    public void testIncompleteLines() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, false, Delimiters.lineDelimiter())});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"Test", (Charset)Charset.defaultCharset())});
        Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"Line\r\ng\r\n", (Charset)Charset.defaultCharset())});
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"TestLine\r\n", (Object)buf.toString(Charset.defaultCharset()));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"g\r\n", (Object)buf2.toString(Charset.defaultCharset()));
        Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        buf.release();
        buf2.release();
    }

    @Test
    public void testDecode() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, true, Delimiters.lineDelimiter())});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"first\r\nsecond\nthird", (Charset)CharsetUtil.US_ASCII)});
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"first", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"second", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        ReferenceCountUtil.release((Object)ch.readInbound());
        buf.release();
        buf2.release();
    }
}

