/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.bytes;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.util.internal.EmptyArrays;
import java.util.Random;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ByteArrayEncoderTest {
    private EmbeddedChannel ch;

    @BeforeEach
    public void setUp() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new ByteArrayEncoder()});
    }

    @AfterEach
    public void tearDown() {
        MatcherAssert.assertThat((Object)this.ch.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testEncode() {
        byte[] b = new byte[2048];
        new Random().nextBytes(b);
        this.ch.writeOutbound(new Object[]{b});
        ByteBuf encoded = (ByteBuf)this.ch.readOutbound();
        MatcherAssert.assertThat((Object)encoded, (Matcher)CoreMatchers.is((Object)Unpooled.wrappedBuffer((byte[])b)));
        encoded.release();
    }

    @Test
    public void testEncodeEmpty() {
        this.ch.writeOutbound(new Object[]{EmptyArrays.EMPTY_BYTES});
        MatcherAssert.assertThat((Object)((ByteBuf)this.ch.readOutbound()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)Unpooled.EMPTY_BUFFER)));
    }

    @Test
    public void testEncodeOtherType() {
        String str = "Meep!";
        this.ch.writeOutbound(new Object[]{str});
        MatcherAssert.assertThat((Object)this.ch.readOutbound(), (Matcher)CoreMatchers.is((Object)str));
    }
}

