/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.serialization.CompatibleObjectEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompatibleObjectEncoderTest {
    @Test
    public void testMultipleEncodeReferenceCount() throws IOException, ClassNotFoundException {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CompatibleObjectEncoder()});
        CompatibleObjectEncoderTest.testEncode(channel, new TestSerializable(6, 8));
        CompatibleObjectEncoderTest.testEncode(channel, new TestSerializable(10, 5));
        CompatibleObjectEncoderTest.testEncode(channel, new TestSerializable(1, 5));
        Assertions.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testEncode(EmbeddedChannel channel, TestSerializable original) throws IOException, ClassNotFoundException {
        channel.writeOutbound(new Object[]{original});
        Object o = channel.readOutbound();
        ByteBuf buf = (ByteBuf)o;
        ObjectInputStream ois = new ObjectInputStream((InputStream)new ByteBufInputStream(buf));
        try {
            Assertions.assertEquals((Object)original, (Object)ois.readObject());
        }
        finally {
            buf.release();
            ois.close();
        }
    }

    private static final class TestSerializable
    implements Serializable {
        private static final long serialVersionUID = 2235771472534930360L;
        public final int x;
        public final int y;

        TestSerializable(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TestSerializable)) {
                return false;
            }
            TestSerializable rhs = (TestSerializable)o;
            return this.x == rhs.x && this.y == rhs.y;
        }

        public int hashCode() {
            return 31 * (31 + this.x) + this.y;
        }
    }
}

