/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.xml;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.xml.XmlFrameDecoder;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class XmlFrameDecoderTest {
    private final List<String> xmlSamples = Arrays.asList(this.sample("01"), this.sample("02"), this.sample("03"), this.sample("04"), this.sample("05"), this.sample("06"));

    @Test
    public void testConstructorWithIllegalArgs01() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new XmlFrameDecoder(0);
            }
        });
    }

    @Test
    public void testConstructorWithIllegalArgs02() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new XmlFrameDecoder(-23);
            }
        });
    }

    @Test
    public void testDecodeWithFrameExceedingMaxLength() {
        XmlFrameDecoder decoder = new XmlFrameDecoder(3);
        final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{decoder});
        Assertions.assertThrows(TooLongFrameException.class, (Executable)new Executable(){

            public void execute() {
                ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"<v/>", (Charset)CharsetUtil.UTF_8)});
            }
        });
    }

    @Test
    public void testDecodeWithInvalidInput() {
        XmlFrameDecoder decoder = new XmlFrameDecoder(0x100000);
        final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{decoder});
        Assertions.assertThrows(CorruptedFrameException.class, (Executable)new Executable(){

            public void execute() {
                ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"invalid XML", (Charset)CharsetUtil.UTF_8)});
            }
        });
    }

    @Test
    public void testDecodeWithInvalidContentBeforeXml() {
        XmlFrameDecoder decoder = new XmlFrameDecoder(0x100000);
        final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{decoder});
        Assertions.assertThrows(CorruptedFrameException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"invalid XML<foo/>", (Charset)CharsetUtil.UTF_8)});
            }
        });
    }

    @Test
    public void testDecodeShortValidXml() {
        XmlFrameDecoderTest.testDecodeWithXml("<xxx/>", "<xxx/>");
    }

    @Test
    public void testDecodeShortValidXmlWithLeadingWhitespace01() {
        XmlFrameDecoderTest.testDecodeWithXml("   <xxx/>", "<xxx/>");
    }

    @Test
    public void testDecodeShortValidXmlWithLeadingWhitespace02() {
        XmlFrameDecoderTest.testDecodeWithXml("  \n\r \t<xxx/>\t", "<xxx/>");
    }

    @Test
    public void testDecodeShortValidXmlWithLeadingWhitespace02AndTrailingGarbage() {
        XmlFrameDecoderTest.testDecodeWithXml("  \n\r \t<xxx/>\ttrash", "<xxx/>", CorruptedFrameException.class);
    }

    @Test
    public void testDecodeInvalidXml() {
        XmlFrameDecoderTest.testDecodeWithXml("<a></", new Object[0]);
        XmlFrameDecoderTest.testDecodeWithXml("<a></a", new Object[0]);
    }

    @Test
    public void testDecodeWithCDATABlock() {
        String xml = "<book><![CDATA[K&R, a.k.a. Kernighan & Ritchie]]></book>";
        XmlFrameDecoderTest.testDecodeWithXml("<book><![CDATA[K&R, a.k.a. Kernighan & Ritchie]]></book>", "<book><![CDATA[K&R, a.k.a. Kernighan & Ritchie]]></book>");
    }

    @Test
    public void testDecodeWithCDATABlockContainingNestedUnbalancedXml() {
        String xml = "<info><![CDATA[Copyright 2012-2013,<br><a href=\"http://www.acme.com\">ACME Inc.<a>]]></info>";
        XmlFrameDecoderTest.testDecodeWithXml("<info><![CDATA[Copyright 2012-2013,<br><a href=\"http://www.acme.com\">ACME Inc.<a>]]></info>", "<info><![CDATA[Copyright 2012-2013,<br><a href=\"http://www.acme.com\">ACME Inc.<a>]]></info>");
    }

    @Test
    public void testDecodeWithMultipleMessages() {
        String input = "<root xmlns=\"http://www.acme.com/acme\" status=\"loginok\" timestamp=\"1362410583776\"/>\n\n<root xmlns=\"http://www.acme.com/acme\" status=\"start\" time=\"0\" timestamp=\"1362410584794\">\n<child active=\"1\" status=\"started\" id=\"935449\" msgnr=\"2\"/>\n</root><root xmlns=\"http://www.acme.com/acme\" status=\"logout\" timestamp=\"1362410584795\"/>";
        String frame1 = "<root xmlns=\"http://www.acme.com/acme\" status=\"loginok\" timestamp=\"1362410583776\"/>";
        String frame2 = "<root xmlns=\"http://www.acme.com/acme\" status=\"start\" time=\"0\" timestamp=\"1362410584794\">\n<child active=\"1\" status=\"started\" id=\"935449\" msgnr=\"2\"/>\n</root>";
        String frame3 = "<root xmlns=\"http://www.acme.com/acme\" status=\"logout\" timestamp=\"1362410584795\"/>";
        XmlFrameDecoderTest.testDecodeWithXml("<root xmlns=\"http://www.acme.com/acme\" status=\"loginok\" timestamp=\"1362410583776\"/>\n\n<root xmlns=\"http://www.acme.com/acme\" status=\"start\" time=\"0\" timestamp=\"1362410584794\">\n<child active=\"1\" status=\"started\" id=\"935449\" msgnr=\"2\"/>\n</root><root xmlns=\"http://www.acme.com/acme\" status=\"logout\" timestamp=\"1362410584795\"/>", "<root xmlns=\"http://www.acme.com/acme\" status=\"loginok\" timestamp=\"1362410583776\"/>", "<root xmlns=\"http://www.acme.com/acme\" status=\"start\" time=\"0\" timestamp=\"1362410584794\">\n<child active=\"1\" status=\"started\" id=\"935449\" msgnr=\"2\"/>\n</root>", "<root xmlns=\"http://www.acme.com/acme\" status=\"logout\" timestamp=\"1362410584795\"/>");
    }

    @Test
    public void testFraming() {
        XmlFrameDecoderTest.testDecodeWithXml(Arrays.asList("<abc", ">123</a", "bc>"), "<abc>123</abc>");
    }

    @Test
    public void testDecodeWithSampleXml() {
        for (String xmlSample : this.xmlSamples) {
            XmlFrameDecoderTest.testDecodeWithXml(xmlSample, xmlSample);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testDecodeWithXml(List<String> xmlFrames, Object ... expected) {
        ByteBuf buf;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new XmlFrameDecoder(0x100000)});
        Exception cause = null;
        try {
            for (String xmlFrame : xmlFrames) {
                ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)xmlFrame, (Charset)CharsetUtil.UTF_8)});
            }
        }
        catch (Exception e) {
            cause = e;
        }
        ArrayList<Object> actual = new ArrayList<Object>();
        while ((buf = (ByteBuf)ch.readInbound()) != null) {
            actual.add(buf.toString(CharsetUtil.UTF_8));
            buf.release();
        }
        if (cause != null) {
            actual.add(cause.getClass());
        }
        try {
            ArrayList expectedList = new ArrayList();
            Collections.addAll(expectedList, expected);
            MatcherAssert.assertThat(actual, (Matcher)CoreMatchers.is(expectedList));
        }
        finally {
            ch.finish();
        }
    }

    private static void testDecodeWithXml(String xml, Object ... expected) {
        XmlFrameDecoderTest.testDecodeWithXml(Collections.singletonList(xml), expected);
    }

    private String sample(String number) throws IOException, URISyntaxException {
        String path = "io/netty/handler/codec/xml/sample-" + number + ".xml";
        URL url = this.getClass().getClassLoader().getResource(path);
        if (url == null) {
            throw new IllegalArgumentException("file not found: " + path);
        }
        byte[] buf = Files.readAllBytes(Paths.get(url.toURI()));
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(buf)).toString();
    }
}

