/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractInternalLoggerTest<T> {
    protected String loggerName = "foo";
    protected T mockLog;
    protected InternalLogger logger;
    protected final Map<String, Object> result = new HashMap<String, Object>();

    protected <V> V getResult(String key) {
        return (V)this.result.get(key);
    }

    @Test
    public void testName() {
        Assertions.assertEquals((Object)this.loggerName, (Object)this.logger.name());
    }

    @Test
    public void testAllLevel() throws Exception {
        this.testLevel(InternalLogLevel.TRACE);
        this.testLevel(InternalLogLevel.DEBUG);
        this.testLevel(InternalLogLevel.INFO);
        this.testLevel(InternalLogLevel.WARN);
        this.testLevel(InternalLogLevel.ERROR);
    }

    protected void testLevel(InternalLogLevel level) throws Exception {
        this.result.clear();
        String format1 = "a={}";
        String format2 = "a={}, b= {}";
        String format3 = "a={}, b= {}, c= {}";
        String msg = "a test message from Junit";
        Exception ex = new Exception("a test Exception from Junit");
        Class<InternalLogger> clazz = InternalLogger.class;
        String levelName = level.name();
        String logMethod = levelName.toLowerCase();
        Method isXXEnabled = clazz.getMethod("is" + levelName.charAt(0) + levelName.substring(1).toLowerCase() + "Enabled", new Class[0]);
        this.setLevelEnable(level, false);
        Assertions.assertFalse((boolean)((Boolean)isXXEnabled.invoke((Object)this.logger, new Object[0])));
        clazz.getMethod(logMethod, String.class).invoke((Object)this.logger, msg);
        Assertions.assertTrue((boolean)this.result.isEmpty());
        clazz.getMethod(logMethod, String.class, Object.class).invoke((Object)this.logger, format1, msg);
        Assertions.assertTrue((boolean)this.result.isEmpty());
        clazz.getMethod(logMethod, String.class, Object.class, Object.class).invoke((Object)this.logger, format2, msg, msg);
        Assertions.assertTrue((boolean)this.result.isEmpty());
        clazz.getMethod(logMethod, String.class, Object[].class).invoke((Object)this.logger, format3, new Object[]{msg, msg, msg});
        Assertions.assertTrue((boolean)this.result.isEmpty());
        clazz.getMethod(logMethod, String.class, Object[].class).invoke((Object)this.logger, format3, new Object[]{msg, msg, msg, ex});
        Assertions.assertTrue((boolean)this.result.isEmpty());
        clazz.getMethod(logMethod, String.class, Throwable.class).invoke((Object)this.logger, msg, ex);
        Assertions.assertTrue((boolean)this.result.isEmpty());
        clazz.getMethod(logMethod, Throwable.class).invoke((Object)this.logger, ex);
        Assertions.assertTrue((boolean)this.result.isEmpty());
        this.setLevelEnable(level, true);
        Assertions.assertTrue((boolean)((Boolean)isXXEnabled.invoke((Object)this.logger, new Object[0])));
        this.result.clear();
        clazz.getMethod(logMethod, String.class).invoke((Object)this.logger, msg);
        this.assertResult(level, null, null, msg);
        this.result.clear();
        clazz.getMethod(logMethod, String.class, Object.class).invoke((Object)this.logger, format1, msg);
        this.assertResult(level, format1, null, msg);
        this.result.clear();
        clazz.getMethod(logMethod, String.class, Object.class, Object.class).invoke((Object)this.logger, format2, msg, msg);
        this.assertResult(level, format2, null, msg, msg);
        this.result.clear();
        clazz.getMethod(logMethod, String.class, Object[].class).invoke((Object)this.logger, format3, new Object[]{msg, msg, msg});
        this.assertResult(level, format3, null, msg, msg, msg);
        this.result.clear();
        clazz.getMethod(logMethod, String.class, Object[].class).invoke((Object)this.logger, format3, new Object[]{msg, msg, msg, ex});
        this.assertResult(level, format3, ex, msg, msg, msg, ex);
        this.result.clear();
        clazz.getMethod(logMethod, String.class, Throwable.class).invoke((Object)this.logger, msg, ex);
        this.assertResult(level, null, ex, msg);
        this.result.clear();
        clazz.getMethod(logMethod, Throwable.class).invoke((Object)this.logger, ex);
        this.assertResult(level, null, ex, new Object[0]);
    }

    protected void assertResult(InternalLogLevel level, String format, Throwable t, Object ... args) {
        Assertions.assertFalse((boolean)this.result.isEmpty());
    }

    protected abstract void setLevelEnable(InternalLogLevel var1, boolean var2) throws Exception;
}

