/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.benchmarkserver;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;

public final class WebSocketServerBenchmarkPage {
    private static final String NEWLINE = "\r\n";

    public static ByteBuf getContent(String webSocketLocation) {
        return Unpooled.copiedBuffer((CharSequence)("<html><head><title>Web Socket Performance Test</title></head>\r\n<body>\r\n<h2>WebSocket Performance Test</h2>\r\n<label>Connection Status:</label>\r\n<label id=\"connectionLabel\"></label><br />\r\n<form onsubmit=\"return false;\">\r\nMessage size:<input type=\"text\" id=\"messageSize\" value=\"1024\"/><br>\r\nNumber of messages:<input type=\"text\" id=\"nrMessages\" value=\"100000\"/><br>\r\nData Type:<input type=\"radio\" name=\"type\" id=\"typeText\" value=\"text\" checked>text<input type=\"radio\" name=\"type\" id=\"typeBinary\" value=\"binary\">binary<br>\r\nMode:<br>\r\n<input type=\"radio\" name=\"mode\" id=\"modeSingle\" value=\"single\" checked>Wait for response after each messages<br>\r\n<input type=\"radio\" name=\"mode\" id=\"modeAll\" value=\"all\">Send all messages and then wait for all responses<br>\r\n<input type=\"checkbox\" id=\"verifiyResponses\">Verify responded messages<br>\r\n<input type=\"button\" value=\"Start Benchmark\"\r\n       onclick=\"startBenchmark()\" />\r\n<h3>Output</h3>\r\n<textarea id=\"output\" style=\"width:500px;height:300px;\"></textarea>\r\n<br>\r\n<input type=\"button\" value=\"Clear\" onclick=\"clearText()\">\r\n</form>\r\n<script type=\"text/javascript\">\r\nvar benchRunning = false;\r\nvar messageSize = 0;\r\nvar totalMessages = 0;\r\nvar rcvdMessages = 0;\r\nvar isBinary = true;\r\nvar isSingle = true;\r\nvar verifiyResponses = false;\r\nvar benchData = null;\r\nvar startTime;\r\nvar endTime;\r\nvar socket;\r\nvar output = document.getElementById('output');\r\nvar connectionLabel = document.getElementById('connectionLabel');\r\nif (!window.WebSocket) {\r\n  window.WebSocket = window.MozWebSocket;\r\n}\r\nif (window.WebSocket) {\r\n  socket = new WebSocket(\"" + webSocketLocation + "\");" + NEWLINE + "  socket.binaryType = 'arraybuffer';" + NEWLINE + "  socket.onmessage = function(event) {" + NEWLINE + "    if (verifiyResponses) {" + NEWLINE + "        if (isBinary) {" + NEWLINE + "            if (!(event.data instanceof ArrayBuffer) || " + NEWLINE + "                  event.data.byteLength != benchData.byteLength) {" + NEWLINE + "                onInvalidResponse(benchData, event.data);" + NEWLINE + "                return;" + NEWLINE + "            } else {" + NEWLINE + "                var v = new Uint8Array(event.data);" + NEWLINE + "                for (var j = 0; j < benchData.byteLength; j++) {" + NEWLINE + "                    if (v[j] != benchData[j]) {" + NEWLINE + "                        onInvalidResponse(benchData, event.data);" + NEWLINE + "                        return;" + NEWLINE + "                    }" + NEWLINE + "                }" + NEWLINE + "            }" + NEWLINE + "        } else {" + NEWLINE + "            if (event.data != benchData) {" + NEWLINE + "                onInvalidResponse(benchData, event.data);" + NEWLINE + "                return;" + NEWLINE + "            }" + NEWLINE + "        }" + NEWLINE + "    }" + NEWLINE + "    rcvdMessages++;" + NEWLINE + "    if (rcvdMessages == totalMessages) {" + NEWLINE + "        onFinished();" + NEWLINE + "    } else if (isSingle) {" + NEWLINE + "        socket.send(benchData);" + NEWLINE + "    }" + NEWLINE + "  };" + NEWLINE + "  socket.onopen = function(event) {" + NEWLINE + "    connectionLabel.innerHTML = \"Connected\";" + NEWLINE + "  };" + NEWLINE + "  socket.onclose = function(event) {" + NEWLINE + "    benchRunning = false;" + NEWLINE + "    connectionLabel.innerHTML = \"Disconnected\";" + NEWLINE + "  };" + NEWLINE + "} else {" + NEWLINE + "  alert(\"Your browser does not support Web Socket.\");" + NEWLINE + '}' + NEWLINE + NEWLINE + "function onInvalidResponse(sent,recvd) {" + NEWLINE + "    socket.close();" + NEWLINE + "    alert(\"Error: Sent data did not match the received data!\");" + NEWLINE + "}" + NEWLINE + NEWLINE + "function clearText() {" + NEWLINE + "    output.value=\"\";" + NEWLINE + "}" + NEWLINE + NEWLINE + "function createBenchData() {" + NEWLINE + "    if (isBinary) {" + NEWLINE + "        benchData = new Uint8Array(messageSize);" + NEWLINE + "        for (var i=0; i < messageSize; i++) {" + NEWLINE + "            benchData[i] += Math.floor(Math.random() * 255);" + NEWLINE + "        }" + NEWLINE + "    } else { " + NEWLINE + "        benchData = \"\";" + NEWLINE + "        for (var i=0; i < messageSize; i++) {" + NEWLINE + "            benchData += String.fromCharCode(Math.floor(Math.random() * (123 - 65) + 65));" + NEWLINE + "        }" + NEWLINE + "    }" + NEWLINE + "}" + NEWLINE + NEWLINE + "function startBenchmark(message) {" + NEWLINE + "  if (!window.WebSocket || benchRunning) { return; }" + NEWLINE + "  if (socket.readyState == WebSocket.OPEN) {" + NEWLINE + "    isBinary = document.getElementById('typeBinary').checked;" + NEWLINE + "    isSingle = document.getElementById('modeSingle').checked;" + NEWLINE + "    verifiyResponses = document.getElementById('verifiyResponses').checked;" + NEWLINE + "    messageSize = parseInt(document.getElementById('messageSize').value);" + NEWLINE + "    totalMessages = parseInt(document.getElementById('nrMessages').value);" + NEWLINE + "    if (isNaN(messageSize) || isNaN(totalMessages)) return;" + NEWLINE + "    createBenchData();" + NEWLINE + "    output.value = output.value + '\\nStarting Benchmark';" + NEWLINE + "    rcvdMessages = 0;" + NEWLINE + "    benchRunning = true;" + NEWLINE + "    startTime = new Date();" + NEWLINE + "    if (isSingle) {" + NEWLINE + "        socket.send(benchData);" + NEWLINE + "    } else {" + NEWLINE + "        for (var i = 0; i < totalMessages; i++) socket.send(benchData);" + NEWLINE + "    }" + NEWLINE + "  } else {" + NEWLINE + "    alert(\"The socket is not open.\");" + NEWLINE + "  }" + NEWLINE + '}' + NEWLINE + NEWLINE + "function onFinished() {" + NEWLINE + "    endTime = new Date();" + NEWLINE + "    var duration = (endTime - startTime) / 1000.0;" + NEWLINE + "    output.value = output.value + '\\nTest took: ' + duration + 's';" + NEWLINE + "    var messagesPerS = totalMessages / duration;" + NEWLINE + "    output.value = output.value + '\\nPerformance: ' + messagesPerS + ' Messages/s';" + NEWLINE + "    output.value = output.value + ' in each direction';" + NEWLINE + "    output.value = output.value + '\\nRound trip: ' + 1000.0/messagesPerS + 'ms';" + NEWLINE + "    var throughput = messageSize * totalMessages / duration;" + NEWLINE + "    var throughputText;" + NEWLINE + "    if (isBinary) throughputText = throughput / (1024*1024) + ' MB/s';" + NEWLINE + "    else throughputText = throughput / (1000*1000) + ' MChars/s';" + NEWLINE + "    output.value = output.value + '\\nThroughput: ' + throughputText;" + NEWLINE + "    output.value = output.value + ' in each direction';" + NEWLINE + "    benchRunning = false;" + NEWLINE + "}" + NEWLINE + "</script>" + NEWLINE + "</body>" + NEWLINE + "</html>" + NEWLINE), (Charset)CharsetUtil.US_ASCII);
    }

    private WebSocketServerBenchmarkPage() {
    }
}

