/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslX509Certificate;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.apache.tomcat.jni.Buffer;
import org.apache.tomcat.jni.SSL;

public final class OpenSslEngine
extends SSLEngine {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSslEngine.class);
    private static final Certificate[] EMPTY_CERTIFICATES = EmptyArrays.EMPTY_CERTIFICATES;
    private static final X509Certificate[] EMPTY_X509_CERTIFICATES = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
    private static final SSLException ENGINE_CLOSED = new SSLException("engine closed");
    private static final SSLException RENEGOTIATION_UNSUPPORTED = new SSLException("renegotiation unsupported");
    private static final SSLException ENCRYPTED_PACKET_OVERSIZED = new SSLException("encrypted packet oversized");
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private static final int MAX_COMPRESSED_LENGTH = 17408;
    private static final int MAX_CIPHERTEXT_LENGTH = 18432;
    private static final String PROTOCOL_SSL_V2_HELLO = "SSLv2Hello";
    private static final String PROTOCOL_SSL_V2 = "SSLv2";
    private static final String PROTOCOL_SSL_V3 = "SSLv3";
    private static final String PROTOCOL_TLS_V1 = "TLSv1";
    private static final String PROTOCOL_TLS_V1_1 = "TLSv1.1";
    private static final String PROTOCOL_TLS_V1_2 = "TLSv1.2";
    private static final String[] SUPPORTED_PROTOCOLS;
    private static final Set<String> SUPPORTED_PROTOCOLS_SET;
    static final int MAX_ENCRYPTED_PACKET_LENGTH = 18713;
    static final int MAX_ENCRYPTION_OVERHEAD_LENGTH = 2329;
    private static final AtomicIntegerFieldUpdater<OpenSslEngine> DESTROYED_UPDATER;
    private static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    private static final long EMPTY_ADDR;
    private static final SSLEngineResult NEED_UNWRAP_OK;
    private static final SSLEngineResult NEED_UNWRAP_CLOSED;
    private static final SSLEngineResult NEED_WRAP_OK;
    private static final SSLEngineResult NEED_WRAP_CLOSED;
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING;
    private long ssl;
    private long networkBIO;
    private int accepted;
    private boolean handshakeFinished;
    private boolean receivedShutdown;
    private volatile int destroyed;
    private volatile String cipher;
    private volatile String applicationProtocol;
    private volatile Certificate[] peerCerts;
    private volatile ClientAuthMode clientAuth = ClientAuthMode.NONE;
    private boolean isInboundDone;
    private boolean isOutboundDone;
    private boolean engineClosed;
    private final boolean clientMode;
    private final ByteBufAllocator alloc;
    private final OpenSslSessionContext sessionContext;
    private final OpenSslEngineMap engineMap;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final boolean rejectRemoteInitiatedRenegation;
    private final SSLSession session = new OpenSslSession();
    SSLHandshakeException handshakeException;

    @Deprecated
    public OpenSslEngine(long sslCtx, ByteBufAllocator alloc, String fallbackApplicationProtocol) {
        this(sslCtx, alloc, false, null, OpenSslContext.NONE_PROTOCOL_NEGOTIATOR, OpenSslEngineMap.EMPTY, false);
    }

    OpenSslEngine(long sslCtx, ByteBufAllocator alloc, boolean clientMode, OpenSslSessionContext sessionContext, OpenSslApplicationProtocolNegotiator apn, OpenSslEngineMap engineMap, boolean rejectRemoteInitiatedRenegation) {
        OpenSsl.ensureAvailability();
        if (sslCtx == 0L) {
            throw new NullPointerException("sslCtx");
        }
        this.alloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)alloc, (String)"alloc");
        this.apn = (OpenSslApplicationProtocolNegotiator)ObjectUtil.checkNotNull((Object)apn, (String)"apn");
        this.ssl = SSL.newSSL((long)sslCtx, (!clientMode ? 1 : 0) != 0);
        this.networkBIO = SSL.makeNetworkBIO((long)this.ssl);
        this.clientMode = clientMode;
        this.sessionContext = sessionContext;
        this.engineMap = engineMap;
        this.rejectRemoteInitiatedRenegation = rejectRemoteInitiatedRenegation;
    }

    @Override
    public SSLSession getHandshakeSession() {
        if (this.accepted > 0) {
            return this.session;
        }
        return null;
    }

    long ssl() {
        return this.ssl;
    }

    public synchronized void shutdown() {
        if (DESTROYED_UPDATER.compareAndSet(this, 0, 1)) {
            this.engineMap.remove(this.ssl);
            SSL.freeSSL((long)this.ssl);
            SSL.freeBIO((long)this.networkBIO);
            this.networkBIO = 0L;
            this.ssl = 0L;
            this.engineClosed = true;
            this.isOutboundDone = true;
            this.isInboundDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlaintextData(ByteBuffer src) {
        int sslWrote;
        int pos = src.position();
        int limit = src.limit();
        int len = Math.min(limit - pos, 16384);
        if (src.isDirect()) {
            long addr = Buffer.address((ByteBuffer)src) + (long)pos;
            sslWrote = SSL.writeToSSL((long)this.ssl, (long)addr, (int)len);
            if (sslWrote > 0) {
                src.position(pos + sslWrote);
                return sslWrote;
            }
        } else {
            ByteBuf buf = this.alloc.directBuffer(len);
            try {
                long addr = OpenSslEngine.memoryAddress(buf);
                src.limit(pos + len);
                buf.setBytes(0, src);
                src.limit(limit);
                sslWrote = SSL.writeToSSL((long)this.ssl, (long)addr, (int)len);
                if (sslWrote > 0) {
                    src.position(pos + sslWrote);
                    int n = sslWrote;
                    return n;
                }
                src.position(pos);
            }
            finally {
                buf.release();
            }
        }
        throw new IllegalStateException("SSL.writeToSSL() returned a non-positive value: " + sslWrote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeEncryptedData(ByteBuffer src) {
        int pos = src.position();
        int len = src.remaining();
        if (src.isDirect()) {
            long addr = Buffer.address((ByteBuffer)src) + (long)pos;
            int netWrote = SSL.writeToBIO((long)this.networkBIO, (long)addr, (int)len);
            if (netWrote >= 0) {
                src.position(pos + netWrote);
                return netWrote;
            }
        } else {
            ByteBuf buf = this.alloc.directBuffer(len);
            try {
                long addr = OpenSslEngine.memoryAddress(buf);
                buf.setBytes(0, src);
                int netWrote = SSL.writeToBIO((long)this.networkBIO, (long)addr, (int)len);
                if (netWrote >= 0) {
                    src.position(pos + netWrote);
                    int n = netWrote;
                    return n;
                }
                src.position(pos);
            }
            finally {
                buf.release();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlaintextData(ByteBuffer dst) {
        if (dst.isDirect()) {
            int len;
            int pos = dst.position();
            long addr = Buffer.address((ByteBuffer)dst) + (long)pos;
            int sslRead = SSL.readFromSSL((long)this.ssl, (long)addr, (int)(len = dst.limit() - pos));
            if (sslRead > 0) {
                dst.position(pos + sslRead);
                return sslRead;
            }
        } else {
            int pos = dst.position();
            int limit = dst.limit();
            int len = Math.min(18713, limit - pos);
            ByteBuf buf = this.alloc.directBuffer(len);
            try {
                long addr = OpenSslEngine.memoryAddress(buf);
                int sslRead = SSL.readFromSSL((long)this.ssl, (long)addr, (int)len);
                if (sslRead > 0) {
                    dst.limit(pos + sslRead);
                    buf.getBytes(0, dst);
                    dst.limit(limit);
                    int n = sslRead;
                    return n;
                }
            }
            finally {
                buf.release();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readEncryptedData(ByteBuffer dst, int pending) {
        if (dst.isDirect() && dst.remaining() >= pending) {
            int pos = dst.position();
            long addr = Buffer.address((ByteBuffer)dst) + (long)pos;
            int bioRead = SSL.readFromBIO((long)this.networkBIO, (long)addr, (int)pending);
            if (bioRead > 0) {
                dst.position(pos + bioRead);
                return bioRead;
            }
        } else {
            ByteBuf buf = this.alloc.directBuffer(pending);
            try {
                long addr = OpenSslEngine.memoryAddress(buf);
                int bioRead = SSL.readFromBIO((long)this.networkBIO, (long)addr, (int)pending);
                if (bioRead > 0) {
                    int oldLimit = dst.limit();
                    dst.limit(dst.position() + bioRead);
                    buf.getBytes(0, dst);
                    dst.limit(oldLimit);
                    int n = bioRead;
                    return n;
                }
            }
            finally {
                buf.release();
            }
        }
        return 0;
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        if (this.destroyed != 0) {
            return CLOSED_NOT_HANDSHAKING;
        }
        if (srcs == null) {
            throw new IllegalArgumentException("srcs is null");
        }
        if (dst == null) {
            throw new IllegalArgumentException("dst is null");
        }
        if (offset >= srcs.length || offset + length > srcs.length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + " (expected: offset <= offset + length <= srcs.length (" + srcs.length + "))");
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (this.accepted == 0) {
            this.beginHandshakeImplicitly();
        }
        if ((handshakeStatus = this.handshakeStatus0()) == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (!this.handshakeFinished) {
                return NEED_UNWRAP_OK;
            }
            if (this.engineClosed) {
                return NEED_UNWRAP_CLOSED;
            }
        }
        int bytesProduced = 0;
        int pendingNet = SSL.pendingWrittenBytesInBIO((long)this.networkBIO);
        if (pendingNet > 0) {
            int capacity = dst.remaining();
            if (capacity < pendingNet) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, bytesProduced);
            }
            try {
                bytesProduced += this.readEncryptedData(dst, pendingNet);
            }
            catch (Exception e) {
                throw new SSLException(e);
            }
            if (this.isOutboundDone) {
                this.shutdown();
            }
            return new SSLEngineResult(this.getEngineStatus(), this.handshakeStatus0(), 0, bytesProduced);
        }
        int bytesConsumed = 0;
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            ByteBuffer src = srcs[i];
            if (src == null) {
                throw new IllegalArgumentException("srcs[" + i + "] is null");
            }
            while (src.hasRemaining()) {
                try {
                    bytesConsumed += this.writePlaintextData(src);
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                pendingNet = SSL.pendingWrittenBytesInBIO((long)this.networkBIO);
                if (pendingNet <= 0) continue;
                int capacity = dst.remaining();
                if (capacity < pendingNet) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.handshakeStatus0(), bytesConsumed, bytesProduced);
                }
                try {
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                return new SSLEngineResult(this.getEngineStatus(), this.handshakeStatus0(), bytesConsumed, bytesProduced += this.readEncryptedData(dst, pendingNet));
            }
        }
        return new SSLEngineResult(this.getEngineStatus(), this.handshakeStatus0(), bytesConsumed, bytesProduced);
    }

    private SSLException newSSLException(String msg) {
        if (!this.handshakeFinished) {
            return new SSLHandshakeException(msg);
        }
        return new SSLException(msg);
    }

    private void checkPendingHandshakeException() throws SSLHandshakeException {
        if (this.handshakeException != null) {
            SSLHandshakeException exception = this.handshakeException;
            this.handshakeException = null;
            this.shutdown();
            throw exception;
        }
    }

    public synchronized SSLEngineResult unwrap(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws SSLException {
        ByteBuffer src;
        SSLEngineResult.HandshakeStatus handshakeStatus;
        if (this.destroyed != 0) {
            return CLOSED_NOT_HANDSHAKING;
        }
        if (srcs == null) {
            throw new NullPointerException("srcs");
        }
        if (srcsOffset >= srcs.length || srcsOffset + srcsLength > srcs.length) {
            throw new IndexOutOfBoundsException("offset: " + srcsOffset + ", length: " + srcsLength + " (expected: offset <= offset + length <= srcs.length (" + srcs.length + "))");
        }
        if (dsts == null) {
            throw new IllegalArgumentException("dsts is null");
        }
        if (dstsOffset >= dsts.length || dstsOffset + dstsLength > dsts.length) {
            throw new IndexOutOfBoundsException("offset: " + dstsOffset + ", length: " + dstsLength + " (expected: offset <= offset + length <= dsts.length (" + dsts.length + "))");
        }
        int capacity = 0;
        int endOffset = dstsOffset + dstsLength;
        for (int i = dstsOffset; i < endOffset; ++i) {
            ByteBuffer dst = dsts[i];
            if (dst == null) {
                throw new IllegalArgumentException("dsts[" + i + "] is null");
            }
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            capacity += dst.remaining();
        }
        if (this.accepted == 0) {
            this.beginHandshakeImplicitly();
        }
        if ((handshakeStatus = this.handshakeStatus0()) == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            if (!this.handshakeFinished) {
                return NEED_WRAP_OK;
            }
            if (this.engineClosed) {
                return NEED_WRAP_CLOSED;
            }
        }
        int srcsEndOffset = srcsOffset + srcsLength;
        int len = 0;
        for (int i = srcsOffset; i < srcsEndOffset; ++i) {
            src = srcs[i];
            if (src == null) {
                throw new IllegalArgumentException("srcs[" + i + "] is null");
            }
            len += src.remaining();
        }
        if (len > 18713) {
            this.isInboundDone = true;
            this.isOutboundDone = true;
            this.engineClosed = true;
            this.shutdown();
            throw ENCRYPTED_PACKET_OVERSIZED;
        }
        int bytesConsumed = -1;
        try {
            while (srcsOffset < srcsEndOffset) {
                src = srcs[srcsOffset];
                int remaining = src.remaining();
                int written = this.writeEncryptedData(src);
                if (written >= 0) {
                    bytesConsumed = bytesConsumed == -1 ? written : (bytesConsumed += written);
                    if (written == remaining) {
                        ++srcsOffset;
                        continue;
                    }
                    if (written != 0) continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
        if (bytesConsumed >= 0) {
            int lastPrimingReadResult = SSL.readFromSSL((long)this.ssl, (long)EMPTY_ADDR, (int)0);
            if (lastPrimingReadResult <= 0) {
                long error = SSL.getLastErrorNumber();
                if (OpenSsl.isError(error)) {
                    String err = SSL.getErrorString((long)error);
                    if (logger.isDebugEnabled()) {
                        logger.debug("SSL_read failed: primingReadResult: " + lastPrimingReadResult + "; OpenSSL error: '" + err + '\'');
                    }
                    this.shutdown();
                    throw this.newSSLException(err);
                }
                this.checkPendingHandshakeException();
            }
            this.rejectRemoteInitiatedRenegation();
        } else {
            bytesConsumed = 0;
        }
        int pendingApp = this.handshakeFinished || SSL.isInInit((long)this.ssl) == 0 ? SSL.pendingReadableBytesInSSL((long)this.ssl) : 0;
        int bytesProduced = 0;
        if (pendingApp > 0) {
            if (capacity < pendingApp) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.handshakeStatus0(), bytesConsumed, 0);
            }
            int idx = dstsOffset;
            while (idx < endOffset) {
                int bytesRead;
                ByteBuffer dst = dsts[idx];
                if (!dst.hasRemaining()) {
                    ++idx;
                    continue;
                }
                if (pendingApp <= 0) break;
                try {
                    bytesRead = this.readPlaintextData(dst);
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                this.rejectRemoteInitiatedRenegation();
                if (bytesRead == 0) break;
                bytesProduced += bytesRead;
                pendingApp -= bytesRead;
                if (dst.hasRemaining()) continue;
                ++idx;
            }
        }
        if (!this.receivedShutdown && (SSL.getShutdown((long)this.ssl) & 2) == 2) {
            this.receivedShutdown = true;
            this.closeOutbound();
            this.closeInbound();
        }
        return new SSLEngineResult(this.getEngineStatus(), this.handshakeStatus0(), bytesConsumed, bytesProduced);
    }

    private void rejectRemoteInitiatedRenegation() throws SSLHandshakeException {
        if (this.rejectRemoteInitiatedRenegation && SSL.getHandshakeCount((long)this.ssl) > 1) {
            this.shutdown();
            throw new SSLHandshakeException("remote-initiated renegotation not allowed");
        }
    }

    public SSLEngineResult unwrap(ByteBuffer[] srcs, ByteBuffer[] dsts) throws SSLException {
        return this.unwrap(srcs, 0, srcs.length, dsts, 0, dsts.length);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        return this.unwrap(new ByteBuffer[]{src}, 0, 1, dsts, offset, length);
    }

    @Override
    public Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        this.engineClosed = true;
        this.shutdown();
        if (this.accepted != 0 && !this.receivedShutdown) {
            throw new SSLException("Inbound closed before receiving peer's close_notify: possible truncation attack?");
        }
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.isInboundDone || this.engineClosed;
    }

    @Override
    public synchronized void closeOutbound() {
        if (this.isOutboundDone) {
            return;
        }
        this.isOutboundDone = true;
        this.engineClosed = true;
        if (this.accepted != 0 && this.destroyed == 0) {
            int mode = SSL.getShutdown((long)this.ssl);
            if ((mode & 1) != 1) {
                SSL.shutdownSSL((long)this.ssl);
            }
        } else {
            this.shutdown();
        }
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.isOutboundDone;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        Set<String> availableCipherSuites = OpenSsl.availableCipherSuites();
        return availableCipherSuites.toArray(new String[availableCipherSuites.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getEnabledCipherSuites() {
        String[] enabled;
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            if (this.destroyed != 0) {
                return EmptyArrays.EMPTY_STRINGS;
            }
            enabled = SSL.getCiphers((long)this.ssl);
        }
        if (enabled == null) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        for (int i = 0; i < enabled.length; ++i) {
            String mapped = this.toJavaCipherSuite(enabled[i]);
            if (mapped == null) continue;
            enabled[i] = mapped;
        }
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabledCipherSuites(String[] cipherSuites) {
        ObjectUtil.checkNotNull((Object)cipherSuites, (String)"cipherSuites");
        StringBuilder buf = new StringBuilder();
        for (String c : cipherSuites) {
            if (c == null) break;
            String converted = CipherSuiteConverter.toOpenSsl(c);
            if (converted == null) {
                converted = c;
            }
            if (!OpenSsl.isCipherSuiteAvailable(converted)) {
                throw new IllegalArgumentException("unsupported cipher suite: " + c + '(' + converted + ')');
            }
            buf.append(converted);
            buf.append(':');
        }
        if (buf.length() == 0) {
            throw new IllegalArgumentException("empty cipher suites");
        }
        buf.setLength(buf.length() - 1);
        String cipherSuiteSpec = buf.toString();
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            if (this.destroyed == 0) {
                try {
                    SSL.setCipherSuites((long)this.ssl, (String)cipherSuiteSpec);
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to enable cipher suites: " + cipherSuiteSpec, e);
                }
            } else {
                throw new IllegalStateException("failed to enable cipher suites: " + cipherSuiteSpec);
            }
        }
    }

    @Override
    public String[] getSupportedProtocols() {
        return (String[])SUPPORTED_PROTOCOLS.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getEnabledProtocols() {
        int opts;
        ArrayList<String> enabled = new ArrayList<String>();
        enabled.add(PROTOCOL_SSL_V2_HELLO);
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            if (this.destroyed != 0) {
                return enabled.toArray(new String[1]);
            }
            opts = SSL.getOptions((long)this.ssl);
        }
        if ((opts & 0x4000000) == 0) {
            enabled.add(PROTOCOL_TLS_V1);
        }
        if ((opts & 0x10000000) == 0) {
            enabled.add(PROTOCOL_TLS_V1_1);
        }
        if ((opts & 0x8000000) == 0) {
            enabled.add(PROTOCOL_TLS_V1_2);
        }
        if ((opts & 0x1000000) == 0) {
            enabled.add(PROTOCOL_SSL_V2);
        }
        if ((opts & 0x2000000) == 0) {
            enabled.add(PROTOCOL_SSL_V3);
        }
        return enabled.toArray(new String[enabled.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException();
        }
        boolean sslv2 = false;
        boolean sslv3 = false;
        boolean tlsv1 = false;
        boolean tlsv1_1 = false;
        boolean tlsv1_2 = false;
        for (String p : protocols) {
            if (!SUPPORTED_PROTOCOLS_SET.contains(p)) {
                throw new IllegalArgumentException("Protocol " + p + " is not supported.");
            }
            if (p.equals(PROTOCOL_SSL_V2)) {
                sslv2 = true;
                continue;
            }
            if (p.equals(PROTOCOL_SSL_V3)) {
                sslv3 = true;
                continue;
            }
            if (p.equals(PROTOCOL_TLS_V1)) {
                tlsv1 = true;
                continue;
            }
            if (p.equals(PROTOCOL_TLS_V1_1)) {
                tlsv1_1 = true;
                continue;
            }
            if (!p.equals(PROTOCOL_TLS_V1_2)) continue;
            tlsv1_2 = true;
        }
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            if (this.destroyed == 0) {
                SSL.setOptions((long)this.ssl, (int)4095);
                if (!sslv2) {
                    SSL.setOptions((long)this.ssl, (int)0x1000000);
                }
                if (!sslv3) {
                    SSL.setOptions((long)this.ssl, (int)0x2000000);
                }
                if (!tlsv1) {
                    SSL.setOptions((long)this.ssl, (int)0x4000000);
                }
                if (!tlsv1_1) {
                    SSL.setOptions((long)this.ssl, (int)0x10000000);
                }
                if (!tlsv1_2) {
                    SSL.setOptions((long)this.ssl, (int)0x8000000);
                }
            } else {
                throw new IllegalStateException("failed to enable protocols: " + protocols);
            }
        }
    }

    @Override
    public SSLSession getSession() {
        return this.session;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.engineClosed || this.destroyed != 0) {
            throw ENGINE_CLOSED;
        }
        switch (this.accepted) {
            case 0: {
                this.handshake();
                this.accepted = 2;
                break;
            }
            case 1: {
                this.accepted = 2;
                break;
            }
            case 2: {
                throw RENEGOTIATION_UNSUPPORTED;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void beginHandshakeImplicitly() throws SSLException {
        if (this.engineClosed || this.destroyed != 0) {
            throw ENGINE_CLOSED;
        }
        if (this.accepted == 0) {
            this.handshake();
            this.accepted = 1;
        }
    }

    private void handshake() throws SSLException {
        int code = SSL.doHandshake((long)this.ssl);
        if (code <= 0) {
            long error = SSL.getLastErrorNumber();
            if (OpenSsl.isError(error)) {
                String err = SSL.getErrorString((long)error);
                if (logger.isDebugEnabled()) {
                    logger.debug("SSL_do_handshake failed: OpenSSL error: '" + err + '\'');
                }
                this.shutdown();
                throw this.newSSLException(err);
            }
            this.checkPendingHandshakeException();
        } else {
            this.handshakeFinished();
        }
    }

    private static long memoryAddress(ByteBuf buf) {
        if (buf.hasMemoryAddress()) {
            return buf.memoryAddress();
        }
        return Buffer.address((ByteBuffer)buf.nioBuffer());
    }

    private void handshakeFinished() throws SSLException {
        ApplicationProtocolConfig.SelectedListenerFailureBehavior behavior = this.apn.selectedListenerFailureBehavior();
        List<String> protocols = this.apn.protocols();
        switch (this.apn.protocol()) {
            case NONE: {
                break;
            }
            case ALPN: {
                String applicationProtocol = SSL.getAlpnSelected((long)this.ssl);
                if (applicationProtocol == null) break;
                this.applicationProtocol = OpenSslEngine.selectApplicationProtocol(protocols, behavior, applicationProtocol);
                break;
            }
            case NPN: {
                String applicationProtocol = SSL.getNextProtoNegotiated((long)this.ssl);
                if (applicationProtocol == null) break;
                this.applicationProtocol = OpenSslEngine.selectApplicationProtocol(protocols, behavior, applicationProtocol);
                break;
            }
            case NPN_AND_ALPN: {
                String applicationProtocol = SSL.getAlpnSelected((long)this.ssl);
                if (applicationProtocol == null) {
                    applicationProtocol = SSL.getNextProtoNegotiated((long)this.ssl);
                }
                if (applicationProtocol == null) break;
                this.applicationProtocol = OpenSslEngine.selectApplicationProtocol(protocols, behavior, applicationProtocol);
                break;
            }
            default: {
                throw new Error();
            }
        }
        this.handshakeFinished = true;
    }

    private static String selectApplicationProtocol(List<String> protocols, ApplicationProtocolConfig.SelectedListenerFailureBehavior behavior, String applicationProtocol) throws SSLException {
        applicationProtocol = applicationProtocol.replace(':', '_');
        if (behavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT) {
            return applicationProtocol;
        }
        int size = protocols.size();
        assert (size > 0);
        if (protocols.contains(applicationProtocol)) {
            return applicationProtocol;
        }
        if (behavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL) {
            return protocols.get(size - 1);
        }
        throw new SSLException("Unknown protocol " + applicationProtocol);
    }

    private SSLEngineResult.Status getEngineStatus() {
        return this.engineClosed ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
    }

    private SSLEngineResult.HandshakeStatus handshakeStatus0() throws SSLException {
        SSLEngineResult.HandshakeStatus status = this.getHandshakeStatus();
        if (status == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.handshakeFinished();
        }
        this.checkPendingHandshakeException();
        return status;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.accepted == 0 || this.destroyed != 0) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        if (!this.handshakeFinished) {
            if (SSL.pendingWrittenBytesInBIO((long)this.networkBIO) != 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (SSL.isInInit((long)this.ssl) == 0) {
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.engineClosed) {
            if (SSL.pendingWrittenBytesInBIO((long)this.networkBIO) != 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private String toJavaCipherSuite(String openSslCipherSuite) {
        if (openSslCipherSuite == null) {
            return null;
        }
        String prefix = OpenSslEngine.toJavaCipherSuitePrefix(SSL.getVersion((long)this.ssl));
        return CipherSuiteConverter.toJava(openSslCipherSuite, prefix);
    }

    private static String toJavaCipherSuitePrefix(String protocolVersion) {
        int c = protocolVersion == null || protocolVersion.length() == 0 ? 0 : (int)protocolVersion.charAt(0);
        switch (c) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        if (clientMode != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public void setNeedClientAuth(boolean b) {
        this.setClientAuth(b ? ClientAuthMode.REQUIRE : ClientAuthMode.NONE);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuthMode.REQUIRE;
    }

    @Override
    public void setWantClientAuth(boolean b) {
        this.setClientAuth(b ? ClientAuthMode.OPTIONAL : ClientAuthMode.NONE);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.clientAuth == ClientAuthMode.OPTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuthMode mode) {
        if (this.clientMode) {
            return;
        }
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            if (this.clientAuth == mode) {
                return;
            }
            switch (mode) {
                case NONE: {
                    SSL.setVerify((long)this.ssl, (int)0, (int)10);
                    break;
                }
                case REQUIRE: {
                    SSL.setVerify((long)this.ssl, (int)2, (int)10);
                    break;
                }
                case OPTIONAL: {
                    SSL.setVerify((long)this.ssl, (int)1, (int)10);
                }
            }
            this.clientAuth = mode;
        }
    }

    @Override
    public void setEnableSessionCreation(boolean b) {
        if (b) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        return false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    static /* synthetic */ Certificate[] access$402(OpenSslEngine x0, Certificate[] x1) {
        x0.peerCerts = x1;
        return x1;
    }

    static {
        ENGINE_CLOSED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        RENEGOTIATION_UNSUPPORTED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        ENCRYPTED_PACKET_OVERSIZED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        AtomicIntegerFieldUpdater<OpenSslEngine> destroyedUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(OpenSslEngine.class, (String)"destroyed");
        if (destroyedUpdater == null) {
            destroyedUpdater = AtomicIntegerFieldUpdater.newUpdater(OpenSslEngine.class, "destroyed");
        }
        DESTROYED_UPDATER = destroyedUpdater;
        SUPPORTED_PROTOCOLS = new String[]{PROTOCOL_SSL_V2_HELLO, PROTOCOL_SSL_V2, PROTOCOL_SSL_V3, PROTOCOL_TLS_V1, PROTOCOL_TLS_V1_1, PROTOCOL_TLS_V1_2};
        SUPPORTED_PROTOCOLS_SET = new HashSet<String>(Arrays.asList(SUPPORTED_PROTOCOLS));
        EMPTY_ADDR = Buffer.address((ByteBuffer)Unpooled.EMPTY_BUFFER.nioBuffer());
        NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    }

    private final class OpenSslSession
    implements SSLSession {
        private X509Certificate[] x509PeerCerts;
        private Map<String, Object> values;

        private OpenSslSession() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getId() {
            byte[] id;
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                id = OpenSslEngine.this.destroyed == 0 ? SSL.getSessionId((long)OpenSslEngine.this.ssl) : EmptyArrays.EMPTY_BYTES;
            }
            if (id == null) {
                throw new IllegalStateException("SSL session ID not available");
            }
            return id;
        }

        @Override
        public SSLSessionContext getSessionContext() {
            return OpenSslEngine.this.sessionContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCreationTime() {
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                if (OpenSslEngine.this.destroyed == 0) {
                    return SSL.getTime((long)OpenSslEngine.this.ssl) * 1000L;
                }
                return 0L;
            }
        }

        @Override
        public long getLastAccessedTime() {
            return this.getCreationTime();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void putValue(String name, Object value) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (value == null) {
                throw new NullPointerException("value");
            }
            Map<String, Object> values = this.values;
            if (values == null) {
                values = this.values = new HashMap<String, Object>(2);
            }
            Object old = values.put(name, value);
            if (value instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
            }
            this.notifyUnbound(old, name);
        }

        @Override
        public Object getValue(String name) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (this.values == null) {
                return null;
            }
            return this.values.get(name);
        }

        @Override
        public void removeValue(String name) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            Map<String, Object> values = this.values;
            if (values == null) {
                return;
            }
            Object old = values.remove(name);
            this.notifyUnbound(old, name);
        }

        @Override
        public String[] getValueNames() {
            Map<String, Object> values = this.values;
            if (values == null || values.isEmpty()) {
                return EmptyArrays.EMPTY_STRINGS;
            }
            return values.keySet().toArray(new String[values.size()]);
        }

        private void notifyUnbound(Object value, String name) {
            if (value instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            Certificate[] c = OpenSslEngine.this.peerCerts;
            if (c == null) {
                OpenSslEngine openSslEngine = OpenSslEngine.this;
                synchronized (openSslEngine) {
                    if (OpenSslEngine.this.destroyed == 0) {
                        if (SSL.isInInit((long)OpenSslEngine.this.ssl) != 0) {
                            throw new SSLPeerUnverifiedException("peer not verified");
                        }
                        c = OpenSslEngine.access$402(OpenSslEngine.this, this.initPeerCertChain());
                    } else {
                        c = OpenSslEngine.access$402(OpenSslEngine.this, EMPTY_CERTIFICATES);
                    }
                }
            }
            return c;
        }

        @Override
        public Certificate[] getLocalCertificates() {
            return EMPTY_CERTIFICATES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
            X509Certificate[] c = this.x509PeerCerts;
            if (c == null) {
                byte[][] chain;
                OpenSslEngine openSslEngine = OpenSslEngine.this;
                synchronized (openSslEngine) {
                    if (OpenSslEngine.this.destroyed == 0) {
                        if (SSL.isInInit((long)OpenSslEngine.this.ssl) != 0) {
                            throw new SSLPeerUnverifiedException("peer not verified");
                        }
                    } else {
                        this.x509PeerCerts = EMPTY_X509_CERTIFICATES;
                        c = this.x509PeerCerts;
                        return c;
                    }
                    chain = SSL.getPeerCertChain((long)OpenSslEngine.this.ssl);
                }
                if (chain == null) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                X509Certificate[] peerCerts = new X509Certificate[chain.length];
                for (int i = 0; i < peerCerts.length; ++i) {
                    try {
                        peerCerts[i] = X509Certificate.getInstance(chain[i]);
                        continue;
                    }
                    catch (CertificateException e) {
                        throw new IllegalStateException(e);
                    }
                }
                this.x509PeerCerts = peerCerts;
                c = peerCerts;
            }
            return c;
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            Certificate[] peer = this.getPeerCertificates();
            if (peer == null || peer.length == 0) {
                return null;
            }
            return this.principal(peer);
        }

        @Override
        public Principal getLocalPrincipal() {
            Certificate[] local = this.getLocalCertificates();
            if (local == null || local.length == 0) {
                return null;
            }
            return this.principal(local);
        }

        private Principal principal(Certificate[] certs) {
            return ((java.security.cert.X509Certificate)certs[0]).getIssuerX500Principal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getCipherSuite() {
            if (!OpenSslEngine.this.handshakeFinished) {
                return OpenSslEngine.INVALID_CIPHER;
            }
            if (OpenSslEngine.this.cipher == null) {
                String c;
                OpenSslEngine openSslEngine = OpenSslEngine.this;
                synchronized (openSslEngine) {
                    c = OpenSslEngine.this.destroyed == 0 ? OpenSslEngine.this.toJavaCipherSuite(SSL.getCipherForSSL((long)OpenSslEngine.this.ssl)) : OpenSslEngine.INVALID_CIPHER;
                }
                if (c != null) {
                    OpenSslEngine.this.cipher = c;
                }
            }
            return OpenSslEngine.this.cipher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getProtocol() {
            String version;
            String applicationProtocol = OpenSslEngine.this.applicationProtocol;
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                if (OpenSslEngine.this.destroyed != 0) {
                    return "";
                }
                version = SSL.getVersion((long)OpenSslEngine.this.ssl);
            }
            if (applicationProtocol == null || applicationProtocol.isEmpty()) {
                return version;
            }
            return version + ':' + applicationProtocol;
        }

        @Override
        public String getPeerHost() {
            return null;
        }

        @Override
        public int getPeerPort() {
            return 0;
        }

        @Override
        public int getPacketBufferSize() {
            return 18713;
        }

        @Override
        public int getApplicationBufferSize() {
            return 16384;
        }

        private Certificate[] initPeerCertChain() throws SSLPeerUnverifiedException {
            Certificate[] peerCerts;
            byte[][] chain = SSL.getPeerCertChain((long)OpenSslEngine.this.ssl);
            byte[] clientCert = !OpenSslEngine.this.clientMode ? SSL.getPeerCertificate((long)OpenSslEngine.this.ssl) : null;
            if (chain == null && clientCert == null) {
                throw new SSLPeerUnverifiedException("peer not verified");
            }
            int len = 0;
            if (chain != null) {
                len += chain.length;
            }
            int i = 0;
            if (clientCert != null) {
                peerCerts = new Certificate[++len];
                peerCerts[i++] = new OpenSslX509Certificate(clientCert);
            } else {
                peerCerts = new Certificate[len];
            }
            if (chain != null) {
                int a = 0;
                while (i < peerCerts.length) {
                    peerCerts[i] = new OpenSslX509Certificate(chain[a++]);
                    ++i;
                }
            }
            return peerCerts;
        }
    }

    static enum ClientAuthMode {
        NONE,
        OPTIONAL,
        REQUIRE;

    }
}

