/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.util.NetUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultDnsCacheTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpire() throws Throwable {
        InetAddress addr1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress addr2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            final DefaultDnsCache cache = new DefaultDnsCache();
            cache.cache("netty.io", null, addr1, 1L, loop);
            cache.cache("netty.io", null, addr2, 10000L, loop);
            Throwable error = (Throwable)loop.schedule((Callable)new Callable<Throwable>(){

                @Override
                public Throwable call() {
                    try {
                        Assertions.assertNull((Object)cache.get("netty.io", null));
                        return null;
                    }
                    catch (Throwable cause) {
                        return cause;
                    }
                }
            }, 1L, TimeUnit.SECONDS).get();
            if (error != null) {
                throw error;
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testExpireWithDifferentTTLs() {
        DefaultDnsCacheTest.testExpireWithTTL0(1);
        DefaultDnsCacheTest.testExpireWithTTL0(1000);
        DefaultDnsCacheTest.testExpireWithTTL0(1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testExpireWithTTL0(int days) {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache();
            Assertions.assertNotNull((Object)cache.cache("netty.io", null, NetUtil.LOCALHOST, (long)days, loop));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpireWithToBigMinTTL() {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            Assertions.assertNotNull((Object)cache.cache("netty.io", null, NetUtil.LOCALHOST, 100L, loop));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddMultipleAddressesForSameHostname() throws Exception {
        InetAddress addr1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress addr2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache();
            cache.cache("netty.io", null, addr1, 1L, loop);
            cache.cache("netty.io", null, addr2, 10000L, loop);
            List entries = cache.get("netty.io", null);
            Assertions.assertEquals((int)2, (int)entries.size());
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(0), addr1);
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(1), addr2);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSameAddressForSameHostname() throws Exception {
        InetAddress addr1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache();
            cache.cache("netty.io", null, addr1, 1L, loop);
            cache.cache("netty.io", null, addr1, 10000L, loop);
            List entries = cache.get("netty.io", null);
            Assertions.assertEquals((int)1, (int)entries.size());
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(0), addr1);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static void assertEntry(DnsCacheEntry entry, InetAddress address) {
        Assertions.assertEquals((Object)address, (Object)entry.address());
        Assertions.assertNull((Object)entry.cause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheFailed() throws Exception {
        InetAddress addr1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress addr2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache(1, 100, 100);
            cache.cache("netty.io", null, addr1, 10000L, loop);
            cache.cache("netty.io", null, addr2, 10000L, loop);
            List entries = cache.get("netty.io", null);
            Assertions.assertEquals((int)2, (int)entries.size());
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(0), addr1);
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(1), addr2);
            Exception exception = new Exception();
            cache.cache("netty.io", null, (Throwable)exception, loop);
            entries = cache.get("netty.io", null);
            DnsCacheEntry entry = (DnsCacheEntry)entries.get(0);
            Assertions.assertEquals((int)1, (int)entries.size());
            DefaultDnsCacheTest.assertThrowable(exception, entry.cause());
            Assertions.assertNull((Object)entry.address());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDotHandling() throws Exception {
        InetAddress addr1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress addr2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache(1, 100, 100);
            cache.cache("netty.io", null, addr1, 10000L, loop);
            cache.cache("netty.io.", null, addr2, 10000L, loop);
            List entries = cache.get("netty.io", null);
            Assertions.assertEquals((int)2, (int)entries.size());
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(0), addr1);
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(1), addr2);
            List entries2 = cache.get("netty.io.", null);
            Assertions.assertEquals((int)2, (int)entries2.size());
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries2.get(0), addr1);
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries2.get(1), addr2);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheExceptionIsSafe() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache(1, 100, 100);
            DefaultDnsCacheTest.testSuppressed((DnsCache)cache, new UnknownHostException("test"), loop);
            DefaultDnsCacheTest.testSuppressed((DnsCache)cache, new Throwable("test"), loop);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static void testSuppressed(DnsCache cache, Throwable exception, EventLoop loop) {
        String hostname = UUID.randomUUID().toString();
        cache.cache(hostname, null, exception, loop);
        List entries = cache.get(hostname, null);
        DnsCacheEntry entry = (DnsCacheEntry)entries.get(0);
        Assertions.assertEquals((int)1, (int)entries.size());
        Assertions.assertNotSame((Object)exception, (Object)entry.cause());
        DefaultDnsCacheTest.assertThrowable(exception, entry.cause());
        entry.cause().addSuppressed(new Throwable());
        Assertions.assertEquals((int)0, (int)exception.getSuppressed().length);
        Assertions.assertEquals((int)1, (int)entry.cause().getSuppressed().length);
        Assertions.assertNull((Object)entry.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertThrowable(Throwable expected, Throwable actual) {
        Assertions.assertInstanceOf(expected.getClass(), (Object)actual);
        Assertions.assertEquals((Object)expected.getMessage(), (Object)actual.getMessage());
        Assertions.assertEquals((int)expected.getStackTrace().length, (int)actual.getStackTrace().length);
        ByteArrayOutputStream expectedOutputStream = new ByteArrayOutputStream();
        PrintWriter expectedWriter = new PrintWriter(expectedOutputStream);
        ByteArrayOutputStream actualOutputStream = new ByteArrayOutputStream();
        PrintWriter actualWriter = new PrintWriter(actualOutputStream);
        try {
            expected.printStackTrace(expectedWriter);
            expected.printStackTrace(actualWriter);
            Assertions.assertArrayEquals((byte[])expectedOutputStream.toByteArray(), (byte[])actualOutputStream.toByteArray());
        }
        finally {
            expectedWriter.close();
            actualWriter.close();
        }
    }
}

