/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.dns.DnsQueryIdSpace;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class DnsQueryIdSpaceTest {
    @Test
    public void testOverflow() {
        final DnsQueryIdSpace ids = new DnsQueryIdSpace();
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                ids.pushId(1);
            }
        });
    }

    @Test
    public void testConsumeAndProduceAll() {
        DnsQueryIdSpace ids = new DnsQueryIdSpace();
        Assertions.assertEquals((int)ids.maxUsableIds(), (int)ids.usableIds());
        LinkedHashSet<Integer> producedIdRound1 = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> producedIdRound2 = new LinkedHashSet<Integer>();
        for (int i = ids.maxUsableIds(); i > 0; --i) {
            int id = ids.nextId();
            Assertions.assertTrue((id >= 0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)producedIdRound1.add(id));
        }
        Assertions.assertEquals((int)0, (int)ids.usableIds());
        Assertions.assertEquals((int)-1, (int)ids.nextId());
        for (Integer v : producedIdRound1) {
            ids.pushId(v.intValue());
        }
        for (int i = ids.maxUsableIds(); i > 0; --i) {
            int id = ids.nextId();
            Assertions.assertTrue((id >= 0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)producedIdRound2.add(id));
        }
        Assertions.assertEquals((int)producedIdRound1.size(), (int)producedIdRound2.size());
        Iterator producedIdRoundIt = producedIdRound1.iterator();
        Iterator producedIdRound2It = producedIdRound2.iterator();
        boolean notSame = false;
        while (producedIdRoundIt.hasNext()) {
            if (((Integer)producedIdRoundIt.next()).intValue() == ((Integer)producedIdRound2It.next()).intValue()) continue;
            notSame = true;
            break;
        }
        Assertions.assertTrue((boolean)notSame);
    }
}

