/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.IoEventLoop;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.InetSocketAddressResolver;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DnsAddressResolverGroupTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseConfiguredEventLoop() throws InterruptedException {
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
        final EventLoop loop = group.next();
        DefaultEventLoopGroup defaultEventLoopGroup = new DefaultEventLoopGroup(1);
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder().eventLoop(loop).datagramChannelType(NioDatagramChannel.class);
        DnsAddressResolverGroup resolverGroup = new DnsAddressResolverGroup(builder);
        try {
            final Promise promise = loop.newPromise();
            AddressResolver resolver = resolverGroup.getResolver((EventExecutor)defaultEventLoopGroup.next());
            resolver.resolve(new SocketAddress(){
                private static final long serialVersionUID = 3169703458729818468L;
            }).addListener((GenericFutureListener)new FutureListener<Object>(){

                public void operationComplete(Future<Object> future) {
                    try {
                        MatcherAssert.assertThat((Object)future.cause(), (Matcher)Matchers.instanceOf(UnsupportedAddressTypeException.class));
                        Assertions.assertTrue((boolean)loop.inEventLoop());
                        promise.setSuccess(null);
                    }
                    catch (Throwable cause) {
                        promise.setFailure(cause);
                    }
                }
            }).await();
            promise.sync();
        }
        finally {
            resolverGroup.close();
            group.shutdownGracefully();
            defaultEventLoopGroup.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSharedDNSCacheAcrossEventLoops() throws InterruptedException, ExecutionException {
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
        IoEventLoop loop = group.next();
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder().eventLoop((EventLoop)loop).datagramChannelType(NioDatagramChannel.class);
        DnsAddressResolverGroup resolverGroup = new DnsAddressResolverGroup(builder);
        DefaultEventLoopGroup defaultEventLoopGroup = new DefaultEventLoopGroup(2);
        EventLoop eventLoop1 = defaultEventLoopGroup.next();
        EventLoop eventLoop2 = defaultEventLoopGroup.next();
        try {
            Promise promise1 = loop.newPromise();
            InetSocketAddressResolver resolver1 = (InetSocketAddressResolver)resolverGroup.getResolver((EventExecutor)eventLoop1);
            InetAddress address1 = this.resolve(resolver1, InetSocketAddress.createUnresolved("netty.io", 80), (Promise<InetSocketAddress>)promise1);
            Promise promise2 = loop.newPromise();
            InetSocketAddressResolver resolver2 = (InetSocketAddressResolver)resolverGroup.getResolver((EventExecutor)eventLoop2);
            InetAddress address2 = this.resolve(resolver2, InetSocketAddress.createUnresolved("netty.io", 80), (Promise<InetSocketAddress>)promise2);
            Assertions.assertSame((Object)address1, (Object)address2);
        }
        finally {
            resolverGroup.close();
            group.shutdownGracefully();
            defaultEventLoopGroup.shutdownGracefully();
        }
    }

    private InetAddress resolve(InetSocketAddressResolver resolver, SocketAddress socketAddress, final Promise<InetSocketAddress> promise) throws InterruptedException, ExecutionException {
        resolver.resolve(socketAddress).addListener((GenericFutureListener)new FutureListener<InetSocketAddress>(){

            public void operationComplete(Future<InetSocketAddress> future) {
                try {
                    promise.setSuccess((Object)((InetSocketAddress)future.get()));
                }
                catch (Throwable cause) {
                    promise.setFailure(cause);
                }
            }
        }).await();
        promise.sync();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)promise.get();
        return inetSocketAddress.getAddress();
    }
}

