/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.SocketProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.HostsFileEntriesProvider;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.AuthoritativeDnsServerCache;
import io.netty.resolver.dns.DefaultAuthoritativeDnsServerCache;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.resolver.dns.DnsCnameCache;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsNameResolverChannelStrategy;
import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.netty.resolver.dns.DnsQueryLifecycleObserver;
import io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.netty.resolver.dns.DnsResolveContext;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.resolver.dns.DnsServerResponseFeedbackAddressStream;
import io.netty.resolver.dns.MultiDnsServerAddressStreamProvider;
import io.netty.resolver.dns.NoopAuthoritativeDnsServerCache;
import io.netty.resolver.dns.NoopDnsCache;
import io.netty.resolver.dns.NoopDnsCnameCache;
import io.netty.resolver.dns.NoopDnsQueryLifecycleObserverFactory;
import io.netty.resolver.dns.SequentialDnsServerAddressStream;
import io.netty.resolver.dns.SequentialDnsServerAddressStreamProvider;
import io.netty.resolver.dns.SingletonDnsServerAddressStreamProvider;
import io.netty.resolver.dns.TestDnsServer;
import io.netty.resolver.dns.ThreadLocalNameServerAddressStream;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.ThreadLocalRandom;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.io.encoder.DnsMessageEncoder;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecordModifier;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.mina.core.buffer.IoBuffer;
import org.assertj.core.api.Assumptions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class DnsNameResolverTest {
    private static final InternalLogger logger;
    private static final long DEFAULT_TEST_TIMEOUT_MS = 30000L;
    private static final Set<String> DOMAINS;
    private static final Map<String, String> DOMAINS_PUNYCODE;
    private static final Set<String> DOMAINS_ALL;
    private static final Set<String> EXCLUSIONS_RESOLVE_A;
    private static final Set<String> EXCLUSIONS_RESOLVE_AAAA;
    private static final Set<String> EXCLUSIONS_QUERY_MX;
    private static final String WINDOWS_HOST_NAME;
    private static final boolean WINDOWS_HOSTS_FILE_LOCALHOST_ENTRY_EXISTS;
    private static final boolean WINDOWS_HOSTS_FILE_HOST_NAME_ENTRY_EXISTS;
    private static final TestDnsServer dnsServer;
    private static final EventLoopGroup group;

    private static DnsNameResolverBuilder newResolver(DnsNameResolverChannelStrategy strategy, boolean decodeToUnicode) {
        return DnsNameResolverTest.newResolver(strategy, decodeToUnicode, null);
    }

    private static DnsNameResolverBuilder newResolver(DnsNameResolverChannelStrategy strategy, boolean decodeToUnicode, DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        return DnsNameResolverTest.newResolver(strategy, decodeToUnicode, dnsServerAddressStreamProvider, dnsServer);
    }

    private static DnsNameResolverBuilder newResolver(DnsNameResolverChannelStrategy strategy, boolean decodeToUnicode, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, TestDnsServer dnsServer) {
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder(group.next()).dnsQueryLifecycleObserverFactory((DnsQueryLifecycleObserverFactory)new TestRecursiveCacheDnsQueryLifecycleObserverFactory()).datagramChannelType(NioDatagramChannel.class).maxQueriesPerResolve(1).decodeIdn(decodeToUnicode).optResourceEnabled(false).ndots(1).datagramChannelStrategy(strategy);
        if (dnsServerAddressStreamProvider == null) {
            builder.nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer.localAddress()));
        } else {
            builder.nameServerProvider((DnsServerAddressStreamProvider)new MultiDnsServerAddressStreamProvider(new DnsServerAddressStreamProvider[]{dnsServerAddressStreamProvider, new SingletonDnsServerAddressStreamProvider(dnsServer.localAddress())}));
        }
        return builder;
    }

    private static DnsNameResolverBuilder newResolver(DnsNameResolverChannelStrategy strategy) {
        return DnsNameResolverTest.newResolver(strategy, true);
    }

    private static DnsNameResolverBuilder newResolver(DnsNameResolverChannelStrategy strategy, ResolvedAddressTypes resolvedAddressTypes) {
        return DnsNameResolverTest.newResolver(strategy).resolvedAddressTypes(resolvedAddressTypes);
    }

    private static DnsNameResolverBuilder newNonCachedResolver(DnsNameResolverChannelStrategy strategy, ResolvedAddressTypes resolvedAddressTypes) {
        return DnsNameResolverTest.newResolver(strategy).resolveCache((DnsCache)NoopDnsCache.INSTANCE).resolvedAddressTypes(resolvedAddressTypes);
    }

    @BeforeAll
    public static void init() throws Exception {
        dnsServer.start();
    }

    @AfterAll
    public static void destroy() {
        dnsServer.stop();
        group.shutdownGracefully();
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAorAAAA(DnsNameResolverChannelStrategy strategy) throws Exception {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, ResolvedAddressTypes.IPV4_PREFERRED).build();){
            DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, DnsRecordType.AAAA);
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAAAAorA(DnsNameResolverChannelStrategy strategy) throws Exception {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, ResolvedAddressTypes.IPV6_PREFERRED).build();){
            DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, DnsRecordType.A);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testNameServerCache(DnsNameResolverChannelStrategy channelStrategy) throws IOException, InterruptedException {
        String overriddenIP = "12.34.12.34";
        final TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                switch (question.getRecordType()) {
                    case A: {
                        HashMap<String, Object> attr = new HashMap<String, Object>();
                        attr.put("apacheDnsIpAddress".toLowerCase(Locale.US), "12.34.12.34");
                        return Collections.singleton(new TestDnsServer.TestResourceRecord(question.getDomainName(), question.getRecordType(), attr));
                    }
                }
                return null;
            }
        });
        dnsServer2.start();
        try {
            final HashSet<String> overriddenHostnames = new HashSet<String>();
            for (String name : DOMAINS) {
                if (EXCLUSIONS_RESOLVE_A.contains(name) || !PlatformDependent.threadLocalRandom().nextBoolean()) continue;
                overriddenHostnames.add(name);
            }
            try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(channelStrategy, false, new DnsServerAddressStreamProvider(){

                public DnsServerAddressStream nameServerAddressStream(String hostname) {
                    return overriddenHostnames.contains(hostname) ? DnsServerAddresses.sequential((InetSocketAddress[])new InetSocketAddress[]{dnsServer2.localAddress()}).stream() : null;
                }
            }).build();){
                Map<String, InetAddress> resultA = DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, DnsRecordType.AAAA);
                for (Map.Entry<String, InetAddress> resolvedEntry : resultA.entrySet()) {
                    if (resolvedEntry.getValue().isLoopbackAddress()) continue;
                    if (overriddenHostnames.contains(resolvedEntry.getKey())) {
                        Assertions.assertEquals((Object)"12.34.12.34", (Object)resolvedEntry.getValue().getHostAddress(), (String)("failed to resolve " + resolvedEntry.getKey()));
                        continue;
                    }
                    Assertions.assertNotEquals((Object)"12.34.12.34", (Object)resolvedEntry.getValue().getHostAddress(), (String)("failed to resolve " + resolvedEntry.getKey()));
                }
            }
        }
        finally {
            dnsServer2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveA(DnsNameResolverChannelStrategy strategy) throws Exception {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, ResolvedAddressTypes.IPV4_ONLY).ttl(Integer.MAX_VALUE, Integer.MAX_VALUE).build();){
            Map<String, InetAddress> resultA = DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, null);
            Map<String, InetAddress> resultB = DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, null);
            MatcherAssert.assertThat((Object)resultB.size(), (Matcher)Matchers.is((Object)resultA.size()));
            for (Map.Entry<String, InetAddress> e : resultA.entrySet()) {
                InetAddress expected = e.getValue();
                InetAddress actual = resultB.get(e.getKey());
                MatcherAssert.assertThat((String)("Cache for " + e.getKey() + ": " + resolver.resolveAll(e.getKey()).getNow()), (Object)actual, (Matcher)Matchers.is((Object)expected));
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAAAA(DnsNameResolverChannelStrategy strategy) throws Exception {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, ResolvedAddressTypes.IPV6_ONLY).build();){
            DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_AAAA, null);
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testNonCachedResolve(DnsNameResolverChannelStrategy strategy) throws Exception {
        try (DnsNameResolver resolver = DnsNameResolverTest.newNonCachedResolver(strategy, ResolvedAddressTypes.IPV4_ONLY).build();){
            DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, null);
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testNonCachedResolveEmptyHostName(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testNonCachedResolveEmptyHostName(strategy, "");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testNonCachedResolveNullHostName(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testNonCachedResolveEmptyHostName(strategy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testNonCachedResolveEmptyHostName(DnsNameResolverChannelStrategy strategy, String inetHost) throws Exception {
        try (DnsNameResolver resolver = DnsNameResolverTest.newNonCachedResolver(strategy, ResolvedAddressTypes.IPV4_ONLY).build();){
            InetAddress addr = (InetAddress)resolver.resolve(inetHost).syncUninterruptibly().getNow();
            Assertions.assertEquals((Object)SocketUtils.addressByName((String)inetHost), (Object)addr);
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testNonCachedResolveAllEmptyHostName(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testNonCachedResolveAllEmptyHostName(strategy, "");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testNonCachedResolveAllNullHostName(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testNonCachedResolveAllEmptyHostName(strategy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testNonCachedResolveAllEmptyHostName(DnsNameResolverChannelStrategy strategy, String inetHost) throws UnknownHostException {
        try (DnsNameResolver resolver = DnsNameResolverTest.newNonCachedResolver(strategy, ResolvedAddressTypes.IPV4_ONLY).build();){
            List addrs = (List)resolver.resolveAll(inetHost).syncUninterruptibly().getNow();
            Assertions.assertEquals(Arrays.asList(SocketUtils.allAddressesByName((String)inetHost)), (Object)addrs);
        }
    }

    private static Map<String, InetAddress> testResolve0(DnsNameResolver resolver, Set<String> excludedDomains, DnsRecordType cancelledType) throws InterruptedException {
        MatcherAssert.assertThat((Object)resolver.isRecursionDesired(), (Matcher)Matchers.is((Object)true));
        HashMap<String, InetAddress> results = new HashMap<String, InetAddress>();
        LinkedHashMap<String, Future<InetAddress>> futures = new LinkedHashMap<String, Future<InetAddress>>();
        for (String string : DOMAINS) {
            if (excludedDomains.contains(string)) continue;
            DnsNameResolverTest.resolve(resolver, futures, string);
        }
        for (Map.Entry entry : futures.entrySet()) {
            String unresolved = (String)entry.getKey();
            InetAddress resolved = (InetAddress)((Future)entry.getValue()).sync().getNow();
            logger.info("{}: {}", (Object)unresolved, (Object)resolved.getHostAddress());
            MatcherAssert.assertThat((Object)resolved.getHostName(), (Matcher)Matchers.is((Object)unresolved));
            boolean typeMatches = false;
            for (SocketProtocolFamily f : resolver.resolvedInternetProtocolFamiliesUnsafe()) {
                Class<?> resolvedType = resolved.getClass();
                Class addressType = DnsNameResolver.addressType((SocketProtocolFamily)f);
                Assertions.assertNotNull((Object)addressType);
                if (!addressType.isAssignableFrom(resolvedType)) continue;
                typeMatches = true;
            }
            MatcherAssert.assertThat((Object)typeMatches, (Matcher)Matchers.is((Object)true));
            results.put(resolved.getHostName(), resolved);
        }
        DnsNameResolverTest.assertQueryObserver(resolver, cancelledType);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testQueryMx(DnsNameResolverChannelStrategy strategy) {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).build();){
            MatcherAssert.assertThat((Object)resolver.isRecursionDesired(), (Matcher)Matchers.is((Object)true));
            LinkedHashMap<String, Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>> futures = new LinkedHashMap<String, Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>>();
            for (String string : DOMAINS) {
                if (EXCLUSIONS_QUERY_MX.contains(string)) continue;
                DnsNameResolverTest.queryMx(resolver, futures, string);
            }
            for (Map.Entry entry : futures.entrySet()) {
                String hostname = (String)entry.getKey();
                Future f = ((Future)entry.getValue()).awaitUninterruptibly();
                DnsResponse response = (DnsResponse)((AddressedEnvelope)f.getNow()).content();
                MatcherAssert.assertThat((Object)response.code(), (Matcher)Matchers.is((Object)DnsResponseCode.NOERROR));
                int answerCount = response.count(DnsSection.ANSWER);
                ArrayList<DnsRecord> mxList = new ArrayList<DnsRecord>(answerCount);
                for (int i = 0; i < answerCount; ++i) {
                    DnsRecord r = response.recordAt(DnsSection.ANSWER, i);
                    if (r.type() != DnsRecordType.MX) continue;
                    mxList.add(r);
                }
                MatcherAssert.assertThat((Object)mxList.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
                StringBuilder buf = new StringBuilder();
                for (DnsRecord r : mxList) {
                    ByteBuf recordContent = ((ByteBufHolder)r).content();
                    buf.append(StringUtil.NEWLINE);
                    buf.append('\t');
                    buf.append(r.name());
                    buf.append(' ');
                    buf.append(r.type().name());
                    buf.append(' ');
                    buf.append(recordContent.readUnsignedShort());
                    buf.append(' ');
                    buf.append(DnsResolveContext.decodeDomainName((ByteBuf)recordContent));
                }
                logger.info("{} has the following MX records:{}", (Object)hostname, (Object)buf);
                response.release();
                DnsNameResolverTest.assertNoQueriesMade(resolver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testNegativeTtl(DnsNameResolverChannelStrategy strategy) throws Exception {
        try (final DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).negativeTtl(10).build();){
            DnsNameResolverTest.resolveNonExistentDomain(resolver);
            int size = 10000;
            final ArrayList exceptions = new ArrayList();
            Thread negativeLookupThread = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 10000; ++i) {
                        exceptions.add(DnsNameResolverTest.resolveNonExistentDomain(resolver));
                        if (this.isInterrupted()) break;
                    }
                }
            };
            negativeLookupThread.start();
            negativeLookupThread.join(30000L);
            if (negativeLookupThread.isAlive()) {
                negativeLookupThread.interrupt();
                Assertions.fail((String)"Cached negative lookups did not finish quickly.");
            }
            MatcherAssert.assertThat(exceptions, (Matcher)Matchers.hasSize((int)10000));
        }
    }

    private static UnknownHostException resolveNonExistentDomain(DnsNameResolver resolver) {
        try {
            resolver.resolve("non-existent.netty.io").sync();
            Assertions.fail();
            return null;
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(UnknownHostException.class)));
            TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = (TestRecursiveCacheDnsQueryLifecycleObserverFactory)resolver.dnsQueryLifecycleObserverFactory();
            TestDnsQueryLifecycleObserver observer = lifecycleObserverFactory.observers.poll();
            if (observer != null) {
                Object o = observer.events.poll();
                if (o instanceof QueryCancelledEvent) {
                    Assertions.assertTrue((observer.question.type() == DnsRecordType.CNAME || observer.question.type() == DnsRecordType.AAAA ? 1 : 0) != 0, (String)("unexpected type: " + observer.question));
                } else if (o instanceof QueryWrittenEvent) {
                    QueryFailedEvent queryFailedEvent = (QueryFailedEvent)observer.events.poll();
                } else if (!(o instanceof QueryFailedEvent)) {
                    Assertions.fail((String)("unexpected event type: " + o));
                }
                Assertions.assertTrue((boolean)observer.events.isEmpty());
            }
            return (UnknownHostException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveIp(DnsNameResolverChannelStrategy strategy) {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).build();){
            InetAddress address = (InetAddress)resolver.resolve("10.0.0.1").syncUninterruptibly().getNow();
            Assertions.assertEquals((Object)"10.0.0.1", (Object)address.getHostAddress());
            DnsNameResolverTest.assertNoQueriesMade(resolver);
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveEmptyIpv4(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolverTest.testResolve0(strategy, ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, "");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveEmptyIpv6(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolverTest.testResolve0(strategy, ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, "");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveLocalhostIpv4(DnsNameResolverChannelStrategy strategy) {
        Assumptions.assumeThat((boolean)PlatformDependent.isWindows()).isTrue();
        Assumptions.assumeThat((boolean)WINDOWS_HOSTS_FILE_LOCALHOST_ENTRY_EXISTS).isFalse();
        Assumptions.assumeThat((Comparable)DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES).isNotEqualTo((Object)ResolvedAddressTypes.IPV6_PREFERRED);
        DnsNameResolverTest.testResolve0(strategy, ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, "localhost");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveLocalhostIpv6(DnsNameResolverChannelStrategy strategy) {
        Assumptions.assumeThat((boolean)PlatformDependent.isWindows()).isTrue();
        Assumptions.assumeThat((boolean)WINDOWS_HOSTS_FILE_LOCALHOST_ENTRY_EXISTS).isFalse();
        Assumptions.assumeThat((Comparable)DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES).isEqualTo((Object)ResolvedAddressTypes.IPV6_PREFERRED);
        DnsNameResolverTest.testResolve0(strategy, ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, "localhost");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveHostNameIpv4(DnsNameResolverChannelStrategy strategy) {
        Assumptions.assumeThat((boolean)PlatformDependent.isWindows()).isTrue();
        Assumptions.assumeThat((boolean)WINDOWS_HOSTS_FILE_HOST_NAME_ENTRY_EXISTS).isFalse();
        Assumptions.assumeThat((Comparable)DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES).isNotEqualTo((Object)ResolvedAddressTypes.IPV6_PREFERRED);
        DnsNameResolverTest.testResolve0(strategy, ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, WINDOWS_HOST_NAME);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveHostNameIpv6(DnsNameResolverChannelStrategy strategy) {
        Assumptions.assumeThat((boolean)PlatformDependent.isWindows()).isTrue();
        Assumptions.assumeThat((boolean)WINDOWS_HOSTS_FILE_HOST_NAME_ENTRY_EXISTS).isFalse();
        Assumptions.assumeThat((Comparable)DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES).isEqualTo((Object)ResolvedAddressTypes.IPV6_PREFERRED);
        DnsNameResolverTest.testResolve0(strategy, ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, WINDOWS_HOST_NAME);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveNullIpv4(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolverTest.testResolve0(strategy, ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, null);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveNullIpv6(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolverTest.testResolve0(strategy, ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testResolve0(DnsNameResolverChannelStrategy strategy, ResolvedAddressTypes addressTypes, InetAddress expectedAddr, String name) {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, addressTypes).build();){
            InetAddress address = (InetAddress)resolver.resolve(name).syncUninterruptibly().getNow();
            Assertions.assertEquals((Object)expectedAddr, (Object)address);
            DnsNameResolverTest.assertNoQueriesMade(resolver);
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllEmptyIpv4(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolverTest.testResolveAll0(strategy, ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, "");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllEmptyIpv6(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolverTest.testResolveAll0(strategy, ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, "");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllLocalhostIpv4(DnsNameResolverChannelStrategy strategy) {
        Assumptions.assumeThat((boolean)PlatformDependent.isWindows()).isTrue();
        Assumptions.assumeThat((boolean)WINDOWS_HOSTS_FILE_LOCALHOST_ENTRY_EXISTS).isFalse();
        Assumptions.assumeThat((Comparable)DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES).isNotEqualTo((Object)ResolvedAddressTypes.IPV6_PREFERRED);
        DnsNameResolverTest.testResolveAll0(strategy, ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, "localhost");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllLocalhostIpv6(DnsNameResolverChannelStrategy strategy) {
        Assumptions.assumeThat((boolean)PlatformDependent.isWindows()).isTrue();
        Assumptions.assumeThat((boolean)WINDOWS_HOSTS_FILE_LOCALHOST_ENTRY_EXISTS).isFalse();
        Assumptions.assumeThat((Comparable)DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES).isEqualTo((Object)ResolvedAddressTypes.IPV6_PREFERRED);
        DnsNameResolverTest.testResolveAll0(strategy, ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, "localhost");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllHostNameIpv4(DnsNameResolverChannelStrategy strategy) {
        Assumptions.assumeThat((boolean)PlatformDependent.isWindows()).isTrue();
        Assumptions.assumeThat((boolean)WINDOWS_HOSTS_FILE_HOST_NAME_ENTRY_EXISTS).isFalse();
        Assumptions.assumeThat((Comparable)DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES).isNotEqualTo((Object)ResolvedAddressTypes.IPV6_PREFERRED);
        DnsNameResolverTest.testResolveAll0(strategy, ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, WINDOWS_HOST_NAME);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllHostNameIpv6(DnsNameResolverChannelStrategy strategy) {
        Assumptions.assumeThat((boolean)PlatformDependent.isWindows()).isTrue();
        Assumptions.assumeThat((boolean)WINDOWS_HOSTS_FILE_HOST_NAME_ENTRY_EXISTS).isFalse();
        Assumptions.assumeThat((Comparable)DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES).isEqualTo((Object)ResolvedAddressTypes.IPV6_PREFERRED);
        DnsNameResolverTest.testResolveAll0(strategy, ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, WINDOWS_HOST_NAME);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCNAMEResolveAllIpv4(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testCNAMERecursiveResolve(strategy, true);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCNAMEResolveAllIpv6(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testCNAMERecursiveResolve(strategy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testCNAMERecursiveResolve(DnsNameResolverChannelStrategy strategy, boolean ipv4Preferred) throws IOException {
        String firstName = "firstname.com";
        String secondName = "secondname.com";
        String lastName = "lastname.com";
        String ipv4Addr = "1.2.3.4";
        String ipv6Addr = "::1";
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                ResourceRecordModifier rm;
                block5: {
                    block7: {
                        block6: {
                            block4: {
                                rm = new ResourceRecordModifier();
                                rm.setDnsClass(RecordClass.IN);
                                rm.setDnsName(question.getDomainName());
                                rm.setDnsTtl(100);
                                rm.setDnsType(RecordType.CNAME);
                                if (!question.getDomainName().equals("firstname.com")) break block4;
                                rm.put("apacheDnsDomainName", "secondname.com");
                                break block5;
                            }
                            if (!question.getDomainName().equals("secondname.com")) break block6;
                            rm.put("apacheDnsDomainName", "lastname.com");
                            break block5;
                        }
                        if (!question.getDomainName().equals("lastname.com")) break block7;
                        rm.setDnsType(question.getRecordType());
                        switch (question.getRecordType()) {
                            case A: {
                                rm.put("apacheDnsIpAddress", "1.2.3.4");
                                break block5;
                            }
                            case AAAA: {
                                rm.put("apacheDnsIpAddress", "::1");
                                break block5;
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    return null;
                }
                return Collections.singleton(rm.getEntry());
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(true).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            if (ipv4Preferred) {
                builder.resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED);
            } else {
                builder.resolvedAddressTypes(ResolvedAddressTypes.IPV6_PREFERRED);
            }
            resolver = builder.build();
            InetAddress resolvedAddress = (InetAddress)resolver.resolve("firstname.com").syncUninterruptibly().getNow();
            if (ipv4Preferred) {
                Assertions.assertEquals((Object)"1.2.3.4", (Object)resolvedAddress.getHostAddress());
            } else {
                Assertions.assertEquals((Object)"::1", (Object)NetUtil.toAddressString((InetAddress)resolvedAddress));
            }
            Assertions.assertEquals((Object)"firstname.com", (Object)resolvedAddress.getHostName());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCNAMERecursiveResolveMultipleNameServersIPv4(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testCNAMERecursiveResolveMultipleNameServers(strategy, true);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCNAMERecursiveResolveMultipleNameServersIPv6(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testCNAMERecursiveResolveMultipleNameServers(strategy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testCNAMERecursiveResolveMultipleNameServers(DnsNameResolverChannelStrategy strategy, boolean ipv4Preferred) throws IOException {
        String firstName = "firstname.nettyfoo.com";
        String lastName = "lastname.nettybar.com";
        String ipv4Addr = "1.2.3.4";
        String ipv6Addr = "::1";
        final AtomicBoolean hitServer2 = new AtomicBoolean();
        final TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
                hitServer2.set(true);
                if (question.getDomainName().equals("firstname.nettyfoo.com")) {
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(question.getDomainName());
                    rm.setDnsTtl(100);
                    rm.setDnsType(RecordType.CNAME);
                    rm.put("apacheDnsDomainName", "lastname.nettybar.com");
                    return Collections.singleton(rm.getEntry());
                }
                throw new DnsException(ResponseCode.REFUSED);
            }
        });
        final TestDnsServer dnsServer3 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
                if (question.getDomainName().equals("lastname.nettybar.com")) {
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(question.getDomainName());
                    rm.setDnsTtl(100);
                    rm.setDnsType(question.getRecordType());
                    switch (question.getRecordType()) {
                        case A: {
                            rm.put("apacheDnsIpAddress", "1.2.3.4");
                            break;
                        }
                        case AAAA: {
                            rm.put("apacheDnsIpAddress", "::1");
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    return Collections.singleton(rm.getEntry());
                }
                throw new DnsException(ResponseCode.REFUSED);
            }
        });
        dnsServer2.start();
        dnsServer3.start();
        DnsNameResolver resolver = null;
        try {
            DefaultAuthoritativeDnsServerCache nsCache = new DefaultAuthoritativeDnsServerCache();
            nsCache.cache("nettyfoo.com.", dnsServer2.localAddress(), 10000L, group.next());
            SequentialDnsServerAddressStreamProvider provider = new SequentialDnsServerAddressStreamProvider(new InetSocketAddress[]{dnsServer2.localAddress(), dnsServer3.localAddress()});
            resolver = new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), null, false, (DnsCache)NoopDnsCache.INSTANCE, (DnsCnameCache)NoopDnsCnameCache.INSTANCE, (AuthoritativeDnsServerCache)nsCache, null, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 3000L, ipv4Preferred ? ResolvedAddressTypes.IPV4_ONLY : ResolvedAddressTypes.IPV6_ONLY, true, 10, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)provider, (DnsServerAddressStream)new ThreadLocalNameServerAddressStream((DnsServerAddressStreamProvider)provider), DnsNameResolver.DEFAULT_SEARCH_DOMAINS, 0, true, false, 0, strategy){

                InetSocketAddress newRedirectServerAddress(InetAddress server) {
                    int port = hitServer2.get() ? dnsServer3.localAddress().getPort() : dnsServer2.localAddress().getPort();
                    return new InetSocketAddress(server, port);
                }
            };
            InetAddress resolvedAddress = (InetAddress)resolver.resolve("firstname.nettyfoo.com").syncUninterruptibly().getNow();
            if (ipv4Preferred) {
                Assertions.assertEquals((Object)"1.2.3.4", (Object)resolvedAddress.getHostAddress());
            } else {
                Assertions.assertEquals((Object)"::1", (Object)NetUtil.toAddressString((InetAddress)resolvedAddress));
            }
            Assertions.assertEquals((Object)"firstname.nettyfoo.com", (Object)resolvedAddress.getHostName());
        }
        finally {
            dnsServer2.stop();
            dnsServer3.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllNullIpv4(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolverTest.testResolveAll0(strategy, ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, null);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllNullIpv6(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolverTest.testResolveAll0(strategy, ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testResolveAll0(DnsNameResolverChannelStrategy strategy, ResolvedAddressTypes addressTypes, InetAddress expectedAddr, String name) {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, addressTypes).build();){
            List addresses = (List)resolver.resolveAll(name).syncUninterruptibly().getNow();
            Assertions.assertEquals((int)1, (int)addresses.size());
            Assertions.assertEquals((Object)expectedAddr, addresses.get(0));
            DnsNameResolverTest.assertNoQueriesMade(resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllMx(DnsNameResolverChannelStrategy strategy) {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).build();){
            MatcherAssert.assertThat((Object)resolver.isRecursionDesired(), (Matcher)Matchers.is((Object)true));
            LinkedHashMap<String, Future> futures = new LinkedHashMap<String, Future>();
            for (String string : DOMAINS) {
                if (EXCLUSIONS_QUERY_MX.contains(string)) continue;
                futures.put(string, resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion(string, DnsRecordType.MX)));
            }
            for (Map.Entry entry : futures.entrySet()) {
                String hostname = (String)entry.getKey();
                Future f = ((Future)entry.getValue()).awaitUninterruptibly();
                List mxList = (List)f.getNow();
                MatcherAssert.assertThat((Object)mxList.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
                StringBuilder buf = new StringBuilder();
                for (DnsRecord r : mxList) {
                    ByteBuf recordContent = ((ByteBufHolder)r).content();
                    buf.append(StringUtil.NEWLINE);
                    buf.append('\t');
                    buf.append(r.name());
                    buf.append(' ');
                    buf.append(r.type().name());
                    buf.append(' ');
                    buf.append(recordContent.readUnsignedShort());
                    buf.append(' ');
                    buf.append(DnsResolveContext.decodeDomainName((ByteBuf)recordContent));
                    ReferenceCountUtil.release((Object)r);
                }
                logger.info("{} has the following MX records:{}", (Object)hostname, (Object)buf);
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllHostsFile(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolver resolver = new DnsNameResolverBuilder(group.next()).datagramChannelType(NioDatagramChannel.class).hostsFileEntriesResolver(new HostsFileEntriesResolver(){

            public InetAddress address(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
                if ("foo.com.".equals(inetHost)) {
                    try {
                        return InetAddress.getByAddress("foo.com", new byte[]{1, 2, 3, 4});
                    }
                    catch (UnknownHostException e) {
                        throw new Error(e);
                    }
                }
                return null;
            }
        }).datagramChannelStrategy(strategy).build();
        List records = (List)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("foo.com.", DnsRecordType.A)).syncUninterruptibly().getNow();
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((DnsRecord)records.get(0)), (Matcher)Matchers.instanceOf(DnsRawRecord.class));
        DnsRawRecord record = (DnsRawRecord)records.get(0);
        ByteBuf content = record.content();
        MatcherAssert.assertThat((Object)record.name(), (Matcher)Matchers.is((Object)"foo.com."));
        MatcherAssert.assertThat((Object)record.dnsClass(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)record.type(), (Matcher)Matchers.is((Object)DnsRecordType.A));
        MatcherAssert.assertThat((Object)content.readableBytes(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)content.readInt(), (Matcher)Matchers.is((Object)16909060));
        record.release();
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveDecodeUnicode(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolverTest.testResolveUnicode(strategy, true);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveNotDecodeUnicode(DnsNameResolverChannelStrategy strategy) {
        DnsNameResolverTest.testResolveUnicode(strategy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testResolveUnicode(DnsNameResolverChannelStrategy strategy, boolean decode) {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, decode).build();){
            for (Map.Entry<String, String> entries : DOMAINS_PUNYCODE.entrySet()) {
                InetAddress address = (InetAddress)resolver.resolve(entries.getKey()).syncUninterruptibly().getNow();
                Assertions.assertEquals((Object)(decode ? entries.getKey() : entries.getValue()), (Object)address.getHostName());
            }
            DnsNameResolverTest.assertQueryObserver(resolver, DnsRecordType.AAAA);
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void secondDnsServerShouldBeUsedBeforeCNAMEFirstServerNotStarted(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.secondDnsServerShouldBeUsedBeforeCNAME(strategy, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void secondDnsServerShouldBeUsedBeforeCNAMEFirstServerFailResolve(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.secondDnsServerShouldBeUsedBeforeCNAME(strategy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void secondDnsServerShouldBeUsedBeforeCNAME(DnsNameResolverChannelStrategy strategy, boolean startDnsServer1) throws IOException {
        String knownHostName = "netty.io";
        TestDnsServer dnsServer1 = new TestDnsServer(Collections.singleton("notnetty.com"));
        TestDnsServer dnsServer2 = new TestDnsServer(Collections.singleton("netty.io"));
        DnsNameResolver resolver = null;
        try {
            InetSocketAddress dnsServer1Address;
            if (startDnsServer1) {
                dnsServer1.start();
                dnsServer1Address = dnsServer1.localAddress();
            } else {
                dnsServer1Address = new InetSocketAddress("127.0.0.1", 22);
            }
            dnsServer2.start();
            TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = new TestRecursiveCacheDnsQueryLifecycleObserverFactory();
            DnsNameResolverBuilder builder = new DnsNameResolverBuilder(group.next()).dnsQueryLifecycleObserverFactory((DnsQueryLifecycleObserverFactory)lifecycleObserverFactory).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).datagramChannelType(NioDatagramChannel.class).queryTimeoutMillis(1000L).optResourceEnabled(false).ndots(1).datagramChannelStrategy(strategy);
            builder.nameServerProvider((DnsServerAddressStreamProvider)new SequentialDnsServerAddressStreamProvider(new InetSocketAddress[]{dnsServer1Address, dnsServer2.localAddress()}));
            resolver = builder.build();
            Assertions.assertNotNull((Object)resolver.resolve("netty.io").syncUninterruptibly().getNow());
            TestDnsQueryLifecycleObserver observer = lifecycleObserverFactory.observers.poll();
            Assertions.assertNotNull((Object)observer);
            Assertions.assertEquals((int)1, (int)lifecycleObserverFactory.observers.size());
            Assertions.assertEquals((int)2, (int)observer.events.size());
            QueryWrittenEvent writtenEvent = (QueryWrittenEvent)observer.events.poll();
            Assertions.assertEquals((Object)dnsServer1Address, (Object)writtenEvent.dnsServerAddress);
            QueryFailedEvent failedEvent = (QueryFailedEvent)observer.events.poll();
            observer = lifecycleObserverFactory.observers.poll();
            Assertions.assertEquals((int)2, (int)observer.events.size());
            writtenEvent = (QueryWrittenEvent)observer.events.poll();
            Assertions.assertEquals((Object)dnsServer2.localAddress(), (Object)writtenEvent.dnsServerAddress);
            QuerySucceededEvent querySucceededEvent = (QuerySucceededEvent)observer.events.poll();
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
            dnsServer1.stop();
            dnsServer2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void aAndAAAAQueryShouldTryFirstDnsServerBeforeSecond(DnsNameResolverChannelStrategy strategy) throws IOException {
        String knownHostName = "netty.io";
        TestDnsServer dnsServer1 = new TestDnsServer(Collections.singleton("notnetty.com"));
        TestDnsServer dnsServer2 = new TestDnsServer(Collections.singleton("netty.io"));
        DnsNameResolver resolver = null;
        try {
            dnsServer1.start();
            dnsServer2.start();
            TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = new TestRecursiveCacheDnsQueryLifecycleObserverFactory();
            DnsNameResolverBuilder builder = new DnsNameResolverBuilder(group.next()).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).dnsQueryLifecycleObserverFactory((DnsQueryLifecycleObserverFactory)lifecycleObserverFactory).datagramChannelType(NioDatagramChannel.class).optResourceEnabled(false).ndots(1).datagramChannelStrategy(strategy);
            builder.nameServerProvider((DnsServerAddressStreamProvider)new SequentialDnsServerAddressStreamProvider(new InetSocketAddress[]{dnsServer1.localAddress(), dnsServer2.localAddress()}));
            resolver = builder.build();
            Assertions.assertNotNull((Object)resolver.resolve("netty.io").syncUninterruptibly().getNow());
            TestDnsQueryLifecycleObserver observer = lifecycleObserverFactory.observers.poll();
            Assertions.assertNotNull((Object)observer);
            Assertions.assertEquals((int)1, (int)lifecycleObserverFactory.observers.size());
            Assertions.assertEquals((int)2, (int)observer.events.size());
            QueryWrittenEvent writtenEvent = (QueryWrittenEvent)observer.events.poll();
            Assertions.assertEquals((Object)dnsServer1.localAddress(), (Object)writtenEvent.dnsServerAddress);
            QueryFailedEvent failedEvent = (QueryFailedEvent)observer.events.poll();
            observer = lifecycleObserverFactory.observers.poll();
            Assertions.assertEquals((int)2, (int)observer.events.size());
            writtenEvent = (QueryWrittenEvent)observer.events.poll();
            Assertions.assertEquals((Object)dnsServer2.localAddress(), (Object)writtenEvent.dnsServerAddress);
            QuerySucceededEvent querySucceededEvent = (QuerySucceededEvent)observer.events.poll();
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
            dnsServer1.stop();
            dnsServer2.stop();
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testRecursiveResolveNoCache(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testRecursiveResolveCache(strategy, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testRecursiveResolveCache(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testRecursiveResolveCache(strategy, true);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testIpv4PreferredWhenIpv6First(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testResolvesPreferredWhenNonPreferredFirst0(strategy, ResolvedAddressTypes.IPV4_PREFERRED);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testIpv6PreferredWhenIpv4First(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testResolvesPreferredWhenNonPreferredFirst0(strategy, ResolvedAddressTypes.IPV6_PREFERRED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testResolvesPreferredWhenNonPreferredFirst0(DnsNameResolverChannelStrategy strategy, ResolvedAddressTypes types) throws Exception {
        String name = "netty.com";
        ArrayList<Set<ResourceRecord>> records = new ArrayList<Set<ResourceRecord>>();
        String ipv6Address = "0:0:0:0:0:0:1:1";
        String ipv4Address = "1.1.1.1";
        if (types == ResolvedAddressTypes.IPV4_PREFERRED) {
            records.add(Collections.singleton(TestDnsServer.newAddressRecord("netty.com", RecordType.AAAA, "0:0:0:0:0:0:1:1")));
            records.add(Collections.singleton(TestDnsServer.newAddressRecord("netty.com", RecordType.A, "1.1.1.1")));
        } else {
            records.add(Collections.singleton(TestDnsServer.newAddressRecord("netty.com", RecordType.A, "1.1.1.1")));
            records.add(Collections.singleton(TestDnsServer.newAddressRecord("netty.com", RecordType.AAAA, "0:0:0:0:0:0:1:1")));
        }
        final Iterator recordsIterator = records.iterator();
        RecordStore arbitrarilyOrderedStore = new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) {
                return (Set)recordsIterator.next();
            }
        };
        TestDnsServer nonCompliantDnsServer = new TestDnsServer(arbitrarilyOrderedStore);
        nonCompliantDnsServer.start();
        try {
            DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, types).maxQueriesPerResolve(2).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(nonCompliantDnsServer.localAddress())).build();
            InetAddress resolved = (InetAddress)resolver.resolve("netty.com").syncUninterruptibly().getNow();
            if (types == ResolvedAddressTypes.IPV4_PREFERRED) {
                Assertions.assertEquals((Object)"1.1.1.1", (Object)resolved.getHostAddress());
            } else {
                Assertions.assertEquals((Object)"0:0:0:0:0:0:1:1", (Object)resolved.getHostAddress());
            }
            InetAddress ipv4InetAddress = InetAddress.getByAddress("netty.com", InetAddress.getByName("1.1.1.1").getAddress());
            InetAddress ipv6InetAddress = InetAddress.getByAddress("netty.com", InetAddress.getByName("0:0:0:0:0:0:1:1").getAddress());
            List resolvedAll = (List)resolver.resolveAll("netty.com").syncUninterruptibly().getNow();
            List<InetAddress> expected = types == ResolvedAddressTypes.IPV4_PREFERRED ? Arrays.asList(ipv4InetAddress, ipv6InetAddress) : Arrays.asList(ipv6InetAddress, ipv4InetAddress);
            Assertions.assertEquals(expected, (Object)resolvedAll);
        }
        finally {
            nonCompliantDnsServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testRecursiveResolveCache(DnsNameResolverChannelStrategy strategy, boolean cache) throws Exception {
        String hostname = "some.record.netty.io";
        String hostname2 = "some2.record.netty.io";
        final TestDnsServer dnsServerAuthority = new TestDnsServer(new HashSet<String>(Arrays.asList("some.record.netty.io", "some2.record.netty.io")));
        dnsServerAuthority.start();
        RedirectingTestDnsServer dnsServer = new RedirectingTestDnsServer("some.record.netty.io", dnsServerAuthority.localAddress().getAddress().getHostAddress());
        dnsServer.start();
        TestAuthoritativeDnsServerCache nsCache = new TestAuthoritativeDnsServerCache((AuthoritativeDnsServerCache)(cache ? new DefaultAuthoritativeDnsServerCache() : NoopAuthoritativeDnsServerCache.INSTANCE));
        TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = new TestRecursiveCacheDnsQueryLifecycleObserverFactory();
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
        SingletonDnsServerAddressStreamProvider provider = new SingletonDnsServerAddressStreamProvider(dnsServer.localAddress());
        DnsNameResolver resolver = new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), null, false, (DnsCache)NoopDnsCache.INSTANCE, (DnsCnameCache)NoopDnsCnameCache.INSTANCE, nsCache, null, lifecycleObserverFactory, 3000L, ResolvedAddressTypes.IPV4_ONLY, true, 10, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)provider, (DnsServerAddressStream)new ThreadLocalNameServerAddressStream((DnsServerAddressStreamProvider)provider), DnsNameResolver.DEFAULT_SEARCH_DOMAINS, 0, true, false, 0, strategy){

            InetSocketAddress newRedirectServerAddress(InetAddress server) {
                if (server.equals(dnsServerAuthority.localAddress().getAddress())) {
                    return new InetSocketAddress(server, dnsServerAuthority.localAddress().getPort());
                }
                return super.newRedirectServerAddress(server);
            }
        };
        String expectedDnsName = "dns4.some.record.netty.io.";
        try {
            resolver.resolveAll("some.record.netty.io").syncUninterruptibly();
            TestDnsQueryLifecycleObserver observer = lifecycleObserverFactory.observers.poll();
            Assertions.assertNotNull((Object)observer);
            Assertions.assertTrue((boolean)lifecycleObserverFactory.observers.isEmpty());
            Assertions.assertEquals((int)4, (int)observer.events.size());
            QueryWrittenEvent writtenEvent1 = (QueryWrittenEvent)observer.events.poll();
            Assertions.assertEquals((Object)dnsServer.localAddress(), (Object)writtenEvent1.dnsServerAddress);
            QueryRedirectedEvent redirectedEvent = (QueryRedirectedEvent)observer.events.poll();
            Assertions.assertEquals((Object)expectedDnsName, (Object)redirectedEvent.nameServers.get(0).getHostName());
            Assertions.assertEquals((Object)dnsServerAuthority.localAddress(), (Object)redirectedEvent.nameServers.get(0));
            QueryWrittenEvent writtenEvent2 = (QueryWrittenEvent)observer.events.poll();
            Assertions.assertEquals((Object)dnsServerAuthority.localAddress(), (Object)writtenEvent2.dnsServerAddress);
            QuerySucceededEvent succeededEvent = (QuerySucceededEvent)observer.events.poll();
            if (cache) {
                Assertions.assertNull((Object)nsCache.cache.get("io."));
                Assertions.assertNull((Object)nsCache.cache.get("netty.io."));
                DnsServerAddressStream entries = nsCache.cache.get("record.netty.io.");
                Assertions.assertEquals((int)2, (int)entries.size());
                Assertions.assertFalse((boolean)entries.next().isUnresolved());
                Assertions.assertTrue((boolean)entries.next().isUnresolved());
                Assertions.assertNull((Object)nsCache.cache.get("some.record.netty.io"));
                resolver.resolveAll("some.record.netty.io").syncUninterruptibly();
                observer = lifecycleObserverFactory.observers.poll();
                Assertions.assertNotNull((Object)observer);
                Assertions.assertTrue((boolean)lifecycleObserverFactory.observers.isEmpty());
                Assertions.assertEquals((int)2, (int)observer.events.size());
                writtenEvent1 = (QueryWrittenEvent)observer.events.poll();
                Assertions.assertEquals((Object)expectedDnsName, (Object)writtenEvent1.dnsServerAddress.getHostName());
                Assertions.assertEquals((Object)dnsServerAuthority.localAddress(), (Object)writtenEvent1.dnsServerAddress);
                succeededEvent = (QuerySucceededEvent)observer.events.poll();
                resolver.resolveAll("some2.record.netty.io").syncUninterruptibly();
                observer = lifecycleObserverFactory.observers.poll();
                Assertions.assertNotNull((Object)observer);
                Assertions.assertTrue((boolean)lifecycleObserverFactory.observers.isEmpty());
                Assertions.assertEquals((int)2, (int)observer.events.size());
                writtenEvent1 = (QueryWrittenEvent)observer.events.poll();
                Assertions.assertEquals((Object)expectedDnsName, (Object)writtenEvent1.dnsServerAddress.getHostName());
                Assertions.assertEquals((Object)dnsServerAuthority.localAddress(), (Object)writtenEvent1.dnsServerAddress);
                succeededEvent = (QuerySucceededEvent)observer.events.poll();
                Assertions.assertNull((Object)nsCache.cacheHits.get("io."));
                Assertions.assertNull((Object)nsCache.cacheHits.get("netty.io."));
                Assertions.assertNotNull((Object)nsCache.cacheHits.get("record.netty.io."));
                Assertions.assertNull((Object)nsCache.cacheHits.get("some.record.netty.io."));
            }
        }
        finally {
            resolver.close();
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            dnsServer.stop();
            dnsServerAuthority.stop();
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testFollowNsRedirectsNoopCaches(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testFollowNsRedirects(strategy, (DnsCache)NoopDnsCache.INSTANCE, (AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testFollowNsRedirectsNoopDnsCache(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testFollowNsRedirects(strategy, (DnsCache)NoopDnsCache.INSTANCE, (AuthoritativeDnsServerCache)new DefaultAuthoritativeDnsServerCache(), false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testFollowNsRedirectsNoopAuthoritativeDnsServerCache(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testFollowNsRedirects(strategy, (DnsCache)new DefaultDnsCache(), (AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testFollowNsRedirectsDefaultCaches(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testFollowNsRedirects(strategy, (DnsCache)new DefaultDnsCache(), (AuthoritativeDnsServerCache)new DefaultAuthoritativeDnsServerCache(), false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testFollowNsRedirectAndTrySecondNsOnTimeout(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testFollowNsRedirects(strategy, (DnsCache)NoopDnsCache.INSTANCE, (AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE, true);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testFollowNsRedirectAndTrySecondNsOnTimeoutDefaultCaches(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testFollowNsRedirects(strategy, (DnsCache)new DefaultDnsCache(), (AuthoritativeDnsServerCache)new DefaultAuthoritativeDnsServerCache(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFollowNsRedirects(DnsNameResolverChannelStrategy strategy, DnsCache cache, AuthoritativeDnsServerCache authoritativeDnsServerCache, final boolean invalidNsFirst) throws Exception {
        String domain = "netty.io";
        String ns1Name = "ns1.netty.io";
        String ns2Name = "ns2.netty.io";
        final InetAddress expected = InetAddress.getByAddress("some.record.netty.io", new byte[]{10, 10, 10, 10});
        final DatagramSocket socket = new DatagramSocket(new InetSocketAddress(0));
        final TestDnsServer dnsServerAuthority = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                if (question.getDomainName().equals(expected.getHostName())) {
                    return Collections.singleton(TestDnsServer.newARecord(expected.getHostName(), expected.getHostAddress()));
                }
                return Collections.emptySet();
            }
        });
        dnsServerAuthority.start();
        TestDnsServer redirectServer = new TestDnsServer(new HashSet<String>(Arrays.asList(expected.getHostName(), "ns1.netty.io", "ns2.netty.io"))){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                for (QuestionRecord record : message.getQuestionRecords()) {
                    if (!record.getDomainName().equals(expected.getHostName())) continue;
                    message.getAdditionalRecords().clear();
                    message.getAnswerRecords().clear();
                    if (invalidNsFirst) {
                        message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns2.netty.io"));
                        message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns1.netty.io"));
                    } else {
                        message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns1.netty.io"));
                        message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns2.netty.io"));
                    }
                    return message;
                }
                return message;
            }
        };
        redirectServer.start();
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
        SingletonDnsServerAddressStreamProvider provider = new SingletonDnsServerAddressStreamProvider(redirectServer.localAddress());
        DnsNameResolver resolver = new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), null, false, cache, (DnsCnameCache)NoopDnsCnameCache.INSTANCE, authoritativeDnsServerCache, null, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 2000L, ResolvedAddressTypes.IPV4_ONLY, true, 10, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)provider, (DnsServerAddressStream)new ThreadLocalNameServerAddressStream((DnsServerAddressStreamProvider)provider), DnsNameResolver.DEFAULT_SEARCH_DOMAINS, 0, true, false, 0, strategy){

            InetSocketAddress newRedirectServerAddress(InetAddress server) {
                try {
                    if (server.getHostName().startsWith("ns1.netty.io")) {
                        return new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io", dnsServerAuthority.localAddress().getAddress().getAddress()), dnsServerAuthority.localAddress().getPort());
                    }
                    if (server.getHostName().startsWith("ns2.netty.io")) {
                        return new InetSocketAddress(InetAddress.getByAddress("ns2.netty.io", NetUtil.LOCALHOST.getAddress()), socket.getLocalPort());
                    }
                }
                catch (UnknownHostException e) {
                    throw new IllegalStateException(e);
                }
                return super.newRedirectServerAddress(server);
            }
        };
        try {
            List resolved = (List)resolver.resolveAll(expected.getHostName()).syncUninterruptibly().getNow();
            Assertions.assertEquals((int)1, (int)resolved.size());
            Assertions.assertEquals((Object)expected, resolved.get(0));
            List resolved2 = (List)resolver.resolveAll(expected.getHostName()).syncUninterruptibly().getNow();
            Assertions.assertEquals((int)1, (int)resolved2.size());
            Assertions.assertEquals((Object)expected, resolved2.get(0));
            if (authoritativeDnsServerCache != NoopAuthoritativeDnsServerCache.INSTANCE) {
                DnsServerAddressStream cached = authoritativeDnsServerCache.get("netty.io.");
                Assertions.assertEquals((int)2, (int)cached.size());
                InetSocketAddress ns1Address = InetSocketAddress.createUnresolved("ns1.netty.io.", 53);
                InetSocketAddress ns2Address = InetSocketAddress.createUnresolved("ns2.netty.io.", 53);
                if (invalidNsFirst) {
                    Assertions.assertEquals((Object)ns2Address, (Object)cached.next());
                    Assertions.assertEquals((Object)ns1Address, (Object)cached.next());
                } else {
                    Assertions.assertEquals((Object)ns1Address, (Object)cached.next());
                    Assertions.assertEquals((Object)ns2Address, (Object)cached.next());
                }
            }
            if (cache != NoopDnsCache.INSTANCE) {
                List ns1Cached = cache.get("ns1.netty.io.", null);
                Assertions.assertEquals((int)1, (int)ns1Cached.size());
                DnsCacheEntry nsEntry = (DnsCacheEntry)ns1Cached.get(0);
                Assertions.assertNotNull((Object)nsEntry.address());
                Assertions.assertNull((Object)nsEntry.cause());
                List ns2Cached = cache.get("ns2.netty.io.", null);
                if (invalidNsFirst) {
                    Assertions.assertEquals((int)1, (int)ns2Cached.size());
                    DnsCacheEntry ns2Entry = (DnsCacheEntry)ns2Cached.get(0);
                    Assertions.assertNotNull((Object)ns2Entry.address());
                    Assertions.assertNull((Object)ns2Entry.cause());
                } else {
                    Assertions.assertNull((Object)ns2Cached);
                }
                List expectedCached = cache.get(expected.getHostName(), null);
                Assertions.assertEquals((int)1, (int)expectedCached.size());
                DnsCacheEntry expectedEntry = (DnsCacheEntry)expectedCached.get(0);
                Assertions.assertEquals((Object)expected, (Object)expectedEntry.address());
                Assertions.assertNull((Object)expectedEntry.cause());
            }
        }
        finally {
            resolver.close();
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            redirectServer.stop();
            dnsServerAuthority.stop();
            socket.close();
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testMultipleAdditionalRecordsForSameNSRecord(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testMultipleAdditionalRecordsForSameNSRecord(strategy, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testMultipleAdditionalRecordsForSameNSRecordReordered(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testMultipleAdditionalRecordsForSameNSRecord(strategy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testMultipleAdditionalRecordsForSameNSRecord(DnsNameResolverChannelStrategy strategy, final boolean reversed) throws Exception {
        String domain = "netty.io";
        String hostname = "test.netty.io";
        String ns1Name = "ns1.netty.io";
        final InetSocketAddress ns1Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io", new byte[]{10, 0, 0, 1}), 53);
        final InetSocketAddress ns2Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io", new byte[]{10, 0, 0, 2}), 53);
        final InetSocketAddress ns3Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io", new byte[]{10, 0, 0, 3}), 53);
        final InetSocketAddress ns4Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io", new byte[]{10, 0, 0, 4}), 53);
        TestDnsServer redirectServer = new TestDnsServer(new HashSet<String>(Arrays.asList("test.netty.io", "ns1.netty.io"))){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                for (QuestionRecord record : message.getQuestionRecords()) {
                    if (!record.getDomainName().equals("test.netty.io")) continue;
                    message.getAdditionalRecords().clear();
                    message.getAnswerRecords().clear();
                    message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns1.netty.io"));
                    message.getAdditionalRecords().add(this.newARecord(ns1Address));
                    message.getAdditionalRecords().add(this.newARecord(ns2Address));
                    message.getAdditionalRecords().add(this.newARecord(ns3Address));
                    message.getAdditionalRecords().add(this.newARecord(ns4Address));
                    return message;
                }
                return message;
            }

            private ResourceRecord newARecord(InetSocketAddress address) {
                return 14.newARecord(address.getHostName(), address.getAddress().getHostAddress());
            }
        };
        redirectServer.start();
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
        final CopyOnWriteArrayList cached = new CopyOnWriteArrayList();
        AuthoritativeDnsServerCache authoritativeDnsServerCache = new AuthoritativeDnsServerCache(){

            public DnsServerAddressStream get(String hostname) {
                return null;
            }

            public void cache(String hostname, InetSocketAddress address, long originalTtl, EventLoop loop) {
                cached.add(address);
            }

            public void clear() {
            }

            public boolean clear(String hostname) {
                return false;
            }
        };
        final AtomicReference redirectedRef = new AtomicReference();
        SingletonDnsServerAddressStreamProvider provider = new SingletonDnsServerAddressStreamProvider(redirectServer.localAddress());
        DnsNameResolver resolver = new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), null, false, (DnsCache)NoopDnsCache.INSTANCE, (DnsCnameCache)NoopDnsCnameCache.INSTANCE, authoritativeDnsServerCache, null, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 2000L, ResolvedAddressTypes.IPV4_ONLY, true, 10, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)provider, (DnsServerAddressStream)new ThreadLocalNameServerAddressStream((DnsServerAddressStreamProvider)provider), DnsNameResolver.DEFAULT_SEARCH_DOMAINS, 0, true, false, 0, strategy){

            protected DnsServerAddressStream newRedirectDnsServerStream(String hostname, List<InetSocketAddress> nameservers) {
                if (reversed) {
                    Collections.reverse(nameservers);
                }
                SequentialDnsServerAddressStream stream = new SequentialDnsServerAddressStream(nameservers, 0);
                redirectedRef.set(stream);
                return stream;
            }
        };
        try {
            Throwable cause = resolver.resolveAll("test.netty.io").await().cause();
            Assertions.assertTrue((boolean)(cause instanceof UnknownHostException));
            DnsServerAddressStream redirected = (DnsServerAddressStream)redirectedRef.get();
            Assertions.assertNotNull((Object)redirected);
            Assertions.assertEquals((int)4, (int)redirected.size());
            Assertions.assertEquals((int)4, (int)cached.size());
            if (reversed) {
                Assertions.assertEquals((Object)ns4Address, (Object)redirected.next());
                Assertions.assertEquals((Object)ns3Address, (Object)redirected.next());
                Assertions.assertEquals((Object)ns2Address, (Object)redirected.next());
                Assertions.assertEquals((Object)ns1Address, (Object)redirected.next());
            } else {
                Assertions.assertEquals((Object)ns1Address, (Object)redirected.next());
                Assertions.assertEquals((Object)ns2Address, (Object)redirected.next());
                Assertions.assertEquals((Object)ns3Address, (Object)redirected.next());
                Assertions.assertEquals((Object)ns4Address, (Object)redirected.next());
            }
            Assertions.assertEquals((Object)ns1Address, cached.get(0));
            Assertions.assertEquals((Object)ns2Address, cached.get(1));
            Assertions.assertEquals((Object)ns3Address, cached.get(2));
            Assertions.assertEquals((Object)ns4Address, cached.get(3));
        }
        finally {
            resolver.close();
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            redirectServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testNSRecordsFromCache(DnsNameResolverChannelStrategy strategy) throws Exception {
        String domain = "netty.io";
        String hostname = "test.netty.io";
        String ns0Name = "ns0.netty.io.";
        String ns1Name = "ns1.netty.io.";
        String ns2Name = "ns2.netty.io.";
        final InetSocketAddress ns0Address = new InetSocketAddress(InetAddress.getByAddress("ns0.netty.io.", new byte[]{10, 1, 0, 1}), 53);
        InetSocketAddress ns1Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io.", new byte[]{10, 0, 0, 1}), 53);
        InetSocketAddress ns2Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io.", new byte[]{10, 0, 0, 2}), 53);
        InetSocketAddress ns3Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io.", new byte[]{10, 0, 0, 3}), 53);
        InetSocketAddress ns4Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io.", new byte[]{10, 0, 0, 4}), 53);
        final InetSocketAddress ns5Address = new InetSocketAddress(InetAddress.getByAddress("ns2.netty.io.", new byte[]{10, 0, 0, 5}), 53);
        TestDnsServer redirectServer = new TestDnsServer(new HashSet<String>(Arrays.asList("test.netty.io", "ns1.netty.io."))){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                for (QuestionRecord record : message.getQuestionRecords()) {
                    if (!record.getDomainName().equals("test.netty.io")) continue;
                    message.getAdditionalRecords().clear();
                    message.getAnswerRecords().clear();
                    message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns0.netty.io."));
                    message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns1.netty.io."));
                    message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns2.netty.io."));
                    message.getAdditionalRecords().add(this.newARecord(ns0Address));
                    message.getAdditionalRecords().add(this.newARecord(ns5Address));
                    return message;
                }
                return message;
            }

            private ResourceRecord newARecord(InetSocketAddress address) {
                return 17.newARecord(address.getHostName(), address.getAddress().getHostAddress());
            }
        };
        redirectServer.start();
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
        final CopyOnWriteArrayList cached = new CopyOnWriteArrayList();
        AuthoritativeDnsServerCache authoritativeDnsServerCache = new AuthoritativeDnsServerCache(){

            public DnsServerAddressStream get(String hostname) {
                return null;
            }

            public void cache(String hostname, InetSocketAddress address, long originalTtl, EventLoop loop) {
                cached.add(address);
            }

            public void clear() {
            }

            public boolean clear(String hostname) {
                return false;
            }
        };
        EventLoop loop = group.next();
        DefaultDnsCache cache = new DefaultDnsCache();
        cache.cache("ns1.netty.io.", null, ns1Address.getAddress(), 10000L, loop);
        cache.cache("ns1.netty.io.", null, ns2Address.getAddress(), 10000L, loop);
        cache.cache("ns1.netty.io.", null, ns3Address.getAddress(), 10000L, loop);
        cache.cache("ns1.netty.io.", null, ns4Address.getAddress(), 10000L, loop);
        final AtomicReference redirectedRef = new AtomicReference();
        SingletonDnsServerAddressStreamProvider provider = new SingletonDnsServerAddressStreamProvider(redirectServer.localAddress());
        DnsNameResolver resolver = new DnsNameResolver(loop, (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), null, false, (DnsCache)cache, (DnsCnameCache)NoopDnsCnameCache.INSTANCE, authoritativeDnsServerCache, null, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 2000L, ResolvedAddressTypes.IPV4_ONLY, true, 10, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)provider, (DnsServerAddressStream)new ThreadLocalNameServerAddressStream((DnsServerAddressStreamProvider)provider), DnsNameResolver.DEFAULT_SEARCH_DOMAINS, 0, true, false, 0, strategy){

            protected DnsServerAddressStream newRedirectDnsServerStream(String hostname, List<InetSocketAddress> nameservers) {
                SequentialDnsServerAddressStream stream = new SequentialDnsServerAddressStream(nameservers, 0);
                redirectedRef.set(stream);
                return stream;
            }
        };
        try {
            Throwable cause = resolver.resolveAll("test.netty.io").await().cause();
            Assertions.assertTrue((boolean)(cause instanceof UnknownHostException));
            DnsServerAddressStream redirected = (DnsServerAddressStream)redirectedRef.get();
            Assertions.assertNotNull((Object)redirected);
            Assertions.assertEquals((int)6, (int)redirected.size());
            Assertions.assertEquals((int)3, (int)cached.size());
            Assertions.assertEquals((Object)ns0Address, (Object)redirected.next());
            Assertions.assertEquals((Object)ns1Address, (Object)redirected.next());
            Assertions.assertEquals((Object)ns2Address, (Object)redirected.next());
            Assertions.assertEquals((Object)ns3Address, (Object)redirected.next());
            Assertions.assertEquals((Object)ns4Address, (Object)redirected.next());
            Assertions.assertEquals((Object)ns5Address, (Object)redirected.next());
            Assertions.assertEquals((Object)ns0Address, cached.get(0));
            Assertions.assertEquals((Object)ns5Address, cached.get(1));
            Assertions.assertEquals((Object)DnsNameResolverTest.unresolved(ns1Address), cached.get(2));
        }
        finally {
            resolver.close();
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            redirectServer.stop();
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testNsLoopFailsResolveWithAuthoritativeDnsServerCache(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testNsLoopFailsResolve(strategy, (AuthoritativeDnsServerCache)new DefaultAuthoritativeDnsServerCache());
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testNsLoopFailsResolveWithoutAuthoritativeDnsServerCache(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testNsLoopFailsResolve(strategy, (AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testRRNameContainsDifferentSearchDomainNoDomains(final DnsNameResolverChannelStrategy strategy) {
        Assertions.assertThrows(UnknownHostException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DnsNameResolverTest.testRRNameContainsDifferentSearchDomain(strategy, Collections.emptyList(), "netty");
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testRRNameContainsDifferentSearchDomainEmptyExtraDomain(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testRRNameContainsDifferentSearchDomain(strategy, Arrays.asList("io", ""), "netty");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testRRNameContainsDifferentSearchDomainSingleExtraDomain(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testRRNameContainsDifferentSearchDomain(strategy, Arrays.asList("io", "foo.dom"), "netty");
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testRRNameContainsDifferentSearchDomainMultiExtraDomains(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testRRNameContainsDifferentSearchDomain(strategy, Arrays.asList("com", "foo.dom", "bar.dom"), "google");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testRRNameContainsDifferentSearchDomain(DnsNameResolverChannelStrategy strategy, final List<String> searchDomains, String unresolved) throws Exception {
        String ipAddrPrefix = "1.2.3.";
        TestDnsServer searchDomainServer = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) {
                HashSet<ResourceRecord> records = new HashSet<ResourceRecord>(searchDomains.size());
                String qName = questionRecord.getDomainName();
                for (String searchDomain : searchDomains) {
                    if (qName.endsWith(searchDomain)) continue;
                    ResourceRecord rr = TestDnsServer.newARecord(qName + '.' + searchDomain, "1.2.3." + ThreadLocalRandom.current().nextInt(1, 10));
                    logger.info("Adding A record: " + rr);
                    records.add(rr);
                }
                return records;
            }
        });
        searchDomainServer.start();
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, false, null, searchDomainServer).searchDomains(searchDomains).build();
        try {
            List addresses = (List)resolver.resolveAll(unresolved).sync().get();
            MatcherAssert.assertThat((Object)addresses, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
            for (InetAddress address : addresses) {
                MatcherAssert.assertThat((Object)address.getHostName(), (Matcher)Matchers.startsWith((String)unresolved));
                MatcherAssert.assertThat((Object)address.getHostAddress(), (Matcher)Matchers.startsWith((String)"1.2.3."));
            }
        }
        finally {
            resolver.close();
            searchDomainServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNsLoopFailsResolve(DnsNameResolverChannelStrategy strategy, AuthoritativeDnsServerCache authoritativeDnsServerCache) throws Exception {
        String domain = "netty.io";
        String ns1Name = "ns1.netty.io";
        String ns2Name = "ns2.netty.io";
        TestDnsServer testDnsServer = new TestDnsServer(new HashSet<String>(Collections.singletonList("netty.io"))){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                for (QuestionRecord record : message.getQuestionRecords()) {
                    if (!record.getDomainName().equals("netty.io")) continue;
                    message.getAdditionalRecords().clear();
                    message.getAnswerRecords().clear();
                    message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns1.netty.io"));
                    message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns2.netty.io"));
                }
                return message;
            }
        };
        testDnsServer.start();
        DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy);
        DnsNameResolver resolver = builder.resolveCache((DnsCache)NoopDnsCache.INSTANCE).authoritativeDnsServerCache(authoritativeDnsServerCache).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(testDnsServer.localAddress())).build();
        try {
            MatcherAssert.assertThat((Object)resolver.resolve("netty.io").await().cause(), (Matcher)Matchers.instanceOf(UnknownHostException.class));
            MatcherAssert.assertThat((Object)resolver.resolveAll("netty.io").await().cause(), (Matcher)Matchers.instanceOf(UnknownHostException.class));
        }
        finally {
            resolver.close();
            testDnsServer.stop();
        }
    }

    private static InetSocketAddress unresolved(InetSocketAddress address) {
        return InetSocketAddress.createUnresolved(address.getHostString(), address.getPort());
    }

    private static void resolve(DnsNameResolver resolver, Map<String, Future<InetAddress>> futures, String hostname) {
        futures.put(hostname, (Future<InetAddress>)resolver.resolve(hostname));
    }

    private static void queryMx(DnsNameResolver resolver, Map<String, Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>> futures, String hostname) {
        futures.put(hostname, (Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>)resolver.query((DnsQuestion)new DefaultDnsQuestion(hostname, DnsRecordType.MX)));
    }

    private static void assertNoQueriesMade(DnsNameResolver resolver) {
        TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = (TestRecursiveCacheDnsQueryLifecycleObserverFactory)resolver.dnsQueryLifecycleObserverFactory();
        Assertions.assertTrue((boolean)lifecycleObserverFactory.observers.isEmpty());
    }

    private static void assertQueryObserver(DnsNameResolver resolver, DnsRecordType cancelledType) {
        TestDnsQueryLifecycleObserver observer;
        TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = (TestRecursiveCacheDnsQueryLifecycleObserverFactory)resolver.dnsQueryLifecycleObserverFactory();
        while ((observer = lifecycleObserverFactory.observers.poll()) != null) {
            Object o = observer.events.poll();
            if (o instanceof QueryCancelledEvent) {
                Assertions.assertEquals((Object)cancelledType, (Object)observer.question.type());
            } else if (o instanceof QueryWrittenEvent) {
                QuerySucceededEvent querySucceededEvent = (QuerySucceededEvent)observer.events.poll();
            } else {
                Assertions.fail((String)("unexpected event type: " + o));
            }
            Assertions.assertTrue((boolean)observer.events.isEmpty());
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testTimeoutNotCached(DnsNameResolverChannelStrategy strategy) {
        DnsCache cache = new DnsCache(){

            public void clear() {
            }

            public boolean clear(String hostname) {
                return false;
            }

            public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
                return Collections.emptyList();
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, InetAddress address, long originalTtl, EventLoop loop) {
                Assertions.fail((String)"Should not be cached");
                return null;
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, Throwable cause, EventLoop loop) {
                Assertions.fail((String)"Should not be cached");
                return null;
            }
        };
        DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy);
        builder.queryTimeoutMillis(100L).authoritativeDnsServerCache(cache).resolveCache(cache).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(new InetSocketAddress(NetUtil.LOCALHOST, 12345)));
        DnsNameResolver resolver = builder.build();
        Future result = resolver.resolve("doesnotexist.netty.io").awaitUninterruptibly();
        Throwable cause = result.cause();
        MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(UnknownHostException.class));
        cause.getCause().printStackTrace();
        MatcherAssert.assertThat((Object)cause.getCause(), (Matcher)Matchers.instanceOf(DnsNameResolverTimeoutException.class));
        Assertions.assertTrue((boolean)DnsNameResolver.isTimeoutError((Throwable)cause));
        Assertions.assertTrue((boolean)DnsNameResolver.isTransportOrTimeoutError((Throwable)cause));
        resolver.close();
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testTimeoutIpv4PreferredA(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testTimeoutOneQuery(strategy, ResolvedAddressTypes.IPV4_PREFERRED, RecordType.A, RecordType.AAAA);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testTimeoutIpv4PreferredAAAA(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testTimeoutOneQuery(strategy, ResolvedAddressTypes.IPV4_PREFERRED, RecordType.AAAA, RecordType.A);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testTimeoutIpv6PreferredA(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testTimeoutOneQuery(strategy, ResolvedAddressTypes.IPV6_PREFERRED, RecordType.A, RecordType.AAAA);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testTimeoutIpv6PreferredAAAA(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testTimeoutOneQuery(strategy, ResolvedAddressTypes.IPV6_PREFERRED, RecordType.AAAA, RecordType.A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testTimeoutOneQuery(DnsNameResolverChannelStrategy strategy, ResolvedAddressTypes type, final RecordType recordType, RecordType dropType) throws IOException {
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>(2);
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                if (question.getRecordType() == RecordType.A) {
                    map1.put("apacheDnsIpAddress".toLowerCase(), "10.0.0.2");
                } else {
                    map1.put("apacheDnsIpAddress".toLowerCase(), "::1");
                }
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), recordType, map1));
                return records;
            }
        });
        dnsServer2.start(dropType);
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(true).queryTimeoutMillis(500L).resolvedAddressTypes(type).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            List resolvedAddresses = (List)resolver.resolveAll("somehost.netty.io").syncUninterruptibly().getNow();
            Assertions.assertEquals((int)1, (int)resolvedAddresses.size());
            if (recordType == RecordType.A) {
                Assertions.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 2})));
            } else {
                Assertions.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1})));
            }
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @Test
    public void testDnsNameResolverBuilderCopy() {
        ReflectiveChannelFactory channelFactory = new ReflectiveChannelFactory(NioDatagramChannel.class);
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder(group.next()).datagramChannelFactory((ChannelFactory)channelFactory);
        DnsNameResolverBuilder copiedBuilder = builder.copy();
        ReflectiveChannelFactory newChannelFactory = new ReflectiveChannelFactory(NioDatagramChannel.class);
        builder.datagramChannelFactory((ChannelFactory)newChannelFactory);
        Assertions.assertEquals((Object)channelFactory, (Object)copiedBuilder.datagramChannelFactory());
        Assertions.assertEquals((Object)newChannelFactory, (Object)builder.datagramChannelFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testFollowCNAMEEvenIfARecordIsPresent(DnsNameResolverChannelStrategy strategy) throws IOException {
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                if (question.getDomainName().equals("cname.netty.io")) {
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    map1.put("apacheDnsIpAddress".toLowerCase(), "10.0.0.99");
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.A, map1));
                }
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>(2);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("apacheDnsDomainName".toLowerCase(), "cname.netty.io");
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.CNAME, map));
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("apacheDnsIpAddress".toLowerCase(), "10.0.0.2");
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.A, map1));
                return records;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(true).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            List resolvedAddresses = (List)resolver.resolveAll("somehost.netty.io").syncUninterruptibly().getNow();
            Assertions.assertEquals((int)2, (int)resolvedAddresses.size());
            Assertions.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 99})));
            Assertions.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 2})));
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCNAMEFollowInResponseWithoutExtraQuery(DnsNameResolverChannelStrategy strategy) throws IOException {
        final AtomicInteger queryCount = new AtomicInteger();
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                queryCount.incrementAndGet();
                if (question.getDomainName().equals("somehost.netty.io")) {
                    LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>(2);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("apacheDnsDomainName".toLowerCase(), "cname.netty.io");
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.CNAME, map));
                    map = new HashMap();
                    map.put("apacheDnsDomainName".toLowerCase(), "cname2.netty.io");
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord("cname.netty.io", RecordType.CNAME, map));
                    map = new HashMap();
                    map.put("apacheDnsDomainName".toLowerCase(), "cname3.netty.io");
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord("cname2.netty.io", RecordType.CNAME, map));
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    map1.put("apacheDnsIpAddress".toLowerCase(), "10.0.0.2");
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord("cname3.netty.io", RecordType.A, map1));
                    return records;
                }
                return null;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(true).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            List resolvedAddresses = (List)resolver.resolveAll("somehost.netty.io").syncUninterruptibly().getNow();
            Assertions.assertEquals((int)1, (int)resolvedAddresses.size());
            Assertions.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 2})));
            Assertions.assertEquals((int)1, (int)queryCount.get());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testFollowCNAMELoop(DnsNameResolverChannelStrategy strategy) throws IOException {
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>(4);
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord("x." + question.getDomainName(), RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "10.0.0.99")));
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord("cname2.netty.io", RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "cname.netty.io")));
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord("cname.netty.io", RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "cname2.netty.io")));
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "cname.netty.io")));
                return records;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(false).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            final DnsNameResolver finalResolver = resolver = builder.build();
            Assertions.assertThrows(UnknownHostException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    finalResolver.resolveAll("somehost.netty.io").syncUninterruptibly().getNow();
                }
            });
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCNAMELoopInCache(DnsNameResolverChannelStrategy strategy) throws Throwable {
        try (DnsNameResolver resolver = null;){
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(false).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer.localAddress()));
            resolver = builder.build();
            String name = "somehost.netty.io.";
            String name2 = "cname.netty.io.";
            resolver.cnameCache().cache("somehost.netty.io.", name2, Long.MAX_VALUE, resolver.executor());
            resolver.cnameCache().cache(name2, "somehost.netty.io.", Long.MAX_VALUE, resolver.executor());
            final DnsNameResolver finalResolver = resolver;
            Assertions.assertThrows(UnknownHostException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    finalResolver.resolve("somehost.netty.io.").syncUninterruptibly().getNow();
                }
            });
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testSearchDomainQueryFailureForSingleAddressTypeCompletes(final DnsNameResolverChannelStrategy strategy) {
        Assertions.assertThrows(UnknownHostException.class, (Executable)new Executable(){

            public void execute() {
                DnsNameResolverTest.this.testSearchDomainQueryFailureCompletes(strategy, ResolvedAddressTypes.IPV4_ONLY);
            }
        });
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testSearchDomainQueryFailureForMultipleAddressTypeCompletes(final DnsNameResolverChannelStrategy strategy) {
        Assertions.assertThrows(UnknownHostException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DnsNameResolverTest.this.testSearchDomainQueryFailureCompletes(strategy, ResolvedAddressTypes.IPV4_PREFERRED);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSearchDomainQueryFailureCompletes(DnsNameResolverChannelStrategy strategy, ResolvedAddressTypes types) {
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).resolvedAddressTypes(types).ndots(1).searchDomains(Collections.singletonList(".")).build();){
            resolver.resolve("invalid.com").syncUninterruptibly();
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testCachesClearedOnClose(DnsNameResolverChannelStrategy strategy) throws Exception {
        final CountDownLatch resolveLatch = new CountDownLatch(1);
        final CountDownLatch authoritativeLatch = new CountDownLatch(1);
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).resolveCache(new DnsCache(){

            public void clear() {
                resolveLatch.countDown();
            }

            public boolean clear(String hostname) {
                return false;
            }

            public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
                return null;
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, InetAddress address, long originalTtl, EventLoop loop) {
                return null;
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, Throwable cause, EventLoop loop) {
                return null;
            }
        }).authoritativeDnsServerCache(new DnsCache(){

            public void clear() {
                authoritativeLatch.countDown();
            }

            public boolean clear(String hostname) {
                return false;
            }

            public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
                return null;
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, InetAddress address, long originalTtl, EventLoop loop) {
                return null;
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, Throwable cause, EventLoop loop) {
                return null;
            }
        }).build();
        resolver.close();
        resolveLatch.await();
        authoritativeLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveACachedWithDot(DnsNameResolverChannelStrategy strategy) {
        DefaultDnsCache cache = new DefaultDnsCache();
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, ResolvedAddressTypes.IPV4_ONLY).resolveCache((DnsCache)cache).build();){
            String domain = DOMAINS.iterator().next();
            String domainWithDot = domain + '.';
            resolver.resolve(domain).syncUninterruptibly();
            List cached = cache.get(domain, null);
            List cached2 = cache.get(domainWithDot, null);
            Assertions.assertEquals((int)1, (int)cached.size());
            Assertions.assertEquals((Object)cached, (Object)cached2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveACachedWithDotSearchDomain(DnsNameResolverChannelStrategy strategy) throws Exception {
        TestDnsCache cache = new TestDnsCache((DnsCache)new DefaultDnsCache());
        TestDnsServer server = new TestDnsServer(Collections.singleton("test.netty.io"));
        server.start();
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, ResolvedAddressTypes.IPV4_ONLY).searchDomains(Collections.singletonList("netty.io")).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(server.localAddress())).resolveCache((DnsCache)cache).build();
        try {
            resolver.resolve("test").syncUninterruptibly();
            Assertions.assertNull(cache.cacheHits.get("test.netty.io"));
            List cached = cache.cache.get("test.netty.io", null);
            List cached2 = cache.cache.get("test.netty.io.", null);
            Assertions.assertEquals((int)1, (int)cached.size());
            Assertions.assertEquals((Object)cached, (Object)cached2);
            Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
            boolean isCached = DnsNameResolver.doResolveAllCached((String)"test", null, (Promise)promise, (DnsCache)cache, (String[])resolver.searchDomains(), (int)resolver.ndots(), (SocketProtocolFamily[])resolver.resolvedInternetProtocolFamiliesUnsafe());
            Assertions.assertTrue((boolean)isCached);
            promise.sync();
            List<? extends DnsCacheEntry> entries = cache.cacheHits.get("test.netty.io");
            Assertions.assertFalse((boolean)entries.isEmpty());
        }
        finally {
            resolver.close();
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCNameCached(DnsNameResolverChannelStrategy strategy) throws Exception {
        final ConcurrentHashMap cache = new ConcurrentHashMap();
        final AtomicInteger cnameQueries = new AtomicInteger();
        final AtomicInteger aQueries = new AtomicInteger();
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                if ("cname.netty.io".equals(question.getDomainName())) {
                    aQueries.incrementAndGet();
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "10.0.0.99")));
                }
                if ("x.netty.io".equals(question.getDomainName())) {
                    cnameQueries.incrementAndGet();
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "cname.netty.io")));
                }
                if ("y.netty.io".equals(question.getDomainName())) {
                    cnameQueries.incrementAndGet();
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "x.netty.io")));
                }
                return Collections.emptySet();
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(true).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress())).resolveCache((DnsCache)NoopDnsCache.INSTANCE).cnameCache(new DnsCnameCache(){

                public String get(String hostname) {
                    Assertions.assertTrue((boolean)hostname.endsWith("."), (String)hostname);
                    return (String)cache.get(hostname);
                }

                public void cache(String hostname, String cname, long originalTtl, EventLoop loop) {
                    Assertions.assertTrue((boolean)hostname.endsWith("."), (String)hostname);
                    cache.put(hostname, cname);
                }

                public void clear() {
                }

                public boolean clear(String hostname) {
                    return false;
                }
            });
            resolver = builder.build();
            List resolvedAddresses = (List)resolver.resolveAll("x.netty.io").syncUninterruptibly().getNow();
            Assertions.assertEquals((int)1, (int)resolvedAddresses.size());
            Assertions.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 99})));
            Assertions.assertEquals((Object)"cname.netty.io.", cache.get("x.netty.io."));
            Assertions.assertEquals((int)1, (int)cnameQueries.get());
            Assertions.assertEquals((int)1, (int)aQueries.get());
            resolvedAddresses = (List)resolver.resolveAll("x.netty.io").syncUninterruptibly().getNow();
            Assertions.assertEquals((int)1, (int)resolvedAddresses.size());
            Assertions.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 99})));
            Assertions.assertEquals((int)1, (int)cnameQueries.get());
            Assertions.assertEquals((int)2, (int)aQueries.get());
            resolvedAddresses = (List)resolver.resolveAll("y.netty.io").syncUninterruptibly().getNow();
            Assertions.assertEquals((int)1, (int)resolvedAddresses.size());
            Assertions.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 99})));
            Assertions.assertEquals((Object)"x.netty.io.", cache.get("y.netty.io."));
            Assertions.assertEquals((int)2, (int)cnameQueries.get());
            Assertions.assertEquals((int)3, (int)aQueries.get());
            resolvedAddresses = (List)resolver.resolveAll("y.netty.io").syncUninterruptibly().getNow();
            Assertions.assertEquals((int)1, (int)resolvedAddresses.size());
            Assertions.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 99})));
            Assertions.assertEquals((int)2, (int)cnameQueries.get());
            Assertions.assertEquals((int)4, (int)aQueries.get());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @Test
    public void testInstanceWithNullPreferredAddressType() {
        new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), (DnsCache)NoopDnsCache.INSTANCE, (AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 100L, null, true, 1, false, 4096, true, HostsFileEntriesResolver.DEFAULT, DnsServerAddressStreamProviders.platformDefault(), null, 1, true).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testQueryTxt(DnsNameResolverChannelStrategy strategy) throws Exception {
        String hostname = "txt.netty.io";
        String txt1 = "some text";
        String txt2 = "some more text";
        TestDnsServer server = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                if (question.getDomainName().equals("txt.netty.io")) {
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    map1.put("apacheDnsCharacterString".toLowerCase(), "some text");
                    HashMap<String, Object> map2 = new HashMap<String, Object>();
                    map2.put("apacheDnsCharacterString".toLowerCase(), "some more text");
                    HashSet<ResourceRecord> records = new HashSet<ResourceRecord>();
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.TXT, map1));
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.TXT, map2));
                    return records;
                }
                return Collections.emptySet();
            }
        });
        server.start();
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, ResolvedAddressTypes.IPV4_ONLY).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(server.localAddress())).build();
        try {
            AddressedEnvelope envelope = (AddressedEnvelope)resolver.query((DnsQuestion)new DefaultDnsQuestion("txt.netty.io", DnsRecordType.TXT)).syncUninterruptibly().getNow();
            Assertions.assertNotNull((Object)envelope.sender());
            DnsResponse response = (DnsResponse)envelope.content();
            Assertions.assertNotNull((Object)response);
            Assertions.assertEquals((Object)DnsResponseCode.NOERROR, (Object)response.code());
            int count = response.count(DnsSection.ANSWER);
            Assertions.assertEquals((int)2, (int)count);
            ArrayList<String> txts = new ArrayList<String>();
            for (int i = 0; i < 2; ++i) {
                txts.addAll(DnsNameResolverTest.decodeTxt(response.recordAt(DnsSection.ANSWER, i)));
            }
            Assertions.assertTrue((boolean)txts.contains("some text"));
            Assertions.assertTrue((boolean)txts.contains("some more text"));
            envelope.release();
        }
        finally {
            resolver.close();
            server.stop();
        }
    }

    private static List<String> decodeTxt(DnsRecord record) {
        short len;
        if (!(record instanceof DnsRawRecord)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        ByteBuf data = ((DnsRawRecord)record).content();
        int wIdx = data.writerIndex();
        for (int idx = data.readerIndex(); idx < wIdx; idx += len) {
            len = data.getUnsignedByte(idx++);
            list.add(data.toString(idx, (int)len, CharsetUtil.UTF_8));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testNotIncludeDuplicates(DnsNameResolverChannelStrategy strategy) throws IOException {
        String name = "netty.io";
        String ipv4Addr = "1.2.3.4";
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>(4);
                String qName = question.getDomainName().toLowerCase();
                if (qName.equals("netty.io")) {
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(qName, RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "cname.netty.io")));
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(qName, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "1.2.3.4")));
                } else {
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(qName, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "1.2.3.4")));
                }
                return records;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(true).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            builder.resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY);
            resolver = builder.build();
            List resolvedAddresses = (List)resolver.resolveAll("netty.io").syncUninterruptibly().getNow();
            Assertions.assertEquals(Collections.singletonList(InetAddress.getByAddress("netty.io", new byte[]{1, 2, 3, 4})), (Object)resolvedAddresses);
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testIncludeDuplicates(DnsNameResolverChannelStrategy strategy) throws IOException {
        String name = "netty.io";
        String ipv4Addr = "1.2.3.4";
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>(2);
                String qName = question.getDomainName().toLowerCase();
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(qName, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "1.2.3.4")));
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(qName, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "1.2.3.4")));
                return records;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(true).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            builder.resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY);
            resolver = builder.build();
            List resolvedAddresses = (List)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("netty.io", DnsRecordType.A)).syncUninterruptibly().getNow();
            Assertions.assertEquals((int)2, (int)resolvedAddresses.size());
            for (DnsRecord record : resolvedAddresses) {
                ReferenceCountUtil.release((Object)record);
            }
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testDropAAAA(DnsNameResolverChannelStrategy strategy) throws IOException {
        String host = "somehost.netty.io";
        TestDnsServer dnsServer2 = new TestDnsServer(Collections.singleton(host));
        dnsServer2.start(RecordType.AAAA);
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(false).queryTimeoutMillis(500L).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            List addressList = (List)resolver.resolveAll(host).syncUninterruptibly().getNow();
            Assertions.assertEquals((int)1, (int)addressList.size());
            Assertions.assertEquals((Object)host, (Object)((InetAddress)addressList.get(0)).getHostName());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testDropAAAAResolveFast(DnsNameResolverChannelStrategy strategy) throws IOException {
        String host = "somehost.netty.io";
        TestDnsServer dnsServer2 = new TestDnsServer(Collections.singleton(host));
        dnsServer2.start(RecordType.AAAA);
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(false).queryTimeoutMillis(10000L).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).completeOncePreferredResolved(true).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            InetAddress address = (InetAddress)resolver.resolve(host).syncUninterruptibly().getNow();
            Assertions.assertEquals((Object)host, (Object)address.getHostName());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testDropAAAAResolveAllFast(DnsNameResolverChannelStrategy strategy) throws IOException {
        String host = "somehost.netty.io";
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
                String name = question.getDomainName();
                if (name.equals("somehost.netty.io")) {
                    HashSet<ResourceRecord> records = new HashSet<ResourceRecord>(2);
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(name, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "10.0.0.1")));
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(name, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "10.0.0.2")));
                    return records;
                }
                return null;
            }
        });
        dnsServer2.start(RecordType.AAAA);
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(false).queryTimeoutMillis(10000L).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).completeOncePreferredResolved(true).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            List addresses = (List)resolver.resolveAll("somehost.netty.io").syncUninterruptibly().getNow();
            Assertions.assertEquals((int)2, (int)addresses.size());
            for (InetAddress address : addresses) {
                MatcherAssert.assertThat((Object)address, (Matcher)Matchers.instanceOf(Inet4Address.class));
                Assertions.assertEquals((Object)"somehost.netty.io", (Object)address.getHostName());
            }
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testTruncatedWithoutTcpFallback(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testTruncated0(strategy, false, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testTruncatedWithTcpFallback(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testTruncated0(strategy, true, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testTruncatedWithTcpFallbackBecauseOfMtu(DnsNameResolverChannelStrategy strategy) throws IOException {
        DnsNameResolverTest.testTruncated0(strategy, true, true);
    }

    private static DnsMessageModifier modifierFrom(DnsMessage message) {
        DnsMessageModifier modifier = new DnsMessageModifier();
        modifier.setAcceptNonAuthenticatedData(message.isAcceptNonAuthenticatedData());
        modifier.setAdditionalRecords(message.getAdditionalRecords());
        modifier.setAnswerRecords(message.getAnswerRecords());
        modifier.setAuthoritativeAnswer(message.isAuthoritativeAnswer());
        modifier.setAuthorityRecords(message.getAuthorityRecords());
        modifier.setMessageType(message.getMessageType());
        modifier.setOpCode(message.getOpCode());
        modifier.setQuestionRecords(message.getQuestionRecords());
        modifier.setRecursionAvailable(message.isRecursionAvailable());
        modifier.setRecursionDesired(message.isRecursionDesired());
        modifier.setReserved(message.isReserved());
        modifier.setResponseCode(message.getResponseCode());
        modifier.setTransactionId(message.getTransactionId());
        modifier.setTruncated(message.isTruncated());
        return modifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testTruncated0(DnsNameResolverChannelStrategy strategy, boolean tcpFallback, final boolean truncatedBecauseOfMtu) throws IOException {
        ServerSocket serverSocket = null;
        String host = "somehost.netty.io";
        String txt = "this is a txt record";
        final AtomicReference messageRef = new AtomicReference();
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                String name = question.getDomainName();
                if (name.equals("somehost.netty.io")) {
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(name, RecordType.TXT, Collections.singletonMap("apacheDnsCharacterString".toLowerCase(), "this is a txt record")));
                }
                return null;
            }
        }){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                messageRef.set(message);
                if (!truncatedBecauseOfMtu) {
                    DnsMessageModifier modifier = DnsNameResolverTest.modifierFrom(message);
                    modifier.setTruncated(true);
                    return modifier.getDnsMessage();
                }
                return message;
            }
        };
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy);
            NioDatagramChannel datagramChannel = new NioDatagramChannel();
            ChannelFactory<DatagramChannel> channelFactory = new ChannelFactory<DatagramChannel>((DatagramChannel)datagramChannel){
                final /* synthetic */ DatagramChannel val$datagramChannel;
                {
                    this.val$datagramChannel = datagramChannel;
                }

                public DatagramChannel newChannel() {
                    return this.val$datagramChannel;
                }
            };
            builder.datagramChannelFactory((ChannelFactory)channelFactory);
            if (tcpFallback) {
                serverSocket = DnsNameResolverTest.startDnsServerAndCreateServerSocket(dnsServer2);
                builder.socketChannelType(NioSocketChannel.class);
            } else {
                dnsServer2.start();
            }
            builder.queryTimeoutMillis(10000L).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            if (truncatedBecauseOfMtu) {
                datagramChannel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        if (msg instanceof DatagramPacket) {
                            DatagramPacket packet = (DatagramPacket)msg;
                            ((ByteBuf)packet.content()).writerIndex(((ByteBuf)packet.content()).writerIndex() - 1);
                        }
                        ctx.fireChannelRead(msg);
                    }
                }});
            }
            Future envelopeFuture = resolver.query((DnsQuestion)new DefaultDnsQuestion("somehost.netty.io", DnsRecordType.TXT));
            if (tcpFallback) {
                Socket socket = serverSocket.accept();
                DnsNameResolverTest.responseViaSocket(socket, (DnsMessage)messageRef.get());
                envelopeFuture.syncUninterruptibly();
                socket.close();
                serverSocket.close();
            }
            AddressedEnvelope envelope = (AddressedEnvelope)envelopeFuture.syncUninterruptibly().getNow();
            Assertions.assertNotNull((Object)envelope.sender());
            DnsResponse response = (DnsResponse)envelope.content();
            Assertions.assertNotNull((Object)response);
            Assertions.assertEquals((Object)DnsResponseCode.NOERROR, (Object)response.code());
            int count = response.count(DnsSection.ANSWER);
            Assertions.assertEquals((int)1, (int)count);
            List<String> texts = DnsNameResolverTest.decodeTxt(response.recordAt(DnsSection.ANSWER, 0));
            Assertions.assertEquals((int)1, (int)texts.size());
            Assertions.assertEquals((Object)"this is a txt record", (Object)texts.get(0));
            if (tcpFallback) {
                Assertions.assertFalse((boolean)((DnsResponse)envelope.content()).isTruncated());
            } else {
                Assertions.assertTrue((boolean)((DnsResponse)envelope.content()).isTruncated());
            }
            Assertions.assertTrue((boolean)envelope.release());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    private static void responseViaSocket(Socket socket, DnsMessage message) throws IOException {
        InputStream in = socket.getInputStream();
        Assertions.assertTrue(((in.read() << 8 | in.read() & 0xFF) > 2 ? 1 : 0) != 0);
        int txnId = in.read() << 8 | in.read() & 0xFF;
        IoBuffer ioBuffer = IoBuffer.allocate((int)1024);
        DnsMessageModifier modifier = DnsNameResolverTest.modifierFrom(message);
        modifier.setTransactionId(txnId);
        new DnsMessageEncoder().encode(ioBuffer, modifier.getDnsMessage());
        ioBuffer.flip();
        ByteBuffer lenBuffer = ByteBuffer.allocate(2);
        lenBuffer.putShort((short)ioBuffer.remaining());
        lenBuffer.flip();
        while (lenBuffer.hasRemaining()) {
            socket.getOutputStream().write(lenBuffer.get());
        }
        while (ioBuffer.hasRemaining()) {
            socket.getOutputStream().write(ioBuffer.get());
        }
        socket.getOutputStream().flush();
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testTcpFallbackWhenTimeout(DnsNameResolverChannelStrategy strategy) throws IOException {
        this.testTcpFallbackWhenTimeout(strategy, true);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testTcpFallbackFailedWhenTimeout(DnsNameResolverChannelStrategy strategy) throws IOException {
        this.testTcpFallbackWhenTimeout(strategy, false);
    }

    private static ServerSocket startDnsServerAndCreateServerSocket(TestDnsServer dns) throws IOException {
        int i = 0;
        while (true) {
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(new InetSocketAddress(NetUtil.LOCALHOST4, 0));
            try {
                dns.start(null, (InetSocketAddress)serverSocket.getLocalSocketAddress());
                return serverSocket;
            }
            catch (IOException e) {
                serverSocket.close();
                if (i == 10) {
                    throw new IllegalStateException("Unable to bind TestDnsServer and ServerSocket to the same address", e);
                }
                ++i;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTcpFallbackWhenTimeout(DnsNameResolverChannelStrategy strategy, boolean tcpSuccess) throws IOException {
        String host = "somehost.netty.io";
        String txt = "this is a txt record";
        final AtomicReference messageRef = new AtomicReference();
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                String name = question.getDomainName();
                if (name.equals("somehost.netty.io")) {
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(name, RecordType.TXT, Collections.singletonMap("apacheDnsCharacterString".toLowerCase(), "this is a txt record")));
                }
                return null;
            }
        }){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                messageRef.set(message);
                return null;
            }
        };
        DnsNameResolver resolver = null;
        ServerSocket serverSocket = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy);
            NioDatagramChannel datagramChannel = new NioDatagramChannel();
            ChannelFactory<DatagramChannel> channelFactory = new ChannelFactory<DatagramChannel>((DatagramChannel)datagramChannel){
                final /* synthetic */ DatagramChannel val$datagramChannel;
                {
                    this.val$datagramChannel = datagramChannel;
                }

                public DatagramChannel newChannel() {
                    return this.val$datagramChannel;
                }
            };
            builder.datagramChannelFactory((ChannelFactory)channelFactory);
            serverSocket = DnsNameResolverTest.startDnsServerAndCreateServerSocket(dnsServer2);
            builder.socketChannelType(NioSocketChannel.class, true);
            builder.queryTimeoutMillis(1000L).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress())).datagramChannelStrategy(strategy);
            resolver = builder.build();
            Future envelopeFuture = resolver.query((DnsQuestion)new DefaultDnsQuestion("somehost.netty.io", DnsRecordType.TXT));
            Socket socket = serverSocket.accept();
            if (tcpSuccess) {
                DnsNameResolverTest.responseViaSocket(socket, (DnsMessage)messageRef.get());
                envelopeFuture.syncUninterruptibly();
                socket.close();
                AddressedEnvelope envelope = (AddressedEnvelope)envelopeFuture.syncUninterruptibly().getNow();
                Assertions.assertNotNull((Object)envelope.sender());
                DnsResponse response = (DnsResponse)envelope.content();
                Assertions.assertNotNull((Object)response);
                Assertions.assertEquals((Object)DnsResponseCode.NOERROR, (Object)response.code());
                int count = response.count(DnsSection.ANSWER);
                Assertions.assertEquals((int)1, (int)count);
                List<String> texts = DnsNameResolverTest.decodeTxt(response.recordAt(DnsSection.ANSWER, 0));
                Assertions.assertEquals((int)1, (int)texts.size());
                Assertions.assertEquals((Object)"this is a txt record", (Object)texts.get(0));
                Assertions.assertFalse((boolean)((DnsResponse)envelope.content()).isTruncated());
                Assertions.assertTrue((boolean)envelope.release());
            } else {
                socket.close();
                Throwable error = envelopeFuture.awaitUninterruptibly().cause();
                MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(DnsNameResolverTimeoutException.class));
                MatcherAssert.assertThat((Object)error.getSuppressed().length, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            }
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
            if (serverSocket != null) {
                serverSocket.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCancelPromise(DnsNameResolverChannelStrategy strategy) throws Exception {
        EventLoop eventLoop = group.next();
        final Promise promise = eventLoop.newPromise();
        TestDnsServer dnsServer1 = new TestDnsServer(Collections.emptySet()){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                promise.cancel(true);
                return message;
            }
        };
        dnsServer1.start();
        final AtomicBoolean isQuerySentToSecondServer = new AtomicBoolean();
        TestDnsServer dnsServer2 = new TestDnsServer(Collections.emptySet()){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                isQuerySentToSecondServer.set(true);
                return message;
            }
        };
        dnsServer2.start();
        SequentialDnsServerAddressStreamProvider nameServerProvider = new SequentialDnsServerAddressStreamProvider(new InetSocketAddress[]{dnsServer1.localAddress(), dnsServer2.localAddress()});
        DnsNameResolver resolver = new DnsNameResolverBuilder(group.next()).dnsQueryLifecycleObserverFactory((DnsQueryLifecycleObserverFactory)new TestRecursiveCacheDnsQueryLifecycleObserverFactory()).datagramChannelType(NioDatagramChannel.class).optResourceEnabled(false).nameServerProvider((DnsServerAddressStreamProvider)nameServerProvider).datagramChannelStrategy(strategy).build();
        try {
            resolver.resolve("non-existent.netty.io", promise).sync();
            Assertions.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(CancellationException.class)));
        }
        MatcherAssert.assertThat((Object)isQuerySentToSecondServer.get(), (Matcher)Matchers.is((Object)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCNAMERecursiveResolveDifferentNameServersForDomains(DnsNameResolverChannelStrategy strategy) throws IOException {
        String firstName = "firstname.com";
        String secondName = "secondname.com";
        String lastName = "lastname.com";
        String ipv4Addr = "1.2.3.4";
        final TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName(question.getDomainName());
                rm.setDnsTtl(100);
                if (question.getDomainName().equals("firstname.com")) {
                    rm.setDnsType(RecordType.CNAME);
                    rm.put("apacheDnsDomainName", "secondname.com");
                } else if (question.getDomainName().equals("lastname.com")) {
                    rm.setDnsType(question.getRecordType());
                    rm.put("apacheDnsIpAddress", "1.2.3.4");
                } else {
                    return null;
                }
                return Collections.singleton(rm.getEntry());
            }
        });
        dnsServer2.start();
        final TestDnsServer dnsServer3 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                if (question.getDomainName().equals("secondname.com")) {
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(question.getDomainName());
                    rm.setDnsTtl(100);
                    rm.setDnsType(RecordType.CNAME);
                    rm.put("apacheDnsDomainName", "lastname.com");
                    return Collections.singleton(rm.getEntry());
                }
                return null;
            }
        });
        dnsServer3.start();
        DnsNameResolver resolver = null;
        try {
            resolver = DnsNameResolverTest.newResolver(strategy).resolveCache((DnsCache)NoopDnsCache.INSTANCE).cnameCache((DnsCnameCache)NoopDnsCnameCache.INSTANCE).recursionDesired(true).maxQueriesPerResolve(16).nameServerProvider(new DnsServerAddressStreamProvider(){

                public DnsServerAddressStream nameServerAddressStream(String hostname) {
                    if (hostname.equals("secondname.com.")) {
                        return DnsServerAddresses.singleton((InetSocketAddress)dnsServer3.localAddress()).stream();
                    }
                    return DnsServerAddresses.singleton((InetSocketAddress)dnsServer2.localAddress()).stream();
                }
            }).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).build();
            DnsNameResolverTest.assertResolvedAddress((InetAddress)resolver.resolve("firstname.com").syncUninterruptibly().getNow(), "1.2.3.4", "firstname.com");
        }
        finally {
            dnsServer2.stop();
            dnsServer3.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    private static void assertResolvedAddress(InetAddress resolvedAddress, String ipAddr, String hostname) {
        Assertions.assertEquals((Object)ipAddr, (Object)resolvedAddress.getHostAddress());
        Assertions.assertEquals((Object)hostname, (Object)resolvedAddress.getHostName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testAllNameServers(DnsNameResolverChannelStrategy strategy) throws IOException {
        String domain = "netty.io";
        String ipv4Addr = "1.2.3.4";
        final AtomicInteger server2Counter = new AtomicInteger();
        final TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                server2Counter.incrementAndGet();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName(question.getDomainName());
                rm.setDnsTtl(100);
                rm.setDnsType(question.getRecordType());
                rm.put("apacheDnsIpAddress", "1.2.3.4");
                return Collections.singleton(rm.getEntry());
            }
        });
        dnsServer2.start();
        final AtomicInteger server3Counter = new AtomicInteger();
        final TestDnsServer dnsServer3 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                server3Counter.incrementAndGet();
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName(question.getDomainName());
                rm.setDnsTtl(100);
                rm.setDnsType(question.getRecordType());
                rm.put("apacheDnsIpAddress", "1.2.3.4");
                return Collections.singleton(rm.getEntry());
            }
        });
        dnsServer3.start();
        DnsNameResolver resolver = null;
        try {
            resolver = DnsNameResolverTest.newResolver(strategy).resolveCache((DnsCache)NoopDnsCache.INSTANCE).cnameCache((DnsCnameCache)NoopDnsCnameCache.INSTANCE).recursionDesired(true).maxQueriesPerResolve(16).nameServerProvider(new DnsServerAddressStreamProvider(){
                private final DnsServerAddresses addresses;
                {
                    this.addresses = DnsServerAddresses.rotational((InetSocketAddress[])new InetSocketAddress[]{dnsServer2.localAddress(), dnsServer3.localAddress()});
                }

                public DnsServerAddressStream nameServerAddressStream(String hostname) {
                    return this.addresses.stream();
                }
            }).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).build();
            DnsNameResolverTest.assertResolvedAddress((InetAddress)resolver.resolve("netty.io").syncUninterruptibly().getNow(), "1.2.3.4", "netty.io");
            Assertions.assertEquals((int)1, (int)server2Counter.get());
            Assertions.assertEquals((int)0, (int)server3Counter.get());
            DnsNameResolverTest.assertResolvedAddress((InetAddress)resolver.resolve("netty.io").syncUninterruptibly().getNow(), "1.2.3.4", "netty.io");
            Assertions.assertEquals((int)1, (int)server2Counter.get());
            Assertions.assertEquals((int)1, (int)server3Counter.get());
            DnsNameResolverTest.assertResolvedAddress((InetAddress)resolver.resolve("netty.io").syncUninterruptibly().getNow(), "1.2.3.4", "netty.io");
            Assertions.assertEquals((int)2, (int)server2Counter.get());
            Assertions.assertEquals((int)1, (int)server3Counter.get());
            DnsNameResolverTest.assertResolvedAddress((InetAddress)resolver.resolve("netty.io").syncUninterruptibly().getNow(), "1.2.3.4", "netty.io");
            Assertions.assertEquals((int)2, (int)server2Counter.get());
            Assertions.assertEquals((int)2, (int)server3Counter.get());
        }
        finally {
            dnsServer2.stop();
            dnsServer3.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testSrvWithCnameNotCached(DnsNameResolverChannelStrategy strategy) throws Exception {
        final AtomicBoolean alias = new AtomicBoolean();
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                String name = question.getDomainName();
                if (name.equals("service.netty.io")) {
                    HashSet<ResourceRecord> records = new HashSet<ResourceRecord>(2);
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(name);
                    rm.setDnsTtl(10);
                    rm.setDnsType(RecordType.CNAME);
                    rm.put("apacheDnsDomainName", "alias.service.netty.io");
                    records.add(rm.getEntry());
                    rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(name);
                    rm.setDnsTtl(10);
                    rm.setDnsType(RecordType.SRV);
                    rm.put("apacheDnsDomainName", "foo.service.netty.io");
                    rm.put("apacheDnsServicePort", "8080");
                    rm.put("apacheDnsServicePriority", "10");
                    rm.put("apacheDnsServiceWeight", "1");
                    records.add(rm.getEntry());
                    return records;
                }
                if (name.equals("foo.service.netty.io")) {
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(name);
                    rm.setDnsTtl(10);
                    rm.setDnsType(RecordType.A);
                    rm.put("apacheDnsIpAddress", "10.0.0.1");
                    return Collections.singleton(rm.getEntry());
                }
                if (alias.get()) {
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(name);
                    rm.setDnsTtl(10);
                    rm.setDnsType(RecordType.SRV);
                    rm.put("apacheDnsDomainName", "foo.service.netty.io");
                    rm.put("apacheDnsServicePort", "8080");
                    rm.put("apacheDnsServicePriority", "10");
                    rm.put("apacheDnsServiceWeight", "1");
                    return Collections.singleton(rm.getEntry());
                }
                return null;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver(strategy).recursionDesired(false).queryTimeoutMillis(10000L).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).completeOncePreferredResolved(true).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            DnsNameResolverTest.assertNotEmptyAndRelease((Future<List<DnsRecord>>)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("service.netty.io", DnsRecordType.SRV)));
            alias.set(true);
            DnsNameResolverTest.assertNotEmptyAndRelease((Future<List<DnsRecord>>)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("service.netty.io", DnsRecordType.SRV)));
            alias.set(false);
            DnsNameResolverTest.assertNotEmptyAndRelease((Future<List<DnsRecord>>)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("service.netty.io", DnsRecordType.SRV)));
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCNAMENotTriedOnAddressLookupsWhenDisabled(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsResolveContext.TRY_FINAL_CNAME_ON_ADDRESS_LOOKUPS = false;
        this.testFollowUpCNAME(strategy, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCNAMEOnlyTriedOnAddressLookups(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsResolveContext.TRY_FINAL_CNAME_ON_ADDRESS_LOOKUPS = true;
        try {
            this.testFollowUpCNAME(strategy, true);
        }
        finally {
            DnsResolveContext.TRY_FINAL_CNAME_ON_ADDRESS_LOOKUPS = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFollowUpCNAME(DnsNameResolverChannelStrategy strategy, boolean enabled) throws Exception {
        final AtomicInteger cnameQueries = new AtomicInteger();
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) {
                if (questionRecord.getRecordType() == RecordType.CNAME) {
                    cnameQueries.incrementAndGet();
                }
                return Collections.emptySet();
            }
        });
        DnsNameResolver resolver = null;
        try {
            dnsServer2.start();
            resolver = DnsNameResolverTest.newNonCachedResolver(strategy, ResolvedAddressTypes.IPV4_PREFERRED).maxQueriesPerResolve(4).searchDomains(Collections.emptyList()).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress())).build();
            MatcherAssert.assertThat((Object)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("lookup-srv.netty.io", DnsRecordType.SRV)).await().cause(), (Matcher)Matchers.instanceOf(UnknownHostException.class));
            Assertions.assertEquals((int)0, (int)cnameQueries.get());
            MatcherAssert.assertThat((Object)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("lookup-naptr.netty.io", DnsRecordType.NAPTR)).await().cause(), (Matcher)Matchers.instanceOf(UnknownHostException.class));
            Assertions.assertEquals((int)0, (int)cnameQueries.get());
            MatcherAssert.assertThat((Object)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("lookup-cname.netty.io", DnsRecordType.CNAME)).await().cause(), (Matcher)Matchers.instanceOf(UnknownHostException.class));
            Assertions.assertEquals((int)1, (int)cnameQueries.getAndSet(0));
            MatcherAssert.assertThat((Object)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("lookup-a.netty.io", DnsRecordType.A)).await().cause(), (Matcher)Matchers.instanceOf(UnknownHostException.class));
            Assertions.assertEquals((int)(enabled ? 1 : 0), (int)cnameQueries.getAndSet(0));
            MatcherAssert.assertThat((Object)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("lookup-aaaa.netty.io", DnsRecordType.AAAA)).await().cause(), (Matcher)Matchers.instanceOf(UnknownHostException.class));
            Assertions.assertEquals((int)(enabled ? 1 : 0), (int)cnameQueries.getAndSet(0));
            MatcherAssert.assertThat((Object)resolver.resolveAll("lookup-address.netty.io").await().cause(), (Matcher)Matchers.instanceOf(UnknownHostException.class));
            Assertions.assertEquals((int)(enabled ? 1 : 0), (int)cnameQueries.getAndSet(0));
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    private static void assertNotEmptyAndRelease(Future<List<DnsRecord>> recordsFuture) throws Exception {
        List records = (List)recordsFuture.get();
        Assertions.assertFalse((boolean)records.isEmpty());
        for (DnsRecord record : records) {
            ReferenceCountUtil.release((Object)record);
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveIpv6WithScopeId(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testResolveIpv6WithScopeId0(strategy, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllIpv6WithScopeId(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testResolveIpv6WithScopeId0(strategy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testResolveIpv6WithScopeId0(DnsNameResolverChannelStrategy strategy, boolean resolveAll) throws Exception {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).build();
        String address = "fe80:0:0:0:1c31:d1d1:4824:72a9";
        int scopeId = 15;
        String addressString = address + '%' + scopeId;
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)address);
        Inet6Address inet6Address = Inet6Address.getByAddress(null, bytes, scopeId);
        try {
            InetAddress addr;
            if (resolveAll) {
                List addressList = (List)resolver.resolveAll(addressString).getNow();
                Assertions.assertEquals((int)1, (int)addressList.size());
                addr = (InetAddress)addressList.get(0);
            } else {
                addr = (InetAddress)resolver.resolve(addressString).getNow();
            }
            Assertions.assertEquals((Object)inet6Address, (Object)addr);
        }
        finally {
            resolver.close();
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveIpv6WithoutScopeId(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testResolveIpv6WithoutScopeId0(strategy, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllIpv6WithoutScopeId(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testResolveIpv6WithoutScopeId0(strategy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testResolveIpv6WithoutScopeId0(DnsNameResolverChannelStrategy strategy, boolean resolveAll) throws Exception {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).build();
        String addressString = "fe80:0:0:0:1c31:d1d1:4824:72a9";
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)addressString);
        Inet6Address inet6Address = (Inet6Address)InetAddress.getByAddress(bytes);
        try {
            InetAddress addr;
            if (resolveAll) {
                List addressList = (List)resolver.resolveAll(addressString).getNow();
                Assertions.assertEquals((int)1, (int)addressList.size());
                addr = (InetAddress)addressList.get(0);
            } else {
                addr = (InetAddress)resolver.resolve(addressString).getNow();
            }
            Assertions.assertEquals((Object)inet6Address, (Object)addr);
        }
        finally {
            resolver.close();
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveIp4(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testResolveIp4(strategy, false);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveAllIp4(DnsNameResolverChannelStrategy strategy) throws Exception {
        this.testResolveIp4(strategy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testResolveIp4(DnsNameResolverChannelStrategy strategy, boolean resolveAll) throws Exception {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).build();
        String addressString = "10.0.0.1";
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)addressString);
        InetAddress inetAddress = InetAddress.getByAddress(bytes);
        try {
            InetAddress addr;
            if (resolveAll) {
                List addressList = (List)resolver.resolveAll(addressString).getNow();
                Assertions.assertEquals((int)1, (int)addressList.size());
                addr = (InetAddress)addressList.get(0);
            } else {
                addr = (InetAddress)resolver.resolve(addressString).getNow();
            }
            Assertions.assertEquals((Object)inetAddress, (Object)addr);
        }
        finally {
            resolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveSearchDomainStopOnFirstSuccess(DnsNameResolverChannelStrategy strategy) throws Exception {
        String addressString = "10.0.0.1";
        final ConcurrentLinkedQueue names = new ConcurrentLinkedQueue();
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){
            private int called;

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                names.offer(question.getDomainName());
                if (++this.called == 2) {
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(question.getDomainName());
                    rm.setDnsTtl(100);
                    rm.setDnsType(question.getRecordType());
                    rm.put("apacheDnsIpAddress", "10.0.0.1");
                    return Collections.singleton(rm.getEntry());
                }
                return null;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).searchDomains(Arrays.asList("search1.netty.io", "search2.netty.io", "search3.netty.io")).ndots(2).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress())).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).build();
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)"10.0.0.1");
        InetAddress inetAddress = InetAddress.getByAddress(bytes);
        try {
            InetAddress addr = (InetAddress)resolver.resolve("netty.io").sync().getNow();
            Assertions.assertEquals((Object)inetAddress, (Object)addr);
        }
        finally {
            resolver.close();
            dnsServer2.stop();
            Assertions.assertEquals((Object)"netty.io.search1.netty.io", names.poll());
            Assertions.assertEquals((Object)"netty.io.search2.netty.io", names.poll());
            Assertions.assertTrue((boolean)names.isEmpty());
        }
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveTryWithoutSearchDomainFirst(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testResolveTryWithoutSearchDomainFirst(strategy, true);
    }

    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResolveTryWithoutSearchDomainFirstButContinue(DnsNameResolverChannelStrategy strategy) throws Exception {
        DnsNameResolverTest.testResolveTryWithoutSearchDomainFirst(strategy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testResolveTryWithoutSearchDomainFirst(DnsNameResolverChannelStrategy strategy, final boolean absoluteSuccess) throws Exception {
        String addressString = "10.0.0.1";
        final ConcurrentLinkedQueue names = new ConcurrentLinkedQueue();
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){
            private int called;

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                names.offer(question.getDomainName());
                ++this.called;
                if (absoluteSuccess && this.called == 1 || this.called == 3) {
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(question.getDomainName());
                    rm.setDnsTtl(100);
                    rm.setDnsType(question.getRecordType());
                    rm.put("apacheDnsIpAddress", "10.0.0.1");
                    return Collections.singleton(rm.getEntry());
                }
                return null;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).searchDomains(Arrays.asList("search1.netty.io", "search2.netty.io", "search3.netty.io")).ndots(1).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress())).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).build();
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)"10.0.0.1");
        InetAddress inetAddress = InetAddress.getByAddress(bytes);
        try {
            InetAddress addr = (InetAddress)resolver.resolve("netty.io").sync().getNow();
            Assertions.assertEquals((Object)inetAddress, (Object)addr);
        }
        finally {
            resolver.close();
            dnsServer2.stop();
            Assertions.assertEquals((Object)"netty.io", names.poll());
            if (!absoluteSuccess) {
                Assertions.assertEquals((Object)"netty.io.search1.netty.io", names.poll());
                Assertions.assertEquals((Object)"netty.io.search2.netty.io", names.poll());
            }
            Assertions.assertTrue((boolean)names.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testInflightQueries(DnsNameResolverChannelStrategy strategy) throws Exception {
        String addressString = "10.0.0.1";
        final AtomicInteger called = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(1);
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                called.incrementAndGet();
                try {
                    latch.await();
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(question.getDomainName());
                    rm.setDnsTtl(100);
                    rm.setDnsType(question.getRecordType());
                    rm.put("apacheDnsIpAddress", "10.0.0.1");
                    return Collections.singleton(rm.getEntry());
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress())).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).consolidateCacheSize(2).build();
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString((String)"10.0.0.1");
        InetAddress inetAddress = InetAddress.getByAddress(bytes);
        try {
            Future f = resolver.resolve("netty.io");
            Future f2 = resolver.resolve("netty.io");
            Assertions.assertFalse((boolean)f.isDone());
            Assertions.assertFalse((boolean)f2.isDone());
            latch.countDown();
            Assertions.assertEquals((Object)inetAddress, (Object)f.sync().getNow());
            Assertions.assertEquals((Object)inetAddress, (Object)f2.sync().getNow());
        }
        finally {
            resolver.close();
            dnsServer2.stop();
            Assertions.assertEquals((int)1, (int)called.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testAddressAlreadyInUse(DnsNameResolverChannelStrategy strategy) throws Exception {
        try (DatagramSocket datagramSocket = new DatagramSocket();){
            Assertions.assertTrue((boolean)datagramSocket.isBound());
            try (final DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy).localAddress(datagramSocket.getLocalSocketAddress()).build();){
                Throwable cause = Assertions.assertThrows(UnknownHostException.class, (Executable)new Executable(){

                    public void execute() throws Throwable {
                        resolver.resolve("netty.io").sync();
                    }
                });
                MatcherAssert.assertThat((Object)cause.getCause(), (Matcher)Matchers.instanceOf(BindException.class));
            }
            catch (IllegalStateException cause) {
                MatcherAssert.assertThat((Object)cause.getCause(), (Matcher)Matchers.instanceOf(BindException.class));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testResponseFeedbackStream(DnsNameResolverChannelStrategy strategy) {
        final AtomicBoolean successCalled = new AtomicBoolean();
        final AtomicBoolean failureCalled = new AtomicBoolean();
        final AtomicBoolean returnSuccess = new AtomicBoolean(false);
        try (DnsNameResolver resolver = DnsNameResolverTest.newResolver(strategy, true, new DnsServerAddressStreamProvider(){

            public DnsServerAddressStream nameServerAddressStream(String hostname) {
                return new DnsServerResponseFeedbackAddressStream(){

                    public void feedbackSuccess(InetSocketAddress address, long queryResponseTimeNanos) {
                        MatcherAssert.assertThat((Object)queryResponseTimeNanos, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
                        successCalled.set(true);
                    }

                    public void feedbackFailure(InetSocketAddress address, Throwable failureCause, long queryResponseTimeNanos) {
                        MatcherAssert.assertThat((Object)queryResponseTimeNanos, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
                        Assertions.assertNotNull((Object)failureCause);
                        failureCalled.set(true);
                    }

                    public InetSocketAddress next() {
                        if (returnSuccess.get()) {
                            return dnsServer.localAddress();
                        }
                        try {
                            return new InetSocketAddress(InetAddress.getByAddress("foo.com", new byte[]{-87, -2, 12, 34}), 53);
                        }
                        catch (UnknownHostException e) {
                            throw new Error(e);
                        }
                    }

                    public int size() {
                        return 1;
                    }

                    public DnsServerAddressStream duplicate() {
                        return this;
                    }
                };
            }
        }).build();){
            returnSuccess.set(true);
            resolver.resolve("google.com").syncUninterruptibly().getNow();
            Assertions.assertTrue((boolean)successCalled.get());
            Assertions.assertFalse((boolean)failureCalled.get());
            successCalled.set(false);
            failureCalled.set(false);
            returnSuccess.set(false);
            try {
                resolver.resolve("yahoo.com").syncUninterruptibly().getNow();
                Assertions.fail();
            }
            catch (Exception e) {
                MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(UnknownHostException.class)));
            }
            finally {
                Assertions.assertFalse((boolean)successCalled.get());
                Assertions.assertTrue((boolean)failureCalled.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DnsNameResolverChannelStrategy.class)
    public void testCnameWithAAndAdditionalsAndAuthorities(DnsNameResolverChannelStrategy strategy) throws Exception {
        String hostname = "test.netty.io";
        String cname = "cname.netty.io";
        final ArrayList<String> nameServers = new ArrayList<String>();
        for (int i = 0; i < 13; ++i) {
            nameServers.add("ns" + i + ".foo.bar");
        }
        TestDnsServer server = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) {
                ResourceRecordModifier rm = new ResourceRecordModifier();
                rm.setDnsClass(RecordClass.IN);
                rm.setDnsName("test.netty.io");
                rm.setDnsTtl(10000);
                rm.setDnsType(RecordType.CNAME);
                rm.put("apacheDnsDomainName", "cname.netty.io");
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>();
                records.add(rm.getEntry());
                records.add(TestDnsServer.newARecord("cname.netty.io", "10.0.0.2"));
                return records;
            }
        }){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                for (QuestionRecord record : message.getQuestionRecords()) {
                    if (!record.getDomainName().equals("test.netty.io")) continue;
                    message.getAuthorityRecords().clear();
                    message.getAdditionalRecords().clear();
                    for (String nameserver : nameServers) {
                        message.getAuthorityRecords().add(TestDnsServer.newNsRecord(".", nameserver));
                        message.getAdditionalRecords().add(63.newAddressRecord(nameserver, RecordType.A, "10.0.0.1"));
                        message.getAdditionalRecords().add(63.newAddressRecord(nameserver, RecordType.AAAA, "::1"));
                    }
                    return message;
                }
                return message;
            }
        };
        server.start();
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
        SingletonDnsServerAddressStreamProvider provider = new SingletonDnsServerAddressStreamProvider(server.localAddress());
        DnsNameResolver resolver = new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), null, false, (DnsCache)NoopDnsCache.INSTANCE, (DnsCnameCache)NoopDnsCnameCache.INSTANCE, (AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE, null, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 2000L, ResolvedAddressTypes.IPV4_ONLY, true, 8, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)provider, (DnsServerAddressStream)new ThreadLocalNameServerAddressStream((DnsServerAddressStreamProvider)provider), new String[]{"k8se-apps.svc.cluster.local, svc.cluster.local, cluster.local"}, 1, true, false, 0, strategy);
        try {
            InetAddress address = (InetAddress)resolver.resolve("test.netty.io").sync().getNow();
            Assertions.assertArrayEquals((byte[])new byte[]{10, 0, 0, 2}, (byte[])address.getAddress());
        }
        finally {
            resolver.close();
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            server.stop();
        }
    }

    static {
        boolean windowsHostsFileHostNameEntryExists;
        boolean windowsHostsFileLocalhostEntryExists;
        String windowsHostName;
        logger = InternalLoggerFactory.getInstance(DnsNameResolver.class);
        DOMAINS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("google.com", "youtube.com", "facebook.com", "baidu.com", "wikipedia.org", "yahoo.com", "reddit.com", "google.co.in", "qq.com", "amazon.com", "taobao.com", "tmall.com", "twitter.com", "vk.com", "live.com", "sohu.com", "instagram.com", "google.co.jp", "sina.com.cn", "jd.com", "weibo.com", "360.cn", "google.de", "google.co.uk", "google.com.br", "list.tmall.com", "google.ru", "google.fr", "yandex.ru", "netflix.com", "google.it", "google.com.hk", "linkedin.com", "pornhub.com", "t.co", "google.es", "twitch.tv", "alipay.com", "xvideos.com", "ebay.com", "yahoo.co.jp", "google.ca", "google.com.mx", "bing.com", "ok.ru", "imgur.com", "microsoft.com", "mail.ru", "imdb.com", "aliexpress.com", "hao123.com", "msn.com", "tumblr.com", "csdn.net", "wikia.com", "wordpress.com", "office.com", "google.com.tr", "livejasmin.com", "amazon.co.jp", "deloton.com", "apple.com", "google.com.au", "paypal.com", "google.com.tw", "bongacams.com", "popads.net", "whatsapp.com", "blogspot.com", "detail.tmall.com", "google.pl", "microsoftonline.com", "xhamster.com", "google.co.id", "github.com", "stackoverflow.com", "pinterest.com", "amazon.de", "diply.com", "amazon.co.uk", "so.com", "google.com.ar", "coccoc.com", "soso.com", "espn.com", "adobe.com", "google.com.ua", "tianya.cn", "xnxx.com", "googleusercontent.com", "savefrom.net", "google.com.pk", "amazon.in", "nicovideo.jp", "google.co.th", "dropbox.com", "thepiratebay.org", "google.com.sa", "google.com.eg", "pixnet.net", "localhost")));
        DOMAINS_PUNYCODE = new HashMap<String, String>();
        DOMAINS_PUNYCODE.put("b\u00fcchner.de", "xn--bchner-3ya.de");
        DOMAINS_PUNYCODE.put("m\u00fcller.de", "xn--mller-kva.de");
        HashSet<String> all = new HashSet<String>(DOMAINS.size() + DOMAINS_PUNYCODE.size());
        all.addAll(DOMAINS);
        all.addAll(DOMAINS_PUNYCODE.values());
        DOMAINS_ALL = Collections.unmodifiableSet(all);
        EXCLUSIONS_RESOLVE_A = new HashSet<String>();
        Collections.addAll(EXCLUSIONS_RESOLVE_A, "akamaihd.net", "googleusercontent.com", "");
        EXCLUSIONS_RESOLVE_AAAA = new HashSet<String>();
        EXCLUSIONS_RESOLVE_AAAA.addAll(EXCLUSIONS_RESOLVE_A);
        EXCLUSIONS_RESOLVE_AAAA.addAll(DOMAINS);
        EXCLUSIONS_RESOLVE_AAAA.removeAll(Arrays.asList("google.com", "facebook.com", "youtube.com", "wikipedia.org", "google.co.in", "blogspot.com", "vk.com", "google.de", "google.co.jp", "google.co.uk", "google.fr", "google.com.br", "google.ru", "google.it", "google.es", "google.com.mx", "xhamster.com", "google.ca", "google.co.id", "blogger.com", "flipkart.com", "google.com.tr", "google.com.au", "google.pl", "google.com.hk", "blogspot.in"));
        EXCLUSIONS_QUERY_MX = new HashSet<String>();
        Collections.addAll(EXCLUSIONS_QUERY_MX, "hao123.com", "blogspot.com", "t.co", "espn.go.com", "people.com.cn", "googleusercontent.com", "blogspot.in", "localhost", "");
        try {
            if (PlatformDependent.isWindows()) {
                windowsHostName = InetAddress.getLocalHost().getHostName();
                HostsFileEntriesProvider provider = HostsFileEntriesProvider.parser().parseSilently(new Charset[]{Charset.defaultCharset(), CharsetUtil.UTF_16, CharsetUtil.UTF_8});
                windowsHostsFileLocalhostEntryExists = provider.ipv4Entries().get("localhost") != null || provider.ipv6Entries().get("localhost") != null;
                windowsHostsFileHostNameEntryExists = provider.ipv4Entries().get(windowsHostName) != null || provider.ipv6Entries().get(windowsHostName) != null;
            } else {
                windowsHostName = null;
                windowsHostsFileLocalhostEntryExists = false;
                windowsHostsFileHostNameEntryExists = false;
            }
        }
        catch (Exception ignore) {
            windowsHostName = null;
            windowsHostsFileLocalhostEntryExists = false;
            windowsHostsFileHostNameEntryExists = false;
        }
        WINDOWS_HOST_NAME = windowsHostName;
        WINDOWS_HOSTS_FILE_LOCALHOST_ENTRY_EXISTS = windowsHostsFileLocalhostEntryExists;
        WINDOWS_HOSTS_FILE_HOST_NAME_ENTRY_EXISTS = windowsHostsFileHostNameEntryExists;
        dnsServer = new TestDnsServer(DOMAINS_ALL);
        group = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
    }

    private static class RedirectingTestDnsServer
    extends TestDnsServer {
        private final String dnsAddress;
        private final String domain;

        RedirectingTestDnsServer(String domain, String dnsAddress) {
            super(Collections.singleton(domain));
            this.domain = domain;
            this.dnsAddress = dnsAddress;
        }

        @Override
        protected DnsMessage filterMessage(DnsMessage message) {
            int idx;
            message.getAnswerRecords().clear();
            message.getAuthorityRecords().clear();
            message.getAdditionalRecords().clear();
            String name = this.domain;
            int i = 0;
            while ((idx = name.indexOf(46)) > 0) {
                name = name.substring(idx + 1);
                String dnsName = "dns" + idx + '.' + this.domain;
                message.getAuthorityRecords().add(RedirectingTestDnsServer.newNsRecord(name, dnsName));
                message.getAdditionalRecords().add(RedirectingTestDnsServer.newARecord(dnsName, i == 0 ? this.dnsAddress : "1.2.3." + idx));
                message.getAuthorityRecords().add(RedirectingTestDnsServer.newNsRecord(name, "unresolved." + dnsName));
                ++i;
            }
            return message;
        }
    }

    private static final class TestDnsCache
    implements DnsCache {
        final DnsCache cache;
        final Map<String, List<? extends DnsCacheEntry>> cacheHits = new HashMap<String, List<? extends DnsCacheEntry>>();

        TestDnsCache(DnsCache cache) {
            this.cache = cache;
        }

        public void clear() {
            this.cache.clear();
        }

        public boolean clear(String hostname) {
            return this.cache.clear(hostname);
        }

        public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
            List cached = this.cache.get(hostname, additionals);
            this.cacheHits.put(hostname, cached);
            return cached;
        }

        public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, InetAddress address, long originalTtl, EventLoop loop) {
            return this.cache.cache(hostname, additionals, address, originalTtl, loop);
        }

        public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, Throwable cause, EventLoop loop) {
            return this.cache.cache(hostname, additionals, cause, loop);
        }
    }

    private static final class TestAuthoritativeDnsServerCache
    implements AuthoritativeDnsServerCache {
        final AuthoritativeDnsServerCache cache;
        final Map<String, DnsServerAddressStream> cacheHits = new HashMap<String, DnsServerAddressStream>();

        TestAuthoritativeDnsServerCache(AuthoritativeDnsServerCache cache) {
            this.cache = cache;
        }

        public void clear() {
            this.cache.clear();
        }

        public boolean clear(String hostname) {
            return this.cache.clear(hostname);
        }

        public DnsServerAddressStream get(String hostname) {
            DnsServerAddressStream cached = this.cache.get(hostname);
            if (cached != null) {
                this.cacheHits.put(hostname, cached.duplicate());
            }
            return cached;
        }

        public void cache(String hostname, InetSocketAddress address, long originalTtl, EventLoop loop) {
            this.cache.cache(hostname, address, originalTtl, loop);
        }
    }

    private static final class TestDnsQueryLifecycleObserver
    implements DnsQueryLifecycleObserver {
        final Queue<Object> events = new ArrayDeque<Object>();
        final DnsQuestion question;

        TestDnsQueryLifecycleObserver(DnsQuestion question) {
            this.question = question;
        }

        public void queryWritten(InetSocketAddress dnsServerAddress, ChannelFuture future) {
            this.events.add(new QueryWrittenEvent(dnsServerAddress));
        }

        public void queryCancelled(int queriesRemaining) {
            this.events.add(new QueryCancelledEvent(queriesRemaining));
        }

        public DnsQueryLifecycleObserver queryRedirected(List<InetSocketAddress> nameServers) {
            this.events.add(new QueryRedirectedEvent(nameServers));
            return this;
        }

        public DnsQueryLifecycleObserver queryCNAMEd(DnsQuestion cnameQuestion) {
            this.events.add(new QueryCnamedEvent(cnameQuestion));
            return this;
        }

        public DnsQueryLifecycleObserver queryNoAnswer(DnsResponseCode code) {
            this.events.add(new QueryNoAnswerEvent(code));
            return this;
        }

        public void queryFailed(Throwable cause) {
            this.events.add(new QueryFailedEvent(cause));
        }

        public void querySucceed() {
            this.events.add(new QuerySucceededEvent());
        }
    }

    private static final class QuerySucceededEvent {
        private QuerySucceededEvent() {
        }
    }

    private static final class QueryFailedEvent {
        final Throwable cause;

        QueryFailedEvent(Throwable cause) {
            this.cause = cause;
        }
    }

    private static final class QueryNoAnswerEvent {
        final DnsResponseCode code;

        QueryNoAnswerEvent(DnsResponseCode code) {
            this.code = code;
        }
    }

    private static final class QueryCnamedEvent {
        final DnsQuestion question;

        QueryCnamedEvent(DnsQuestion question) {
            this.question = question;
        }
    }

    private static final class QueryRedirectedEvent {
        final List<InetSocketAddress> nameServers;

        QueryRedirectedEvent(List<InetSocketAddress> nameServers) {
            this.nameServers = nameServers;
        }
    }

    private static final class QueryCancelledEvent {
        final int queriesRemaining;

        QueryCancelledEvent(int queriesRemaining) {
            this.queriesRemaining = queriesRemaining;
        }
    }

    private static final class QueryWrittenEvent {
        final InetSocketAddress dnsServerAddress;

        QueryWrittenEvent(InetSocketAddress dnsServerAddress) {
            this.dnsServerAddress = dnsServerAddress;
        }
    }

    private static final class TestRecursiveCacheDnsQueryLifecycleObserverFactory
    implements DnsQueryLifecycleObserverFactory {
        final Queue<TestDnsQueryLifecycleObserver> observers = new ConcurrentLinkedQueue<TestDnsQueryLifecycleObserver>();

        private TestRecursiveCacheDnsQueryLifecycleObserverFactory() {
        }

        public DnsQueryLifecycleObserver newDnsQueryLifecycleObserver(DnsQuestion question) {
            TestDnsQueryLifecycleObserver observer = new TestDnsQueryLifecycleObserver(question);
            this.observers.add(observer);
            return observer;
        }
    }
}

