/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.bootstrap;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.bootstrap.ServerBootstrap;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelConfig;
import io.netty5.channel.ChannelFactory;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.DefaultChannelConfig;
import io.netty5.channel.EventLoop;
import io.netty5.channel.EventLoopGroup;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.local.LocalAddress;
import io.netty5.channel.local.LocalChannel;
import io.netty5.channel.local.LocalHandler;
import io.netty5.channel.local.LocalServerChannel;
import io.netty5.resolver.AbstractAddressResolver;
import io.netty5.resolver.AddressResolver;
import io.netty5.resolver.AddressResolverGroup;
import io.netty5.util.AttributeKey;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class BootstrapTest {
    private static final EventLoopGroup groupA = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
    private static final EventLoopGroup groupB = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
    private static final ChannelHandler dummyHandler = new DummyHandler();

    @AfterAll
    public static void destroy() {
        groupA.shutdownGracefully();
        groupB.shutdownGracefully();
        groupA.terminationFuture().syncUninterruptibly();
        groupB.terminationFuture().syncUninterruptibly();
    }

    @Test
    public void testOptionsCopied() {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.option(ChannelOption.AUTO_READ, (Object)true);
        Map.Entry[] channelOptions = bootstrapA.newOptionsArray();
        bootstrapA.option(ChannelOption.AUTO_READ, (Object)false);
        Assertions.assertEquals((Object)ChannelOption.AUTO_READ, channelOptions[0].getKey());
        Assertions.assertEquals((Object)true, channelOptions[0].getValue());
    }

    @Test
    public void testAttributesCopied() {
        AttributeKey key = AttributeKey.valueOf((String)UUID.randomUUID().toString());
        String value = "value";
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.attr(key, (Object)value);
        Map.Entry[] attributesArray = bootstrapA.newAttributesArray();
        bootstrapA.attr(key, (Object)"value2");
        Assertions.assertEquals((Object)key, attributesArray[0].getKey());
        Assertions.assertEquals((Object)value, attributesArray[0].getValue());
    }

    @Test
    public void optionsAndAttributesMustBeAvailableOnChannelInit() throws InterruptedException {
        final AttributeKey key = AttributeKey.valueOf((String)UUID.randomUUID().toString());
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(groupA)).channel(LocalChannel.class).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)4242)).attr(key, (Object)"value")).handler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                Integer option = (Integer)ch.config().getOption(ChannelOption.CONNECT_TIMEOUT_MILLIS);
                Assertions.assertEquals((int)4242, (int)option);
                Assertions.assertEquals((Object)"value", (Object)ch.attr(key).get());
            }
        })).bind((SocketAddress)LocalAddress.ANY).sync();
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testBindDeadLock() throws Exception {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.handler(dummyHandler);
        Bootstrap bootstrapB = new Bootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalChannel.class);
        bootstrapB.handler(dummyHandler);
        ArrayList<Future> bindFutures = new ArrayList<Future>();
        for (int i = 0; i < 1024; ++i) {
            bindFutures.add(groupA.next().submit(() -> bootstrapB.bind((SocketAddress)LocalAddress.ANY)));
            bindFutures.add(groupB.next().submit(() -> bootstrapA.bind((SocketAddress)LocalAddress.ANY)));
        }
        for (Future f : bindFutures) {
            f.sync();
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testConnectDeadLock() throws Exception {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.handler(dummyHandler);
        Bootstrap bootstrapB = new Bootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalChannel.class);
        bootstrapB.handler(dummyHandler);
        ArrayList<Future> bindFutures = new ArrayList<Future>();
        for (int i = 0; i < 1024; ++i) {
            bindFutures.add(groupA.next().submit(() -> bootstrapB.connect((SocketAddress)LocalAddress.ANY)));
            bindFutures.add(groupB.next().submit(() -> bootstrapA.connect((SocketAddress)LocalAddress.ANY)));
        }
        for (Future f : bindFutures) {
            f.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLateRegisterSuccess() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            LateRegisterHandler registerHandler = new LateRegisterHandler();
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group((EventLoopGroup)group);
            bootstrap.handler((ChannelHandler)registerHandler);
            bootstrap.channel(LocalServerChannel.class);
            bootstrap.childHandler((ChannelHandler)new DummyHandler());
            bootstrap.localAddress((SocketAddress)new LocalAddress("1"));
            Future future = bootstrap.bind();
            Assertions.assertFalse((boolean)future.isDone());
            registerHandler.registerPromise().setSuccess(null);
            LinkedBlockingQueue queue = new LinkedBlockingQueue();
            future.addListener(fut -> {
                queue.add(((Channel)fut.getNow()).executor().inEventLoop(Thread.currentThread()));
                queue.add(fut.isSuccess());
            });
            Assertions.assertTrue((boolean)((Boolean)queue.take()));
            Assertions.assertTrue((boolean)((Boolean)queue.take()));
        }
        finally {
            group.shutdownGracefully();
            group.terminationFuture().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLateRegisterSuccessBindFailed() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        LateRegisterHandler registerHandler = new LateRegisterHandler();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group((EventLoopGroup)group);
            bootstrap.channelFactory((eventLoop, childEventLoopGroup) -> new LocalServerChannel(eventLoop, childEventLoopGroup){

                public Future<Void> bind(SocketAddress localAddress) {
                    this.close();
                    return this.newFailedFuture(new SocketException());
                }
            });
            bootstrap.childHandler((ChannelHandler)new DummyHandler());
            bootstrap.handler((ChannelHandler)registerHandler);
            bootstrap.localAddress((SocketAddress)new LocalAddress("1"));
            Future future = bootstrap.bind();
            Assertions.assertFalse((boolean)future.isDone());
            registerHandler.registerPromise().setSuccess(null);
            LinkedBlockingQueue queue = new LinkedBlockingQueue();
            future.addListener(fut -> {
                queue.add(fut.executor().inEventLoop(Thread.currentThread()));
                queue.add(fut.isSuccess());
            });
            Assertions.assertTrue((boolean)((Boolean)queue.take()));
            Assertions.assertFalse((boolean)((Boolean)queue.take()));
        }
        finally {
            group.shutdownGracefully();
            group.terminationFuture().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testLateRegistrationConnect() throws Throwable {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        LateRegisterHandler registerHandler = new LateRegisterHandler();
        try {
            Bootstrap bootstrapA = new Bootstrap();
            bootstrapA.group((EventLoopGroup)group);
            bootstrapA.channel(LocalChannel.class);
            bootstrapA.handler((ChannelHandler)registerHandler);
            Future future = bootstrapA.connect((SocketAddress)LocalAddress.ANY);
            Assertions.assertFalse((boolean)future.isDone());
            registerHandler.registerPromise().setSuccess(null);
            CompletionException cause = (CompletionException)Assertions.assertThrows(CompletionException.class, () -> ((Future)future).syncUninterruptibly());
            MatcherAssert.assertThat((Object)cause.getCause(), (Matcher)CoreMatchers.instanceOf(ConnectException.class));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testAsyncResolutionSuccess() throws Exception {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.resolver((AddressResolverGroup)new TestAddressResolverGroup(true));
        bootstrapA.handler(dummyHandler);
        ServerBootstrap bootstrapB = new ServerBootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalServerChannel.class);
        bootstrapB.childHandler(dummyHandler);
        SocketAddress localAddress = ((Channel)bootstrapB.bind((SocketAddress)LocalAddress.ANY).get()).localAddress();
        bootstrapA.connect(localAddress).sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testLateRegistrationConnectWithCreateUnregistered() throws Throwable {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        LateRegisterHandler registerHandler = new LateRegisterHandler();
        try {
            Bootstrap bootstrapA = new Bootstrap();
            bootstrapA.group((EventLoopGroup)group);
            bootstrapA.channel(LocalChannel.class);
            bootstrapA.handler((ChannelHandler)registerHandler);
            Channel channel = bootstrapA.createUnregistered();
            Future registerFuture = channel.register();
            Future connectFuture = channel.connect((SocketAddress)LocalAddress.ANY);
            registerHandler.registerPromise().setSuccess(null);
            registerFuture.sync();
            CompletionException exception = (CompletionException)Assertions.assertThrows(CompletionException.class, () -> ((Future)connectFuture).syncUninterruptibly());
            Assertions.assertTrue((boolean)(exception.getCause() instanceof ConnectException));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testAsyncResolutionFailure() throws Exception {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.resolver((AddressResolverGroup)new TestAddressResolverGroup(false));
        bootstrapA.handler(dummyHandler);
        ServerBootstrap bootstrapB = new ServerBootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalServerChannel.class);
        bootstrapB.childHandler(dummyHandler);
        SocketAddress localAddress = ((Channel)bootstrapB.bind((SocketAddress)LocalAddress.ANY).get()).localAddress();
        Future connectFuture = bootstrapA.connect(localAddress);
        Assertions.assertTrue((boolean)connectFuture.await(10000L));
        MatcherAssert.assertThat((Object)connectFuture.cause(), (Matcher)CoreMatchers.instanceOf(UnknownHostException.class));
    }

    @Test
    public void testChannelFactoryFailureNotifiesPromise() throws Exception {
        RuntimeException exception = new RuntimeException("newChannel crash");
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().handler(dummyHandler)).group(groupA)).channelFactory(eventLoop -> {
            throw exception;
        });
        Future connectFuture = bootstrap.connect((SocketAddress)LocalAddress.ANY);
        Assertions.assertTrue((boolean)connectFuture.await(10000L));
        Assertions.assertSame((Object)connectFuture.cause(), (Object)exception);
    }

    @Test
    public void testChannelOptionOrderPreserve() throws InterruptedException {
        final LinkedBlockingQueue options = new LinkedBlockingQueue();
        final CountDownLatch latch = new CountDownLatch(1);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                latch.countDown();
            }
        })).group(groupA)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

            public Channel newChannel(EventLoop eventLoop) {
                return new LocalChannel(eventLoop){
                    private 1ChannelConfigValidator config;

                    public synchronized ChannelConfig config() {
                        class ChannelConfigValidator
                        extends DefaultChannelConfig {
                            final /* synthetic */ BlockingQueue val$options;

                            ChannelConfigValidator(Channel channel) {
                                this.val$options = blockingQueue;
                                super(channel);
                            }

                            public <T> boolean setOption(ChannelOption<T> option, T value) {
                                this.val$options.add(option);
                                return super.setOption(option, value);
                            }
                        }
                        if (this.config == null) {
                            this.config = new ChannelConfigValidator(BootstrapTest.this, (Channel)this, options);
                        }
                        return this.config;
                    }
                };
            }
        }).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)1)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)2);
        bootstrap.register().syncUninterruptibly();
        latch.await();
        Assertions.assertSame((Object)ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, options.take());
        Assertions.assertSame((Object)ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, options.take());
    }

    private static final class TestAddressResolverGroup
    extends AddressResolverGroup<SocketAddress> {
        private final boolean success;

        TestAddressResolverGroup(boolean success) {
            this.success = success;
        }

        protected AddressResolver<SocketAddress> newResolver(EventExecutor executor) throws Exception {
            return new AbstractAddressResolver<SocketAddress>(executor){

                protected boolean doIsResolved(SocketAddress address) {
                    return false;
                }

                protected void doResolve(SocketAddress unresolvedAddress, Promise<SocketAddress> promise) {
                    this.executor().execute(() -> {
                        if (success) {
                            promise.setSuccess((Object)unresolvedAddress);
                        } else {
                            promise.setFailure((Throwable)new UnknownHostException(unresolvedAddress.toString()));
                        }
                    });
                }

                protected void doResolveAll(SocketAddress unresolvedAddress, Promise<List<SocketAddress>> promise) throws Exception {
                    this.executor().execute(() -> {
                        if (success) {
                            promise.setSuccess(Collections.singletonList(unresolvedAddress));
                        } else {
                            promise.setFailure((Throwable)new UnknownHostException(unresolvedAddress.toString()));
                        }
                    });
                }
            };
        }
    }

    @ChannelHandler.Sharable
    private static final class DummyHandler
    implements ChannelHandler {
        private DummyHandler() {
        }
    }

    private static final class LateRegisterHandler
    implements ChannelHandler {
        private final CountDownLatch latch = new CountDownLatch(1);
        private Promise<Void> registerPromise;

        private LateRegisterHandler() {
        }

        public Future<Void> register(ChannelHandlerContext ctx) {
            this.registerPromise = ctx.newPromise();
            this.latch.countDown();
            return ctx.register().addListener(future -> {
                if (!future.isSuccess()) {
                    this.registerPromise.tryFailure(future.cause());
                }
            });
        }

        Promise<Void> registerPromise() throws InterruptedException {
            this.latch.await();
            return this.registerPromise;
        }
    }
}

